/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11.wrapper;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import sun.security.pkcs11.wrapper.CK_DATE;

public class Functions {
    private static final Map<Integer, String> mechNames = new HashMap<Integer, String>();
    private static final Map<String, Integer> mechIds = new HashMap<String, Integer>();
    private static final Map<String, Long> hashMechIds = new HashMap<String, Long>();
    private static final Map<Integer, String> keyNames = new HashMap<Integer, String>();
    private static final Map<String, Integer> keyIds = new HashMap<String, Integer>();
    private static final Map<Integer, String> attributeNames = new HashMap<Integer, String>();
    private static final Map<String, Integer> attributeIds = new HashMap<String, Integer>();
    private static final Map<Integer, String> objectClassNames = new HashMap<Integer, String>();
    private static final Map<String, Integer> objectClassIds = new HashMap<String, Integer>();
    private static final char[] HEX_DIGITS = "0123456789ABCDEF".toCharArray();
    private static final Flags slotInfoFlags = new Flags(new long[]{1L, 2L, 4L}, new String[]{"CKF_TOKEN_PRESENT", "CKF_REMOVABLE_DEVICE", "CKF_HW_SLOT"});
    private static final Flags tokenInfoFlags = new Flags(new long[]{1L, 2L, 4L, 8L, 32L, 64L, 256L, 512L, 1024L, 2048L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L}, new String[]{"CKF_RNG", "CKF_WRITE_PROTECTED", "CKF_LOGIN_REQUIRED", "CKF_USER_PIN_INITIALIZED", "CKF_RESTORE_KEY_NOT_NEEDED", "CKF_CLOCK_ON_TOKEN", "CKF_PROTECTED_AUTHENTICATION_PATH", "CKF_DUAL_CRYPTO_OPERATIONS", "CKF_TOKEN_INITIALIZED", "CKF_SECONDARY_AUTHENTICATION", "CKF_USER_PIN_COUNT_LOW", "CKF_USER_PIN_FINAL_TRY", "CKF_USER_PIN_LOCKED", "CKF_USER_PIN_TO_BE_CHANGED", "CKF_SO_PIN_COUNT_LOW", "CKF_SO_PIN_FINAL_TRY", "CKF_SO_PIN_LOCKED", "CKF_SO_PIN_TO_BE_CHANGED"});
    private static final Flags sessionInfoFlags = new Flags(new long[]{2L, 4L}, new String[]{"CKF_RW_SESSION", "CKF_SERIAL_SESSION"});
    private static final Flags mechanismInfoFlags = new Flags(new long[]{1L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 0x80000000L}, new String[]{"CKF_HW", "CKF_ENCRYPT", "CKF_DECRYPT", "CKF_DIGEST", "CKF_SIGN", "CKF_SIGN_RECOVER", "CKF_VERIFY", "CKF_VERIFY_RECOVER", "CKF_GENERATE", "CKF_GENERATE_KEY_PAIR", "CKF_WRAP", "CKF_UNWRAP", "CKF_DERIVE", "CKF_EC_F_P", "CKF_EC_F_2M", "CKF_EC_ECPARAMETERS", "CKF_EC_NAMEDCURVE", "CKF_EC_UNCOMPRESS", "CKF_EC_COMPRESS", "CKF_EXTENSION"});

    public static String toFullHexString(long l) {
        long l2 = l;
        StringBuffer stringBuffer = new StringBuffer(16);
        for (int i = 0; i < 16; ++i) {
            int n = (int)l2 & 0xF;
            stringBuffer.append(HEX_DIGITS[n]);
            l2 >>>= 4;
        }
        return stringBuffer.reverse().toString();
    }

    public static String toFullHexString(int n) {
        int n2 = n;
        StringBuffer stringBuffer = new StringBuffer(8);
        for (int i = 0; i < 8; ++i) {
            int n3 = n2 & 0xF;
            stringBuffer.append(HEX_DIGITS[n3]);
            n2 >>>= 4;
        }
        return stringBuffer.reverse().toString();
    }

    public static String toHexString(long l) {
        return Long.toHexString(l);
    }

    public static String toHexString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(2 * byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            if (n < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toString(n, 16));
        }
        return stringBuffer.toString();
    }

    public static String toBinaryString(long l) {
        return Long.toString(l, 2);
    }

    public static String toBinaryString(byte[] byArray) {
        BigInteger bigInteger = new BigInteger(1, byArray);
        return bigInteger.toString(2);
    }

    public static String slotInfoFlagsToString(long l) {
        return slotInfoFlags.toString(l);
    }

    public static String tokenInfoFlagsToString(long l) {
        return tokenInfoFlags.toString(l);
    }

    public static String sessionInfoFlagsToString(long l) {
        return sessionInfoFlags.toString(l);
    }

    public static String sessionStateToString(long l) {
        String string = l == 0L ? "CKS_RO_PUBLIC_SESSION" : (l == 1L ? "CKS_RO_USER_FUNCTIONS" : (l == 2L ? "CKS_RW_PUBLIC_SESSION" : (l == 3L ? "CKS_RW_USER_FUNCTIONS" : (l == 4L ? "CKS_RW_SO_FUNCTIONS" : "ERROR: unknown session state 0x" + Functions.toFullHexString(l)))));
        return string;
    }

    public static String mechanismInfoFlagsToString(long l) {
        return mechanismInfoFlags.toString(l);
    }

    private static String getName(Map<Integer, String> map, long l) {
        String string = null;
        if (l >>> 32 == 0L) {
            string = map.get((int)l);
        }
        if (string == null) {
            string = "Unknown 0x" + Functions.toFullHexString(l);
        }
        return string;
    }

    public static long getId(Map<String, Integer> map, String string) {
        Integer n = map.get(string);
        if (n == null) {
            throw new IllegalArgumentException("Unknown name " + string);
        }
        return (long)n.intValue() & 0xFFFFFFFFL;
    }

    public static String getMechanismName(long l) {
        return Functions.getName(mechNames, l);
    }

    public static long getMechanismId(String string) {
        return Functions.getId(mechIds, string);
    }

    public static String getKeyName(long l) {
        return Functions.getName(keyNames, l);
    }

    public static long getKeyId(String string) {
        return Functions.getId(keyIds, string);
    }

    public static String getAttributeName(long l) {
        return Functions.getName(attributeNames, l);
    }

    public static long getAttributeId(String string) {
        return Functions.getId(attributeIds, string);
    }

    public static String getObjectClassName(long l) {
        return Functions.getName(objectClassNames, l);
    }

    public static long getObjectClassId(String string) {
        return Functions.getId(objectClassIds, string);
    }

    public static long getHashMechId(String string) {
        return hashMechIds.get(string);
    }

    private static boolean equals(char[] cArray, char[] cArray2) {
        return Arrays.equals(cArray, cArray2);
    }

    public static boolean equals(CK_DATE cK_DATE, CK_DATE cK_DATE2) {
        boolean bl = false;
        bl = cK_DATE == cK_DATE2 ? true : (cK_DATE != null && cK_DATE2 != null ? Functions.equals(cK_DATE.year, cK_DATE2.year) && Functions.equals(cK_DATE.month, cK_DATE2.month) && Functions.equals(cK_DATE.day, cK_DATE2.day) : false);
        return bl;
    }

    public static int hashCode(byte[] byArray) {
        int n = 0;
        if (byArray != null) {
            for (int i = 0; i < 4 && i < byArray.length; ++i) {
                n ^= (0xFF & byArray[i]) << (i % 4 << 3);
            }
        }
        return n;
    }

    public static int hashCode(char[] cArray) {
        int n = 0;
        if (cArray != null) {
            for (int i = 0; i < 4 && i < cArray.length; ++i) {
                n ^= (0xFFFF & cArray[i]) << (i % 2 << 4);
            }
        }
        return n;
    }

    public static int hashCode(CK_DATE cK_DATE) {
        int n = 0;
        if (cK_DATE != null) {
            if (cK_DATE.year.length == 4) {
                n ^= (0xFFFF & cK_DATE.year[0]) << 16;
                n ^= 0xFFFF & cK_DATE.year[1];
                n ^= (0xFFFF & cK_DATE.year[2]) << 16;
                n ^= 0xFFFF & cK_DATE.year[3];
            }
            if (cK_DATE.month.length == 2) {
                n ^= (0xFFFF & cK_DATE.month[0]) << 16;
                n ^= 0xFFFF & cK_DATE.month[1];
            }
            if (cK_DATE.day.length == 2) {
                n ^= (0xFFFF & cK_DATE.day[0]) << 16;
                n ^= 0xFFFF & cK_DATE.day[1];
            }
        }
        return n;
    }

    private static void addMapping(Map<Integer, String> map, Map<String, Integer> map2, long l, String string) {
        if (l >>> 32 != 0L) {
            throw new AssertionError((Object)("Id has high bits set: " + l + ", " + string));
        }
        Integer n = (int)l;
        if (map.put(n, string) != null) {
            throw new AssertionError((Object)("Duplicate id: " + l + ", " + string));
        }
        if (map2.put(string, n) != null) {
            throw new AssertionError((Object)("Duplicate name: " + l + ", " + string));
        }
    }

    private static void addMech(long l, String string) {
        Functions.addMapping(mechNames, mechIds, l, string);
    }

    private static void addKeyType(long l, String string) {
        Functions.addMapping(keyNames, keyIds, l, string);
    }

    private static void addAttribute(long l, String string) {
        Functions.addMapping(attributeNames, attributeIds, l, string);
    }

    private static void addObjectClass(long l, String string) {
        Functions.addMapping(objectClassNames, objectClassIds, l, string);
    }

    private static void addHashMech(long l, String string) {
        hashMechIds.put(string, l);
    }

    static {
        Functions.addMech(0L, "CKM_RSA_PKCS_KEY_PAIR_GEN");
        Functions.addMech(1L, "CKM_RSA_PKCS");
        Functions.addMech(2L, "CKM_RSA_9796");
        Functions.addMech(3L, "CKM_RSA_X_509");
        Functions.addMech(4L, "CKM_MD2_RSA_PKCS");
        Functions.addMech(5L, "CKM_MD5_RSA_PKCS");
        Functions.addMech(6L, "CKM_SHA1_RSA_PKCS");
        Functions.addMech(7L, "CKM_RIPEMD128_RSA_PKCS");
        Functions.addMech(8L, "CKM_RIPEMD160_RSA_PKCS");
        Functions.addMech(9L, "CKM_RSA_PKCS_OAEP");
        Functions.addMech(10L, "CKM_RSA_X9_31_KEY_PAIR_GEN");
        Functions.addMech(11L, "CKM_RSA_X9_31");
        Functions.addMech(12L, "CKM_SHA1_RSA_X9_31");
        Functions.addMech(13L, "CKM_RSA_PKCS_PSS");
        Functions.addMech(14L, "CKM_SHA1_RSA_PKCS_PSS");
        Functions.addMech(16L, "CKM_DSA_KEY_PAIR_GEN");
        Functions.addMech(17L, "CKM_DSA");
        Functions.addMech(18L, "CKM_DSA_SHA1");
        Functions.addMech(32L, "CKM_DH_PKCS_KEY_PAIR_GEN");
        Functions.addMech(33L, "CKM_DH_PKCS_DERIVE");
        Functions.addMech(48L, "CKM_X9_42_DH_KEY_PAIR_GEN");
        Functions.addMech(49L, "CKM_X9_42_DH_DERIVE");
        Functions.addMech(50L, "CKM_X9_42_DH_HYBRID_DERIVE");
        Functions.addMech(51L, "CKM_X9_42_MQV_DERIVE");
        Functions.addMech(70L, "CKM_SHA224_RSA_PKCS");
        Functions.addMech(64L, "CKM_SHA256_RSA_PKCS");
        Functions.addMech(65L, "CKM_SHA384_RSA_PKCS");
        Functions.addMech(66L, "CKM_SHA512_RSA_PKCS");
        Functions.addMech(256L, "CKM_RC2_KEY_GEN");
        Functions.addMech(257L, "CKM_RC2_ECB");
        Functions.addMech(258L, "CKM_RC2_CBC");
        Functions.addMech(259L, "CKM_RC2_MAC");
        Functions.addMech(260L, "CKM_RC2_MAC_GENERAL");
        Functions.addMech(261L, "CKM_RC2_CBC_PAD");
        Functions.addMech(272L, "CKM_RC4_KEY_GEN");
        Functions.addMech(273L, "CKM_RC4");
        Functions.addMech(288L, "CKM_DES_KEY_GEN");
        Functions.addMech(289L, "CKM_DES_ECB");
        Functions.addMech(290L, "CKM_DES_CBC");
        Functions.addMech(291L, "CKM_DES_MAC");
        Functions.addMech(292L, "CKM_DES_MAC_GENERAL");
        Functions.addMech(293L, "CKM_DES_CBC_PAD");
        Functions.addMech(304L, "CKM_DES2_KEY_GEN");
        Functions.addMech(305L, "CKM_DES3_KEY_GEN");
        Functions.addMech(306L, "CKM_DES3_ECB");
        Functions.addMech(307L, "CKM_DES3_CBC");
        Functions.addMech(308L, "CKM_DES3_MAC");
        Functions.addMech(309L, "CKM_DES3_MAC_GENERAL");
        Functions.addMech(310L, "CKM_DES3_CBC_PAD");
        Functions.addMech(320L, "CKM_CDMF_KEY_GEN");
        Functions.addMech(321L, "CKM_CDMF_ECB");
        Functions.addMech(322L, "CKM_CDMF_CBC");
        Functions.addMech(323L, "CKM_CDMF_MAC");
        Functions.addMech(324L, "CKM_CDMF_MAC_GENERAL");
        Functions.addMech(325L, "CKM_CDMF_CBC_PAD");
        Functions.addMech(512L, "CKM_MD2");
        Functions.addMech(513L, "CKM_MD2_HMAC");
        Functions.addMech(514L, "CKM_MD2_HMAC_GENERAL");
        Functions.addMech(528L, "CKM_MD5");
        Functions.addMech(529L, "CKM_MD5_HMAC");
        Functions.addMech(530L, "CKM_MD5_HMAC_GENERAL");
        Functions.addMech(544L, "CKM_SHA_1");
        Functions.addMech(545L, "CKM_SHA_1_HMAC");
        Functions.addMech(546L, "CKM_SHA_1_HMAC_GENERAL");
        Functions.addMech(560L, "CKM_RIPEMD128");
        Functions.addMech(561L, "CKM_RIPEMD128_HMAC");
        Functions.addMech(562L, "CKM_RIPEMD128_HMAC_GENERAL");
        Functions.addMech(576L, "CKM_RIPEMD160");
        Functions.addMech(577L, "CKM_RIPEMD160_HMAC");
        Functions.addMech(578L, "CKM_RIPEMD160_HMAC_GENERAL");
        Functions.addMech(597L, "CKM_SHA224");
        Functions.addMech(598L, "CKM_SHA224_HMAC");
        Functions.addMech(599L, "CKM_SHA224_HMAC_GENERAL");
        Functions.addMech(592L, "CKM_SHA256");
        Functions.addMech(593L, "CKM_SHA256_HMAC");
        Functions.addMech(594L, "CKM_SHA256_HMAC_GENERAL");
        Functions.addMech(608L, "CKM_SHA384");
        Functions.addMech(609L, "CKM_SHA384_HMAC");
        Functions.addMech(610L, "CKM_SHA384_HMAC_GENERAL");
        Functions.addMech(624L, "CKM_SHA512");
        Functions.addMech(625L, "CKM_SHA512_HMAC");
        Functions.addMech(626L, "CKM_SHA512_HMAC_GENERAL");
        Functions.addMech(768L, "CKM_CAST_KEY_GEN");
        Functions.addMech(769L, "CKM_CAST_ECB");
        Functions.addMech(770L, "CKM_CAST_CBC");
        Functions.addMech(771L, "CKM_CAST_MAC");
        Functions.addMech(772L, "CKM_CAST_MAC_GENERAL");
        Functions.addMech(773L, "CKM_CAST_CBC_PAD");
        Functions.addMech(784L, "CKM_CAST3_KEY_GEN");
        Functions.addMech(785L, "CKM_CAST3_ECB");
        Functions.addMech(786L, "CKM_CAST3_CBC");
        Functions.addMech(787L, "CKM_CAST3_MAC");
        Functions.addMech(788L, "CKM_CAST3_MAC_GENERAL");
        Functions.addMech(789L, "CKM_CAST3_CBC_PAD");
        Functions.addMech(800L, "CKM_CAST128_KEY_GEN");
        Functions.addMech(801L, "CKM_CAST128_ECB");
        Functions.addMech(802L, "CKM_CAST128_CBC");
        Functions.addMech(803L, "CKM_CAST128_MAC");
        Functions.addMech(804L, "CKM_CAST128_MAC_GENERAL");
        Functions.addMech(805L, "CKM_CAST128_CBC_PAD");
        Functions.addMech(816L, "CKM_RC5_KEY_GEN");
        Functions.addMech(817L, "CKM_RC5_ECB");
        Functions.addMech(818L, "CKM_RC5_CBC");
        Functions.addMech(819L, "CKM_RC5_MAC");
        Functions.addMech(820L, "CKM_RC5_MAC_GENERAL");
        Functions.addMech(821L, "CKM_RC5_CBC_PAD");
        Functions.addMech(832L, "CKM_IDEA_KEY_GEN");
        Functions.addMech(833L, "CKM_IDEA_ECB");
        Functions.addMech(834L, "CKM_IDEA_CBC");
        Functions.addMech(835L, "CKM_IDEA_MAC");
        Functions.addMech(836L, "CKM_IDEA_MAC_GENERAL");
        Functions.addMech(837L, "CKM_IDEA_CBC_PAD");
        Functions.addMech(848L, "CKM_GENERIC_SECRET_KEY_GEN");
        Functions.addMech(864L, "CKM_CONCATENATE_BASE_AND_KEY");
        Functions.addMech(866L, "CKM_CONCATENATE_BASE_AND_DATA");
        Functions.addMech(867L, "CKM_CONCATENATE_DATA_AND_BASE");
        Functions.addMech(868L, "CKM_XOR_BASE_AND_DATA");
        Functions.addMech(869L, "CKM_EXTRACT_KEY_FROM_KEY");
        Functions.addMech(880L, "CKM_SSL3_PRE_MASTER_KEY_GEN");
        Functions.addMech(881L, "CKM_SSL3_MASTER_KEY_DERIVE");
        Functions.addMech(882L, "CKM_SSL3_KEY_AND_MAC_DERIVE");
        Functions.addMech(883L, "CKM_SSL3_MASTER_KEY_DERIVE_DH");
        Functions.addMech(884L, "CKM_TLS_PRE_MASTER_KEY_GEN");
        Functions.addMech(885L, "CKM_TLS_MASTER_KEY_DERIVE");
        Functions.addMech(886L, "CKM_TLS_KEY_AND_MAC_DERIVE");
        Functions.addMech(887L, "CKM_TLS_MASTER_KEY_DERIVE_DH");
        Functions.addMech(888L, "CKM_TLS_PRF");
        Functions.addMech(896L, "CKM_SSL3_MD5_MAC");
        Functions.addMech(897L, "CKM_SSL3_SHA1_MAC");
        Functions.addMech(992L, "CKM_TLS12_MASTER_KEY_DERIVE");
        Functions.addMech(993L, "CKM_TLS12_KEY_AND_MAC_DERIVE");
        Functions.addMech(994L, "CKM_TLS12_MASTER_KEY_DERIVE_DH");
        Functions.addMech(996L, "CKM_TLS_MAC");
        Functions.addMech(912L, "CKM_MD5_KEY_DERIVATION");
        Functions.addMech(913L, "CKM_MD2_KEY_DERIVATION");
        Functions.addMech(914L, "CKM_SHA1_KEY_DERIVATION");
        Functions.addMech(918L, "CKM_SHA224_KEY_DERIVATION");
        Functions.addMech(915L, "CKM_SHA256_KEY_DERIVATION");
        Functions.addMech(916L, "CKM_SHA384_KEY_DERIVATION");
        Functions.addMech(917L, "CKM_SHA512_KEY_DERIVATION");
        Functions.addMech(928L, "CKM_PBE_MD2_DES_CBC");
        Functions.addMech(929L, "CKM_PBE_MD5_DES_CBC");
        Functions.addMech(930L, "CKM_PBE_MD5_CAST_CBC");
        Functions.addMech(931L, "CKM_PBE_MD5_CAST3_CBC");
        Functions.addMech(932L, "CKM_PBE_MD5_CAST128_CBC");
        Functions.addMech(933L, "CKM_PBE_SHA1_CAST128_CBC");
        Functions.addMech(934L, "CKM_PBE_SHA1_RC4_128");
        Functions.addMech(935L, "CKM_PBE_SHA1_RC4_40");
        Functions.addMech(936L, "CKM_PBE_SHA1_DES3_EDE_CBC");
        Functions.addMech(937L, "CKM_PBE_SHA1_DES2_EDE_CBC");
        Functions.addMech(938L, "CKM_PBE_SHA1_RC2_128_CBC");
        Functions.addMech(939L, "CKM_PBE_SHA1_RC2_40_CBC");
        Functions.addMech(944L, "CKM_PKCS5_PBKD2");
        Functions.addMech(960L, "CKM_PBA_SHA1_WITH_SHA1_HMAC");
        Functions.addMech(1024L, "CKM_KEY_WRAP_LYNKS");
        Functions.addMech(1025L, "CKM_KEY_WRAP_SET_OAEP");
        Functions.addMech(4096L, "CKM_SKIPJACK_KEY_GEN");
        Functions.addMech(4097L, "CKM_SKIPJACK_ECB64");
        Functions.addMech(4098L, "CKM_SKIPJACK_CBC64");
        Functions.addMech(4099L, "CKM_SKIPJACK_OFB64");
        Functions.addMech(4100L, "CKM_SKIPJACK_CFB64");
        Functions.addMech(4101L, "CKM_SKIPJACK_CFB32");
        Functions.addMech(4102L, "CKM_SKIPJACK_CFB16");
        Functions.addMech(4103L, "CKM_SKIPJACK_CFB8");
        Functions.addMech(4104L, "CKM_SKIPJACK_WRAP");
        Functions.addMech(4105L, "CKM_SKIPJACK_PRIVATE_WRAP");
        Functions.addMech(4106L, "CKM_SKIPJACK_RELAYX");
        Functions.addMech(4112L, "CKM_KEA_KEY_PAIR_GEN");
        Functions.addMech(4113L, "CKM_KEA_KEY_DERIVE");
        Functions.addMech(4128L, "CKM_FORTEZZA_TIMESTAMP");
        Functions.addMech(4144L, "CKM_BATON_KEY_GEN");
        Functions.addMech(4145L, "CKM_BATON_ECB128");
        Functions.addMech(4146L, "CKM_BATON_ECB96");
        Functions.addMech(4147L, "CKM_BATON_CBC128");
        Functions.addMech(4148L, "CKM_BATON_COUNTER");
        Functions.addMech(4149L, "CKM_BATON_SHUFFLE");
        Functions.addMech(4150L, "CKM_BATON_WRAP");
        Functions.addMech(4160L, "CKM_EC_KEY_PAIR_GEN");
        Functions.addMech(4161L, "CKM_ECDSA");
        Functions.addMech(4162L, "CKM_ECDSA_SHA1");
        Functions.addMech(4176L, "CKM_ECDH1_DERIVE");
        Functions.addMech(4177L, "CKM_ECDH1_COFACTOR_DERIVE");
        Functions.addMech(4178L, "CKM_ECMQV_DERIVE");
        Functions.addMech(4192L, "CKM_JUNIPER_KEY_GEN");
        Functions.addMech(4193L, "CKM_JUNIPER_ECB128");
        Functions.addMech(4194L, "CKM_JUNIPER_CBC128");
        Functions.addMech(4195L, "CKM_JUNIPER_COUNTER");
        Functions.addMech(4196L, "CKM_JUNIPER_SHUFFLE");
        Functions.addMech(4197L, "CKM_JUNIPER_WRAP");
        Functions.addMech(4208L, "CKM_FASTHASH");
        Functions.addMech(4224L, "CKM_AES_KEY_GEN");
        Functions.addMech(4225L, "CKM_AES_ECB");
        Functions.addMech(4226L, "CKM_AES_CBC");
        Functions.addMech(4227L, "CKM_AES_MAC");
        Functions.addMech(4228L, "CKM_AES_MAC_GENERAL");
        Functions.addMech(4229L, "CKM_AES_CBC_PAD");
        Functions.addMech(4240L, "CKM_BLOWFISH_KEY_GEN");
        Functions.addMech(4241L, "CKM_BLOWFISH_CBC");
        Functions.addMech(8192L, "CKM_DSA_PARAMETER_GEN");
        Functions.addMech(8193L, "CKM_DH_PKCS_PARAMETER_GEN");
        Functions.addMech(8194L, "CKM_X9_42_DH_PARAMETER_GEN");
        Functions.addMech(0x80000000L, "CKM_VENDOR_DEFINED");
        Functions.addMech(2147484531L, "CKM_NSS_TLS_PRF_GENERAL");
        Functions.addMech(2147483424L, "SecureRandom");
        Functions.addMech(2147483425L, "KeyStore");
        Functions.addHashMech(544L, "SHA-1");
        Functions.addHashMech(597L, "SHA-224");
        Functions.addHashMech(592L, "SHA-256");
        Functions.addHashMech(608L, "SHA-384");
        Functions.addHashMech(624L, "SHA-512");
        Functions.addKeyType(0L, "CKK_RSA");
        Functions.addKeyType(1L, "CKK_DSA");
        Functions.addKeyType(2L, "CKK_DH");
        Functions.addKeyType(3L, "CKK_EC");
        Functions.addKeyType(4L, "CKK_X9_42_DH");
        Functions.addKeyType(5L, "CKK_KEA");
        Functions.addKeyType(16L, "CKK_GENERIC_SECRET");
        Functions.addKeyType(17L, "CKK_RC2");
        Functions.addKeyType(18L, "CKK_RC4");
        Functions.addKeyType(19L, "CKK_DES");
        Functions.addKeyType(20L, "CKK_DES2");
        Functions.addKeyType(21L, "CKK_DES3");
        Functions.addKeyType(22L, "CKK_CAST");
        Functions.addKeyType(23L, "CKK_CAST3");
        Functions.addKeyType(24L, "CKK_CAST128");
        Functions.addKeyType(25L, "CKK_RC5");
        Functions.addKeyType(26L, "CKK_IDEA");
        Functions.addKeyType(27L, "CKK_SKIPJACK");
        Functions.addKeyType(28L, "CKK_BATON");
        Functions.addKeyType(29L, "CKK_JUNIPER");
        Functions.addKeyType(30L, "CKK_CDMF");
        Functions.addKeyType(31L, "CKK_AES");
        Functions.addKeyType(32L, "CKK_BLOWFISH");
        Functions.addKeyType(0x80000000L, "CKK_VENDOR_DEFINED");
        Functions.addKeyType(0x7FFFFF22L, "*");
        Functions.addAttribute(0L, "CKA_CLASS");
        Functions.addAttribute(1L, "CKA_TOKEN");
        Functions.addAttribute(2L, "CKA_PRIVATE");
        Functions.addAttribute(3L, "CKA_LABEL");
        Functions.addAttribute(16L, "CKA_APPLICATION");
        Functions.addAttribute(17L, "CKA_VALUE");
        Functions.addAttribute(18L, "CKA_OBJECT_ID");
        Functions.addAttribute(128L, "CKA_CERTIFICATE_TYPE");
        Functions.addAttribute(129L, "CKA_ISSUER");
        Functions.addAttribute(130L, "CKA_SERIAL_NUMBER");
        Functions.addAttribute(131L, "CKA_AC_ISSUER");
        Functions.addAttribute(132L, "CKA_OWNER");
        Functions.addAttribute(133L, "CKA_ATTR_TYPES");
        Functions.addAttribute(134L, "CKA_TRUSTED");
        Functions.addAttribute(256L, "CKA_KEY_TYPE");
        Functions.addAttribute(257L, "CKA_SUBJECT");
        Functions.addAttribute(258L, "CKA_ID");
        Functions.addAttribute(259L, "CKA_SENSITIVE");
        Functions.addAttribute(260L, "CKA_ENCRYPT");
        Functions.addAttribute(261L, "CKA_DECRYPT");
        Functions.addAttribute(262L, "CKA_WRAP");
        Functions.addAttribute(263L, "CKA_UNWRAP");
        Functions.addAttribute(264L, "CKA_SIGN");
        Functions.addAttribute(265L, "CKA_SIGN_RECOVER");
        Functions.addAttribute(266L, "CKA_VERIFY");
        Functions.addAttribute(267L, "CKA_VERIFY_RECOVER");
        Functions.addAttribute(268L, "CKA_DERIVE");
        Functions.addAttribute(272L, "CKA_START_DATE");
        Functions.addAttribute(273L, "CKA_END_DATE");
        Functions.addAttribute(288L, "CKA_MODULUS");
        Functions.addAttribute(289L, "CKA_MODULUS_BITS");
        Functions.addAttribute(290L, "CKA_PUBLIC_EXPONENT");
        Functions.addAttribute(291L, "CKA_PRIVATE_EXPONENT");
        Functions.addAttribute(292L, "CKA_PRIME_1");
        Functions.addAttribute(293L, "CKA_PRIME_2");
        Functions.addAttribute(294L, "CKA_EXPONENT_1");
        Functions.addAttribute(295L, "CKA_EXPONENT_2");
        Functions.addAttribute(296L, "CKA_COEFFICIENT");
        Functions.addAttribute(304L, "CKA_PRIME");
        Functions.addAttribute(305L, "CKA_SUBPRIME");
        Functions.addAttribute(306L, "CKA_BASE");
        Functions.addAttribute(307L, "CKA_PRIME_BITS");
        Functions.addAttribute(308L, "CKA_SUB_PRIME_BITS");
        Functions.addAttribute(352L, "CKA_VALUE_BITS");
        Functions.addAttribute(353L, "CKA_VALUE_LEN");
        Functions.addAttribute(354L, "CKA_EXTRACTABLE");
        Functions.addAttribute(355L, "CKA_LOCAL");
        Functions.addAttribute(356L, "CKA_NEVER_EXTRACTABLE");
        Functions.addAttribute(357L, "CKA_ALWAYS_SENSITIVE");
        Functions.addAttribute(358L, "CKA_KEY_GEN_MECHANISM");
        Functions.addAttribute(368L, "CKA_MODIFIABLE");
        Functions.addAttribute(384L, "CKA_EC_PARAMS");
        Functions.addAttribute(385L, "CKA_EC_POINT");
        Functions.addAttribute(512L, "CKA_SECONDARY_AUTH");
        Functions.addAttribute(513L, "CKA_AUTH_PIN_FLAGS");
        Functions.addAttribute(768L, "CKA_HW_FEATURE_TYPE");
        Functions.addAttribute(769L, "CKA_RESET_ON_INIT");
        Functions.addAttribute(770L, "CKA_HAS_RESET");
        Functions.addAttribute(0x80000000L, "CKA_VENDOR_DEFINED");
        Functions.addAttribute(3584088832L, "CKA_NETSCAPE_DB");
        Functions.addAttribute(3461571416L, "CKA_NETSCAPE_TRUST_SERVER_AUTH");
        Functions.addAttribute(3461571417L, "CKA_NETSCAPE_TRUST_CLIENT_AUTH");
        Functions.addAttribute(3461571418L, "CKA_NETSCAPE_TRUST_CODE_SIGNING");
        Functions.addAttribute(3461571419L, "CKA_NETSCAPE_TRUST_EMAIL_PROTECTION");
        Functions.addAttribute(3461571508L, "CKA_NETSCAPE_CERT_SHA1_HASH");
        Functions.addAttribute(3461571509L, "CKA_NETSCAPE_CERT_MD5_HASH");
        Functions.addObjectClass(0L, "CKO_DATA");
        Functions.addObjectClass(1L, "CKO_CERTIFICATE");
        Functions.addObjectClass(2L, "CKO_PUBLIC_KEY");
        Functions.addObjectClass(3L, "CKO_PRIVATE_KEY");
        Functions.addObjectClass(4L, "CKO_SECRET_KEY");
        Functions.addObjectClass(5L, "CKO_HW_FEATURE");
        Functions.addObjectClass(6L, "CKO_DOMAIN_PARAMETERS");
        Functions.addObjectClass(0x80000000L, "CKO_VENDOR_DEFINED");
        Functions.addObjectClass(2147483427L, "*");
    }

    private static class Flags {
        private final long[] flagIds;
        private final String[] flagNames;

        Flags(long[] lArray, String[] stringArray) {
            if (lArray.length != stringArray.length) {
                throw new AssertionError((Object)"Array lengths do not match");
            }
            this.flagIds = lArray;
            this.flagNames = stringArray;
        }

        String toString(long l) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            for (int i = 0; i < this.flagIds.length; ++i) {
                if ((l & this.flagIds[i]) == 0L) continue;
                if (!bl) {
                    stringBuilder.append(" | ");
                }
                stringBuilder.append(this.flagNames[i]);
                bl = false;
            }
            return stringBuilder.toString();
        }
    }
}

