package org.bbreak.excella.reports.samples;

import java.math.BigDecimal;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import org.bbreak.excella.reports.exporter.OoPdfExporter;
import org.bbreak.excella.reports.model.ParamInfo;
import org.bbreak.excella.reports.model.ReportBook;
import org.bbreak.excella.reports.model.ReportSheet;
import org.bbreak.excella.reports.processor.ReportProcessor;
import org.bbreak.excella.reports.tag.BlockRowRepeatParamParser;
import org.bbreak.excella.reports.tag.SingleParamParser;

/**
 * ʔ\Tvo̓NX
 * 
 * @since 1.0
 */
public class TransExpenseReporter {

    private static Calendar calendar = Calendar.getInstance();
    
    /**
     * ʔ\Tv̏o͂s܂B
     * 
     * @param args
     * @throws Exception
     */
    public static void main( String[] args) throws Exception {

        // 
        // @ǂݍރev[gt@C̃pX(gq)
        // Ao͐̃t@CpX(gqExpoterɂĎIɕt^邽߁AsvB)
        // Bt@CtH[}bg(ConvertConfiguration̔z)
        // w肵AReportBookCX^X𐶐܂B
        //
        String templateFileName = "ʔ\ev[g.xls";
        URL templateFileUrl = TransExpenseReporter.class.getResource( templateFileName);
        String templateFilePath = URLDecoder.decode( templateFileUrl.getPath(), "UTF-8");
        
        // TODO: o͐̃fBNgAyуt@C(gqsv)w肵ĂB
        String outputFileName = "ʔ\Tv";
        String outputFileDir = "C:/reports_output/";
        String outputFilePath = outputFileDir.concat( outputFileName);
        ReportBook outputBook = new ReportBook( templateFilePath, outputFilePath, OoPdfExporter.FORMAT_TYPE);

        //
        // PDFɃIvVw肵ꍇ
        // ConvertConfiguration쐬
        //
//        ConvertConfiguration convertConfig = new ConvertConfiguration( OoPdfExporter.FORMAT_TYPE);
//        ReportBook outputBook = new ReportBook( templateFilePath, outputFilePath, convertConfig);
//        convertConfig.addOption( "RestrictPermissions", Boolean.TRUE); //ݒFL
//        convertConfig.addOption( "PermissionPassword", "pass");        //ҏWpX[h
//        convertConfig.addOption( "Printing", 0);                       //s
//        convertConfig.addOption( "Changes", 4);                         //ҏWs
        
        
        
        
        //
        // ev[gt@C̃V[gƏo̓V[gw肵A
        // ReportSheetCX^X𐶐āAReportBookɒǉ܂B
        //
        ReportSheet outputSheet = new ReportSheet( "\", "\");
        outputBook.addReportSheet( outputSheet);

        //
        // up[^ReportSheetIuWFNgɒǉ܂B
        // (ũp[^ɂ͔zn܂B)
        //
        outputSheet.addParam( SingleParamParser.DEFAULT_TAG, "\ԍ", "000001");

        outputSheet.addParam( SingleParamParser.DEFAULT_TAG, "\", calendar.getTime());

        outputSheet.addParam( SingleParamParser.DEFAULT_TAG, "Јԍ", "000123");

        outputSheet.addParam( SingleParamParser.DEFAULT_TAG, "", "[UP");

        int targetYear = calendar.get( Calendar.YEAR);
        int targetMonth = calendar.get( Calendar.MONTH) - 1;
        calendar.set( targetYear, targetMonth, 1);
        outputSheet.addParam( SingleParamParser.DEFAULT_TAG, "Ώ۔N", calendar.getTime());

        ParamInfo[] details = createDetailParamInfos( targetYear, targetMonth);
        outputSheet.addParam( BlockRowRepeatParamParser.DEFAULT_TAG, "", details);

        //
        // ReportProcessorCX^X𐶐A
        // ReportBookɃ|[gs܂B
        //
        ReportProcessor reportProcessor = new ReportProcessor();
        reportProcessor.process( outputBook);

    }

    /**
     * גuf[^𐶐܂B
     * 
     * @return ׂListԂ܂B
     */
    private static ParamInfo[] createDetailParamInfos( int targetYear, int targetMonth) {

        List<ParamInfo> details = new ArrayList<ParamInfo>();
        ParamInfo detail = null;

        // 1s
        detail = new ParamInfo();
        calendar.set( targetYear, targetMonth, 1);
        detail.addParam( SingleParamParser.DEFAULT_TAG, "t", calendar.getTime());
        detail.addParam( SingleParamParser.DEFAULT_TAG, "", "");
        detail.addParam( SingleParamParser.DEFAULT_TAG, "~", "i");
        detail.addParam( SingleParamParser.DEFAULT_TAG, "ʋ@", "d");
        detail.addParam( SingleParamParser.DEFAULT_TAG, "Ev", "EvA");
        detail.addParam( SingleParamParser.DEFAULT_TAG, "z", new BigDecimal( 160));
        details.add( detail);

        // 2s
        detail = new ParamInfo();
        calendar.set( targetYear, targetMonth, 2);
        detail.addParam( SingleParamParser.DEFAULT_TAG, "t", calendar.getTime());
        detail.addParam( SingleParamParser.DEFAULT_TAG, "", "");
        detail.addParam( SingleParamParser.DEFAULT_TAG, "~", "Vh");
        detail.addParam( SingleParamParser.DEFAULT_TAG, "ʋ@", "d");
        detail.addParam( SingleParamParser.DEFAULT_TAG, "Ev", "EvB");
        detail.addParam( SingleParamParser.DEFAULT_TAG, "z", new BigDecimal( 190));
        details.add( detail);

        // 3s
        detail = new ParamInfo();
        calendar.set( targetYear, targetMonth, 3);
        detail.addParam( SingleParamParser.DEFAULT_TAG, "t", calendar.getTime());
        detail.addParam( SingleParamParser.DEFAULT_TAG, "", "");
        detail.addParam( SingleParamParser.DEFAULT_TAG, "~", "aJ");
        detail.addParam( SingleParamParser.DEFAULT_TAG, "", "d");
        detail.addParam( SingleParamParser.DEFAULT_TAG, "", "EvC");
        detail.addParam( SingleParamParser.DEFAULT_TAG, "", new BigDecimal( 190));
        details.add( detail);

        return details.toArray( new ParamInfo[details.size()]);
    }

}
