/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.core.tag.excel2java;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArraysParser
extends TagParser<List<Object[]>> {
    protected static final String PARAM_DATA_ROW_FROM = "DataRowFrom";
    protected static final String PARAM_DATA_ROW_TO = "DataRowTo";
    protected static final String PARAM_DATA_CLOMUN_FROM = "DataColumnFrom";
    protected static final String PARAM_DATA_CLOMUN_TO = "DataColumnTo";
    protected static final int DEFAULT_VALUE_ROW_FROM_ADJUST = 1;
    protected static final int DEFAULT_VALUE_COLUMN_FROM_ADJUST = 0;

    public ArraysParser(String tag) {
        super(tag);
    }

    @Override
    public List<Object[]> parse(Sheet sheet, Cell tagCell, Object data) throws ParseException {
        ArrayList<Object[]> resultList = new ArrayList<Object[]>();
        int tagRowIdx = tagCell.getRowIndex();
        int tagColIdx = tagCell.getColumnIndex();
        int valueRowToIdx = sheet.getLastRowNum();
        int valueColumnToIdx = 0;
        boolean valueColumnToFlag = false;
        try {
            Map<String, String> paramDef = TagUtil.getParams(tagCell.getStringCellValue());
            int valueRowFromIdx = TagUtil.adjustValue(tagRowIdx, paramDef, PARAM_DATA_ROW_FROM, 1);
            if (valueRowFromIdx < 0 || valueRowFromIdx > sheet.getLastRowNum()) {
                throw new ParseException(tagCell, "\u30d1\u30e9\u30e1\u30fc\u30bf\u5024\u4e0d\u6b63\uff1aDataRowFrom");
            }
            if ((valueRowToIdx = TagUtil.adjustValue(tagRowIdx, paramDef, PARAM_DATA_ROW_TO, valueRowToIdx - tagRowIdx)) > sheet.getLastRowNum() || valueRowToIdx < 0) {
                throw new ParseException(tagCell, "\u30d1\u30e9\u30e1\u30fc\u30bf\u5024\u4e0d\u6b63\uff1aDataRowTo");
            }
            if (valueRowFromIdx > valueRowToIdx) {
                throw new ParseException(tagCell, "\u30d1\u30e9\u30e1\u30fc\u30bf\u5024\u4e0d\u6b63\uff1aDataRowFrom,DataRowTo");
            }
            int valueColumnFromIdx = TagUtil.adjustValue(tagColIdx, paramDef, PARAM_DATA_CLOMUN_FROM, 0);
            if (valueColumnFromIdx < 0 || valueColumnFromIdx > PoiUtil.getLastColNum(sheet)) {
                throw new ParseException(tagCell, "\u30d1\u30e9\u30e1\u30fc\u30bf\u5024\u4e0d\u6b63\uff1aDataColumnFrom");
            }
            valueColumnToFlag = paramDef.containsKey(PARAM_DATA_CLOMUN_TO);
            if (valueColumnToFlag) {
                valueColumnToIdx = tagColIdx + Integer.valueOf(paramDef.get(PARAM_DATA_CLOMUN_TO));
                if (valueColumnToIdx < 0 || valueColumnToIdx > PoiUtil.getLastColNum(sheet)) {
                    throw new ParseException(tagCell, "\u30d1\u30e9\u30e1\u30fc\u30bf\u5024\u4e0d\u6b63\uff1aDataColumnTo");
                }
                if (valueColumnFromIdx > valueColumnToIdx) {
                    throw new ParseException(tagCell, "\u30d1\u30e9\u30e1\u30fc\u30bf\u5024\u4e0d\u6b63\uff1aDataColumnFrom,DataColumnTo");
                }
            }
        }
        catch (Exception e) {
            if (e instanceof ParseException) {
                throw (ParseException)e;
            }
            throw new ParseException(tagCell, (Throwable)e);
        }
        for (int rowCnt = valueRowFromIdx; rowCnt <= valueRowToIdx; ++rowCnt) {
            ArrayList<Object> objList = new ArrayList<Object>();
            Row row = sheet.getRow(rowCnt);
            if (row == null) continue;
            if (!valueColumnToFlag) {
                valueColumnToIdx = row.getLastCellNum() - 1;
            }
            for (int cellCnt = valueColumnFromIdx; cellCnt <= valueColumnToIdx; ++cellCnt) {
                Cell cell = row.getCell(cellCnt);
                Object cellValue = PoiUtil.getCellValue(cell);
                objList.add(cellValue);
            }
            resultList.add(objList.toArray());
        }
        return resultList;
    }
}

