/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import java.io.FileFilter;
import org.tigris.subversion.svnant.SvnAntException;
import org.tigris.subversion.svnant.SvnAntValidationException;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class Ignore
extends SvnCommand {
    private File file = null;
    private boolean failonerror = false;
    private File dir = null;
    private boolean recurse = false;
    private String pattern;

    public void execute() throws SvnAntException {
        if (this.file != null) {
            this.svnIgnoreFile(this.file);
        }
        if (this.dir != null) {
            this.svnIgnorePattern(this.dir, this.pattern, this.recurse);
        }
    }

    protected void validateAttributes() throws SvnAntValidationException {
        if (this.file == null && this.dir == null) {
            throw new SvnAntValidationException("file or dir must be set");
        }
        if (this.dir != null) {
            if (this.file != null) {
                throw new SvnAntValidationException("file must not be set when dir attribute is present");
            }
            if (this.pattern == null) {
                throw new SvnAntValidationException("pattern must be set when dir attribute is present");
            }
        }
        if (this.file != null && this.pattern != null) {
            throw new SvnAntValidationException("pattern must not be set when file attribute is present");
        }
    }

    private void svnIgnoreFile(File file) throws SvnAntException {
        if (file.exists()) {
            try {
                this.svnClient.addToIgnoredPatterns(file.getParentFile(), file.getName());
            }
            catch (SVNClientException sVNClientException) {
                throw new SvnAntException("Can't add file " + file.getAbsolutePath() + "to svn:ignore", sVNClientException);
            }
        } else {
            String string = "Warning: Could not find file " + file.getAbsolutePath();
            if (!this.failonerror) {
                this.logWarning(string);
            } else {
                throw new SvnAntException(string);
            }
        }
    }

    private void svnIgnorePattern(File file, String string, boolean bl) throws SvnAntException {
        this.svnIgnorePattern(file, string);
        if (bl) {
            File[] fileArray = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() && !file.getName().equals(Ignore.this.svnClient.getAdminDirectoryName());
                }
            });
            for (int i = 0; i < fileArray.length; ++i) {
                this.svnIgnorePattern(fileArray[i], string, true);
            }
        }
    }

    private void svnIgnorePattern(File file, String string) throws SvnAntException {
        if (file.exists()) {
            if (!file.isDirectory()) {
                this.logWarning("Can't add a pattern to svn:ignore for a file. It needs to be a directory");
            } else {
                try {
                    this.svnClient.addToIgnoredPatterns(file, string);
                }
                catch (SVNClientException sVNClientException) {
                    throw new SvnAntException("Can't add pattern " + string + " to svn:ignore for " + file.getAbsolutePath(), sVNClientException);
                }
            }
        } else {
            String string2 = "Warning: Could not find directory " + file.getAbsolutePath();
            if (!this.failonerror) {
                this.logWarning(string2);
            } else {
                throw new SvnAntException(string2);
            }
        }
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setDir(File file) {
        this.dir = file;
    }

    public void setRecurse(boolean bl) {
        this.recurse = bl;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }
}

