/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.reports.exporter;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Workbook;
import org.artofsolving.jodconverter.OfficeDocumentConverter;
import org.artofsolving.jodconverter.document.DefaultDocumentFormatRegistry;
import org.artofsolving.jodconverter.document.DocumentFamily;
import org.artofsolving.jodconverter.document.DocumentFormat;
import org.artofsolving.jodconverter.document.DocumentFormatRegistry;
import org.artofsolving.jodconverter.office.DefaultOfficeManagerConfiguration;
import org.artofsolving.jodconverter.office.OfficeManager;
import org.bbreak.excella.core.BookData;
import org.bbreak.excella.core.exception.ExportException;
import org.bbreak.excella.reports.exporter.ExcelExporter;
import org.bbreak.excella.reports.exporter.ReportBookExporter;
import org.bbreak.excella.reports.model.ConvertConfiguration;

public class OoPdfExporter
extends ReportBookExporter {
    private static Log log = LogFactory.getLog(OoPdfExporter.class);
    public static final String FORMAT_TYPE = "PDF";
    public static final String EXTENTION = ".pdf";
    public static final int OPENOFFICE_DEFAULT_PORT = 8100;
    private int port = 8100;
    private OfficeManager officeManager = null;
    private boolean controlOfficeManager = false;

    public OoPdfExporter() {
    }

    public OoPdfExporter(int port) {
        this.port = port;
    }

    public OoPdfExporter(OfficeManager officeManager) {
        this.officeManager = officeManager;
        this.controlOfficeManager = true;
    }

    public void output(Workbook book, BookData bookdata, ConvertConfiguration configuration) throws ExportException {
        if (log.isInfoEnabled()) {
            log.info((Object)("\u51e6\u7406\u7d50\u679c\u3092" + this.getFilePath() + "\u306b\u51fa\u529b\u3057\u307e\u3059"));
        }
        if (!this.controlOfficeManager) {
            this.officeManager = new DefaultOfficeManagerConfiguration().setPortNumber(this.port).buildOfficeManager();
            this.officeManager.start();
        }
        File tmpFile = null;
        try {
            OfficeDocumentConverter converter = null;
            if (configuration.getOptionsProperties().isEmpty()) {
                converter = new OfficeDocumentConverter(this.officeManager);
            } else {
                DocumentFormatRegistry registry = this.createDocumentFormatRegistry(configuration);
                converter = new OfficeDocumentConverter(this.officeManager, registry);
            }
            ExcelExporter excelExporter = new ExcelExporter();
            String tmpFileName = System.getProperty("java.io.tmpdir") + System.currentTimeMillis();
            excelExporter.setFilePath(tmpFileName);
            excelExporter.output(book, bookdata, null);
            tmpFileName = excelExporter.getFilePath();
            tmpFile = new File(tmpFileName);
            converter.convert(tmpFile, new File(this.getFilePath()));
        }
        catch (Exception e) {
            throw new ExportException((Throwable)e);
        }
        finally {
            if (!this.controlOfficeManager) {
                this.officeManager.stop();
            }
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }

    private DocumentFormatRegistry createDocumentFormatRegistry(ConvertConfiguration configuration) {
        DefaultDocumentFormatRegistry registry = new DefaultDocumentFormatRegistry();
        if (configuration == null || configuration.getOptionsProperties().isEmpty()) {
            return registry;
        }
        DocumentFormat documentFormat = registry.getFormatByExtension("pdf");
        HashMap<String, Map<String, Object>> optionMap = new HashMap<String, Map<String, Object>>(documentFormat.getStoreProperties(DocumentFamily.SPREADSHEET));
        optionMap.put("FilterData", configuration.getOptions());
        documentFormat.setStoreProperties(DocumentFamily.SPREADSHEET, optionMap);
        return registry;
    }

    public String getFormatType() {
        return FORMAT_TYPE;
    }

    public String getExtention() {
        return EXTENTION;
    }
}

