/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNLogRunner {
    private boolean myIsEntriesChanged;
    private boolean myIsWCPropertiesChanged;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void runCommand(SVNAdminArea adminArea, String name, SVNProperties attributes, int count) throws SVNException {
        SVNErrorCode code;
        SVNException error;
        block98: {
            String dstName;
            File src;
            File file;
            String fileName;
            block109: {
                block108: {
                    block107: {
                        block106: {
                            block105: {
                                SVNHashMap entryAttrs;
                                block104: {
                                    block103: {
                                        block102: {
                                            error = null;
                                            fileName = attributes.getStringValue("name");
                                            if ("delete-entry".equals(name)) {
                                                File path = adminArea.getFile(fileName);
                                                SVNAdminArea dir = adminArea.getWCAccess().probeRetrieve(path);
                                                SVNEntry entry = dir.getWCAccess().getEntry(path, false);
                                                if (entry == null) {
                                                    return;
                                                }
                                                try {
                                                    if (entry.isDirectory()) {
                                                        try {
                                                            SVNAdminArea childDir = dir.getWCAccess().retrieve(path);
                                                            if (childDir != null) {
                                                                childDir.extendLockToTree();
                                                                childDir.removeFromRevisionControl(childDir.getThisDirName(), true, false);
                                                            } else {
                                                                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED), SVNLogType.DEFAULT);
                                                            }
                                                            break block98;
                                                        }
                                                        catch (SVNException e) {
                                                            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                                                                if (!entry.isScheduledForAddition()) {
                                                                    adminArea.deleteEntry(fileName);
                                                                    adminArea.saveEntries(false);
                                                                }
                                                                break block98;
                                                            }
                                                            throw e;
                                                        }
                                                    }
                                                    if (entry.isFile()) {
                                                        adminArea.removeFromRevisionControl(fileName, true, false);
                                                    }
                                                    break block98;
                                                }
                                                catch (SVNException e) {
                                                    if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_LEFT_LOCAL_MOD) {
                                                        error = e;
                                                    }
                                                    break block98;
                                                }
                                            }
                                            if (!"modify-entry".equals(name)) break block102;
                                            try {
                                                String workingSize;
                                                SVNEntry entry;
                                                String value;
                                                entryAttrs = new SVNHashMap();
                                                Iterator attrtibutesIter = attributes.nameSet().iterator();
                                                while (attrtibutesIter.hasNext()) {
                                                    String attrName = (String)attrtibutesIter.next();
                                                    if ("".equals(attrName) || "name".equals(attrName) || "force".equals(attrName)) continue;
                                                    String value2 = attributes.getStringValue(attrName);
                                                    attrName = "svn:entry:" + attrName;
                                                    entryAttrs.put(attrName, value2);
                                                }
                                                if (entryAttrs.containsKey("svn:entry:text-time") && "working".equals(value = (String)entryAttrs.get("svn:entry:text-time"))) {
                                                    File file2 = adminArea.getFile(fileName);
                                                    value = SVNDate.formatDate(new Date(file2.lastModified()));
                                                    entryAttrs.put("svn:entry:text-time", value);
                                                }
                                                if (entryAttrs.containsKey("svn:entry:prop-time") && "working".equals(value = (String)entryAttrs.get("svn:entry:prop-time"))) {
                                                    entry = adminArea.getEntry(fileName, false);
                                                    if (entry == null) {
                                                        return;
                                                    }
                                                    value = adminArea.getPropertyTime(fileName);
                                                    entryAttrs.put("svn:entry:prop-time", value);
                                                }
                                                if (entryAttrs.containsKey("svn:entry:working-size") && "working".equals(workingSize = (String)entryAttrs.get("svn:entry:working-size"))) {
                                                    entry = adminArea.getEntry(fileName, false);
                                                    if (entry == null) {
                                                        return;
                                                    }
                                                    File file3 = adminArea.getFile(fileName);
                                                    if (!file3.exists()) {
                                                        entryAttrs.put("svn:entry:working-size", "0");
                                                    } else {
                                                        try {
                                                            entryAttrs.put("svn:entry:working-size", Long.toString(file3.length()));
                                                        }
                                                        catch (SecurityException se) {
                                                            SVNErrorCode code2 = count <= 1 ? SVNErrorCode.WC_BAD_ADM_LOG_START : SVNErrorCode.WC_BAD_ADM_LOG;
                                                            SVNErrorMessage err = SVNErrorMessage.create(code2, "Error getting file size on ''{0}''", file3);
                                                            SVNErrorManager.error(err, se, SVNLogType.WC);
                                                        }
                                                    }
                                                }
                                                boolean force = false;
                                                if (attributes.containsName("force")) {
                                                    String forceAttr = attributes.getStringValue("force");
                                                    force = SVNProperty.booleanValue(forceAttr);
                                                }
                                                try {
                                                    adminArea.modifyEntry(fileName, entryAttrs, false, force);
                                                }
                                                catch (SVNException svne) {
                                                    SVNErrorCode code3 = count <= 1 ? SVNErrorCode.WC_BAD_ADM_LOG_START : SVNErrorCode.WC_BAD_ADM_LOG;
                                                    SVNErrorMessage err = SVNErrorMessage.create(code3, "Error modifying entry for ''{0}''", fileName);
                                                    SVNErrorManager.error(err, svne, SVNLogType.WC);
                                                }
                                                this.setEntriesChanged(true);
                                            }
                                            catch (SVNException svne) {
                                                error = svne;
                                            }
                                            break block98;
                                        }
                                        if (!"modify-wcprop".equals(name)) break block103;
                                        try {
                                            SVNVersionedProperties wcprops = adminArea.getWCProperties(fileName);
                                            if (wcprops != null) {
                                                String propName = attributes.getStringValue("propname");
                                                SVNPropertyValue propValue = attributes.getSVNPropertyValue("propval");
                                                wcprops.setPropertyValue(propName, propValue);
                                                this.setWCPropertiesChanged(true);
                                            }
                                            break block98;
                                        }
                                        catch (SVNException svne) {
                                            error = svne;
                                        }
                                        break block98;
                                    }
                                    if (!"delete-lock".equals(name)) break block104;
                                    try {
                                        SVNEntry entry = adminArea.getEntry(fileName, true);
                                        if (entry != null) {
                                            entry.setLockToken(null);
                                            entry.setLockOwner(null);
                                            entry.setLockCreationDate(null);
                                            entry.setLockComment(null);
                                            this.setEntriesChanged(true);
                                        }
                                        break block98;
                                    }
                                    catch (SVNException svne) {
                                        SVNErrorCode code4 = count <= 1 ? SVNErrorCode.WC_BAD_ADM_LOG_START : SVNErrorCode.WC_BAD_ADM_LOG;
                                        SVNErrorMessage err = SVNErrorMessage.create(code4, "Error removing lock from entry for ''{0}''", fileName);
                                        error = new SVNException(err, (Throwable)svne);
                                    }
                                    break block98;
                                }
                                if (!"delete-changelist".equals(name)) break block105;
                                try {
                                    entryAttrs = new SVNHashMap();
                                    entryAttrs.put("svn:entry:changelist", null);
                                    adminArea.modifyEntry(fileName, entryAttrs, false, false);
                                    this.setEntriesChanged(true);
                                }
                                catch (SVNException svne) {
                                    SVNErrorCode code5 = count <= 1 ? SVNErrorCode.WC_BAD_ADM_LOG_START : SVNErrorCode.WC_BAD_ADM_LOG;
                                    SVNErrorMessage err = SVNErrorMessage.create(code5, "Error removing changelist from entry ''{0}''", fileName);
                                    error = new SVNException(err, (Throwable)svne);
                                }
                                break block98;
                            }
                            if (!"rm".equals(name)) break block106;
                            file = adminArea.getFile(fileName);
                            SVNFileUtil.deleteFile(file);
                            break block98;
                        }
                        if (!"readonly".equals(name)) break block107;
                        file = adminArea.getFile(fileName);
                        SVNFileUtil.setReadonly(file, true);
                        break block98;
                    }
                    if (!"mv".equals(name)) break block108;
                    src = adminArea.getFile(fileName);
                    File dst = adminArea.getFile(attributes.getStringValue("dest"));
                    try {
                        SVNFileUtil.rename(src, dst);
                    }
                    catch (SVNException svne) {
                        error = new SVNException(svne.getErrorMessage().wrap("Can't move source to dest"), (Throwable)svne);
                    }
                    break block98;
                }
                if (!"append".equals(name)) break block109;
                src = adminArea.getFile(fileName);
                File dst = adminArea.getFile(attributes.getStringValue("dest"));
                OutputStream os = null;
                InputStream is = null;
                try {
                    int r;
                    os = SVNFileUtil.openFileForWriting(dst, true);
                    is = SVNFileUtil.openFileForReading(src, SVNLogType.WC);
                    while ((r = is.read()) >= 0) {
                        os.write(r);
                    }
                }
                catch (IOException e) {
                    block99: {
                        if (!src.exists()) break block99;
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write to ''{0}'': {1}", new Object[]{dst, e.getLocalizedMessage()});
                        error = new SVNException(err, (Throwable)e);
                    }
                    SVNFileUtil.closeFile(os);
                    SVNFileUtil.closeFile(is);
                    break block98;
                }
                catch (SVNException svne) {
                    block100: {
                        if (!src.exists()) break block100;
                        error = svne;
                        {
                            catch (Throwable throwable) {
                                SVNFileUtil.closeFile(os);
                                SVNFileUtil.closeFile(is);
                                throw throwable;
                            }
                        }
                    }
                    SVNFileUtil.closeFile(os);
                    SVNFileUtil.closeFile(is);
                    break block98;
                }
                SVNFileUtil.closeFile(os);
                SVNFileUtil.closeFile(is);
                break block98;
            }
            if ("set-timestamp".equals(name)) {
                file = adminArea.getFile(fileName);
                String timestamp = attributes.getStringValue("timestamp");
                try {
                    SVNDate time;
                    if (timestamp == null) {
                        SVNErrorCode code6 = count <= 1 ? SVNErrorCode.WC_BAD_ADM_LOG_START : SVNErrorCode.WC_BAD_ADM_LOG;
                        SVNErrorMessage err = SVNErrorMessage.create(code6, "Missing 'timestamp' attribute in ''{0}''", adminArea.getRoot());
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    if (!file.setLastModified((time = SVNDate.parseDate(timestamp)).getTime()) && !file.canWrite() && file.isFile()) {
                        SVNFileUtil.setReadonly(file, false);
                        file.setLastModified(time.getTime());
                        SVNFileUtil.setReadonly(file, true);
                    }
                }
                catch (SVNException svne) {
                    error = svne;
                }
            } else if ("upgrade-format".equals(name)) {
                String format = attributes.getStringValue("format");
                SVNErrorCode code7 = count <= 1 ? SVNErrorCode.WC_BAD_ADM_LOG_START : SVNErrorCode.WC_BAD_ADM_LOG;
                try {
                    if (format == null) {
                        SVNErrorMessage err = SVNErrorMessage.create(code7, "Invalid 'format' attribute");
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    int number = -1;
                    try {
                        number = Integer.parseInt(format);
                    }
                    catch (NumberFormatException e) {
                        SVNErrorMessage err = SVNErrorMessage.create(code7, "Invalid 'format' attribute");
                        SVNErrorManager.error(err, e, SVNLogType.WC);
                    }
                    adminArea.postUpgradeFormat(number);
                    this.setEntriesChanged(true);
                }
                catch (SVNException svne) {
                    error = svne;
                }
            } else if ("maybe-readonly".equals(name)) {
                file = adminArea.getFile(fileName);
                try {
                    SVNEntry entry = adminArea.getEntry(fileName, false);
                    if (entry == null) break block98;
                    adminArea.closeVersionedProperties();
                    SVNVersionedProperties props = adminArea.getProperties(fileName);
                    String needsLock = props.getStringPropertyValue("svn:needs-lock");
                    if (entry.getLockToken() == null && needsLock != null) {
                        SVNFileUtil.setReadonly(file, true);
                    }
                }
                catch (SVNException svne) {
                    error = svne;
                }
            } else if ("maybe-executable".equals(name)) {
                boolean executable;
                adminArea.closeVersionedProperties();
                SVNVersionedProperties props = adminArea.getProperties(fileName);
                boolean bl = SVNFileUtil.isWindows ? false : (executable = props.getPropertyValue("svn:executable") != null);
                if (executable) {
                    SVNFileUtil.setExecutable(adminArea.getFile(fileName), true);
                }
            } else if ("cp-and-translate".equals(name)) {
                dstName = attributes.getStringValue("dest");
                String versionedName = attributes.getStringValue("arg2");
                if (versionedName == null) {
                    versionedName = dstName;
                }
                File src2 = adminArea.getFile(fileName);
                File dst = adminArea.getFile(dstName);
                adminArea.closeVersionedProperties();
                try {
                    SVNEntry entry;
                    boolean executable;
                    block101: {
                        try {
                            SVNTranslator.translate(adminArea, versionedName, src2, dst, null, true);
                        }
                        catch (SVNException svne) {
                            if (!src2.exists()) break block101;
                            throw svne;
                        }
                    }
                    SVNVersionedProperties props = adminArea.getProperties(dstName);
                    boolean bl = SVNFileUtil.isWindows ? false : (executable = props.getPropertyValue("svn:executable") != null);
                    if (executable) {
                        SVNFileUtil.setExecutable(dst, true);
                    }
                    if ((entry = adminArea.getEntry(dstName, false)) != null && entry.getLockToken() == null && props.getPropertyValue("svn:needs-lock") != null) {
                        SVNFileUtil.setReadonly(dst, true);
                    }
                }
                catch (SVNException svne) {
                    error = svne;
                }
            } else if ("cp-and-detranslate".equals(name)) {
                dstName = attributes.getStringValue("dest");
                String versionedName = attributes.getStringValue("arg2");
                adminArea.closeVersionedProperties();
                try {
                    SVNTranslator.translate(adminArea, versionedName != null ? versionedName : fileName, fileName, dstName, false);
                }
                catch (SVNException svne) {
                    error = svne;
                }
            } else if ("cp".equals(name)) {
                src = adminArea.getFile(fileName);
                File dst = adminArea.getFile(attributes.getStringValue("dest"));
                try {
                    SVNFileUtil.copy(src, dst, true, false);
                }
                catch (SVNException svne) {
                    error = svne;
                }
            } else if ("merge".equals(name)) {
                File target = adminArea.getFile(fileName);
                try {
                    String leftLabel;
                    String rightPath;
                    SVNErrorCode code8 = count <= 1 ? SVNErrorCode.WC_BAD_ADM_LOG_START : SVNErrorCode.WC_BAD_ADM_LOG;
                    String leftPath = attributes.getStringValue("arg1");
                    if (leftPath == null) {
                        SVNErrorMessage err = SVNErrorMessage.create(code8, "Missing 'left' attribute in ''{0}''", adminArea.getRoot());
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    if ((rightPath = attributes.getStringValue("arg2")) == null) {
                        SVNErrorMessage err = SVNErrorMessage.create(code8, "Missing 'right' attribute in ''{0}''", adminArea.getRoot());
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    leftLabel = (leftLabel = attributes.getStringValue("arg3")) == null ? ".old" : leftLabel;
                    String rightLabel = attributes.getStringValue("arg4");
                    rightLabel = rightLabel == null ? ".new" : rightLabel;
                    String targetLabel = attributes.getStringValue("arg5");
                    targetLabel = targetLabel == null ? ".working" : targetLabel;
                    adminArea.closeVersionedProperties();
                    SVNVersionedProperties props = adminArea.getProperties(fileName);
                    SVNEntry entry = adminArea.getEntry(fileName, true);
                    SVNStatusType mergeResult = adminArea.mergeText(fileName, adminArea.getFile(leftPath), adminArea.getFile(rightPath), null, targetLabel, leftLabel, rightLabel, null, false, null, null);
                    if (props.getPropertyValue("svn:executable") != null) {
                        SVNFileUtil.setExecutable(target, true);
                    }
                    if (props.getPropertyValue("svn:needs-lock") != null && entry.getLockToken() == null) {
                        SVNFileUtil.setReadonly(target, true);
                    }
                    this.setEntriesChanged(mergeResult == SVNStatusType.CONFLICTED || mergeResult == SVNStatusType.CONFLICTED_UNRESOLVED);
                }
                catch (SVNException svne) {
                    error = svne;
                }
            } else if ("committed".equals(name)) {
                try {
                    SVNEntry entry;
                    SVNErrorCode sVNErrorCode = code = count <= 1 ? SVNErrorCode.WC_BAD_ADM_LOG_START : SVNErrorCode.WC_BAD_ADM_LOG;
                    if (attributes.getStringValue("revision") == null) {
                        SVNErrorMessage err = SVNErrorMessage.create(code, "Missing revision attribute for ''{0}''", fileName);
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    if ((entry = adminArea.getEntry(fileName, true)) == null || !adminArea.getThisDirName().equals(fileName) && entry.getKind() != SVNNodeKind.FILE) {
                        SVNErrorMessage err = SVNErrorMessage.create(code, "Log command for directory ''{0}'' is mislocated", adminArea.getRoot());
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    boolean implicit = attributes.getStringValue("implicit") != null && entry.isCopied();
                    this.setEntriesChanged(true);
                    long revisionNumber = Long.parseLong(attributes.getStringValue("revision"));
                    adminArea.postCommit(fileName, revisionNumber, implicit, code);
                }
                catch (SVNException svne) {
                    error = svne;
                }
            } else {
                code = count <= 1 ? SVNErrorCode.WC_BAD_ADM_LOG_START : SVNErrorCode.WC_BAD_ADM_LOG;
                SVNErrorMessage err = SVNErrorMessage.create(code, "Unrecognized logfile element ''{0}'' in ''{1}''", new Object[]{name, adminArea.getRoot()});
                SVNErrorManager.error(err.wrap("In directory ''{0}''", adminArea.getRoot()), SVNLogType.WC);
            }
        }
        if (error != null) {
            code = count <= 1 ? SVNErrorCode.WC_BAD_ADM_LOG_START : SVNErrorCode.WC_BAD_ADM_LOG;
            SVNErrorMessage err = SVNErrorMessage.create(code, "Error processing command ''{0}'' in ''{1}''", new Object[]{name, adminArea.getRoot()});
            SVNErrorManager.error(err, error, SVNLogType.WC);
        }
    }

    private void setEntriesChanged(boolean modified) {
        this.myIsEntriesChanged |= modified;
    }

    private void setWCPropertiesChanged(boolean modified) {
        this.myIsWCPropertiesChanged |= modified;
    }

    public void logFailed(SVNAdminArea adminArea) throws SVNException {
        if (this.myIsWCPropertiesChanged) {
            adminArea.saveWCProperties(true);
        } else {
            adminArea.closeWCProperties();
        }
        if (this.myIsEntriesChanged) {
            adminArea.saveEntries(false);
        } else {
            adminArea.closeEntries();
        }
    }

    public void logCompleted(SVNAdminArea adminArea) throws SVNException {
        if (this.myIsWCPropertiesChanged) {
            adminArea.saveWCProperties(true);
        }
        if (this.myIsEntriesChanged) {
            adminArea.saveEntries(false);
        }
        adminArea.handleKillMe();
        this.myIsEntriesChanged = false;
        this.myIsWCPropertiesChanged = false;
    }
}

