/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Reports - Excelt@C𗘗p[c[
 *
 * $Id: ReportProcessorTest.java 44 2009-10-02 08:00:14Z tsuchida $
 * $Revision: 44 $
 *
 * This file is part of ExCella Reports.
 *
 * ExCella Reports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Reports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Reports.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.reports.processor;

import static org.junit.Assert.*;

import java.io.FileNotFoundException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.bbreak.excella.core.BookData;
import org.bbreak.excella.core.SheetData;
import org.bbreak.excella.core.SheetParser;
import org.bbreak.excella.core.exception.ExportException;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.reports.ReportsTestUtil;
import org.bbreak.excella.reports.exporter.ReportBookExporter;
import org.bbreak.excella.reports.listener.ReportProcessAdaptor;
import org.bbreak.excella.reports.listener.ReportProcessListener;
import org.bbreak.excella.reports.model.ConvertConfiguration;
import org.bbreak.excella.reports.model.ParsedReportInfo;
import org.bbreak.excella.reports.model.ReportBook;
import org.bbreak.excella.reports.model.ReportSheet;
import org.bbreak.excella.reports.tag.ReportsTagParser;
import org.junit.Test;

/**
 * {@link org.bbreak.excella.reports.processor.ReportProcessor} ̂߂̃eXgENXB
 * 
 * @since 1.0
 */
@SuppressWarnings( "unchecked")
public class ReportProcessorTest extends ReportsWorkbookTest {

    /**
     * VXeϐFevfBNg
     */
    private String tmpDirPath = ReportsTestUtil.getTestOutputDir();

    /**
     * vZXO
     */
    private List<String> processStrings = new ArrayList<String>();

    /**
     * RXgN^
     * 
     * @param version o[W
     */
    public ReportProcessorTest( String version) {
        super( version);
    }

    /**
     * {@link org.bbreak.excella.reports.processor.ReportProcessor#ReportProcessor()} ̂߂̃eXgE\bhB
     */
    @Test
    public void testReportProcessor() {
        ReportProcessor processor = new ReportProcessor();
        // ftHg^Op[T[
        Map<String, ReportsTagParser<?>> actualParsers = ( Map<String, ReportsTagParser<?>>) getPrivateFiled( processor, "parsers");
        Map<String, ReportsTagParser<?>> expectedParsers = ReportCreateHelper.createDefaultParsers();

        assertEquals( expectedParsers.size(), actualParsers.size());

        for ( Entry<String, ReportsTagParser<?>> entry : expectedParsers.entrySet()) {
            ReportsTagParser<?> actualParser = actualParsers.get( entry.getKey());
            assertNotNull( actualParser);
            assertEquals( entry.getValue().getClass(), actualParser.getClass());
        }

        // ftHgGNX|[^[
        Map<String, ReportBookExporter> actualExporters = ( Map<String, ReportBookExporter>) getPrivateFiled( processor, "exporters");
        Map<String, ReportBookExporter> expectedExporters = ReportCreateHelper.createDefaultExporters();

        assertEquals( expectedExporters.size(), actualExporters.size());

        for ( Entry<String, ReportBookExporter> entry : expectedExporters.entrySet()) {
            ReportBookExporter actualExporter = actualExporters.get( entry.getKey());
            assertNotNull( actualExporter);
            assertEquals( entry.getValue().getClass(), actualExporter.getClass());
        }

    }

    /**
     * {@link org.bbreak.excella.reports.processor.ReportProcessor#process(org.bbreak.excella.reports.model.ReportData)} ̂߂̃eXgE\bhB
     */
    @Test
    public void testProcess() {

        getWorkbook();

        ReportProcessor reportProcessor = new ReportProcessor();
        reportProcessor.addReportProcessListener( new CustomListener());

        reportProcessor.addReportsTagParser( new CustomTagParser( "$CUSTOM"));
        ReportBookExporter exporter = new CustomExporter();
        reportProcessor.addReportBookExporter( exporter);
        reportProcessor.addReportBookExporter( new ThrowExceptionExporter());

        // ------------------------------------
        // ev[gRs[̂ȂsmF
        // ------------------------------------
        processStrings.clear();

        ConvertConfiguration configuration = new ConvertConfiguration( "CUSTOM");
        ConvertConfiguration[] configurations = new ConvertConfiguration[] {configuration, null};

        // ubNP
        ReportBook book1 = new ReportBook( getFilepath(), tmpDirPath + "workbookout1", configurations);
        // V[gP
        ReportSheet sheet1 = new ReportSheet( "Sheet1");
        book1.addReportSheet( sheet1);
        // V[gQ
        ReportSheet sheet2 = new ReportSheet( "Sheet2");
        book1.addReportSheet( sheet2);

        // ubNQ
        ReportBook book2 = new ReportBook( getFilepath(), tmpDirPath + "workbookout2", configurations);
        // V[gR
        ReportSheet sheet3 = new ReportSheet( "Sheet3");
        book2.addReportSheet( sheet3);

        book2.addReportSheet( null);

        try {
            reportProcessor.process( new ReportBook[] {book1, book2, null});
        } catch ( Exception e) {
            e.printStackTrace();
            fail( e.toString());
        }

        List<String> exceptedProccess = new ArrayList<String>();
        exceptedProccess.add( "ubN͑O CustomListener#preBookParse( Workbook workbook, ReportBook reportBook)");
        exceptedProccess.add( "V[g͑O CustomListener#preParse( Sheet sheet, SheetParser sheetParser)");
        exceptedProccess.add( "^O͏ CustomTagParser#parse( Sheet sheet, Cell tagCell, Object data)");
        exceptedProccess.add( "V[g͌㏈ CustomListener#postParse( Sheet sheet, SheetParser sheetParser, SheetData sheetData)");
        exceptedProccess.add( "V[g͑O CustomListener#preParse( Sheet sheet, SheetParser sheetParser)");
        exceptedProccess.add( "^O͏ CustomTagParser#parse( Sheet sheet, Cell tagCell, Object data)");
        exceptedProccess.add( "V[g͌㏈ CustomListener#postParse( Sheet sheet, SheetParser sheetParser, SheetData sheetData)");
        exceptedProccess.add( "ubN͌㏈ CustomListener#postBookParse( Workbook workbook, ReportBook reportBook)");
        exceptedProccess.add( "ubN:V[g1=Sheet1,V[g2=Sheet2,");
        exceptedProccess.add( "o͑O CustomExporter#setup()");
        exceptedProccess.add( "o͏ CustomExporter#output( Workbook book, BookData bookdata, ConvertConfiguration configuration)");
        exceptedProccess.add( "o͌㏈ CustomExporter#tearDown()");
        exceptedProccess.add( "ubN͑O CustomListener#preBookParse( Workbook workbook, ReportBook reportBook)");
        exceptedProccess.add( "V[g͑O CustomListener#preParse( Sheet sheet, SheetParser sheetParser)");
        exceptedProccess.add( "^O͏ CustomTagParser#parse( Sheet sheet, Cell tagCell, Object data)");
        exceptedProccess.add( "V[g͌㏈ CustomListener#postParse( Sheet sheet, SheetParser sheetParser, SheetData sheetData)");
        exceptedProccess.add( "ubN͌㏈ CustomListener#postBookParse( Workbook workbook, ReportBook reportBook)");
        exceptedProccess.add( "ubN:V[g1=Sheet3,");
        exceptedProccess.add( "o͑O CustomExporter#setup()");
        exceptedProccess.add( "o͏ CustomExporter#output( Workbook book, BookData bookdata, ConvertConfiguration configuration)");
        exceptedProccess.add( "o͌㏈ CustomExporter#tearDown()");

        assertArrayEquals( exceptedProccess.toArray(), processStrings.toArray());

        // s̊mF

        // ------------------------------------
        // ev[gRs[̂smF
        // ------------------------------------
        processStrings.clear();

        // ubNP
        book1 = new ReportBook( getFilepath(), tmpDirPath + "workbookout1", configurations);
        // book1.setCopyTemplate( true);

        // V[gP
        ReportSheet sheetC1 = new ReportSheet( "Sheet1", "CSheet1");
        book1.addReportSheet( sheetC1);
        // V[gQ
        ReportSheet sheetC2 = new ReportSheet( "Sheet2", "CSheet2");
        book1.addReportSheet( sheetC2);

        // ubNQ
        book2 = new ReportBook( getFilepath(), tmpDirPath + "workbookout2", configurations);
        // V[gR
        ReportSheet sheetC3 = new ReportSheet( "Sheet3");
        book2.addReportSheet( sheetC3);

        book2.addReportSheet( null);

        try {
            reportProcessor.process( book1, book2, null);
        } catch ( Exception e) {
            e.printStackTrace();
            fail( e.toString());
        }

        exceptedProccess = new ArrayList<String>();
        exceptedProccess.add( "ubN͑O CustomListener#preBookParse( Workbook workbook, ReportBook reportBook)");
        exceptedProccess.add( "V[g͑O CustomListener#preParse( Sheet sheet, SheetParser sheetParser)");
        exceptedProccess.add( "^O͏ CustomTagParser#parse( Sheet sheet, Cell tagCell, Object data)");
        exceptedProccess.add( "V[g͌㏈ CustomListener#postParse( Sheet sheet, SheetParser sheetParser, SheetData sheetData)");
        exceptedProccess.add( "V[g͑O CustomListener#preParse( Sheet sheet, SheetParser sheetParser)");
        exceptedProccess.add( "^O͏ CustomTagParser#parse( Sheet sheet, Cell tagCell, Object data)");
        exceptedProccess.add( "V[g͌㏈ CustomListener#postParse( Sheet sheet, SheetParser sheetParser, SheetData sheetData)");
        exceptedProccess.add( "ubN͌㏈ CustomListener#postBookParse( Workbook workbook, ReportBook reportBook)");
        exceptedProccess.add( "ubN:V[g1=CSheet1,V[g2=CSheet2,");
        exceptedProccess.add( "o͑O CustomExporter#setup()");
        exceptedProccess.add( "o͏ CustomExporter#output( Workbook book, BookData bookdata, ConvertConfiguration configuration)");
        exceptedProccess.add( "o͌㏈ CustomExporter#tearDown()");
        exceptedProccess.add( "ubN͑O CustomListener#preBookParse( Workbook workbook, ReportBook reportBook)");
        exceptedProccess.add( "V[g͑O CustomListener#preParse( Sheet sheet, SheetParser sheetParser)");
        exceptedProccess.add( "^O͏ CustomTagParser#parse( Sheet sheet, Cell tagCell, Object data)");
        exceptedProccess.add( "V[g͌㏈ CustomListener#postParse( Sheet sheet, SheetParser sheetParser, SheetData sheetData)");
        exceptedProccess.add( "ubN͌㏈ CustomListener#postBookParse( Workbook workbook, ReportBook reportBook)");
        exceptedProccess.add( "ubN:V[g1=Sheet3,");
        exceptedProccess.add( "o͑O CustomExporter#setup()");
        exceptedProccess.add( "o͏ CustomExporter#output( Workbook book, BookData bookdata, ConvertConfiguration configuration)");
        exceptedProccess.add( "o͌㏈ CustomExporter#tearDown()");

        assertArrayEquals( exceptedProccess.toArray(), processStrings.toArray());

        // --------------------------------------------------------------------------
        // ev[gt@CȂꍇ
        // --------------------------------------------------------------------------
        processStrings.clear();

        // ubNP
        book1 = new ReportBook( "test", tmpDirPath + "workbookout1", configurations);
        // book1.setCopyTemplate( true);

        // V[gP
        sheetC1 = new ReportSheet( "Sheet1", "CSheet1");
        book1.addReportSheet( sheetC1);

        try {
            reportProcessor.process( book1);
            fail();
        } catch ( FileNotFoundException e) {
            assertTrue( true);
        } catch ( Exception e) {
            e.printStackTrace();
            fail( e.toString());
        }
        assertTrue( processStrings.isEmpty());
        
        // ---------------------------------------------------------------------------
        // ev[g㏑A ev[gRs[ApȂev[g݂ꍇ̃V[gI[_[̓mF
        // ---------------------------------------------------------------------------
        processStrings.clear();

        // ubNP
        book1 = new ReportBook( getFilepath(), tmpDirPath + "workbookout1", configurations);

        // V[gP(Rs[)
        ReportSheet sheetCopy1 = new ReportSheet( "Sheet1", "CSheet1");
        book1.addReportSheet( sheetCopy1);
        // V[gQi㏑j
        ReportSheet sheet2Original = new ReportSheet( "Sheet2");
        book1.addReportSheet( sheet2Original);
        // V[gQiRs[j
        ReportSheet sheetCopy2 = new ReportSheet( "Sheet2", "CSheet2");
        book1.addReportSheet( sheetCopy2);
        // V[gRi㏑j
        ReportSheet sheet3Original = new ReportSheet( "Sheet3");
        book1.addReportSheet( sheet3Original);
        // V[gSio͑ΏۊOj

        // ubNQ
        book2 = new ReportBook( getFilepath(), tmpDirPath + "workbookout2", configurations);
        // V[gP(o͑ΏۊO)
        // V[gQ(Rs[j
        ReportSheet sheet2Copy = new ReportSheet( "Sheet2", "CSheet2");
        book2.addReportSheet( sheet2Copy);
        // V[gQi㏑j
        ReportSheet sheetOriginal2 = new ReportSheet( "Sheet2");
        book2.addReportSheet( sheetOriginal2);
        // V[gR(Rs[j
        ReportSheet sheet3Copy = new ReportSheet( "Sheet3", "CSheet3");
        book2.addReportSheet( sheet3Copy);
        // V[gSi㏑j
        ReportSheet sheetOriginal3 = new ReportSheet( "Sheet3");
        book2.addReportSheet( sheetOriginal3);
        // V[gSio͑ΏۊOj

        try {
            reportProcessor.process( book1, book2);
        } catch ( Exception e) {
            e.printStackTrace();
            fail( e.toString());
        }

        exceptedProccess = new ArrayList<String>();
        exceptedProccess.add( "ubN͑O CustomListener#preBookParse( Workbook workbook, ReportBook reportBook)");
        exceptedProccess.add( "V[g͑O CustomListener#preParse( Sheet sheet, SheetParser sheetParser)");
        exceptedProccess.add( "^O͏ CustomTagParser#parse( Sheet sheet, Cell tagCell, Object data)");
        exceptedProccess.add( "V[g͌㏈ CustomListener#postParse( Sheet sheet, SheetParser sheetParser, SheetData sheetData)");
        exceptedProccess.add( "V[g͑O CustomListener#preParse( Sheet sheet, SheetParser sheetParser)");
        exceptedProccess.add( "^O͏ CustomTagParser#parse( Sheet sheet, Cell tagCell, Object data)");
        exceptedProccess.add( "V[g͌㏈ CustomListener#postParse( Sheet sheet, SheetParser sheetParser, SheetData sheetData)");
        exceptedProccess.add( "V[g͑O CustomListener#preParse( Sheet sheet, SheetParser sheetParser)");
        exceptedProccess.add( "^O͏ CustomTagParser#parse( Sheet sheet, Cell tagCell, Object data)");
        exceptedProccess.add( "V[g͌㏈ CustomListener#postParse( Sheet sheet, SheetParser sheetParser, SheetData sheetData)");
        exceptedProccess.add( "V[g͑O CustomListener#preParse( Sheet sheet, SheetParser sheetParser)");
        exceptedProccess.add( "^O͏ CustomTagParser#parse( Sheet sheet, Cell tagCell, Object data)");
        exceptedProccess.add( "V[g͌㏈ CustomListener#postParse( Sheet sheet, SheetParser sheetParser, SheetData sheetData)");
        exceptedProccess.add( "ubN͌㏈ CustomListener#postBookParse( Workbook workbook, ReportBook reportBook)");
        exceptedProccess.add( "ubN:V[g1=CSheet1,V[g2=Sheet2,V[g3=CSheet2,V[g4=Sheet3,");
        exceptedProccess.add( "o͑O CustomExporter#setup()");
        exceptedProccess.add( "o͏ CustomExporter#output( Workbook book, BookData bookdata, ConvertConfiguration configuration)");
        exceptedProccess.add( "o͌㏈ CustomExporter#tearDown()");
        exceptedProccess.add( "ubN͑O CustomListener#preBookParse( Workbook workbook, ReportBook reportBook)");
        exceptedProccess.add( "V[g͑O CustomListener#preParse( Sheet sheet, SheetParser sheetParser)");
        exceptedProccess.add( "^O͏ CustomTagParser#parse( Sheet sheet, Cell tagCell, Object data)");
        exceptedProccess.add( "V[g͌㏈ CustomListener#postParse( Sheet sheet, SheetParser sheetParser, SheetData sheetData)");
        exceptedProccess.add( "V[g͑O CustomListener#preParse( Sheet sheet, SheetParser sheetParser)");
        exceptedProccess.add( "^O͏ CustomTagParser#parse( Sheet sheet, Cell tagCell, Object data)");
        exceptedProccess.add( "V[g͌㏈ CustomListener#postParse( Sheet sheet, SheetParser sheetParser, SheetData sheetData)");
        exceptedProccess.add( "V[g͑O CustomListener#preParse( Sheet sheet, SheetParser sheetParser)");
        exceptedProccess.add( "^O͏ CustomTagParser#parse( Sheet sheet, Cell tagCell, Object data)");
        exceptedProccess.add( "V[g͌㏈ CustomListener#postParse( Sheet sheet, SheetParser sheetParser, SheetData sheetData)");
        exceptedProccess.add( "V[g͑O CustomListener#preParse( Sheet sheet, SheetParser sheetParser)");
        exceptedProccess.add( "^O͏ CustomTagParser#parse( Sheet sheet, Cell tagCell, Object data)");
        exceptedProccess.add( "V[g͌㏈ CustomListener#postParse( Sheet sheet, SheetParser sheetParser, SheetData sheetData)");
        exceptedProccess.add( "ubN͌㏈ CustomListener#postBookParse( Workbook workbook, ReportBook reportBook)");
        exceptedProccess.add( "ubN:V[g1=CSheet2,V[g2=Sheet2,V[g3=CSheet3,V[g4=Sheet3,");
        exceptedProccess.add( "o͑O CustomExporter#setup()");
        exceptedProccess.add( "o͏ CustomExporter#output( Workbook book, BookData bookdata, ConvertConfiguration configuration)");
        exceptedProccess.add( "o͌㏈ CustomExporter#tearDown()");

        assertArrayEquals( exceptedProccess.toArray(), processStrings.toArray());

        // --------------------------------------------------------------------------
        // Export̏o͏ɃG[̏ꍇ̏o͌㏈̓mF
        // --------------------------------------------------------------------------
        // õ͎G[Ao͌㏈
        processStrings.clear();

        ConvertConfiguration configuration2 = new ConvertConfiguration( "E");
        configurations = new ConvertConfiguration[] {configuration, configuration2};

        // ubNP
        book1 = new ReportBook( getFilepath(), tmpDirPath + "workbookout1", configurations);
        // book1.setCopyTemplate( true);

        // V[gP
        sheetC1 = new ReportSheet( "Sheet1", "CSheet1");
        book1.addReportSheet( sheetC1);

        try {
            reportProcessor.process( book1);
            fail();
        } catch ( Exception e) {
            assertTrue( true);
        }

        exceptedProccess = new ArrayList<String>();
        exceptedProccess.add( "ubN͑O CustomListener#preBookParse( Workbook workbook, ReportBook reportBook)");
        exceptedProccess.add( "V[g͑O CustomListener#preParse( Sheet sheet, SheetParser sheetParser)");
        exceptedProccess.add( "^O͏ CustomTagParser#parse( Sheet sheet, Cell tagCell, Object data)");
        exceptedProccess.add( "V[g͌㏈ CustomListener#postParse( Sheet sheet, SheetParser sheetParser, SheetData sheetData)");
        exceptedProccess.add( "ubN͌㏈ CustomListener#postBookParse( Workbook workbook, ReportBook reportBook)");
        exceptedProccess.add( "ubN:V[g1=CSheet1,");
        exceptedProccess.add( "o͑O CustomExporter#setup()");
        exceptedProccess.add( "o͏ CustomExporter#output( Workbook book, BookData bookdata, ConvertConfiguration configuration)");
        exceptedProccess.add( "o͌㏈ CustomExporter#tearDown()");
        exceptedProccess.add( "o͑O ThrowExceptionExporter#setup()");
        exceptedProccess.add( "o͏ ThrowExceptionExporter#output( Workbook book, BookData bookdata, ConvertConfiguration configuration)");
        exceptedProccess.add( "o͌㏈ ThrowExceptionExporter#tearDown()");

        assertArrayEquals( exceptedProccess.toArray(), processStrings.toArray());

    }

    /**
     * {@link org.bbreak.excella.reports.processor.ReportProcessor#addReportsTagParser(org.bbreak.excella.reports.tag.ReportsTagParser)} ̂߂̃eXgE\bhB
     */
    @Test
    public void testAddReportsTagParser() {
        ReportProcessor processor = new ReportProcessor();

        ReportsTagParser<?> addparser = new CustomTagParser( "$CUSTOM");
        processor.addReportsTagParser( addparser);

        Map<String, ReportsTagParser<?>> actualParsers = ( Map<String, ReportsTagParser<?>>) getPrivateFiled( processor, "parsers");
        assertEquals( addparser, actualParsers.get( "$CUSTOM"));
    }

    /**
     * {@link org.bbreak.excella.reports.processor.ReportProcessor#removeReportsTagParser(java.lang.String)} ̂߂̃eXgE\bhB
     */
    @Test
    public void testRemoveReportsTagParser() {

        ReportProcessor processor = new ReportProcessor();

        processor.removeReportsTagParser( "");
        Map<String, ReportsTagParser<?>> actualParsers = ( Map<String, ReportsTagParser<?>>) getPrivateFiled( processor, "parsers");

        assertNull( actualParsers.get( ""));
    }

    /**
     * {@link org.bbreak.excella.reports.processor.ReportProcessor#clearReportsTagParser()} ̂߂̃eXgE\bhB
     */
    @Test
    public void testClearReportsTagParser() {
        ReportProcessor processor = new ReportProcessor();
        processor.clearReportsTagParser();
        Map<String, ReportsTagParser<?>> actualParsers = ( Map<String, ReportsTagParser<?>>) getPrivateFiled( processor, "parsers");

        assertTrue( actualParsers.isEmpty());
    }

    /**
     * {@link org.bbreak.excella.reports.processor.ReportProcessor#addReportBookExporter(org.bbreak.excella.reports.exporter.ReportBookExporter)} ̂߂̃eXgE\bhB
     */
    @Test
    public void testAddReportBookExporter() {
        ReportProcessor processor = new ReportProcessor();

        ReportBookExporter bookExporter = new CustomExporter();
        processor.addReportBookExporter( bookExporter);

        Map<String, ReportBookExporter> actualExporters = ( Map<String, ReportBookExporter>) getPrivateFiled( processor, "exporters");

        assertEquals( bookExporter, actualExporters.get( "CUSTOM"));
    }

    /**
     * {@link org.bbreak.excella.reports.processor.ReportProcessor#removeReportBookExporter(java.lang.String)} ̂߂̃eXgE\bhB
     */
    @Test
    public void testRemoveReportBookExporter() {
        ReportProcessor processor = new ReportProcessor();

        processor.removeReportBookExporter( "EXCEL");

        Map<String, ReportBookExporter> actualExporters = ( Map<String, ReportBookExporter>) getPrivateFiled( processor, "exporters");

        assertNull( actualExporters.get( "EXCEL"));
    }

    /**
     * {@link org.bbreak.excella.reports.processor.ReportProcessor#clearReportBookExporter()} ̂߂̃eXgE\bhB
     */
    @Test
    public void testClearReportBookExporter() {
        ReportProcessor processor = new ReportProcessor();

        processor.clearReportBookExporter();

        Map<String, ReportBookExporter> actualExporters = ( Map<String, ReportBookExporter>) getPrivateFiled( processor, "exporters");

        assertTrue( actualExporters.isEmpty());
    }

    /**
     * {@link org.bbreak.excella.reports.processor.ReportProcessor#addReportProcessListener(org.bbreak.excella.reports.listener.ReportProcessListener)} ̂߂̃eXgE\bhB
     */
    @Test
    public void testAddReportProcessListener() {
        ReportProcessor processor = new ReportProcessor();
        CustomListener listener = new CustomListener();

        List<ReportProcessListener> listenerList = ( List<ReportProcessListener>) getPrivateFiled( processor, "listeners");

        assertTrue( listenerList.isEmpty());

        processor.addReportProcessListener( listener);

        assertEquals( 1, listenerList.size());
        assertEquals( listener, listenerList.iterator().next());

    }

    /**
     * {@link org.bbreak.excella.reports.processor.ReportProcessor#removeReportProcessListener(org.bbreak.excella.reports.listener.ReportProcessListener)} ̂߂̃eXgE\bhB
     */
    @Test
    public void testRemoveReportProcessListener() {

        ReportProcessor processor = new ReportProcessor();
        CustomListener listener = new CustomListener();
        processor.addReportProcessListener( listener);

        List<ReportProcessListener> listenerList = ( List<ReportProcessListener>) getPrivateFiled( processor, "listeners");

        assertEquals( 1, listenerList.size());

        processor.removeReportProcessListener( listener);

        assertTrue( listenerList.isEmpty());

    }

    private Object getPrivateFiled( Object object, String fieldName) {

        Field field = null;
        Object res = null;
        try {
            field = object.getClass().getDeclaredField( fieldName);
            field.setAccessible( true);
            res = field.get( object);
        } catch ( Exception e) {
            e.printStackTrace();
            fail();
        }
        return res;

    }

    class CustomTagParser extends ReportsTagParser<Object> {

        public CustomTagParser( String tag) {
            super( tag);
        }

        @Override
        public ParsedReportInfo parse( Sheet sheet, Cell tagCell, Object data) throws ParseException {
            processStrings.add( "^O͏ CustomTagParser#parse( Sheet sheet, Cell tagCell, Object data)");
            return null;
        }

        @Override
        public boolean useControlRow() {
            return false;
        }

    }

    class CustomExporter extends ReportBookExporter {

        @Override
        public String getExtention() {
            return ".custom";
        }

        @Override
        public String getFormatType() {
            return "CUSTOM";
        }

        @Override
        public void output( Workbook book, BookData bookdata, ConvertConfiguration configuration) throws ExportException {
            processStrings.add( "o͏ CustomExporter#output( Workbook book, BookData bookdata, ConvertConfiguration configuration)");
        }

        @Override
        public void setup() {
            processStrings.add( "o͑O CustomExporter#setup()");
            super.setup();
        }

        @Override
        public void tearDown() {
            processStrings.add( "o͌㏈ CustomExporter#tearDown()");
            super.tearDown();
        }

    }

    class ThrowExceptionExporter extends ReportBookExporter {

        @Override
        public String getExtention() {
            return ".e";
        }

        @Override
        public String getFormatType() {
            return "E";
        }

        @Override
        public void output( Workbook book, BookData bookdata, ConvertConfiguration configuration) throws ExportException {
            processStrings.add( "o͏ ThrowExceptionExporter#output( Workbook book, BookData bookdata, ConvertConfiguration configuration)");
            throw new ExportException( new Exception());
        }

        @Override
        public void setup() {
            processStrings.add( "o͑O ThrowExceptionExporter#setup()");
            super.setup();
        }

        @Override
        public void tearDown() {
            processStrings.add( "o͌㏈ ThrowExceptionExporter#tearDown()");
            super.tearDown();
        }

    }

    class CustomListener extends ReportProcessAdaptor {

        @Override
        public void postBookParse( Workbook workbook, ReportBook reportBook) {
            processStrings.add( "ubN͌㏈ CustomListener#postBookParse( Workbook workbook, ReportBook reportBook)");

            StringBuffer buffer = new StringBuffer( "ubN:");
            for ( int i = 0; i < workbook.getNumberOfSheets(); i++) {
                buffer.append( "V[g" + (i + 1) + "=" + workbook.getSheetName( i) + ",");
            }
            processStrings.add( buffer.toString());
            System.out.println( buffer.toString());

            // System.out.println("workbook=" + workbook + ",reportBook=" + reportBook);
            super.postBookParse( workbook, reportBook);
        }

        @Override
        public void postParse( Sheet sheet, SheetParser sheetParser, SheetData sheetData) throws ParseException {
            processStrings.add( "V[g͌㏈ CustomListener#postParse( Sheet sheet, SheetParser sheetParser, SheetData sheetData)");
            // System.out.println("sheet=" + sheet + ",sheetParser=" + sheetParser+ ",sheetData=" + sheetData);
            super.postParse( sheet, sheetParser, sheetData);
        }

        @Override
        public void preBookParse( Workbook workbook, ReportBook reportBook) {
            processStrings.add( "ubN͑O CustomListener#preBookParse( Workbook workbook, ReportBook reportBook)");
            // System.out.println("workbook=" + workbook +",reportBook=" + reportBook);
            super.preBookParse( workbook, reportBook);
        }

        @Override
        public void preParse( Sheet sheet, SheetParser sheetParser) throws ParseException {
            processStrings.add( "V[g͑O CustomListener#preParse( Sheet sheet, SheetParser sheetParser)");
            // System.out.println("sheet=" + sheet +",SheetParser=" + sheetParser);
            super.preParse( sheet, sheetParser);
        }

    }

}
