/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Reports - Excelt@C𗘗p[c[
 *
 * $Id: ExcelOutputStreamExporterTest.java 80 2009-10-30 02:29:59Z a-hoshino $
 * $Revision: 80 $
 *
 * This file is part of ExCella Reports.
 *
 * ExCella Reports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Reports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Reports.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.reports.exporter;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Date;

import org.bbreak.excella.reports.ReportsTestUtil;
import org.bbreak.excella.reports.model.ReportBook;
import org.bbreak.excella.reports.model.ReportSheet;
import org.bbreak.excella.reports.processor.ReportProcessor;
import org.junit.Test;

/**
 * {@link org.bbreak.excella.reports.exporter.ExcelOutputStreamExporter}̂߂̃eXgENXB
 *
 * @since 1.1
 */
public class ExcelOutputStreamExporterTest {

    private String tmpDirPath = ReportsTestUtil.getTestOutputDir();

    private OutputStream outputStream;

    /**
     * {@link org.bbreak.excella.reports.exporter.ExcelOutputStreamExporter#output(org.apache.poi.ss.usermodel.Workbook, org.bbreak.excella.core.BookData, org.bbreak.excella.reports.model.ConvertConfiguration)}
     * ̂߂̃eXgE\bhB
     *
     * @throws Exception
     */
    @Test
    public void testOutput() {

        FileOutputStream xlsFileOutputStream = null;
        // o͐
        String filePath = tmpDirPath + (new Date()).getTime();
        String xlsTemplateFileName = "ExcelOutputStreamExporterTest.xls";
        URL xlsTemplateFileUrl = ExcelOutputStreamExporterTest.class.getResource( xlsTemplateFileName);
        // XLSeXg@ - tH[}bgwETCYreXg
        try {
            String xlsTemplateFilePath = URLDecoder.decode( xlsTemplateFileUrl.getPath(), "UTF-8");

            ReportBook xlsOutputBook = new ReportBook( xlsTemplateFilePath, filePath, ExcelExporter.FORMAT_TYPE, ExcelOutputStreamExporter.FORMAT_TYPE);

            ReportSheet outputSheet = new ReportSheet( "test");
            xlsOutputBook.addReportSheet( outputSheet);

            ReportProcessor xlsReportProcessor = new ReportProcessor();

            // Stream̏
            File xlsStreamFile = new File( filePath + "_stream.xls");
            xlsFileOutputStream = new FileOutputStream( xlsStreamFile);

            xlsReportProcessor.addReportBookExporter( new ExcelOutputStreamExporter( xlsFileOutputStream));
            xlsReportProcessor.process( xlsOutputBook);

            File xlsExcelFile = new File( filePath + ".xls");

            // TCYr
            long xlsFileByteLength = xlsExcelFile.length();
            long xlsStreamFileSize = xlsStreamFile.length();
            assertEquals( xlsFileByteLength, xlsStreamFileSize);
        } catch ( Exception e) {
            e.getStackTrace();
            fail( e.toString());
        } finally {
            try {
                if ( xlsFileOutputStream != null) {
                    xlsFileOutputStream.close();
                }
            } catch ( IOException e) {
                e.printStackTrace();
                fail( e.toString());
            }
        }
        // XLSeXgA - tH[}bgPwEXg[o͂ɂt@CȊO폜Ă邱ƂmF
        try {
            String xlsTemplateFilePath = URLDecoder.decode( xlsTemplateFileUrl.getPath(), "UTF-8");

            ReportBook xlsOutputBook = new ReportBook( xlsTemplateFilePath, filePath, ExcelOutputStreamExporter.FORMAT_TYPE);

            ReportSheet outputSheet = new ReportSheet( "test");
            xlsOutputBook.addReportSheet( outputSheet);

            ReportProcessor xlsReportProcessor = new ReportProcessor();

            // Stream̏
            File xlsStreamFile = new File( filePath + "_exsistStream.xls");
            xlsFileOutputStream = new FileOutputStream( xlsStreamFile);

            xlsReportProcessor.addReportBookExporter( new ExcelOutputStreamExporter( xlsFileOutputStream));
            xlsReportProcessor.process( xlsOutputBook);

            File xlsExcelFile = new File( filePath + "_exsistsCheck.xls");

            // Xg[o͂ꂽt@CJ邱Ɓi0oCgłȂt@Cł邱ƂmFj
            if ( xlsStreamFile.length() <= 0) {
                fail( "File is not opened");
            }

            // t@C폜`FbN
            if ( xlsExcelFile.exists()) {
                fail( "ExcelFile exists.");
            }
        } catch ( Exception e) {
            e.getStackTrace();
            fail( e.toString());
        } finally {
            try {
                if ( xlsFileOutputStream != null) {
                    xlsFileOutputStream.close();
                }
            } catch ( IOException e) {
                e.printStackTrace();
                fail( e.toString());
            }
        }

        // XLSX
        FileOutputStream xlsxFileOutputStream = null;
        try {

            String xlsxTemplateFileName = "ExcelOutputStreamExporterTest.xlsx";
            URL xlsxTemplateFileUrl = ExcelOutputStreamExporterTest.class.getResource( xlsxTemplateFileName);
            String xlsxTemplateFilePath = URLDecoder.decode( xlsxTemplateFileUrl.getPath(), "UTF-8");

            // TODO:XLSX̏ꍇ͕ws
            ReportBook xlsxOutputBook = new ReportBook( xlsxTemplateFilePath, filePath, ExcelOutputStreamExporter.FORMAT_TYPE);

            ReportSheet outputSheet = new ReportSheet( "test");
            xlsxOutputBook.addReportSheet( outputSheet);

            // Streamݗp̃t@C
            File xlsxStreamFile = new File( filePath + "_stream.xlsx");
            xlsxFileOutputStream = new FileOutputStream( xlsxStreamFile);

            // s
            ReportProcessor xlsxReportProcessor = new ReportProcessor();
            ExcelOutputStreamExporter exporter = new ExcelOutputStreamExporter( xlsxFileOutputStream);
            xlsxReportProcessor.addReportBookExporter( exporter);
            xlsxReportProcessor.process( xlsxOutputBook);

            // Xg[o͂ꂽt@CJ邱Ɓi0oCgłȂt@Cł邱ƂmFj
            if ( xlsxStreamFile.length() <= 0) {
                fail( "File is not opened");
            }

        } catch ( Exception e) {
            e.getStackTrace();
            fail( e.toString());
        } finally {
            try {
                if ( xlsFileOutputStream != null) {
                    xlsxFileOutputStream.close();
                }
            } catch ( IOException e) {
                e.printStackTrace();
                fail( e.toString());
            }
        }
    }

    /**
     * {@link org.bbreak.excella.reports.exporter.ExcelOutputStreamExporter#getFormatType()} ̂߂̃eXgE\bhB
     */
    @Test
    public void testGetFormatType() {
        ExcelOutputStreamExporter exporter = new ExcelOutputStreamExporter( outputStream);
        assertEquals( "OUTPUT_STREAM_EXCEL", exporter.getFormatType());
    }

    /**
     * {@link org.bbreak.excella.reports.exporter.ExcelOutputStreamExporter#getExtention()} ̂߂̃eXgE\bhB
     */
    @Test
    public void testGetExtention() {
        ExcelOutputStreamExporter exporter = new ExcelOutputStreamExporter( outputStream);
        assertEquals( "", exporter.getExtention());
    }
}
