package org.bbreak.excella.reports.samples;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import org.bbreak.excella.reports.exporter.ExcelExporter;
import org.bbreak.excella.reports.model.ReportBook;
import org.bbreak.excella.reports.model.ReportSheet;
import org.bbreak.excella.reports.processor.ReportProcessor;
import org.bbreak.excella.reports.tag.ImageParamParser;
import org.bbreak.excella.reports.tag.RowRepeatParamParser;
import org.bbreak.excella.reports.tag.SingleParamParser;

/**
 * Tvo̓NX
 * 
 * @since 1.0
 */
public class InvoiceReporter {

    /**
     * Tv̏o͂s܂B
     * 
     * @param args
     * @throws Exception
     */
    public static void main( String[] args) throws Exception {

        //
        // @ǂݍރev[gt@C̃pX(gq)
        // Ao͐̃t@CpX(gqExpoterɂĎIɕt^邽߁AsvB)
        // Bo̓t@CtH[}bg(ConvertConfiguration̔z)
        // w肵AReportBookCX^X𐶐܂B
        // 
        String templateFileName = "ev[g.xls";
        URL templateFileUrl = InvoiceReporter.class.getResource( templateFileName);
        String templateFilePath = URLDecoder.decode( templateFileUrl.getPath(), "UTF-8");

        // TODO: o͐̃fBNgAyуt@C(gqsv)w肵ĂB
        String outputFileName = "Tv";
        String outputFileDir = "C:/reports_output/";
        String outputFilePath = outputFileDir.concat( outputFileName);
        ReportBook outputBook = new ReportBook( templateFilePath, outputFilePath, ExcelExporter.FORMAT_TYPE);

        //@
        // ev[gt@C̃V[gƏo̓V[gw肵A
        // ReportSheetCX^X𐶐āAReportBookɒǉ܂B
        //@
        ReportSheet outputSheet = new ReportSheet( "");
        outputBook.addReportSheet( outputSheet);

        //@
        // up[^ReportSheetIuWFNgɒǉ܂B
        // (ũp[^ɂ͔zn܂B)
        //@
        Calendar calendar = Calendar.getInstance();
        outputSheet.addParam( SingleParamParser.DEFAULT_TAG, "t", calendar.getTime());

        outputSheet.addParam( SingleParamParser.DEFAULT_TAG, "ڋq", "@l");

        URL imageFileUrl = InvoiceReporter.class.getResource( "S.jpg");
        String imageFilePath = URLDecoder.decode( imageFileUrl.getPath(), "UTF-8");
        outputSheet.addParam( ImageParamParser.DEFAULT_TAG, "ЃS", imageFilePath);

        outputSheet.addParam( SingleParamParser.DEFAULT_TAG, "olZ1", "100-0000");
        outputSheet.addParam( SingleParamParser.DEFAULT_TAG, "olZ2", "s恛 ~~~[~~~");
        outputSheet.addParam( SingleParamParser.DEFAULT_TAG, "olZ3", "~~~r 9F");

        List<String> productNameList = new ArrayList<String>();
        productNameList.add( "iA");
        productNameList.add( "iB");
        productNameList.add( "iC");
        outputSheet.addParam( RowRepeatParamParser.DEFAULT_TAG, "i", productNameList.toArray());

        List<BigDecimal> unitPriceList = new ArrayList<BigDecimal>();
        unitPriceList.add( new BigDecimal( 10000));
        unitPriceList.add( new BigDecimal( 9000));
        unitPriceList.add( new BigDecimal( 7000));
        outputSheet.addParam( RowRepeatParamParser.DEFAULT_TAG, "P", unitPriceList.toArray());

        List<Integer> quantityList = new ArrayList<Integer>();
        quantityList.add( new Integer( 4));
        quantityList.add( new Integer( 5));
        quantityList.add( new Integer( 6));
        outputSheet.addParam( RowRepeatParamParser.DEFAULT_TAG, "", quantityList.toArray());

        List<BigDecimal> priceList = new ArrayList<BigDecimal>();
        priceList.add( new BigDecimal( 40000));
        priceList.add( new BigDecimal( 45000));
        priceList.add( new BigDecimal( 42000));
        outputSheet.addParam( RowRepeatParamParser.DEFAULT_TAG, "z", priceList.toArray());

        BigDecimal subTotal = BigDecimal.ZERO;
        for ( BigDecimal price : priceList) {
            subTotal = subTotal.add( price);
        }
        outputSheet.addParam( SingleParamParser.DEFAULT_TAG, "v", subTotal);

        BigDecimal discount = new BigDecimal( 10000);
        outputSheet.addParam( SingleParamParser.DEFAULT_TAG, "l", discount);

        BigDecimal taxRate = new BigDecimal( 0.05);
        BigDecimal taxCharge = subTotal.multiply( taxRate).setScale( 0, RoundingMode.DOWN);
        outputSheet.addParam( SingleParamParser.DEFAULT_TAG, "Ŋz", taxCharge);

        BigDecimal total = subTotal.add( taxCharge).subtract( discount);
        outputSheet.addParam( SingleParamParser.DEFAULT_TAG, "v", total);

        // 
        // ReportProcessorCX^X𐶐A
        // ReportBookɃ|[gs܂B
        // 
        ReportProcessor reportProcessor = new ReportProcessor();
        reportProcessor.process( outputBook);

    }

}
