/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.reports.util;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.reports.model.ParamInfo;
import org.bbreak.excella.reports.model.ReportBook;
import org.bbreak.excella.reports.model.ReportSheet;
import org.bbreak.excella.reports.tag.ReportsTagParser;
import org.bbreak.excella.reports.tag.SingleParamParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReportsUtil {
    public static final String VALUE_SHEET_NAMES = "#SHEET_NAME[]";
    public static final String VALUE_SHEET_VALUES = "#SHEET_VALUE[]";

    private ReportsUtil() {
    }

    public static ReportSheet getReportSheet(String sheetName, ReportBook reportBook) {
        if (reportBook != null) {
            for (ReportSheet reportSheet : reportBook.getReportSheets()) {
                if (reportSheet == null || !reportSheet.getSheetName().equals(sheetName)) continue;
                return reportSheet;
            }
        }
        return null;
    }

    public static List<String> getSheetNames(ReportBook reportBook) {
        ArrayList<String> names = new ArrayList<String>();
        for (ReportSheet reportSheet : reportBook.getReportSheets()) {
            names.add(reportSheet.getSheetName());
        }
        return names;
    }

    public static List<Object> getParamValues(ParamInfo info, String propertyNameString, List<ReportsTagParser<?>> parsers) {
        String[] levels = propertyNameString.split("\\.");
        ArrayList<Object> paramValues = new ArrayList<Object>();
        ParamInfo[] paramInfos = new ParamInfo[]{info};
        for (String level : levels) {
            ArrayList<ParamInfo> newParamInfos;
            String tagName = null;
            String propertyName = null;
            if (level.indexOf(":") != -1) {
                String[] values = level.split(":");
                tagName = values[0];
                propertyName = values[1];
            } else {
                tagName = "$";
                propertyName = level;
            }
            ArrayList<SingleParamParser> singleParsers = new ArrayList<SingleParamParser>();
            for (ReportsTagParser<?> reportsParser : parsers) {
                if (!(reportsParser instanceof SingleParamParser)) continue;
                singleParsers.add((SingleParamParser)reportsParser);
            }
            ReportsTagParser<?> targetParser = null;
            for (ReportsTagParser<?> tagParser : parsers) {
                if (!tagParser.getTag().equals(tagName)) continue;
                targetParser = tagParser;
            }
            if (targetParser == null) break;
            Object object = targetParser.getParamData(paramInfos[0], propertyName);
            if (object == null) continue;
            if (object instanceof ParamInfo[]) {
                newParamInfos = new ArrayList<ParamInfo>();
                for (ParamInfo paramInfo : paramInfos) {
                    ParamInfo[] params = (ParamInfo[])targetParser.getParamData(paramInfo, propertyName);
                    if (params == null) continue;
                    newParamInfos.addAll(Arrays.asList(params));
                }
                paramInfos = newParamInfos.toArray(new ParamInfo[newParamInfos.size()]);
                continue;
            }
            if (object.getClass().isArray()) {
                if (Array.getLength(object) == 0) continue;
                if (Array.get(object, 0) instanceof String || Array.get(object, 0) instanceof Number || Array.get(object, 0) instanceof Date || Array.get(object, 0) instanceof Boolean) {
                    for (ParamInfo paramInfo : paramInfos) {
                        Object arrayObj = targetParser.getParamData(paramInfo, propertyName);
                        if (arrayObj == null) continue;
                        for (int i = 0; i < Array.getLength(arrayObj); ++i) {
                            paramValues.add(Array.get(arrayObj, i));
                        }
                    }
                    continue;
                }
                newParamInfos = new ArrayList();
                for (ParamInfo paramInfo : paramInfos) {
                    Object[] params;
                    for (Object obj : params = (Object[])targetParser.getParamData(paramInfo, propertyName)) {
                        if (obj instanceof ParamInfo) {
                            newParamInfos.add((ParamInfo)obj);
                            continue;
                        }
                        ParamInfo childParamInfo = new ParamInfo();
                        Map map = null;
                        try {
                            map = PropertyUtils.describe((Object)obj);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("\u4e0d\u6b63\u306a\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u3002", e);
                        }
                        for (Map.Entry entry : map.entrySet()) {
                            for (SingleParamParser parser : singleParsers) {
                                childParamInfo.addParam(parser.getTag(), (String)entry.getKey(), entry.getValue());
                            }
                        }
                        newParamInfos.add(childParamInfo);
                    }
                }
                paramInfos = newParamInfos.toArray(new ParamInfo[newParamInfos.size()]);
                continue;
            }
            if (object instanceof Collection) {
                for (ParamInfo paramInfo : paramInfos) {
                    Collection collection = (Collection)targetParser.getParamData(paramInfo, propertyName);
                    if (collection == null) continue;
                    paramValues.addAll(collection);
                }
                continue;
            }
            for (ParamInfo paramInfo : paramInfos) {
                Object value = targetParser.getParamData(paramInfo, propertyName);
                if (value == null) continue;
                paramValues.add(value);
            }
        }
        return paramValues;
    }

    public static List<Object> getSheetValues(ReportBook reportBook, String propertyName, List<ReportsTagParser<?>> parsers) {
        ArrayList<Object> paramValues = new ArrayList<Object>();
        if (propertyName.indexOf(".") != -1) {
            return paramValues;
        }
        if (propertyName.indexOf(":") != -1) {
            return paramValues;
        }
        for (ReportSheet reportSheet : reportBook.getReportSheets()) {
            if (parsers == null) continue;
            for (ReportsTagParser<?> tagParser : parsers) {
                Object object;
                if (!(tagParser instanceof SingleParamParser) || (object = reportSheet.getParam(tagParser.getTag(), propertyName)) == null) continue;
                paramValues.add(object);
            }
        }
        return paramValues;
    }

    public static BigDecimal getSumValue(ParamInfo info, String propertyName, List<ReportsTagParser<?>> parsers) {
        List<Object> values = ReportsUtil.getParamValues(info, propertyName, parsers);
        BigDecimal sumValue = BigDecimal.ZERO;
        for (Object value : values) {
            if (!(value instanceof Number)) continue;
            Number num = (Number)value;
            BigDecimal decimal = null;
            if (value instanceof Byte) {
                decimal = new BigDecimal(num.intValue());
            } else if (value instanceof Short) {
                decimal = new BigDecimal(num.intValue());
            } else if (value instanceof Integer) {
                decimal = new BigDecimal(num.intValue());
            } else if (value instanceof Long) {
                decimal = new BigDecimal(num.longValue());
            } else if (value instanceof Float) {
                Float floatValue = (Float)value;
                decimal = new BigDecimal(String.valueOf(floatValue));
            } else if (value instanceof Double) {
                decimal = BigDecimal.valueOf(num.doubleValue());
            } else if (value instanceof BigInteger) {
                decimal = new BigDecimal((BigInteger)value);
            } else if (value instanceof BigDecimal) {
                decimal = (BigDecimal)value;
            }
            if (decimal == null) continue;
            sumValue = sumValue.add(decimal);
        }
        return sumValue;
    }

    public static CellRangeAddress getMergedAddress(Sheet sheet, int rowIndex, int columnIndex) {
        CellRangeAddress rangeAddress = new CellRangeAddress(rowIndex, rowIndex, columnIndex, columnIndex);
        int fromSheetMargNums = sheet.getNumMergedRegions();
        for (int i = 0; i < fromSheetMargNums; ++i) {
            CellRangeAddress mergedAddress = null;
            if (sheet instanceof XSSFSheet) {
                mergedAddress = ((XSSFSheet)sheet).getMergedRegion(i);
            } else if (sheet instanceof HSSFSheet) {
                mergedAddress = ((HSSFSheet)sheet).getMergedRegion(i);
            }
            if (!PoiUtil.containCellRangeAddress((CellRangeAddress)mergedAddress, (CellRangeAddress)rangeAddress)) continue;
            return mergedAddress;
        }
        return null;
    }

    public static int[] getCellIndex(String cellParam, String tagName) throws ParseException {
        String[] cellIndex = cellParam.split(":");
        if (cellIndex.length != 2) {
            throw new ParseException("cellParam:" + cellParam);
        }
        int rowIndex = ReportsUtil.getIndex(cellIndex[0], tagName);
        int colIndex = ReportsUtil.getIndex(cellIndex[1], tagName);
        int[] index = new int[]{rowIndex, colIndex};
        return index;
    }

    private static int getIndex(String index, String tagName) throws ParseException {
        int intIndex = 0;
        try {
            intIndex = Integer.parseInt(index);
        }
        catch (Exception e) {
            throw new ParseException("index:" + index);
        }
        return intIndex;
    }

    public static Object[][] getBlockCellValue(Sheet sheet, int bStartRowIndex, int bEndRowIndex, int bStartColIndex, int bEndColIndex) {
        Object[][] blockCellValue = new Object[bEndRowIndex - bStartRowIndex + 1][bEndColIndex - bStartColIndex + 1];
        int row = 0;
        for (int bRowIndex = bStartRowIndex; bRowIndex <= bEndRowIndex; ++bRowIndex) {
            int col = 0;
            for (int bColIndex = bStartColIndex; bColIndex <= bEndColIndex; ++bColIndex) {
                blockCellValue[row][col] = sheet.getRow(bRowIndex) != null && sheet.getRow(bRowIndex).getCell(bColIndex) != null ? PoiUtil.getCellValue((Cell)sheet.getRow(bRowIndex).getCell(bColIndex)) : null;
                ++col;
            }
            ++row;
        }
        return blockCellValue;
    }

    public static CellStyle[][] getBlockCellStyle(Sheet sheet, int bStartRowIndex, int bEndRowIndex, int bStartColIndex, int bEndColIndex) {
        CellStyle[][] blockCellStyle = new CellStyle[bEndRowIndex - bStartRowIndex + 1][bEndColIndex - bStartColIndex + 1];
        int row = 0;
        for (int bRowIndex = bStartRowIndex; bRowIndex <= bEndRowIndex; ++bRowIndex) {
            int col = 0;
            for (int bColIndex = bStartColIndex; bColIndex <= bEndColIndex; ++bColIndex) {
                blockCellStyle[row][col] = sheet.getRow(bRowIndex) != null && sheet.getRow(bRowIndex).getCell(bColIndex) != null ? sheet.getRow(bRowIndex).getCell(bColIndex).getCellStyle() : null;
                ++col;
            }
            ++row;
        }
        return blockCellStyle;
    }

    public static int[][] getBlockCellType(Sheet sheet, int bStartRowIndex, int bEndRowIndex, int bStartColIndex, int bEndColIndex) {
        int[][] blockCellType = new int[bEndRowIndex - bStartRowIndex + 1][bEndColIndex - bStartColIndex + 1];
        int rowIdx = 0;
        for (int bRowIndex = bStartRowIndex; bRowIndex <= bEndRowIndex; ++bRowIndex) {
            int colIdx = 0;
            for (int bColIndex = bStartColIndex; bColIndex <= bEndColIndex; ++bColIndex) {
                Row row = sheet.getRow(bRowIndex);
                blockCellType[rowIdx][colIdx] = row != null && row.getCell(bColIndex) != null ? row.getCell(bColIndex).getCellType() : 3;
                ++colIdx;
            }
            ++rowIdx;
        }
        return blockCellType;
    }
}

