/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.reports.model;

import java.util.ArrayList;
import java.util.List;
import org.bbreak.excella.reports.model.ConvertConfiguration;
import org.bbreak.excella.reports.model.ReportSheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportBook {
    private List<ReportSheet> reportSheets = new ArrayList<ReportSheet>();
    private String templateFileName = null;
    private String outputFileName = null;
    private ConvertConfiguration[] configurations = null;

    public ReportBook(String templateFileName, String outputFileName, ConvertConfiguration ... configurations) {
        this.templateFileName = templateFileName;
        this.outputFileName = outputFileName;
        this.configurations = configurations;
    }

    public ReportBook(String templateFileName, String outputFileName, String ... formatTypes) {
        this.templateFileName = templateFileName;
        this.outputFileName = outputFileName;
        this.configurations = new ConvertConfiguration[formatTypes.length];
        for (int i = 0; i < formatTypes.length; ++i) {
            this.configurations[i] = new ConvertConfiguration(formatTypes[i]);
        }
    }

    public void setReportSheets(List<ReportSheet> reportSheets) {
        this.reportSheets = reportSheets;
    }

    public List<ReportSheet> getReportSheets() {
        return this.reportSheets;
    }

    public void addReportSheet(ReportSheet reportSheet) {
        this.reportSheets.add(reportSheet);
    }

    public void addReportSheets(List<ReportSheet> reportSheets) {
        this.reportSheets.addAll(reportSheets);
    }

    public void removeReportSheet(ReportSheet reportSheet) {
        this.reportSheets.remove(reportSheet);
    }

    public void clearReportSheets() {
        this.reportSheets.clear();
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public void setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    public ConvertConfiguration[] getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(ConvertConfiguration ... configurations) {
        this.configurations = configurations;
    }

    public String getTemplateFileName() {
        return this.templateFileName;
    }

    public void setTemplateFileName(String templateFileName) {
        this.templateFileName = templateFileName;
    }
}

