/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Reports - Excelt@C𗘗p[c[
 *
 * $Id: ReportsTagParser.java 5 2009-06-22 07:55:44Z tomo-shibata $
 * $Revision: 5 $
 *
 * This file is part of ExCella Reports.
 *
 * ExCella Reports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Reports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Reports .  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.reports.tag;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.reports.model.ParamInfo;
import org.bbreak.excella.reports.model.ParsedReportInfo;

/**
 * [̃p[T[NX
 * @param <T> p[^uľ^
 * @since 1.0
 */
public abstract class ReportsTagParser<T> extends TagParser<ParsedReportInfo> {

    /*
     * (non-Javadoc)
     * 
     * @see org.bbreak.excella.core.tag.TagParser#parse(org.apache.poi.ss.usermodel.Sheet, org.apache.poi.ss.usermodel.Cell, java.lang.Object)
     */
    @Override
    public abstract ParsedReportInfo parse( Sheet sheet, Cell tagCell, Object data) throws ParseException;

    /**
     * RXgN^
     * 
     * @param tag ^O
     */
    public ReportsTagParser( String tag) {
        super( tag);
    }

    /**
     * ^O𐧌sƂĈۂ擾B
     * 
     * @return true:sƂč폜^false:u
     */
    public abstract boolean useControlRow();

    /**
     * p[^p[^Ŋi[Ăl擾B
     * 
     * @param paramInfo p[^
     * @param paramName p[^
     * @return ul
     */
    @SuppressWarnings( "unchecked")
    public T getParamData( ParamInfo paramInfo, String paramName) {
        if ( paramInfo == null || paramName == null) {
            return null;
        }
        return ( T) paramInfo.getParam( getTag(), paramName);
    }

}
