/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Reports - Excelt@C𗘗p[c[
 *
 * $Id: BlockColRepeatParamParser.java 5 2009-06-22 07:55:44Z tomo-shibata $
 * $Revision: 5 $
 *
 * This file is part of ExCella Reports.
 *
 * ExCella Reports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Reports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Reports .  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.reports.tag;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;
import org.bbreak.excella.reports.model.ParamInfo;
import org.bbreak.excella.reports.model.ParsedReportInfo;
import org.bbreak.excella.reports.processor.ReportsParserInfo;
import org.bbreak.excella.reports.util.ReportsUtil;

/**
 * V[g̒uɃubNPʂŌJԂϊp[T
 * 
 * @since 1.0
 */
public class BlockColRepeatParamParser extends ReportsTagParser<Object[]> {

    /**
     * O
     */
    private static Log log = LogFactory.getLog( BlockColRepeatParamParser.class);

    /**
     * ftHg^O
     */
    public static final String DEFAULT_TAG = "$BC[]";

    /**
     * uϐ̃p[^
     */
    public static final String PARAM_VALUE = "";

    /**
     * ubNs[gJnZp[^
     */
    public static final String PARAM_FROM = "fromCell";

    /**
     * ubNs[gIZp[^
     */
    public static final String PARAM_TO = "toCell";

    /**
     * őJԂ񐔃p[^
     */
    public static final String PARAM_REPEAT = "repeatNum";

    /**
     * ő܂Ԃ񐔃p[^
     */
    public static final String PARAM_TURN = "turnNum";

    /**
     * d\̒p[^
     */
    protected static final String PARAM_DUPLICATE = "hideDuplicate";

    /**
     * V[gւ̃nCp[NݒL
     */
    // ̕
    // public static final String PARAM_SHEET_LINK = "sheetLink";
    /**
     * ^Op[^
     */
    public static final String PARAM_REMOVE_TAG = "removeTag";

    /**
     * RXgN^
     */
    public BlockColRepeatParamParser() {
        super( DEFAULT_TAG);
    }

    /**
     * RXgN^
     * 
     * @param tag ^O
     */
    public BlockColRepeatParamParser( String tag) {
        super( tag);
    }

    @Override
    public boolean useControlRow() {
        return true;
    }

    @Override
    public ParsedReportInfo parse( Sheet sheet, Cell tagCell, Object data) throws ParseException {
        try {
            // p[^̎擾
            Map<String, String> paramDef = TagUtil.getParams( tagCell.getStringCellValue());

            // p[^`FbN
            checkParam( paramDef, tagCell);

            ReportsParserInfo info = ( ReportsParserInfo) data;
            ParamInfo paramInfo = info.getParamInfo();

            // ^[NX
            ParsedReportInfo parsedReportInfo = new ParsedReportInfo();
            List<Object> resultList = new ArrayList<Object>();

            // BC^O̖O擾
            String bcTagname = paramDef.get( PARAM_VALUE);
            if ( log.isDebugEnabled()) {
                log.debug( "BCp[^ : " + bcTagname);
            }

            // p[^ɑΉf[^擾
            Object[] paramInfos = getParamData( paramInfo, bcTagname);
            if ( paramInfos == null) {
                return parsedReportInfo;
            }
            // Pũp[T[擾
            List<SingleParamParser> singleParsers = getSingleReplaceParsers( info);

            // POJOParamInfoɕϊ
            List<ParamInfo> paramInfoList = new ArrayList<ParamInfo>();
            for ( Object obj : paramInfos) {
                if ( obj instanceof ParamInfo) {
                    paramInfoList.add( ( ParamInfo) obj);
                    continue;
                }
                ParamInfo childParamInfo = new ParamInfo();
                @SuppressWarnings( "unchecked")
                Map<String, Object> map = PropertyUtils.describe( obj);
                for ( Map.Entry<String, Object> entry : map.entrySet()) {
                    for ( ReportsTagParser<?> parser : singleParsers) {
                        childParamInfo.addParam( parser.getTag(), entry.getKey(), entry.getValue());
                    }
                }
                paramInfoList.add( childParamInfo);
            }
            paramInfos = paramInfoList.toArray( new ParamInfo[paramInfoList.size()]);

            // JԂő
            Integer repeatNum = paramInfos.length;
            if ( paramDef.containsKey( PARAM_REPEAT)) {
                if ( Integer.valueOf( paramDef.get( PARAM_REPEAT)) < repeatNum) {
                    repeatNum = Integer.valueOf( paramDef.get( PARAM_REPEAT));
                }
            }

            // ܂Ԃő
            // TODO ۗ
            /*
             * Integer turnNum = null; if (paramDef.containsKey( PARAM_TURN)) { turnNum = Integer.valueOf( paramDef.get( PARAM_TURN)); }
             */

            // d\s̂߂̃VOuʊi[}bv
            Map<String, Object> beforeBlockSingleDataMap = new HashMap<String, Object>();
            // d\̐ݒL
            if ( paramDef.containsKey( PARAM_DUPLICATE)) {
                String[] tmp = paramDef.get( PARAM_DUPLICATE).split( ";");
                // single^O`ɂ
                for ( String str : tmp) {
                    for ( ReportsTagParser<?> parser : singleParsers) {
                        str = parser.getTag() + TAG_PARAM_PREFIX + str + TAG_PARAM_SUFFIX;
                        // ŏkeyZbg
                        beforeBlockSingleDataMap.put( str, "");
                    }
                }
            }

            // removeTag`
            boolean removeTag = false;
            if ( paramDef.containsKey( PARAM_REMOVE_TAG)) {
                removeTag = Boolean.valueOf( paramDef.get( PARAM_REMOVE_TAG));
            }

            // fromCell`
            int[] fromCellPosition = ReportsUtil.getCellIndex( paramDef.get( PARAM_FROM), PARAM_FROM);
            int defaultFromCellRowIndex = tagCell.getRow().getRowNum() + fromCellPosition[0];
            int defaultFromCellColIndex = tagCell.getColumnIndex() + fromCellPosition[1];

            // toCell`
            int[] toCellIndex = ReportsUtil.getCellIndex( paramDef.get( PARAM_TO), PARAM_TO);
            int defaultToCellRowIndex = tagCell.getRow().getRowNum() + toCellIndex[0];
            int defaultToCellColIndex = tagCell.getColumnIndex() + toCellIndex[1];

            // ubNuŏIW(l̓ubN͈)
            int blockEndRowIndex = defaultToCellRowIndex;
            int blockEndColIndex = defaultToCellColIndex;
            int blockStartRowIndex = defaultFromCellRowIndex;
            int blockStartColIndex = defaultFromCellColIndex;

            // BCubN̕ۑCell[row][col]
            Object[][] blockCellsValue = ReportsUtil.getBlockCellValue( sheet, defaultFromCellRowIndex, defaultToCellRowIndex, defaultFromCellColIndex, defaultToCellColIndex);
            CellStyle[][] blockCellsStyle = ReportsUtil.getBlockCellStyle( sheet, defaultFromCellRowIndex, defaultToCellRowIndex, defaultFromCellColIndex, defaultToCellColIndex);

            // ubN͈͎擾
            int rowlen = defaultToCellRowIndex - defaultFromCellRowIndex + 1;
            int collen = defaultToCellColIndex - defaultFromCellColIndex + 1;

            // ܂Ԃ܂ł̃ubN[vJE^
            int turnCount = 0;

            int maxblockEndRowIndex = blockEndRowIndex;

            TagParser<?> parser = null;

            ParsedReportInfo result = null;

            int totalPlusColNum = 0;

            // f[^[v
            for ( int repeatCount = 0; repeatCount < repeatNum; repeatCount++) {

                // f[^[v܂Ԃ񐔂ɒBblockStartRowIndex̐ݒAblockEndColIndex̃Zbg
                // TODO ۗ
                /*
                 * if (turnNum != null && turnNum <= turnCount) { blockStartRowIndex = blockEndRowIndex + 1; blockEndColIndex = 0; turnCount = 0; }
                 */

                // ubNJnݒ
                if ( turnCount > 0) {
                    blockStartColIndex = blockEndColIndex + 1;
                    blockEndColIndex = blockStartColIndex + collen - 1;
                } else {
                    blockStartColIndex = tagCell.getColumnIndex();
                }
                turnCount++;

                // EBCubN
                if ( repeatCount > 0) {
                    CellRangeAddress rangeAddress = new CellRangeAddress( blockStartRowIndex, sheet.getLastRowNum(), blockStartColIndex, blockStartColIndex + collen - 1);
                    PoiUtil.insertRangeRight( sheet, rangeAddress);
                }

                // ubNV[gɃRs[
                if ( log.isDebugEnabled()) {
                    log.debug( "ubNRs[ f[^[v=" + repeatCount);
                }

                for ( int row = 0; row < blockCellsValue.length; row++) {
                    for ( int col = 0; col < blockCellsValue[row].length; col++) {
                        if ( sheet.getRow( blockStartRowIndex + row).getCell( blockStartColIndex + col) == null) {
                            sheet.getRow( blockStartRowIndex + row).createCell( blockStartColIndex + col);
                        }

                        PoiUtil.setCellValue( sheet.getRow( blockStartRowIndex + row).getCell( blockStartColIndex + col), blockCellsValue[row][col]);

                        if ( blockCellsStyle[row][col] != null) {
                            sheet.getRow( blockStartRowIndex + row).getCell( blockStartColIndex + col).setCellStyle( blockCellsStyle[row][col]);
                        }
                        if ( log.isDebugEnabled()) {
                            log.debug( "row=" + (blockStartRowIndex + row) + " col" + (blockStartColIndex + col) + ">>>>>>" + blockCellsValue[row][col]);
                        }
                    }
                }

                // qp[Tł̍s}ɂĐe^O͔͈͂̑̒l
                int plusRowNum = 0;
                // qp[Tł̍s}ɂĐe^O͔͈͂̑̒l
                int plusColNum = 0;
                collen = defaultToCellColIndex - defaultFromCellColIndex + 1;

                // s[v
                for ( int targetRow = blockStartRowIndex; targetRow < blockStartRowIndex + rowlen + plusRowNum; targetRow++) {
                    if ( sheet.getRow( targetRow) == null) {
                        if ( log.isDebugEnabled()) {
                            log.debug( "row=" + targetRow + " : row is not available. continued...");
                        }
                        continue;
                    }

                    // uΏۃZ
                    Cell chgTargetCell = null;

                    // 񃋁[v
                    for ( int targetCol = blockStartColIndex; targetCol <= blockStartColIndex + collen + plusColNum - 1; targetCol++) {

                        // uZ̎擾
                        chgTargetCell = sheet.getRow( targetRow).getCell( targetCol);
                        if ( chgTargetCell == null) {
                            if ( log.isDebugEnabled()) {
                                log.debug( "row=" + targetRow + " col=" + targetCol + " : cell is not available. continued...");
                            }
                            continue;
                        }

                        parser = info.getMatchTagParser( sheet, chgTargetCell);
                        if ( parser == null) {
                            if ( log.isDebugEnabled()) {
                                log.debug( "row=" + targetRow + " col=" + targetCol + " parser is not available. continued...");
                            }
                            continue;
                        }

                        String chgTargetCellString = chgTargetCell.getStringCellValue();
                        if ( log.isDebugEnabled()) {
                            log.debug( "########## ^OZW row=" + targetRow + " col=" + targetCol + " ^O=" + chgTargetCellString + " ##########");
                        }

                        // p[Xs
                        result = ( ParsedReportInfo) parser.parse( sheet, chgTargetCell, info.createChildParserInfo( ( ParamInfo) paramInfos[repeatCount]));

                        // qp[Tł̍s}
                        plusRowNum += result.getRowIndex() - result.getDefaultRowIndex();

                        // qp[Tł̗}
                        plusColNum += result.getColumnIndex() - result.getDefaultColumnIndex();

                        // p[T[singleȕꍇIvVŎw肳ꂽds^O̒ul
                        // OubN̓ulƓꍇ͏B
                        if ( parser instanceof SingleParamParser && beforeBlockSingleDataMap.containsKey( chgTargetCellString)) {
                            if ( beforeBlockSingleDataMap.get( chgTargetCellString).equals( result.getParsedObject())) {
                                // 󕶎Zbg
                                PoiUtil.setCellValue( chgTargetCell, "");

                            } else {
                                // }bv̒l̏㏑
                                beforeBlockSingleDataMap.put( chgTargetCellString, result.getParsedObject());
                            }
                        }

                        // qp[TɂďcɑAqp[T̃^OʒuO̗ɃZ}
                        if ( blockStartColIndex != result.getDefaultColumnIndex() && maxblockEndRowIndex <= blockEndRowIndex && result.getRowIndex() > result.getDefaultRowIndex()) {
                            CellRangeAddress preRangeAddress = new CellRangeAddress( blockEndRowIndex + 1, blockEndRowIndex + (result.getRowIndex() - result.getDefaultRowIndex()), blockStartColIndex,
                                targetCol - 1);
                            PoiUtil.insertRangeDown( sheet, preRangeAddress);
                            if ( log.isDebugEnabled()) {
                                log.debug( "***c␳***");
                                log.debug( "}͈1 : " + (blockEndRowIndex + 1) + ":" + (blockEndRowIndex + (result.getRowIndex() - result.getDefaultRowIndex())) + ":" + blockStartColIndex + ":"
                                        + (targetCol - 1));
                            }
                        }

                        // Ȑꍇ̓^Oʒuȍ~ɂZ}
                        if ( parser instanceof RowRepeatParamParser && maxblockEndRowIndex <= blockEndRowIndex && result.getRowIndex() > result.getDefaultRowIndex()) {
                            CellRangeAddress rearRangeAddress = new CellRangeAddress( blockEndRowIndex + 1, blockEndRowIndex + (result.getRowIndex() - result.getDefaultRowIndex()), result
                                .getDefaultColumnIndex() + 1, blockEndColIndex);
                            PoiUtil.insertRangeDown( sheet, rearRangeAddress);
                            if ( log.isDebugEnabled()) {
                                log.debug( "***c␳***");
                                log.debug( "}͈2 : " + (blockEndRowIndex + 1) + ":" + (blockEndRowIndex + (result.getRowIndex() - result.getDefaultRowIndex())) + ":"
                                        + (result.getDefaultColumnIndex() + 1) + ":" + blockEndColIndex);
                            }
                        }

                        blockEndRowIndex = defaultToCellRowIndex + plusRowNum;

                        resultList.add( result.getParsedObject());

                        if ( parser instanceof BlockColRepeatParamParser || parser instanceof BlockRowRepeatParamParser) {
                            collen += result.getColumnIndex() - result.getDefaultColumnIndex();
                            plusColNum -= result.getColumnIndex() - result.getDefaultColumnIndex();
                        }

                        // q̃p[XĉɑAubNŏIWXV
                        if ( blockStartColIndex + collen + plusColNum - 1 > blockEndColIndex) {
                            int beforeLastColIndex = blockEndColIndex;
                            blockEndColIndex = blockStartColIndex + collen + plusColNum - 1;

                            // ^OZs猻ݍŝP܂łɉɑZ}
                            CellRangeAddress preRangeAddress = new CellRangeAddress( tagCell.getRowIndex(), targetRow - 1, beforeLastColIndex + 1, blockEndColIndex);
                            PoiUtil.insertRangeRight( sheet, preRangeAddress);
                            if ( log.isDebugEnabled()) {
                                log.debug( "***␳***");
                                log.debug( "}͈1 : " + tagCell.getRowIndex() + ":" + (targetRow - 1) + ":" + (beforeLastColIndex + 1) + ":" + blockEndColIndex);
                            }
                            // ŏIsɍŏIȍ~ɑZ}
                            CellRangeAddress rangeAddress = new CellRangeAddress( blockEndRowIndex + 1, sheet.getLastRowNum(), beforeLastColIndex + 1, blockEndColIndex);
                            PoiUtil.insertRangeRight( sheet, rangeAddress);
                            if ( log.isDebugEnabled()) {
                                log.debug( "***␳***");
                                log.debug( "}͈3 : " + (blockEndRowIndex + 1) + ":" + sheet.getLastRowNum() + ":" + (beforeLastColIndex + 1) + ":" + blockEndColIndex);
                            }
                        }
                        // 񃋁[vI
                    }
                    // sɉɑZ}
                    if ( blockStartColIndex + collen + plusColNum - 1 < blockEndColIndex) {
                        CellRangeAddress rearRangeAddress = new CellRangeAddress( targetRow, targetRow, blockStartColIndex + collen + plusColNum, blockEndColIndex);
                        PoiUtil.insertRangeRight( sheet, rearRangeAddress);
                        if ( log.isDebugEnabled()) {
                            log.debug( "***␳***");
                            log.debug( "}͈2 : " + targetRow + ":" + targetRow + ":" + (blockStartColIndex + collen + plusColNum) + ":" + blockEndColIndex);
                        }
                    }

                    totalPlusColNum += plusColNum;
                    plusColNum = 0;

                    // s[vI
                }

                // ubNJnOɏcɐLт̃Z}
                if ( maxblockEndRowIndex < blockEndRowIndex) {
                    if ( log.isDebugEnabled()) {
                        log.debug( "***c␳***");
                    }
                    if ( repeatCount != 0) {
                        CellRangeAddress preRangeAddress = new CellRangeAddress( maxblockEndRowIndex + 1, blockEndRowIndex, defaultFromCellColIndex, blockStartColIndex - 1);
                        PoiUtil.insertRangeDown( sheet, preRangeAddress);
                        if ( log.isDebugEnabled()) {
                            log.debug( "}͈1 : " + (maxblockEndRowIndex + 1) + ":" + blockEndRowIndex + ":" + defaultFromCellColIndex + ":" + (blockStartColIndex - 1));
                        }
                    }

                    // ubNŏIȍ~ɏcɐLт̃Z}
                    CellRangeAddress rearRangeAddress = new CellRangeAddress( maxblockEndRowIndex + 1, blockEndRowIndex, blockEndColIndex + 1, PoiUtil.getLastColNum( sheet));
                    PoiUtil.insertRangeDown( sheet, rearRangeAddress);
                    if ( log.isDebugEnabled()) {
                        log.debug( "}͈2 : " + (maxblockEndRowIndex + 1) + ":" + blockEndRowIndex + ":" + (blockEndColIndex + 1) + ":" + PoiUtil.getLastColNum( sheet));
                    }

                    maxblockEndRowIndex = blockEndRowIndex;
                }
            }

            // ^O
            if ( removeTag) {
                tagCell.setCellType( Cell.CELL_TYPE_BLANK);
            }

            // ^[Zbg
            parsedReportInfo.setDefaultRowIndex( defaultToCellRowIndex);
            parsedReportInfo.setDefaultColumnIndex( defaultToCellColIndex);
            parsedReportInfo.setColumnIndex( blockEndColIndex);
            parsedReportInfo.setParsedObject( resultList);
            parsedReportInfo.setRowIndex( maxblockEndRowIndex);

            if ( log.isDebugEnabled()) {
                log.debug( "finalBlockRowIndex= " + maxblockEndRowIndex);
                log.debug( "finalBlockColIndex=" + blockEndColIndex);
            }
            return parsedReportInfo;

        } catch ( Exception e) {
            throw new ParseException( tagCell, e);
        }
    }

    /**
     * ݎgpĂPup[T[擾B
     * 
     * @param reportsParserInfo [͏
     * @return ݎgpĂPu
     */
    private List<SingleParamParser> getSingleReplaceParsers( ReportsParserInfo reportsParserInfo) {
        List<ReportsTagParser<?>> parsers = reportsParserInfo.getReportParsers();
        List<SingleParamParser> singleParsers = new ArrayList<SingleParamParser>();
        for ( ReportsTagParser<?> reportsParser : parsers) {
            if ( reportsParser instanceof SingleParamParser) {
                singleParsers.add( ( SingleParamParser) reportsParser);
            }
        }
        return singleParsers;
    }

    /**
     * sȃp[^ꍇAParseExceptionthrowB
     * 
     * @param paramDef
     * @param tagCell
     * @throws ParseException
     */
    private void checkParam( Map<String, String> paramDef, Cell tagCell) throws ParseException {
        // L[
        // K{`FbN
        if ( !paramDef.containsKey( PARAM_FROM)) {
            throw new ParseException( tagCell + "K{p[^ȂF" + PARAM_FROM);
        }
        if ( !paramDef.containsKey( PARAM_TO)) {
            throw new ParseException( tagCell + "K{p[^ȂF" + PARAM_TO);
        }

        // l
        if ( paramDef.get( PARAM_FROM).split( ":").length != 2) {
            throw new ParseException( tagCell + "p[^lsF" + PARAM_FROM);
        }
        if ( paramDef.get( PARAM_TO).split( ":").length != 2) {
            throw new ParseException( tagCell + "p[^lsF" + PARAM_TO);
        }

        int[] fromCellIndex = ReportsUtil.getCellIndex( paramDef.get( PARAM_FROM), PARAM_FROM);
        int[] toCellIndex = ReportsUtil.getCellIndex( paramDef.get( PARAM_TO), PARAM_TO);

        if ( fromCellIndex[0] < 0 || fromCellIndex[1] < 0) {
            throw new ParseException( tagCell + "p[^sF" + PARAM_FROM);
        }
        if ( toCellIndex[0] < 0 || toCellIndex[1] < 0) {
            throw new ParseException( tagCell + "p[^sF" + PARAM_TO);
        }

        if ( fromCellIndex[0] > toCellIndex[0]) {
            throw new ParseException( tagCell + "p[^sisjF" + PARAM_FROM + "," + PARAM_TO);
        }
        if ( fromCellIndex[1] > toCellIndex[1]) {
            throw new ParseException( tagCell + "p[^sijF" + PARAM_FROM + "," + PARAM_TO);
        }

        try {
            if ( paramDef.containsKey( PARAM_REPEAT)) {
                if ( Integer.valueOf( paramDef.get( PARAM_REPEAT)) < 0) {
                    throw new ParseException( tagCell, "p[^lsF" + PARAM_REPEAT);
                }
            }
        } catch ( NumberFormatException e) {
            throw new ParseException( tagCell + "p[^sF" + PARAM_REPEAT);
        }

    }
}
