/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.poi.hssf.record.UnicodeString;
import org.apache.poi.hssf.record.constant.ErrorConstant;
import org.apache.poi.hssf.record.formula.AbstractFunctionPtg;
import org.apache.poi.hssf.record.formula.AddPtg;
import org.apache.poi.hssf.record.formula.Area3DPtg;
import org.apache.poi.hssf.record.formula.AreaPtg;
import org.apache.poi.hssf.record.formula.ArrayPtg;
import org.apache.poi.hssf.record.formula.AttrPtg;
import org.apache.poi.hssf.record.formula.BoolPtg;
import org.apache.poi.hssf.record.formula.ConcatPtg;
import org.apache.poi.hssf.record.formula.DividePtg;
import org.apache.poi.hssf.record.formula.EqualPtg;
import org.apache.poi.hssf.record.formula.ErrPtg;
import org.apache.poi.hssf.record.formula.FuncPtg;
import org.apache.poi.hssf.record.formula.FuncVarPtg;
import org.apache.poi.hssf.record.formula.GreaterEqualPtg;
import org.apache.poi.hssf.record.formula.GreaterThanPtg;
import org.apache.poi.hssf.record.formula.IntPtg;
import org.apache.poi.hssf.record.formula.LessEqualPtg;
import org.apache.poi.hssf.record.formula.LessThanPtg;
import org.apache.poi.hssf.record.formula.MemAreaPtg;
import org.apache.poi.hssf.record.formula.MemFuncPtg;
import org.apache.poi.hssf.record.formula.MissingArgPtg;
import org.apache.poi.hssf.record.formula.MultiplyPtg;
import org.apache.poi.hssf.record.formula.NamePtg;
import org.apache.poi.hssf.record.formula.NameXPtg;
import org.apache.poi.hssf.record.formula.NotEqualPtg;
import org.apache.poi.hssf.record.formula.NumberPtg;
import org.apache.poi.hssf.record.formula.OperandPtg;
import org.apache.poi.hssf.record.formula.OperationPtg;
import org.apache.poi.hssf.record.formula.ParenthesisPtg;
import org.apache.poi.hssf.record.formula.PercentPtg;
import org.apache.poi.hssf.record.formula.PowerPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.RangePtg;
import org.apache.poi.hssf.record.formula.Ref3DPtg;
import org.apache.poi.hssf.record.formula.RefPtg;
import org.apache.poi.hssf.record.formula.StringPtg;
import org.apache.poi.hssf.record.formula.SubtractPtg;
import org.apache.poi.hssf.record.formula.UnaryMinusPtg;
import org.apache.poi.hssf.record.formula.UnaryPlusPtg;
import org.apache.poi.hssf.record.formula.UnionPtg;
import org.apache.poi.hssf.record.formula.ValueOperatorPtg;
import org.apache.poi.hssf.record.formula.function.FunctionMetadata;
import org.apache.poi.hssf.record.formula.function.FunctionMetadataRegistry;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.formula.EvaluationName;
import org.apache.poi.ss.formula.ExternSheetReferenceToken;
import org.apache.poi.ss.formula.FormulaParsingWorkbook;
import org.apache.poi.ss.formula.OperandClassTransformer;
import org.apache.poi.ss.formula.ParseNode;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.ss.util.CellReference;

public final class FormulaParser {
    private final String _formulaString;
    private final int _formulaLength;
    private int _pointer;
    private ParseNode _rootNode;
    private static char TAB = (char)9;
    private char look;
    private FormulaParsingWorkbook _book;
    private SpreadsheetVersion _ssVersion;
    private int _sheetIndex;
    private static final Pattern CELL_REF_PATTERN = Pattern.compile("(\\$?[A-Za-z]+)?(\\$?[0-9]+)?");

    private FormulaParser(String formula, FormulaParsingWorkbook book, int sheetIndex) {
        this._formulaString = formula;
        this._pointer = 0;
        this._book = book;
        this._ssVersion = book == null ? SpreadsheetVersion.EXCEL97 : book.getSpreadsheetVersion();
        this._formulaLength = this._formulaString.length();
        this._sheetIndex = sheetIndex;
    }

    public static Ptg[] parse(String formula, FormulaParsingWorkbook book) {
        return FormulaParser.parse(formula, book, 0);
    }

    public static Ptg[] parse(String formula, FormulaParsingWorkbook workbook, int formulaType) {
        return FormulaParser.parse(formula, workbook, formulaType, -1);
    }

    public static Ptg[] parse(String formula, FormulaParsingWorkbook workbook, int formulaType, int sheetIndex) {
        FormulaParser fp = new FormulaParser(formula, workbook, sheetIndex);
        fp.parse();
        return fp.getRPNPtg(formulaType);
    }

    private void GetChar() {
        if (this._pointer > this._formulaLength) {
            throw new RuntimeException("too far");
        }
        this.look = this._pointer < this._formulaLength ? this._formulaString.charAt(this._pointer) : (char)'\u0000';
        ++this._pointer;
    }

    private void resetPointer(int ptr) {
        this._pointer = ptr;
        this.look = this._pointer <= this._formulaLength ? this._formulaString.charAt(this._pointer - 1) : (char)'\u0000';
    }

    private RuntimeException expected(String s) {
        String msg = this.look == '=' && this._formulaString.substring(0, this._pointer - 1).trim().length() < 1 ? "The specified formula '" + this._formulaString + "' starts with an equals sign which is not allowed." : "Parse error near char " + (this._pointer - 1) + " '" + this.look + "'" + " in specified formula '" + this._formulaString + "'. Expected " + s;
        return new FormulaParseException(msg);
    }

    private static boolean IsAlpha(char c) {
        return Character.isLetter(c) || c == '$' || c == '_';
    }

    private static boolean IsDigit(char c) {
        return Character.isDigit(c);
    }

    private static boolean IsWhite(char c) {
        return c == ' ' || c == TAB;
    }

    private void SkipWhite() {
        while (FormulaParser.IsWhite(this.look)) {
            this.GetChar();
        }
    }

    private void Match(char x) {
        if (this.look != x) {
            throw this.expected("'" + x + "'");
        }
        this.GetChar();
    }

    private String GetNum() {
        StringBuffer value = new StringBuffer();
        while (FormulaParser.IsDigit(this.look)) {
            value.append(this.look);
            this.GetChar();
        }
        return value.length() == 0 ? null : value.toString();
    }

    private ParseNode parseRangeExpression() {
        ParseNode result = this.parseRangeable();
        boolean hasRange = false;
        while (this.look == ':') {
            int pos = this._pointer;
            this.GetChar();
            ParseNode nextPart = this.parseRangeable();
            FormulaParser.checkValidRangeOperand("LHS", pos, result);
            FormulaParser.checkValidRangeOperand("RHS", pos, nextPart);
            ParseNode[] children = new ParseNode[]{result, nextPart};
            result = new ParseNode((Ptg)RangePtg.instance, children);
            hasRange = true;
        }
        if (hasRange) {
            return FormulaParser.augmentWithMemPtg(result);
        }
        return result;
    }

    private static ParseNode augmentWithMemPtg(ParseNode root) {
        OperandPtg memPtg = FormulaParser.needsMemFunc(root) ? new MemFuncPtg(root.getEncodedSize()) : new MemAreaPtg(root.getEncodedSize());
        return new ParseNode((Ptg)memPtg, root);
    }

    private static boolean needsMemFunc(ParseNode root) {
        Ptg token = root.getToken();
        if (token instanceof AbstractFunctionPtg) {
            return true;
        }
        if (token instanceof ExternSheetReferenceToken) {
            return true;
        }
        if (token instanceof NamePtg || token instanceof NameXPtg) {
            return true;
        }
        if (token instanceof OperationPtg || token instanceof ParenthesisPtg) {
            for (ParseNode child : root.getChildren()) {
                if (!FormulaParser.needsMemFunc(child)) continue;
                return true;
            }
            return false;
        }
        if (token instanceof OperandPtg) {
            return false;
        }
        return token instanceof OperationPtg;
    }

    private static void checkValidRangeOperand(String sideName, int currentParsePosition, ParseNode pn) {
        if (!FormulaParser.isValidRangeOperand(pn)) {
            throw new FormulaParseException("The " + sideName + " of the range operator ':' at position " + currentParsePosition + " is not a proper reference.");
        }
    }

    private static boolean isValidRangeOperand(ParseNode a) {
        Ptg tkn = a.getToken();
        if (tkn instanceof OperandPtg) {
            return true;
        }
        if (tkn instanceof AbstractFunctionPtg) {
            AbstractFunctionPtg afp = (AbstractFunctionPtg)tkn;
            byte returnClass = afp.getDefaultOperandClass();
            return 0 == returnClass;
        }
        if (tkn instanceof ValueOperatorPtg) {
            return false;
        }
        if (tkn instanceof OperationPtg) {
            return true;
        }
        if (tkn instanceof ParenthesisPtg) {
            return FormulaParser.isValidRangeOperand(a.getChildren()[0]);
        }
        return tkn == ErrPtg.REF_INVALID;
    }

    private ParseNode parseRangeable() {
        this.SkipWhite();
        int savePointer = this._pointer;
        SheetIdentifier sheetIden = this.parseSheetName();
        if (sheetIden == null) {
            this.resetPointer(savePointer);
        } else {
            this.SkipWhite();
            savePointer = this._pointer;
        }
        SimpleRangePart part1 = this.parseSimpleRangePart();
        if (part1 == null) {
            if (sheetIden != null) {
                throw new FormulaParseException("Cell reference expected after sheet name at index " + this._pointer + ".");
            }
            return this.parseNonRange(savePointer);
        }
        boolean whiteAfterPart1 = FormulaParser.IsWhite(this.look);
        if (whiteAfterPart1) {
            this.SkipWhite();
        }
        if (this.look == ':') {
            int colonPos = this._pointer;
            this.GetChar();
            this.SkipWhite();
            SimpleRangePart part2 = this.parseSimpleRangePart();
            if (part2 != null && !part1.isCompatibleForArea(part2)) {
                part2 = null;
            }
            if (part2 == null) {
                this.resetPointer(colonPos);
                if (!part1.isCell()) {
                    String prefix = sheetIden == null ? "" : "'" + sheetIden.getSheetIdentifier().getName() + '!';
                    throw new FormulaParseException(prefix + part1.getRep() + "' is not a proper reference.");
                }
                return this.createAreaRefParseNode(sheetIden, part1, part2);
            }
            return this.createAreaRefParseNode(sheetIden, part1, part2);
        }
        if (this.look == '.') {
            this.GetChar();
            int dotCount = 1;
            while (this.look == '.') {
                ++dotCount;
                this.GetChar();
            }
            boolean whiteBeforePart2 = FormulaParser.IsWhite(this.look);
            this.SkipWhite();
            SimpleRangePart part2 = this.parseSimpleRangePart();
            String part1And2 = this._formulaString.substring(savePointer - 1, this._pointer - 1);
            if (part2 == null) {
                if (sheetIden != null) {
                    throw new FormulaParseException("Complete area reference expected after sheet name at index " + this._pointer + ".");
                }
                return this.parseNonRange(savePointer);
            }
            if (whiteAfterPart1 || whiteBeforePart2) {
                if (part1.isRowOrColumn() || part2.isRowOrColumn()) {
                    throw new FormulaParseException("Dotted range (full row or column) expression '" + part1And2 + "' must not contain whitespace.");
                }
                return this.createAreaRefParseNode(sheetIden, part1, part2);
            }
            if (dotCount == 1 && part1.isRow() && part2.isRow()) {
                return this.parseNonRange(savePointer);
            }
            if ((part1.isRowOrColumn() || part2.isRowOrColumn()) && dotCount != 2) {
                throw new FormulaParseException("Dotted range (full row or column) expression '" + part1And2 + "' must have exactly 2 dots.");
            }
            return this.createAreaRefParseNode(sheetIden, part1, part2);
        }
        if (part1.isCell() && this.isValidCellReference(part1.getRep())) {
            return this.createAreaRefParseNode(sheetIden, part1, null);
        }
        if (sheetIden != null) {
            throw new FormulaParseException("Second part of cell reference expected after sheet name at index " + this._pointer + ".");
        }
        return this.parseNonRange(savePointer);
    }

    private ParseNode parseNonRange(int savePointer) {
        this.resetPointer(savePointer);
        if (Character.isDigit(this.look)) {
            return new ParseNode(this.parseNumber());
        }
        if (this.look == '\"') {
            return new ParseNode(new StringPtg(this.parseStringLiteral()));
        }
        StringBuilder sb = new StringBuilder();
        if (!Character.isLetter(this.look)) {
            throw this.expected("number, string, or defined name");
        }
        while (FormulaParser.isValidDefinedNameChar(this.look)) {
            sb.append(this.look);
            this.GetChar();
        }
        this.SkipWhite();
        String name = sb.toString();
        if (this.look == '(') {
            return this.function(name);
        }
        if (name.equalsIgnoreCase("TRUE") || name.equalsIgnoreCase("FALSE")) {
            return new ParseNode(new BoolPtg(name.toUpperCase()));
        }
        if (this._book == null) {
            throw new IllegalStateException("Need book to evaluate name '" + name + "'");
        }
        EvaluationName evalName = this._book.getName(name, this._sheetIndex);
        if (evalName == null) {
            throw new FormulaParseException("Specified named range '" + name + "' does not exist in the current workbook.");
        }
        if (evalName.isRange()) {
            return new ParseNode(evalName.createPtg());
        }
        throw new FormulaParseException("Specified name '" + name + "' is not a range as expected.");
    }

    private static boolean isValidDefinedNameChar(char ch) {
        if (Character.isLetterOrDigit(ch)) {
            return true;
        }
        switch (ch) {
            case '.': 
            case '?': 
            case '\\': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    private ParseNode createAreaRefParseNode(SheetIdentifier sheetIden, SimpleRangePart part1, SimpleRangePart part2) throws FormulaParseException {
        OperandPtg ptg;
        int extIx;
        if (sheetIden == null) {
            extIx = Integer.MIN_VALUE;
        } else {
            String sName = sheetIden.getSheetIdentifier().getName();
            extIx = sheetIden.getBookName() == null ? this._book.getExternalSheetIndex(sName) : this._book.getExternalSheetIndex(sheetIden.getBookName(), sName);
        }
        if (part2 == null) {
            CellReference cr = part1.getCellReference();
            ptg = sheetIden == null ? new RefPtg(cr) : new Ref3DPtg(cr, extIx);
        } else {
            AreaReference areaRef = FormulaParser.createAreaRef(part1, part2);
            ptg = sheetIden == null ? new AreaPtg(areaRef) : new Area3DPtg(areaRef, extIx);
        }
        return new ParseNode(ptg);
    }

    private static AreaReference createAreaRef(SimpleRangePart part1, SimpleRangePart part2) {
        if (!part1.isCompatibleForArea(part2)) {
            throw new FormulaParseException("has incompatible parts: '" + part1.getRep() + "' and '" + part2.getRep() + "'.");
        }
        if (part1.isRow()) {
            return AreaReference.getWholeRow(part1.getRep(), part2.getRep());
        }
        if (part1.isColumn()) {
            return AreaReference.getWholeColumn(part1.getRep(), part2.getRep());
        }
        return new AreaReference(part1.getCellReference(), part2.getCellReference());
    }

    private SimpleRangePart parseSimpleRangePart() {
        int ptr;
        boolean hasDigits = false;
        boolean hasLetters = false;
        for (ptr = this._pointer - 1; ptr < this._formulaLength; ++ptr) {
            char ch = this._formulaString.charAt(ptr);
            if (Character.isDigit(ch)) {
                hasDigits = true;
                continue;
            }
            if (Character.isLetter(ch)) {
                hasLetters = true;
                continue;
            }
            if (ch != '$') break;
        }
        if (ptr <= this._pointer - 1) {
            return null;
        }
        String rep = this._formulaString.substring(this._pointer - 1, ptr);
        if (!CELL_REF_PATTERN.matcher(rep).matches()) {
            return null;
        }
        if (hasLetters && hasDigits) {
            if (!this.isValidCellReference(rep)) {
                return null;
            }
        } else if (hasLetters) {
            if (!CellReference.isColumnWithnRange(rep.replace("$", ""), this._ssVersion)) {
                return null;
            }
        } else if (hasDigits) {
            int i;
            try {
                i = Integer.parseInt(rep.replace("$", ""));
            }
            catch (NumberFormatException e) {
                return null;
            }
            if (i < 1 || i > 65536) {
                return null;
            }
        } else {
            return null;
        }
        this.resetPointer(ptr + 1);
        return new SimpleRangePart(rep, hasLetters, hasDigits);
    }

    private SheetIdentifier parseSheetName() {
        String bookName;
        AbstractStringBuilder sb;
        if (this.look == '[') {
            sb = new StringBuilder();
            this.GetChar();
            while (this.look != ']') {
                ((StringBuilder)sb).append(this.look);
                this.GetChar();
            }
            this.GetChar();
            bookName = ((StringBuilder)sb).toString();
        } else {
            bookName = null;
        }
        if (this.look == '\'') {
            boolean done;
            sb = new StringBuffer();
            this.Match('\'');
            boolean bl = done = this.look == '\'';
            while (!done) {
                ((StringBuffer)sb).append(this.look);
                this.GetChar();
                if (this.look != '\'') continue;
                this.Match('\'');
                done = this.look != '\'';
            }
            Identifier iden = new Identifier(((StringBuffer)sb).toString(), true);
            this.SkipWhite();
            if (this.look == '!') {
                this.GetChar();
                return new SheetIdentifier(bookName, iden);
            }
            return null;
        }
        if (this.look == '_' || Character.isLetter(this.look)) {
            sb = new StringBuilder();
            while (FormulaParser.isUnquotedSheetNameChar(this.look)) {
                ((StringBuilder)sb).append(this.look);
                this.GetChar();
            }
            this.SkipWhite();
            if (this.look == '!') {
                this.GetChar();
                return new SheetIdentifier(bookName, new Identifier(((StringBuilder)sb).toString(), false));
            }
            return null;
        }
        return null;
    }

    private static boolean isUnquotedSheetNameChar(char ch) {
        if (Character.isLetterOrDigit(ch)) {
            return true;
        }
        switch (ch) {
            case '.': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    private boolean isValidCellReference(String str) {
        boolean result;
        boolean bl = result = CellReference.classifyCellReference(str, this._ssVersion) == 1;
        if (result) {
            boolean isFunc;
            boolean bl2 = isFunc = FunctionMetadataRegistry.getFunctionByName(str.toUpperCase()) != null;
            if (isFunc) {
                int savePointer = this._pointer;
                this.resetPointer(this._pointer + str.length());
                this.SkipWhite();
                result = this.look != '(';
                this.resetPointer(savePointer);
            }
        }
        return result;
    }

    private ParseNode function(String name) {
        OperandPtg nameToken = null;
        if (!AbstractFunctionPtg.isBuiltInFunctionName(name)) {
            if (this._book == null) {
                throw new IllegalStateException("Need book to evaluate name '" + name + "'");
            }
            EvaluationName hName = this._book.getName(name, this._sheetIndex);
            if (hName == null) {
                nameToken = this._book.getNameXPtg(name);
                if (nameToken == null) {
                    throw new FormulaParseException("Name '" + name + "' is completely unknown in the current workbook");
                }
            } else {
                if (!hName.isFunctionName()) {
                    throw new FormulaParseException("Attempt to use name '" + name + "' as a function, but defined name in workbook does not refer to a function");
                }
                nameToken = hName.createPtg();
            }
        }
        this.Match('(');
        ParseNode[] args = this.Arguments();
        this.Match(')');
        return this.getFunction(name, nameToken, args);
    }

    private ParseNode getFunction(String name, Ptg namePtg, ParseNode[] args) {
        FunctionMetadata fm = FunctionMetadataRegistry.getFunctionByName(name.toUpperCase());
        int numArgs = args.length;
        if (fm == null) {
            if (namePtg == null) {
                throw new IllegalStateException("NamePtg must be supplied for external functions");
            }
            ParseNode[] allArgs = new ParseNode[numArgs + 1];
            allArgs[0] = new ParseNode(namePtg);
            System.arraycopy(args, 0, allArgs, 1, numArgs);
            return new ParseNode((Ptg)new FuncVarPtg(name, (byte)(numArgs + 1)), allArgs);
        }
        if (namePtg != null) {
            throw new IllegalStateException("NamePtg no applicable to internal functions");
        }
        boolean isVarArgs = !fm.hasFixedArgsLength();
        int funcIx = fm.getIndex();
        if (funcIx == 4 && args.length == 1) {
            return new ParseNode((Ptg)AttrPtg.getSumSingle(), args);
        }
        this.validateNumArgs(args.length, fm);
        AbstractFunctionPtg retval = isVarArgs ? new FuncVarPtg(name, (byte)numArgs) : new FuncPtg(funcIx);
        return new ParseNode((Ptg)retval, args);
    }

    private void validateNumArgs(int numArgs, FunctionMetadata fm) {
        if (numArgs < fm.getMinParams()) {
            String msg = "Too few arguments to function '" + fm.getName() + "'. ";
            msg = fm.hasFixedArgsLength() ? msg + "Expected " + fm.getMinParams() : msg + "At least " + fm.getMinParams() + " were expected";
            msg = msg + " but got " + numArgs + ".";
            throw new FormulaParseException(msg);
        }
        int maxArgs = fm.hasUnlimitedVarags() ? (this._book != null ? this._book.getSpreadsheetVersion().getMaxFunctionArgs() : fm.getMaxParams()) : fm.getMaxParams();
        if (numArgs > maxArgs) {
            String msg = "Too many arguments to function '" + fm.getName() + "'. ";
            msg = fm.hasFixedArgsLength() ? msg + "Expected " + maxArgs : msg + "At most " + maxArgs + " were expected";
            msg = msg + " but got " + numArgs + ".";
            throw new FormulaParseException(msg);
        }
    }

    private static boolean isArgumentDelimiter(char ch) {
        return ch == ',' || ch == ')';
    }

    private ParseNode[] Arguments() {
        ArrayList<ParseNode> temp;
        block5: {
            temp = new ArrayList<ParseNode>(2);
            this.SkipWhite();
            if (this.look == ')') {
                return ParseNode.EMPTY_ARRAY;
            }
            boolean missedPrevArg = true;
            int numArgs = 0;
            while (true) {
                this.SkipWhite();
                if (FormulaParser.isArgumentDelimiter(this.look)) {
                    if (missedPrevArg) {
                        temp.add(new ParseNode(MissingArgPtg.instance));
                        ++numArgs;
                    }
                    if (this.look != ')') {
                        this.Match(',');
                        missedPrevArg = true;
                        continue;
                    }
                    break block5;
                }
                temp.add(this.comparisonExpression());
                ++numArgs;
                missedPrevArg = false;
                this.SkipWhite();
                if (!FormulaParser.isArgumentDelimiter(this.look)) break;
            }
            throw this.expected("',' or ')'");
        }
        ParseNode[] result = new ParseNode[temp.size()];
        temp.toArray(result);
        return result;
    }

    private ParseNode powerFactor() {
        ParseNode result = this.percentFactor();
        while (true) {
            this.SkipWhite();
            if (this.look != '^') {
                return result;
            }
            this.Match('^');
            ParseNode other = this.percentFactor();
            result = new ParseNode(PowerPtg.instance, result, other);
        }
    }

    private ParseNode percentFactor() {
        ParseNode result = this.parseSimpleFactor();
        while (true) {
            this.SkipWhite();
            if (this.look != '%') {
                return result;
            }
            this.Match('%');
            result = new ParseNode((Ptg)PercentPtg.instance, result);
        }
    }

    private ParseNode parseSimpleFactor() {
        this.SkipWhite();
        switch (this.look) {
            case '#': {
                return new ParseNode(ErrPtg.valueOf(this.parseErrorLiteral()));
            }
            case '-': {
                this.Match('-');
                return new ParseNode((Ptg)UnaryMinusPtg.instance, this.powerFactor());
            }
            case '+': {
                this.Match('+');
                return new ParseNode((Ptg)UnaryPlusPtg.instance, this.powerFactor());
            }
            case '(': {
                this.Match('(');
                ParseNode inside = this.comparisonExpression();
                this.Match(')');
                return new ParseNode((Ptg)ParenthesisPtg.instance, inside);
            }
            case '\"': {
                return new ParseNode(new StringPtg(this.parseStringLiteral()));
            }
            case '{': {
                this.Match('{');
                ParseNode arrayNode = this.parseArray();
                this.Match('}');
                return arrayNode;
            }
        }
        if (FormulaParser.IsAlpha(this.look) || Character.isDigit(this.look) || this.look == '\'' || this.look == '[') {
            return this.parseRangeExpression();
        }
        if (this.look == '.') {
            return new ParseNode(this.parseNumber());
        }
        throw this.expected("cell ref or constant literal");
    }

    private ParseNode parseArray() {
        ArrayList<Object[]> rowsData = new ArrayList<Object[]>();
        while (true) {
            Object[] singleRowData = this.parseArrayRow();
            rowsData.add(singleRowData);
            if (this.look == '}') break;
            if (this.look != ';') {
                throw this.expected("'}' or ';'");
            }
            this.Match(';');
        }
        int nRows = rowsData.size();
        Object[][] values2d = new Object[nRows][];
        rowsData.toArray((T[])values2d);
        int nColumns = values2d[0].length;
        this.checkRowLengths(values2d, nColumns);
        return new ParseNode(new ArrayPtg(values2d));
    }

    private void checkRowLengths(Object[][] values2d, int nColumns) {
        for (int i = 0; i < values2d.length; ++i) {
            int rowLen = values2d[i].length;
            if (rowLen == nColumns) continue;
            throw new FormulaParseException("Array row " + i + " has length " + rowLen + " but row 0 has length " + nColumns);
        }
    }

    private Object[] parseArrayRow() {
        ArrayList<Object> temp = new ArrayList<Object>();
        block4: while (true) {
            temp.add(this.parseArrayItem());
            this.SkipWhite();
            switch (this.look) {
                case ';': 
                case '}': {
                    break block4;
                }
                case ',': {
                    this.Match(',');
                    continue block4;
                }
                default: {
                    throw this.expected("'}' or ','");
                }
            }
            break;
        }
        Object[] result = new Object[temp.size()];
        temp.toArray(result);
        return result;
    }

    private Object parseArrayItem() {
        this.SkipWhite();
        switch (this.look) {
            case '\"': {
                return new UnicodeString(this.parseStringLiteral());
            }
            case '#': {
                return ErrorConstant.valueOf(this.parseErrorLiteral());
            }
            case 'F': 
            case 'T': 
            case 'f': 
            case 't': {
                return this.parseBooleanLiteral();
            }
        }
        return FormulaParser.convertArrayNumber(this.parseNumber());
    }

    private Boolean parseBooleanLiteral() {
        String iden = this.parseUnquotedIdentifier();
        if ("TRUE".equalsIgnoreCase(iden)) {
            return Boolean.TRUE;
        }
        if ("FALSE".equalsIgnoreCase(iden)) {
            return Boolean.FALSE;
        }
        throw this.expected("'TRUE' or 'FALSE'");
    }

    private static Double convertArrayNumber(Ptg ptg) {
        if (ptg instanceof IntPtg) {
            return new Double(((IntPtg)ptg).getValue());
        }
        if (ptg instanceof NumberPtg) {
            return new Double(((NumberPtg)ptg).getValue());
        }
        throw new RuntimeException("Unexpected ptg (" + ptg.getClass().getName() + ")");
    }

    private Ptg parseNumber() {
        String number2 = null;
        String exponent = null;
        String number1 = this.GetNum();
        if (this.look == '.') {
            this.GetChar();
            number2 = this.GetNum();
        }
        if (this.look == 'E') {
            this.GetChar();
            String sign = "";
            if (this.look == '+') {
                this.GetChar();
            } else if (this.look == '-') {
                this.GetChar();
                sign = "-";
            }
            String number = this.GetNum();
            if (number == null) {
                throw this.expected("Integer");
            }
            exponent = sign + number;
        }
        if (number1 == null && number2 == null) {
            throw this.expected("Integer");
        }
        return FormulaParser.getNumberPtgFromString(number1, number2, exponent);
    }

    private int parseErrorLiteral() {
        this.Match('#');
        String part1 = this.parseUnquotedIdentifier().toUpperCase();
        if (part1 == null) {
            throw this.expected("remainder of error constant literal");
        }
        switch (part1.charAt(0)) {
            case 'V': {
                if (part1.equals("VALUE")) {
                    this.Match('!');
                    return 15;
                }
                throw this.expected("#VALUE!");
            }
            case 'R': {
                if (part1.equals("REF")) {
                    this.Match('!');
                    return 23;
                }
                throw this.expected("#REF!");
            }
            case 'D': {
                if (part1.equals("DIV")) {
                    this.Match('/');
                    this.Match('0');
                    this.Match('!');
                    return 7;
                }
                throw this.expected("#DIV/0!");
            }
            case 'N': {
                if (part1.equals("NAME")) {
                    this.Match('?');
                    return 29;
                }
                if (part1.equals("NUM")) {
                    this.Match('!');
                    return 36;
                }
                if (part1.equals("NULL")) {
                    this.Match('!');
                    return 0;
                }
                if (part1.equals("N")) {
                    this.Match('/');
                    if (this.look != 'A' && this.look != 'a') {
                        throw this.expected("#N/A");
                    }
                    this.Match(this.look);
                    return 42;
                }
                throw this.expected("#NAME?, #NUM!, #NULL! or #N/A");
            }
        }
        throw this.expected("#VALUE!, #REF!, #DIV/0!, #NAME?, #NUM!, #NULL! or #N/A");
    }

    private String parseUnquotedIdentifier() {
        if (this.look == '\'') {
            throw this.expected("unquoted identifier");
        }
        StringBuilder sb = new StringBuilder();
        while (Character.isLetterOrDigit(this.look) || this.look == '.') {
            sb.append(this.look);
            this.GetChar();
        }
        if (sb.length() < 1) {
            return null;
        }
        return sb.toString();
    }

    private static Ptg getNumberPtgFromString(String number1, String number2, String exponent) {
        StringBuffer number = new StringBuffer();
        if (number2 == null) {
            int intVal;
            number.append(number1);
            if (exponent != null) {
                number.append('E');
                number.append(exponent);
            }
            String numberStr = number.toString();
            try {
                intVal = Integer.parseInt(numberStr);
            }
            catch (NumberFormatException e) {
                return new NumberPtg(numberStr);
            }
            if (IntPtg.isInRange(intVal)) {
                return new IntPtg(intVal);
            }
            return new NumberPtg(numberStr);
        }
        if (number1 != null) {
            number.append(number1);
        }
        number.append('.');
        number.append(number2);
        if (exponent != null) {
            number.append('E');
            number.append(exponent);
        }
        return new NumberPtg(number.toString());
    }

    private String parseStringLiteral() {
        this.Match('\"');
        StringBuffer token = new StringBuffer();
        while (true) {
            if (this.look == '\"') {
                this.GetChar();
                if (this.look != '\"') break;
            }
            token.append(this.look);
            this.GetChar();
        }
        return token.toString();
    }

    private ParseNode Term() {
        ParseNode result = this.powerFactor();
        while (true) {
            ValueOperatorPtg operator;
            this.SkipWhite();
            switch (this.look) {
                case '*': {
                    this.Match('*');
                    operator = MultiplyPtg.instance;
                    break;
                }
                case '/': {
                    this.Match('/');
                    operator = DividePtg.instance;
                    break;
                }
                default: {
                    return result;
                }
            }
            ParseNode other = this.powerFactor();
            result = new ParseNode(operator, result, other);
        }
    }

    private ParseNode unionExpression() {
        ParseNode result = this.comparisonExpression();
        boolean hasUnions = false;
        block3: while (true) {
            this.SkipWhite();
            switch (this.look) {
                case ',': {
                    this.GetChar();
                    hasUnions = true;
                    ParseNode other = this.comparisonExpression();
                    result = new ParseNode(UnionPtg.instance, result, other);
                    continue block3;
                }
            }
            break;
        }
        if (hasUnions) {
            return FormulaParser.augmentWithMemPtg(result);
        }
        return result;
    }

    private ParseNode comparisonExpression() {
        ParseNode result = this.concatExpression();
        block3: while (true) {
            this.SkipWhite();
            switch (this.look) {
                case '<': 
                case '=': 
                case '>': {
                    Ptg comparisonToken = this.getComparisonToken();
                    ParseNode other = this.concatExpression();
                    result = new ParseNode(comparisonToken, result, other);
                    continue block3;
                }
            }
            break;
        }
        return result;
    }

    private Ptg getComparisonToken() {
        if (this.look == '=') {
            this.Match(this.look);
            return EqualPtg.instance;
        }
        boolean isGreater = this.look == '>';
        this.Match(this.look);
        if (isGreater) {
            if (this.look == '=') {
                this.Match('=');
                return GreaterEqualPtg.instance;
            }
            return GreaterThanPtg.instance;
        }
        switch (this.look) {
            case '=': {
                this.Match('=');
                return LessEqualPtg.instance;
            }
            case '>': {
                this.Match('>');
                return NotEqualPtg.instance;
            }
        }
        return LessThanPtg.instance;
    }

    private ParseNode concatExpression() {
        ParseNode result = this.additiveExpression();
        while (true) {
            this.SkipWhite();
            if (this.look != '&') break;
            this.Match('&');
            ParseNode other = this.additiveExpression();
            result = new ParseNode(ConcatPtg.instance, result, other);
        }
        return result;
    }

    private ParseNode additiveExpression() {
        ParseNode result = this.Term();
        while (true) {
            ValueOperatorPtg operator;
            this.SkipWhite();
            switch (this.look) {
                case '+': {
                    this.Match('+');
                    operator = AddPtg.instance;
                    break;
                }
                case '-': {
                    this.Match('-');
                    operator = SubtractPtg.instance;
                    break;
                }
                default: {
                    return result;
                }
            }
            ParseNode other = this.Term();
            result = new ParseNode(operator, result, other);
        }
    }

    private void parse() {
        this._pointer = 0;
        this.GetChar();
        this._rootNode = this.unionExpression();
        if (this._pointer <= this._formulaLength) {
            String msg = "Unused input [" + this._formulaString.substring(this._pointer - 1) + "] after attempting to parse the formula [" + this._formulaString + "]";
            throw new FormulaParseException(msg);
        }
    }

    private Ptg[] getRPNPtg(int formulaType) {
        OperandClassTransformer oct = new OperandClassTransformer(formulaType);
        oct.transformFormula(this._rootNode);
        return ParseNode.toTokenArray(this._rootNode);
    }

    private static final class SimpleRangePart {
        private final Type _type;
        private final String _rep;

        public SimpleRangePart(String rep, boolean hasLetters, boolean hasNumbers) {
            this._rep = rep;
            this._type = Type.get(hasLetters, hasNumbers);
        }

        public boolean isCell() {
            return this._type == Type.CELL;
        }

        public boolean isRowOrColumn() {
            return this._type != Type.CELL;
        }

        public CellReference getCellReference() {
            if (this._type != Type.CELL) {
                throw new IllegalStateException("Not applicable to this type");
            }
            return new CellReference(this._rep);
        }

        public boolean isColumn() {
            return this._type == Type.COLUMN;
        }

        public boolean isRow() {
            return this._type == Type.ROW;
        }

        public String getRep() {
            return this._rep;
        }

        public boolean isCompatibleForArea(SimpleRangePart part2) {
            return this._type == part2._type;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(64);
            sb.append(this.getClass().getName()).append(" [");
            sb.append(this._rep);
            sb.append("]");
            return sb.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Type {
            CELL,
            ROW,
            COLUMN;


            public static Type get(boolean hasLetters, boolean hasDigits) {
                if (hasLetters) {
                    return hasDigits ? CELL : COLUMN;
                }
                if (!hasDigits) {
                    throw new IllegalArgumentException("must have either letters or numbers");
                }
                return ROW;
            }
        }
    }

    static final class FormulaParseException
    extends RuntimeException {
        public FormulaParseException(String msg) {
            super(msg);
        }
    }

    private static final class SheetIdentifier {
        private final String _bookName;
        private final Identifier _sheetIdentifier;

        public SheetIdentifier(String bookName, Identifier sheetIdentifier) {
            this._bookName = bookName;
            this._sheetIdentifier = sheetIdentifier;
        }

        public String getBookName() {
            return this._bookName;
        }

        public Identifier getSheetIdentifier() {
            return this._sheetIdentifier;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(64);
            sb.append(this.getClass().getName());
            sb.append(" [");
            if (this._bookName != null) {
                sb.append(" [").append(this._sheetIdentifier.getName()).append("]");
            }
            if (this._sheetIdentifier.isQuoted()) {
                sb.append("'").append(this._sheetIdentifier.getName()).append("'");
            } else {
                sb.append(this._sheetIdentifier.getName());
            }
            sb.append("]");
            return sb.toString();
        }
    }

    private static final class Identifier {
        private final String _name;
        private final boolean _isQuoted;

        public Identifier(String name, boolean isQuoted) {
            this._name = name;
            this._isQuoted = isQuoted;
        }

        public String getName() {
            return this._name;
        }

        public boolean isQuoted() {
            return this._isQuoted;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(64);
            sb.append(this.getClass().getName());
            sb.append(" [");
            if (this._isQuoted) {
                sb.append("'").append(this._name).append("'");
            } else {
                sb.append(this._name);
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

