/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.poi.ddf.EscherBSERecord;
import org.apache.poi.hssf.usermodel.HSSFAnchor;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFSimpleShape;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class HSSFPicture
extends HSSFSimpleShape
implements Picture {
    public static final int PICTURE_TYPE_EMF = 2;
    public static final int PICTURE_TYPE_WMF = 3;
    public static final int PICTURE_TYPE_PICT = 4;
    public static final int PICTURE_TYPE_JPEG = 5;
    public static final int PICTURE_TYPE_PNG = 6;
    public static final int PICTURE_TYPE_DIB = 7;
    private static final float PX_DEFAULT = 32.0f;
    private static final float PX_MODIFIED = 36.56f;
    private static final int PX_ROW = 15;
    private int _pictureIndex;
    HSSFPatriarch _patriarch;
    private static final POILogger log = POILogFactory.getLogger(HSSFPicture.class);

    HSSFPicture(HSSFShape parent, HSSFAnchor anchor) {
        super(parent, anchor);
        this.setShapeType(8);
    }

    public int getPictureIndex() {
        return this._pictureIndex;
    }

    public void setPictureIndex(int pictureIndex) {
        this._pictureIndex = pictureIndex;
    }

    public void resize(double scale) {
        HSSFClientAnchor anchor = (HSSFClientAnchor)this.getAnchor();
        anchor.setAnchorType(2);
        HSSFClientAnchor pref = this.getPreferredSize(scale);
        int row2 = anchor.getRow1() + (pref.getRow2() - pref.getRow1());
        int col2 = anchor.getCol1() + (pref.getCol2() - pref.getCol1());
        anchor.setCol2((short)col2);
        anchor.setDx1(0);
        anchor.setDx2(pref.getDx2());
        anchor.setRow2(row2);
        anchor.setDy1(0);
        anchor.setDy2(pref.getDy2());
    }

    public void resize() {
        this.resize(1.0);
    }

    public HSSFClientAnchor getPreferredSize() {
        return this.getPreferredSize(1.0);
    }

    public HSSFClientAnchor getPreferredSize(double scale) {
        HSSFClientAnchor anchor = (HSSFClientAnchor)this.getAnchor();
        Dimension size = this.getImageDimension();
        double scaledWidth = size.getWidth() * scale;
        double scaledHeight = size.getHeight() * scale;
        float w = 0.0f;
        w += this.getColumnWidthInPixels(anchor.col1) * (1.0f - (float)anchor.dx1 / 1024.0f);
        short col2 = (short)(anchor.col1 + 1);
        int dx2 = 0;
        while ((double)w < scaledWidth) {
            short s = col2;
            col2 = (short)(col2 + 1);
            w += this.getColumnWidthInPixels(s);
        }
        if ((double)w > scaledWidth) {
            col2 = (short)(col2 - 1);
            double cw = this.getColumnWidthInPixels(col2);
            double delta = (double)w - scaledWidth;
            dx2 = (int)((cw - delta) / cw * 1024.0);
        }
        anchor.col2 = col2;
        anchor.dx2 = dx2;
        float h = 0.0f;
        h += (1.0f - (float)anchor.dy1 / 256.0f) * this.getRowHeightInPixels(anchor.row1);
        int row2 = anchor.row1 + 1;
        int dy2 = 0;
        while ((double)h < scaledHeight) {
            h += this.getRowHeightInPixels(row2++);
        }
        if ((double)h > scaledHeight) {
            double ch = this.getRowHeightInPixels(--row2);
            double delta = (double)h - scaledHeight;
            dy2 = (int)((ch - delta) / ch * 256.0);
        }
        anchor.row2 = row2;
        anchor.dy2 = dy2;
        return anchor;
    }

    private float getColumnWidthInPixels(int column) {
        int cw = this._patriarch._sheet.getColumnWidth(column);
        float px = this.getPixelWidth(column);
        return (float)cw / px;
    }

    private float getRowHeightInPixels(int i) {
        HSSFRow row = this._patriarch._sheet.getRow(i);
        float height = row != null ? (float)row.getHeight() : (float)this._patriarch._sheet.getDefaultRowHeight();
        return height / 15.0f;
    }

    private float getPixelWidth(int column) {
        int def = this._patriarch._sheet.getDefaultColumnWidth() * 256;
        int cw = this._patriarch._sheet.getColumnWidth(column);
        return cw == def ? 32.0f : 36.56f;
    }

    protected int[] getResolution(ImageReader r) throws IOException {
        int hdpi = 96;
        int vdpi = 96;
        double mm2inch = 25.4;
        Element node = (Element)r.getImageMetadata(0).getAsTree("javax_imageio_1.0");
        NodeList lst = node.getElementsByTagName("HorizontalPixelSize");
        if (lst != null && lst.getLength() == 1) {
            hdpi = (int)(mm2inch / (double)Float.parseFloat(((Element)lst.item(0)).getAttribute("value")));
        }
        if ((lst = node.getElementsByTagName("VerticalPixelSize")) != null && lst.getLength() == 1) {
            vdpi = (int)(mm2inch / (double)Float.parseFloat(((Element)lst.item(0)).getAttribute("value")));
        }
        return new int[]{hdpi, vdpi};
    }

    public Dimension getImageDimension() {
        EscherBSERecord bse = this._patriarch._sheet._book.getBSERecord(this._pictureIndex);
        byte[] data = bse.getBlipRecord().getPicturedata();
        byte type = bse.getBlipTypeWin32();
        Dimension size = new Dimension();
        switch (type) {
            case 5: 
            case 6: 
            case 7: {
                try {
                    ImageInputStream iis = ImageIO.createImageInputStream(new ByteArrayInputStream(data));
                    Iterator<ImageReader> i = ImageIO.getImageReaders(iis);
                    ImageReader r = i.next();
                    r.setInput(iis);
                    BufferedImage img = r.read(0);
                    int[] dpi = this.getResolution(r);
                    if (dpi[0] == 0) {
                        dpi[0] = 96;
                    }
                    if (dpi[1] == 0) {
                        dpi[1] = 96;
                    }
                    size.width = img.getWidth() * 96 / dpi[0];
                    size.height = img.getHeight() * 96 / dpi[1];
                    break;
                }
                catch (IOException e) {
                    log.log(5, e);
                }
            }
        }
        return size;
    }
}

