/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.MissingArgEval;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.OperandResolver;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.Function;

public final class Time
implements Function {
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int HOURS_PER_DAY = 24;
    private static final int SECONDS_PER_DAY = 86400;

    public Eval evaluate(Eval[] args, int srcCellRow, short srcCellCol) {
        double result;
        if (args.length != 3) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            result = Time.evaluate(Time.evalArg(args[0]), Time.evalArg(args[1]), Time.evalArg(args[2]));
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        return new NumberEval(result);
    }

    private static int evalArg(Eval arg) throws EvaluationException {
        if (arg == MissingArgEval.instance) {
            return 0;
        }
        return OperandResolver.coerceValueToInt((ValueEval)arg);
    }

    private static double evaluate(int hours, int minutes, int seconds) throws EvaluationException {
        if (hours > Short.MAX_VALUE || minutes > Short.MAX_VALUE || seconds > Short.MAX_VALUE) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        int totalSeconds = hours * 3600 + minutes * 60 + seconds;
        if (totalSeconds < 0) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        return (double)(totalSeconds % 86400) / 86400.0;
    }
}

