/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.reports.tag;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;
import org.bbreak.excella.reports.model.ParamInfo;
import org.bbreak.excella.reports.model.ParsedReportInfo;
import org.bbreak.excella.reports.processor.ReportsParserInfo;
import org.bbreak.excella.reports.tag.ReportsTagParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleParamParser
extends ReportsTagParser<Object> {
    private static Log log = LogFactory.getLog(SingleParamParser.class);
    public static final String DEFAULT_TAG = "$";
    public static final String PARAM_VALUE = "";

    public SingleParamParser() {
        super(DEFAULT_TAG);
    }

    public SingleParamParser(String tag) {
        super(tag);
    }

    @Override
    public ParsedReportInfo parse(Sheet sheet, Cell tagCell, Object data) throws ParseException {
        Map paramDef = TagUtil.getParams((String)tagCell.getStringCellValue());
        this.checkParam(paramDef, tagCell);
        ReportsParserInfo reportsParserInfo = (ReportsParserInfo)data;
        ParamInfo paramInfo = reportsParserInfo.getParamInfo();
        Object paramValue = null;
        if (paramInfo != null) {
            String replaceParam = (String)paramDef.get(PARAM_VALUE);
            paramValue = this.getParamData(paramInfo, replaceParam);
            if (log.isDebugEnabled()) {
                Workbook workbook = sheet.getWorkbook();
                String sheetName = workbook.getSheetName(workbook.getSheetIndex(sheet));
                log.debug((Object)("[\u30b7\u30fc\u30c8\u540d=" + sheetName + ",\u30bb\u30eb=(" + tagCell.getRowIndex() + "," + tagCell.getColumnIndex() + ")]  " + tagCell.getStringCellValue() + " \u21d2 " + paramValue));
            }
            PoiUtil.setCellValue((Cell)tagCell, paramValue);
        }
        ParsedReportInfo parsedReportInfo = new ParsedReportInfo();
        parsedReportInfo.setParsedObject(paramValue);
        parsedReportInfo.setDefaultRowIndex(tagCell.getRowIndex());
        parsedReportInfo.setDefaultColumnIndex(tagCell.getColumnIndex());
        parsedReportInfo.setRowIndex(tagCell.getRowIndex());
        parsedReportInfo.setColumnIndex(tagCell.getColumnIndex());
        return parsedReportInfo;
    }

    private void checkParam(Map<String, String> paramDef, Cell tagCell) throws ParseException {
    }

    @Override
    public boolean useControlRow() {
        return false;
    }
}

