/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.core.tag.excel2java;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapsParser
extends TagParser<List<Map<?, ?>>> {
    protected static final String PARAM_KEY_ROW = "KeyRow";
    protected static final String PARAM_DATA_ROW_FROM = "DataRowFrom";
    protected static final String PARAM_DATA_ROW_TO = "DataRowTo";
    protected static final int DEFAULT_KEY_ROW_ADJUST = 1;
    protected static final int DEFAULT_VALUE_ROW_FROM_ADJUST = 2;

    public MapsParser(String tag) {
        super(tag);
    }

    @Override
    public List<Map<?, ?>> parse(Sheet sheet, Cell tagCell, Object data) throws ParseException {
        int keyRowIdx;
        ArrayList resultList = new ArrayList();
        int tagRowIdx = tagCell.getRowIndex();
        int valueRowToIdx = sheet.getLastRowNum();
        try {
            Map<String, String> paramDef = TagUtil.getParams(tagCell.getStringCellValue());
            keyRowIdx = TagUtil.adjustValue(tagRowIdx, paramDef, PARAM_KEY_ROW, 1);
            if (keyRowIdx < 0 || keyRowIdx > sheet.getLastRowNum()) {
                throw new ParseException(tagCell);
            }
            int valueRowFromIdx = TagUtil.adjustValue(tagRowIdx, paramDef, PARAM_DATA_ROW_FROM, 2);
            if (valueRowFromIdx < 0 || valueRowFromIdx > sheet.getLastRowNum()) {
                throw new ParseException(tagCell);
            }
            if ((valueRowToIdx = TagUtil.adjustValue(tagRowIdx, paramDef, PARAM_DATA_ROW_TO, valueRowToIdx - tagRowIdx)) < valueRowFromIdx || valueRowToIdx > sheet.getLastRowNum() || valueRowToIdx < 0) {
                throw new ParseException(tagCell);
            }
        }
        catch (Exception e) {
            throw new ParseException(tagCell, (Throwable)e);
        }
        ArrayList<Integer> targetColNums = new ArrayList<Integer>();
        Row keyRow = sheet.getRow(keyRowIdx);
        if (keyRow == null) {
            return resultList;
        }
        int firstCellNum = keyRow.getFirstCellNum();
        short lastCellNum = keyRow.getLastCellNum();
        for (int cellCnt = firstCellNum; cellCnt < lastCellNum; ++cellCnt) {
            String keyName;
            Cell cell = keyRow.getCell(cellCnt);
            Object cellValue = PoiUtil.getCellValue(cell);
            if (cellValue instanceof String && (keyName = (String)cellValue).startsWith("-") || cellValue == null) continue;
            targetColNums.add(cellCnt);
        }
        if (targetColNums.size() > 0) {
            for (int rowCnt = valueRowFromIdx; rowCnt <= valueRowToIdx; ++rowCnt) {
                Row dataRow = sheet.getRow(rowCnt);
                if (dataRow == null) continue;
                LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
                for (Integer colCnt : targetColNums) {
                    Cell keyCell = keyRow.getCell(colCnt.intValue());
                    Cell valueCell = dataRow.getCell(colCnt.intValue());
                    Object key = PoiUtil.getCellValue(keyCell);
                    Object value = PoiUtil.getCellValue(valueCell);
                    map.put(key, value);
                }
                resultList.add(map);
            }
        }
        return resultList;
    }
}

