/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.emulator.commands;

import java.io.PrintStream;
import java.util.TimerTask;
import ow.tool.emulator.EmulatorContext;
import ow.tool.emulator.EmulatorMode;
import ow.tool.emulator.EmulatorTask;
import ow.tool.emulator.SchedulableCommand;
import ow.tool.emulator.action.ControlTask;
import ow.tool.util.shellframework.ShellContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractControlCommand
implements SchedulableCommand<EmulatorContext> {
    @Override
    public boolean execute(ShellContext<EmulatorContext> context) throws Exception {
        EmulatorContext cxt = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        EmulatorTask task = this.getEmulatorTask(context);
        if (task == null) {
            out.println("Usage: " + this.getHelp());
            return !context.isInteractive();
        }
        if (cxt.getEmulatorMode() != EmulatorMode.WORKER && cxt.getVerboseInParsing()) {
            out.print("control " + args[0] + ":");
            for (int i = 1; i < args.length; ++i) {
                out.print(" " + args[i]);
            }
            out.println();
            out.flush();
        }
        ((TimerTask)task).run();
        return false;
    }

    protected abstract boolean executedConcurrently();

    @Override
    public EmulatorTask getEmulatorTask(ShellContext<EmulatorContext> context) throws Exception {
        EmulatorContext cxt = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        if (args.length < 2) {
            return null;
        }
        int id = args[0].toLowerCase().equals("all") ? -1 : Integer.parseInt(args[0]);
        StringBuilder sb = new StringBuilder();
        sb.append(args[1]);
        for (int i = 2; i < args.length; ++i) {
            sb.append(" ");
            sb.append(args[i]);
        }
        String command = sb.toString();
        return new ControlTask(cxt, id, out, command, this.executedConcurrently());
    }
}

