/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.dhtshell.commands;

import java.io.PrintStream;
import java.net.UnknownHostException;
import ow.dht.DHT;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClearCommand
implements Command<DHT<String>> {
    private static final String[] NAMES = new String[]{"clear"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "clear {routingtable,dht}";
    }

    private void usage(PrintStream out) {
        out.print("usage: " + this.getHelp() + "\r\n");
        out.flush();
    }

    @Override
    public boolean execute(ShellContext<DHT<String>> context) throws UnknownHostException {
        DHT<String> dht = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        if (args.length < 1) {
            this.usage(out);
            return false;
        }
        char firstChar = args[0].charAt(0);
        switch (firstChar) {
            case 'r': {
                dht.clearRoutingTable();
                out.print("routing table cleared.\r\n");
                break;
            }
            case 'd': {
                dht.clearDHTState();
                out.print("DHT states (key-value pairs) cleared.\r\n");
                break;
            }
            default: {
                this.usage(out);
            }
        }
        return false;
    }
}

