/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.chord;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.util.logging.Level;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.messaging.Tag;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingException;
import ow.routing.RoutingHop;
import ow.routing.RoutingResult;
import ow.routing.RoutingService;
import ow.routing.chord.AbstractChord;
import ow.routing.chord.ChordConfiguration;
import ow.util.Timer;

public final class Chord
extends AbstractChord {
    private ChordConfiguration config;
    private FingerTableFixer fingerTableFixer;
    private Thread fingerTableFixerThread = null;

    protected Chord(RoutingAlgorithmConfiguration config, RoutingService routingSvc) throws InvalidAlgorithmParameterException {
        super(config, routingSvc);
        try {
            this.config = (ChordConfiguration)config;
        }
        catch (ClassCastException e) {
            throw new InvalidAlgorithmParameterException("The given config is not ChordConfiguration.");
        }
    }

    private synchronized void startFingerTableFixer() {
        if (!this.config.getDoFixFingers()) {
            return;
        }
        if (this.fingerTableFixer != null) {
            return;
        }
        this.fingerTableFixer = new FingerTableFixer();
        if (this.config.getUseTimerInsteadOfThread()) {
            timer.schedule(this.fingerTableFixer, timer.currentTimeMillis(), true, true);
        } else if (this.fingerTableFixerThread == null) {
            this.fingerTableFixerThread = new Thread(this.fingerTableFixer);
            this.fingerTableFixerThread.setName("FingerTableFixer on " + this.selfIDAddress.getAddress());
            this.fingerTableFixerThread.setDaemon(true);
            this.fingerTableFixerThread.start();
        }
    }

    private synchronized void stopFingerTableFixer() {
        if (this.fingerTableFixerThread != null) {
            this.fingerTableFixerThread.interrupt();
            this.fingerTableFixerThread = null;
        }
    }

    public synchronized void stop() {
        logger.log(Level.INFO, "Chord#stop() called.");
        super.stop();
        this.stopFingerTableFixer();
    }

    public synchronized void suspend() {
        super.suspend();
        this.stopFingerTableFixer();
    }

    public synchronized void resume() {
        super.resume();
        this.startFingerTableFixer();
    }

    public void prepareHandlers() {
        super.prepareHandlers(true);
        ReqConnectMessageHandler handler = new ReqConnectMessageHandler();
        this.runtime.addMessageHandler(Tag.REQ_CONNECT.getNumber(), handler);
    }

    private final class FingerTableFixer
    implements Runnable {
        public static final boolean OPTIMIZE = false;

        private FingerTableFixer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block13: {
                boolean updated = true;
                try {
                    if (!Chord.this.config.getUseTimerInsteadOfThread()) {
                        Thread.sleep(Chord.this.config.getFixFingersInitialInterval());
                    }
                    do {
                        BigInteger fingerEdgeDistance;
                        Chord chord = Chord.this;
                        synchronized (chord) {
                            if (Chord.this.stopped || Chord.this.suspended) {
                                Chord.this.fingerTableFixer = null;
                                Chord.this.fingerTableFixerThread = null;
                                break block13;
                            }
                        }
                        if (random.nextDouble() < Chord.this.config.getProbProportionalToIDSpace()) {
                            fingerEdgeDistance = new BigInteger(Chord.this.idSizeInBit - 1, random);
                        } else {
                            int i = random.nextInt(Chord.this.idSizeInBit - 1) + 2;
                            fingerEdgeDistance = BigInteger.ONE.shiftLeft(i - 1);
                        }
                        BigInteger fingerStartBigInteger = Chord.this.selfIDAddress.getID().toBigInteger().add(fingerEdgeDistance);
                        ID fingerEdge = ID.getID(fingerStartBigInteger, Chord.this.config.getIDSizeInByte());
                        try {
                            RoutingResult res = Chord.this.runtime.routeToRootNode(fingerEdge, 1);
                            RoutingHop[] route = res.getRoute();
                            IDAddressPair rootNode = route[route.length - 1].getIDAddressPair();
                            for (int i = route.length - 1; i > 0; --i) {
                                IDAddressPair node = route[i].getIDAddressPair();
                                if (Chord.this.selfIDAddress.getID().equals(node.getID())) continue;
                                updated |= Chord.this.fingerTable.put(node);
                                Chord.this.successorList.add(node);
                            }
                            if (!updated) continue;
                            logger.log(Level.INFO, "An entry incorporated to finger table: " + rootNode);
                        }
                        catch (RoutingException e) {
                            logger.log(Level.WARNING, "Routing failed.", e);
                        }
                    } while (!this.sleep());
                    return;
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "FingerTableFixer interrupted and die.", e);
                }
            }
        }

        private boolean sleep() throws InterruptedException {
            long interval = Chord.this.config.getFixFingersMinInterval();
            long minInterval = Chord.this.config.getFixFingersMinInterval();
            long maxInterval = Chord.this.config.getFixFingersMaxInterval();
            int numFingers = Chord.this.fingerTable.numOfDifferentEntries();
            double ratio = Math.log(numFingers + 1) / Math.log(Chord.this.idSizeInBit + 1);
            interval = minInterval + (long)((double)(maxInterval - minInterval) * ratio);
            double playRatio = Chord.this.config.getFixFingersIntervalPlayRatio();
            double intervalRatio = 1.0 - playRatio + playRatio * 2.0 * random.nextDouble();
            long sleepPeriod = (long)((double)interval * intervalRatio);
            if (Chord.this.config.getUseTimerInsteadOfThread()) {
                timer.schedule(this, Timer.currentTimeMillis() + sleepPeriod, true, true);
                return true;
            }
            Thread.sleep(sleepPeriod);
            return false;
        }
    }

    class ReqConnectMessageHandler
    extends AbstractChord.ReqConnectMessageHandler {
        ReqConnectMessageHandler() {
        }
    }
}

