/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.address;

import java.io.UnsupportedEncodingException;

public class RFC2396UrlDecoder {
    public static String decode(String uri) {
        StringBuffer translatedUri = new StringBuffer(uri.length());
        byte[] encodedchars = new byte[uri.length() / 3];
        int i = 0;
        int length = uri.length();
        int encodedcharsLength = 0;
        while (i < length) {
            if (uri.charAt(i) == '%') {
                while (i < length && uri.charAt(i) == '%') {
                    if (i + 2 < length) {
                        try {
                            byte x;
                            encodedchars[encodedcharsLength] = x = (byte)Integer.parseInt(uri.substring(i + 1, i + 3), 16);
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("Illegal hex characters in pattern %" + uri.substring(i + 1, i + 3));
                        }
                        ++encodedcharsLength;
                        i += 3;
                        continue;
                    }
                    throw new IllegalArgumentException("% character should be followed by 2 hexadecimal characters.");
                }
                try {
                    String translatedPart = new String(encodedchars, 0, encodedcharsLength, "UTF-8");
                    translatedUri.append(translatedPart);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Problem in decodePath: UTF-8 encoding not supported.");
                }
                encodedcharsLength = 0;
                continue;
            }
            translatedUri.append(uri.charAt(i));
            ++i;
        }
        return translatedUri.toString();
    }
}

