/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import gov.nist.core.Debug;
import gov.nist.core.StringTokenizer;
import gov.nist.core.Token;
import java.text.ParseException;
import java.util.Hashtable;

public class LexerCore
extends StringTokenizer {
    public static final int START = 2048;
    public static final int END = 4096;
    public static final int ID = 4095;
    public static final int SAFE = 4094;
    public static final int WHITESPACE = 4097;
    public static final int DIGIT = 4098;
    public static final int ALPHA = 4099;
    public static final int BACKSLASH = 92;
    public static final int QUOTE = 39;
    public static final int AT = 64;
    public static final int SP = 32;
    public static final int HT = 9;
    public static final int COLON = 58;
    public static final int STAR = 42;
    public static final int DOLLAR = 36;
    public static final int PLUS = 43;
    public static final int POUND = 35;
    public static final int MINUS = 45;
    public static final int DOUBLEQUOTE = 34;
    public static final int TILDE = 126;
    public static final int BACK_QUOTE = 96;
    public static final int NULL = 0;
    public static final int EQUALS = 61;
    public static final int SEMICOLON = 59;
    public static final int SLASH = 47;
    public static final int L_SQUARE_BRACKET = 91;
    public static final int R_SQUARE_BRACKET = 93;
    public static final int R_CURLY = 125;
    public static final int L_CURLY = 123;
    public static final int HAT = 94;
    public static final int BAR = 124;
    public static final int DOT = 46;
    public static final int EXCLAMATION = 33;
    public static final int LPAREN = 40;
    public static final int RPAREN = 41;
    public static final int GREATER_THAN = 62;
    public static final int LESS_THAN = 60;
    public static final int PERCENT = 37;
    public static final int QUESTION = 63;
    public static final int AND = 38;
    public static final int UNDERSCORE = 95;
    protected static final Hashtable globalSymbolTable = new Hashtable();
    protected static final Hashtable lexerTables = new Hashtable();
    protected Hashtable currentLexer;
    protected String currentLexerName;
    protected Token currentMatch;
    static final char ALPHA_VALID_CHARS = '\uffff';
    static final char DIGIT_VALID_CHARS = '\ufffe';
    static final char ALPHADIGIT_VALID_CHARS = '\ufffd';

    protected void addKeyword(String name, int value) {
        Integer val = new Integer(value);
        this.currentLexer.put(name, val);
        if (!globalSymbolTable.containsKey(val)) {
            globalSymbolTable.put(val, name);
        }
    }

    public String lookupToken(int value) {
        if (value > 2048) {
            return (String)globalSymbolTable.get(new Integer(value));
        }
        Character ch = new Character((char)value);
        return ch.toString();
    }

    protected Hashtable addLexer(String lexerName) {
        this.currentLexer = (Hashtable)lexerTables.get(lexerName);
        if (this.currentLexer == null) {
            this.currentLexer = new Hashtable();
            lexerTables.put(lexerName, this.currentLexer);
        }
        return this.currentLexer;
    }

    public void selectLexer(String lexerName) {
        this.currentLexerName = lexerName;
    }

    protected LexerCore() {
        this.currentLexer = new Hashtable();
        this.currentLexerName = "charLexer";
    }

    public LexerCore(String lexerName, String buffer) {
        super(buffer);
        this.currentLexerName = lexerName;
    }

    public String peekNextId() {
        int oldPtr = this.ptr;
        String retval = this.ttoken();
        this.savedPtr = this.ptr;
        this.ptr = oldPtr;
        return retval;
    }

    public String getNextId() {
        return this.ttoken();
    }

    public Token getNextToken() {
        return this.currentMatch;
    }

    public Token peekNextToken() throws ParseException {
        return this.peekNextToken(1)[0];
    }

    public Token[] peekNextToken(int ntokens) throws ParseException {
        int old = this.ptr;
        Token[] retval = new Token[ntokens];
        for (int i = 0; i < ntokens; ++i) {
            Token tok = new Token();
            if (this.startsId()) {
                String id;
                tok.tokenValue = id = this.ttoken();
                String idUppercase = id.toUpperCase();
                if (this.currentLexer.containsKey(idUppercase)) {
                    Integer type = (Integer)this.currentLexer.get(idUppercase);
                    tok.tokenType = type;
                } else {
                    tok.tokenType = 4095;
                }
            } else {
                char nextChar = this.getNextChar();
                tok.tokenValue = String.valueOf(nextChar);
                tok.tokenType = LexerCore.isAlpha(nextChar) ? 4099 : (LexerCore.isDigit(nextChar) ? 4098 : (int)nextChar);
            }
            retval[i] = tok;
        }
        this.savedPtr = this.ptr;
        this.ptr = old;
        return retval;
    }

    public Token match(int tok) throws ParseException {
        if (Debug.parserDebug) {
            Debug.println("match " + tok);
        }
        if (tok > 2048 && tok < 4096) {
            if (tok == 4095) {
                if (!this.startsId()) {
                    throw new ParseException(this.buffer + "\nID expected", this.ptr);
                }
                String id = this.getNextId();
                this.currentMatch = new Token();
                this.currentMatch.tokenValue = id;
                this.currentMatch.tokenType = 4095;
            } else if (tok == 4094) {
                if (!this.startsSafeToken()) {
                    throw new ParseException(this.buffer + "\nID expected", this.ptr);
                }
                String id = this.ttokenSafe();
                this.currentMatch = new Token();
                this.currentMatch.tokenValue = id;
                this.currentMatch.tokenType = 4094;
            } else {
                String nexttok = this.getNextId();
                Integer cur = (Integer)this.currentLexer.get(nexttok.toUpperCase());
                if (cur == null || cur != tok) {
                    throw new ParseException(this.buffer + "\nUnexpected Token : " + nexttok, this.ptr);
                }
                this.currentMatch = new Token();
                this.currentMatch.tokenValue = nexttok;
                this.currentMatch.tokenType = tok;
            }
        } else if (tok > 4096) {
            char next = this.lookAhead(0);
            if (tok == 4098) {
                if (!LexerCore.isDigit(next)) {
                    throw new ParseException(this.buffer + "\nExpecting DIGIT", this.ptr);
                }
                this.currentMatch = new Token();
                this.currentMatch.tokenValue = String.valueOf(next);
                this.currentMatch.tokenType = tok;
                this.consume(1);
            } else if (tok == 4099) {
                if (!LexerCore.isAlpha(next)) {
                    throw new ParseException(this.buffer + "\nExpecting ALPHA", this.ptr);
                }
                this.currentMatch = new Token();
                this.currentMatch.tokenValue = String.valueOf(next);
                this.currentMatch.tokenType = tok;
                this.consume(1);
            }
        } else {
            char ch = (char)tok;
            char next = this.lookAhead(0);
            if (next == ch) {
                this.consume(1);
            } else {
                throw new ParseException(this.buffer + "\nExpecting  >>>" + ch + "<<< got >>>" + next + "<<<", this.ptr);
            }
        }
        return this.currentMatch;
    }

    public void SPorHT() {
        try {
            char c = this.lookAhead(0);
            while (c == ' ' || c == '\t') {
                this.consume(1);
                c = this.lookAhead(0);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public static final boolean isTokenChar(char c) {
        if (LexerCore.isAlphaDigit(c)) {
            return true;
        }
        switch (c) {
            case '!': 
            case '%': 
            case '\'': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '_': 
            case '`': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    public boolean startsId() {
        try {
            char nextChar = this.lookAhead(0);
            return LexerCore.isTokenChar(nextChar);
        }
        catch (ParseException ex) {
            return false;
        }
    }

    public boolean startsSafeToken() {
        try {
            char nextChar = this.lookAhead(0);
            if (LexerCore.isAlphaDigit(nextChar)) {
                return true;
            }
            switch (nextChar) {
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '%': 
                case '\'': 
                case '*': 
                case '+': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '=': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '_': 
                case '`': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    return true;
                }
            }
            return false;
        }
        catch (ParseException ex) {
            return false;
        }
    }

    public String ttoken() {
        int startIdx = this.ptr;
        try {
            char nextChar;
            while (this.hasMoreChars() && LexerCore.isTokenChar(nextChar = this.lookAhead(0))) {
                this.consume(1);
            }
            return this.buffer.substring(startIdx, this.ptr);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public String ttokenSafe() {
        int startIdx = this.ptr;
        try {
            while (this.hasMoreChars()) {
                char nextChar = this.lookAhead(0);
                if (LexerCore.isAlphaDigit(nextChar)) {
                    this.consume(1);
                    continue;
                }
                boolean isValidChar = false;
                switch (nextChar) {
                    case '!': 
                    case '\"': 
                    case '#': 
                    case '$': 
                    case '%': 
                    case '\'': 
                    case '*': 
                    case '+': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case ':': 
                    case ';': 
                    case '?': 
                    case '@': 
                    case '[': 
                    case ']': 
                    case '^': 
                    case '_': 
                    case '`': 
                    case '{': 
                    case '|': 
                    case '}': 
                    case '~': {
                        isValidChar = true;
                    }
                }
                if (!isValidChar) break;
                this.consume(1);
            }
            return this.buffer.substring(startIdx, this.ptr);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public void consumeValidChars(char[] validChars) {
        int validCharsLength = validChars.length;
        try {
            while (this.hasMoreChars()) {
                char nextChar = this.lookAhead(0);
                boolean isValid = false;
                for (int i = 0; i < validCharsLength; ++i) {
                    char validChar = validChars[i];
                    switch (validChar) {
                        case '\uffff': {
                            isValid = LexerCore.isAlpha(nextChar);
                            break;
                        }
                        case '\ufffe': {
                            isValid = LexerCore.isDigit(nextChar);
                            break;
                        }
                        case '\ufffd': {
                            isValid = LexerCore.isAlphaDigit(nextChar);
                            break;
                        }
                        default: {
                            boolean bl = isValid = nextChar == validChar;
                        }
                    }
                    if (isValid) break;
                }
                if (isValid) {
                    this.consume(1);
                    continue;
                }
                break;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public String quotedString() throws ParseException {
        char next;
        int startIdx = this.ptr + 1;
        if (this.lookAhead(0) != '\"') {
            return null;
        }
        this.consume(1);
        while ((next = this.getNextChar()) != '\"') {
            if (next == '\u0000') {
                throw new ParseException(this.buffer + " :unexpected EOL", this.ptr);
            }
            if (next != '\\') continue;
            this.consume(1);
        }
        return this.buffer.substring(startIdx, this.ptr - 1);
    }

    public String comment() throws ParseException {
        char next;
        StringBuffer retval = new StringBuffer();
        if (this.lookAhead(0) != '(') {
            return null;
        }
        this.consume(1);
        while ((next = this.getNextChar()) != ')') {
            if (next == '\u0000') {
                throw new ParseException(this.buffer + " :unexpected EOL", this.ptr);
            }
            if (next == '\\') {
                retval.append(next);
                next = this.getNextChar();
                if (next == '\u0000') {
                    throw new ParseException(this.buffer + " : unexpected EOL", this.ptr);
                }
                retval.append(next);
                continue;
            }
            retval.append(next);
        }
        return retval.toString();
    }

    public String byteStringNoSemicolon() {
        StringBuffer retval = new StringBuffer();
        try {
            char next;
            while ((next = this.lookAhead(0)) != '\u0000' && next != '\n' && next != ';' && next != ',') {
                this.consume(1);
                retval.append(next);
            }
        }
        catch (ParseException ex) {
            return retval.toString();
        }
        return retval.toString();
    }

    public String byteStringNoSlash() {
        StringBuffer retval = new StringBuffer();
        try {
            char next;
            while ((next = this.lookAhead(0)) != '\u0000' && next != '\n' && next != '/') {
                this.consume(1);
                retval.append(next);
            }
        }
        catch (ParseException ex) {
            return retval.toString();
        }
        return retval.toString();
    }

    public String byteStringNoComma() {
        StringBuffer retval = new StringBuffer();
        try {
            char next;
            while ((next = this.lookAhead(0)) != '\n' && next != ',') {
                this.consume(1);
                retval.append(next);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return retval.toString();
    }

    public static String charAsString(char ch) {
        return String.valueOf(ch);
    }

    public String charAsString(int nchars) {
        return this.buffer.substring(this.ptr, this.ptr + nchars);
    }

    public String number() throws ParseException {
        int startIdx = this.ptr;
        try {
            char next;
            if (!LexerCore.isDigit(this.lookAhead(0))) {
                throw new ParseException(this.buffer + ": Unexpected token at " + this.lookAhead(0), this.ptr);
            }
            this.consume(1);
            while (LexerCore.isDigit(next = this.lookAhead(0))) {
                this.consume(1);
            }
            return this.buffer.substring(startIdx, this.ptr);
        }
        catch (ParseException ex) {
            return this.buffer.substring(startIdx, this.ptr);
        }
    }

    public int markInputPosition() {
        return this.ptr;
    }

    public void rewindInputPosition(int position) {
        this.ptr = position;
    }

    public String getRest() {
        if (this.ptr >= this.buffer.length()) {
            return null;
        }
        return this.buffer.substring(this.ptr);
    }

    public String getString(char c) throws ParseException {
        StringBuffer retval = new StringBuffer();
        while (true) {
            char next;
            if ((next = this.lookAhead(0)) == '\u0000') {
                throw new ParseException(this.buffer + "unexpected EOL", this.ptr);
            }
            if (next == c) break;
            if (next == '\\') {
                this.consume(1);
                char nextchar = this.lookAhead(0);
                if (nextchar == '\u0000') {
                    throw new ParseException(this.buffer + "unexpected EOL", this.ptr);
                }
                this.consume(1);
                retval.append(nextchar);
                continue;
            }
            this.consume(1);
            retval.append(next);
        }
        this.consume(1);
        return retval.toString();
    }

    public int getPtr() {
        return this.ptr;
    }

    public String getBuffer() {
        return this.buffer;
    }

    public ParseException createParseException() {
        return new ParseException(this.buffer, this.ptr);
    }
}

