/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.sip;

import javax.sip.RequestEvent;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.header.FromHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import javax.xml.parsers.ParserConfigurationException;
import jp.ac.naka.ec.entity.AbstractEntity;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityContainerImpl;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityImpl;
import jp.ac.naka.ec.entity.EntityInformation;
import jp.ac.naka.ec.entity.EntityInformationParser;
import jp.ac.naka.ec.sip.MethodDelegate;
import jp.ac.naka.ec.sip.SipCore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

class NotifyDelegate
implements MethodDelegate {
    private static Log logger = LogFactory.getLog(NotifyDelegate.class);
    private EntityInformationParser parser = EntityInformationParser.getInstance();
    private static SipCore core;
    private static EntityContainer container;

    public NotifyDelegate() throws ParserConfigurationException, SAXException {
        core = SipCore.getInstance();
        container = EntityContainerImpl.getInstance();
    }

    public boolean forward(RequestEvent evt) {
        Address addr;
        byte[] content;
        Request req;
        block7: {
            logger.info((Object)("Notify Request from " + evt.getRequest().getRequestURI().toString()));
            req = evt.getRequest();
            content = req.getRawContent();
            try {
                FromHeader from = (FromHeader)req.getHeader("From");
                addr = from.getAddress();
                if (content != null) break block7;
                core.sendResponse(200, evt, addr.getURI().toString());
                return false;
            }
            catch (Exception e) {
                logger.warn((Object)"Error occures while processing PIDF :", (Throwable)e);
                return false;
            }
        }
        EntityInformation data = this.parser.parse(content);
        if (data != null) {
            EntityImpl source = new EntityImpl(data);
            ToHeader to = (ToHeader)req.getHeader("To");
            SipURI toUri = (SipURI)to.getAddress().getURI();
            Entity target = container.getEntity(toUri.toString());
            if (target == null) {
                throw new NullPointerException(toUri + " is null!");
            }
            EntityEvent e = new EntityEvent("", target, source, EntityEvent.EventType.NOTIFY);
            if (target instanceof AbstractEntity) {
                ((AbstractEntity)target).handleEvent(e);
            } else {
                target.receiveNotify(e);
            }
        }
        core.sendResponse(200, evt, addr.getURI().toString());
        return true;
    }
}

