/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.entity;

import java.util.EventObject;
import javax.sdp.SessionDescription;
import javax.sip.message.Request;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityListener;

public class EntityEvent
extends EventObject {
    private static final long serialVersionUID = -5024101656766992758L;
    private EntityListener target;
    private String message;
    private SessionDescription sdp;
    private Request request;
    private EventType type;
    private int statusCode;

    public EntityEvent(EntityListener target, Entity source, EventType type) {
        this("", target, source, type);
    }

    public EntityEvent(String message, EntityListener target, Entity source, EventType type) {
        super(source);
        this.message = message;
        this.target = target;
        this.type = type;
    }

    public EntityEvent(String message, EntityListener target, Entity source) {
        super(source);
        this.message = message;
        this.target = target;
        this.type = EventType.MESSAGE;
    }

    public EntityEvent(SessionDescription sdp, EntityListener target, Entity source) {
        this("", target, source);
        this.type = EventType.OFFER;
        this.sdp = sdp;
    }

    public EntityEvent(SessionDescription sdp2, Entity source) {
        super(source);
        this.sdp = sdp2;
        this.type = EventType.ANSWER;
    }

    public EntityListener getTarget() {
        return this.target;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public SessionDescription getSessionDescription() {
        return this.sdp;
    }

    public EventType getEventType() {
        return this.type;
    }

    public void setEventType(EventType type) {
        this.type = type;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request req) {
        this.request = req;
    }

    public String toString() {
        return "Target :" + this.target + ", Type :" + this.type.toString();
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        MESSAGE,
        LOCATION,
        INIT,
        REGISTER,
        OFFER,
        ADD,
        ANSWER,
        IMAGE,
        BYE,
        SUBSCRIBE,
        NOTIFY,
        ACK,
        REMOVE,
        ERROR;

    }
}

