﻿using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.GameData.Expression;

namespace MinorShift.Emuera.Sub
{
	/// <summary>
	/// 字句解析結果の保存場所。Listとその現在位置を結びつけるためのもの。
	/// 基本的に全てpublicで
	/// </summary>
	internal sealed class WordCollection
	{
		public List<Word> Collection = new List<Word>();
		public int Pointer = 0;
		private static Word nullToken = new NullWord();
		public void Add(Word token)
		{
			Collection.Add(token);
		}
		public void Add(WordCollection wc)
		{
			Collection.AddRange(wc.Collection);
		}

		public void Clear()
		{
			Collection.Clear();
		}

		public void ShiftNext() { Pointer++; }
		public Word Current
		{
			get
			{
				if (Pointer >= Collection.Count)
					return nullToken;
				return Collection[Pointer]; 
			} 
		}
		public bool EOL { get { return Pointer >= Collection.Count; } }

		public void InsertRange(WordCollection wc)
		{
			Collection.InsertRange(Pointer, wc.Collection);
		}
		public void Remove()
		{
			Collection.RemoveAt(Pointer);
		}
		
		public void SetIsMacro()
		{
			foreach(Word word in Collection)
			{
				word.SetIsMacro();
			}
		}
		
		public WordCollection ReplaceMacroToTerm(IOperandTerm[] terms)
		{//termsの全ての要素が非nullであること
			WordCollection wc = new WordCollection();
			wc.Add(this);
			int macroLength = terms.Length;
			int collectionCount = Collection.Count;
			for(int i = 0;i < collectionCount; i++)
			{
				MacroWord word = Collection[i] as MacroWord;
				if(word != null)
				{
					wc.Collection.RemoveAt(i);
					wc.Collection.Insert(i, new TermWord(terms[word.Number]));
					continue;
				}
				StrFormWord strform = Collection[i] as StrFormWord;
				if(strform != null)
				{
					wc.Collection.RemoveAt(i);
					wc.Collection.Insert(i, replaceStrFormMacroToTerm(strform, terms));
				}
			}
			return wc;
		}
		
		//本当はdefineマクロで@""とか使わないで欲しいんだが
		private StrFormWord replaceStrFormMacroToTerm(StrFormWord strform, IOperandTerm[] terms)
		{
			int subwordsLength = strform.SubWords.Length;
			string[] strs = strform.Strs;
			SubWord[] newSubwords = new SubWord[subwordsLength];
			for(int i = 0; i < subwordsLength; i++)
			{
				SubWord subword = strform.SubWords[i];
				if(subword is CurlyBraceSubWord)
					newSubwords[i] = new CurlyBraceSubWord(subword.Words.ReplaceMacroToTerm(terms));
				else if(subword is PercentSubWord)
					newSubwords[i] = new PercentSubWord(subword.Words.ReplaceMacroToTerm(terms));
				else if(subword is YenAtSubWord)
				{
					YenAtSubWord yenat = (YenAtSubWord)subword;
					WordCollection wc = yenat.Words.ReplaceMacroToTerm(terms);
					StrFormWord left = replaceStrFormMacroToTerm(yenat.Left, terms);
					StrFormWord right = replaceStrFormMacroToTerm(yenat.Right, terms);
					newSubwords[i] = new YenAtSubWord(wc, left, right);
				}
				else
					newSubwords[i] = subword;
			}
			return new StrFormWord(strs, newSubwords);
		}
		
		
		public WordCollection ReplaceIdentifierToMacro(List<string> macroIDs)
		{
			WordCollection wc = new WordCollection();
			wc.Add(this);
			int collectionCount = Collection.Count;
			int macroLength = macroIDs.Count;
			for(int j = 0;j < collectionCount; j++)
			{
				IdentifierWord word = Collection[j] as IdentifierWord;
				if(word != null)
				{
					for(int i = 0; i < macroLength; i++)
					{
						if(!string.Equals(word.Code, macroIDs[i], Config.SCVariable))
							continue;
						wc.Collection.RemoveAt(j);
						wc.Collection.Insert(j, new MacroWord(i));
					}
					continue;
				}
				StrFormWord strform = Collection[j] as StrFormWord;
				if(strform != null)
				{
					wc.Collection.RemoveAt(j);
					wc.Collection.Insert(j, replaceStrFormIDToMacro(strform, macroIDs));
				}
			}
			return wc;
		}

		private StrFormWord replaceStrFormIDToMacro(StrFormWord strform, List<string> macroIDs)
		{
			int subwordsLength = strform.SubWords.Length;
			string[] strs = strform.Strs;
			SubWord[] newSubwords = new SubWord[subwordsLength];
			for(int i = 0; i < subwordsLength; i++)
			{
				SubWord subword = strform.SubWords[i];
				if(subword is CurlyBraceSubWord)
					newSubwords[i] = new CurlyBraceSubWord(subword.Words.ReplaceIdentifierToMacro(macroIDs));
				else if(subword is PercentSubWord)
					newSubwords[i] = new PercentSubWord(subword.Words.ReplaceIdentifierToMacro(macroIDs));
				else if(subword is YenAtSubWord)
				{
					YenAtSubWord yenat = (YenAtSubWord)subword;
					WordCollection wc = yenat.Words.ReplaceIdentifierToMacro(macroIDs);
					StrFormWord left = replaceStrFormIDToMacro(yenat.Left, macroIDs);
					StrFormWord right = replaceStrFormIDToMacro(yenat.Right, macroIDs);
					newSubwords[i] = new YenAtSubWord(wc, left, right);
				}
				else
					newSubwords[i] = subword;
			}
			return new StrFormWord(strs, newSubwords);
		}
		
		
		
	}
}
















