﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameView;
using MinorShift.Emuera.GameData.Variable;

namespace MinorShift.Emuera.GameData
{
	//難読化用属性。enum.ToString()やenum.Parse()を行うなら(Exclude=true)にすること。
	[global::System.Reflection.Obfuscation(Exclude=false)]
    internal enum CharacterStrData
    {
        NAME = 0,
        CALLNAME = 1,
        NICKNAME = 2,
        MASTERNAME = 3,
        CSTR = 4,
    }

	//難読化用属性。enum.ToString()やenum.Parse()を行うなら(Exclude=true)にすること。
	[global::System.Reflection.Obfuscation(Exclude=false)]
    internal enum CharacterIntData
    {
        BASE = 0,
        ABL = 1,
        TALENT = 2,
        MARK = 3,
        EXP = 4,
        RELATION = 5,
        CFLAG = 6,
        EQUIP = 7,
        JUEL = 8,
    }
    
    internal sealed class ConstantData
	{
		public static int MaxAbl { get; private set; }
		public static int MaxTalent { get; private set; }
		public static int MaxExp { get; private set; }
		public static int MaxMark { get; private set; }
		public static int MaxTrain { get; private set; }
		public static int MaxParam { get; private set; }
		public static int MaxItem { get; private set; }
		public static int MaxBasedata { get; private set; }
		public static int MaxSource { get; private set; }
		public static int MaxEx { get; private set; }
		public static int MaxEquip { get; private set; }
		public static int MaxTequip { get; private set; }
		public static int MaxFlag { get; private set; }
		public static int MaxTFlag { get; private set; }
		public static int MaxCFlag { get; private set; }
        public static int MaxTCVar { get; private set; }
        public static int MaxCStr { get; private set; }

		public static int MaxStr { get; private set; }

		static ConstantData()
		{
			MaxAbl = 100;
			MaxTalent = 1000;
			MaxExp = 100;
			MaxMark = 100;
			MaxTrain = 1000;
			MaxParam = 200;
			MaxItem = 1000;
			MaxBasedata = 100;
			MaxSource = 1000;
			MaxEx = 100;
			MaxEquip = 100;
			MaxTequip = 100;
			MaxFlag = 10000;
			MaxTFlag = 1000;
			MaxCFlag = 1000;
            MaxTCVar = 100;
            MaxCStr = 100;

			MaxStr = 20000;
			
		}

		public int[] VariableIntArrayLength;
		public int[] VariableStrArrayLength;
		public int[] CharacterIntArrayLength;
		public int[] CharacterStrArrayLength;
		public Int64[] VariableIntArray2DLength;
		public Int64[] VariableStrArray2DLength;
        public Int64[] VariableIntArray3DLength;
        public Int64[] VariableStrArray3DLength;

		private void setArray()
		{
			AblName = new string[MaxAbl];
			BaseName = new string[MaxBasedata];
			TalentName = new string[MaxTalent];
			ExpName = new string[MaxExp];
			ParamName = new string[MaxParam];
			TrainName = new string[MaxTrain];
			MarkName = new string[MaxMark];
			SourceName = new string[MaxSource];
			ExName = new string[MaxEx];
			EquipName = new string[MaxEquip];
			TequipName = new string[MaxTequip];
			FlagName = new string[MaxFlag];
			TFlagName = new string[MaxTFlag];
			CFlagName = new string[MaxCFlag];
            TCVarName = new string[MaxTCVar];
            CStrName = new string[MaxCStr];

			ItemName = new string[MaxItem];
			ItemPrice = new Int64[MaxItem];

			Str = new string[MaxStr];
		}

		public ConstantData(GameBase gamebase)
		{
			this.gamebase = gamebase;
			setDefaultArrayLength();

			CharacterTmplList = new List<CharacterTemplate>();
			useCompatiName = Config.CompatiCALLNAME;
			for (int i = 0; i < nameToIntDics.Length; i++)
			{
				nameToIntDics[i] = new Dictionary<string, int>();
			}
		}

        readonly bool useCompatiName;

		private void setDefaultArrayLength()
		{

			VariableIntArrayLength = new int[(int)VariableCode.__COUNT_INTEGER_ARRAY__];
			VariableStrArrayLength = new int[(int)VariableCode.__COUNT_STRING_ARRAY__];
			CharacterIntArrayLength = new int[(int)VariableCode.__COUNT_CHARACTER_INTEGER_ARRAY__];
			CharacterStrArrayLength = new int[(int)VariableCode.__COUNT_CHARACTER_STRING_ARRAY__];
			VariableIntArray2DLength = new Int64[(int)VariableCode.__COUNT_INTEGER_ARRAY_2D__];
			VariableStrArray2DLength = new Int64[(int)VariableCode.__COUNT_STRING_ARRAY_2D__];
            VariableIntArray3DLength = new Int64[(int)VariableCode.__COUNT_INTEGER_ARRAY_3D__];
            VariableStrArray3DLength = new Int64[(int)VariableCode.__COUNT_STRING_ARRAY_3D__];
            for (int i = 0; i < VariableIntArrayLength.Length; i++)
				VariableIntArrayLength[i] = 1000;
			VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.FLAG)] = 10000;
			VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.ITEMPRICE)] = ConstantData.MaxItem;

			VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.RANDDATA)] = 625;
			
			for (int i = 0; i < VariableStrArrayLength.Length; i++)
				VariableStrArrayLength[i] = 100;
			VariableStrArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.STR)] = ConstantData.MaxStr;

			for (int i = 0; i < CharacterIntArrayLength.Length; i++)
				CharacterIntArrayLength[i] = 100;
			CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TALENT)] = 1000;
			CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.CFLAG)] = 1000;
			CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.JUEL)] = 200;
			CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.GOTJUEL)] = 200;

			for (int i = 0; i < CharacterStrArrayLength.Length; i++)
				CharacterStrArrayLength[i] = 100;

			for (int i = 0; i < VariableIntArray2DLength.Length; i++)
				VariableIntArray2DLength[i] = (100L << 32) + 100L;
			for (int i = 0; i < VariableStrArray2DLength.Length; i++)
				VariableStrArray2DLength[i] = (100L << 32) + 100L;

            for (int i = 0; i < VariableIntArray3DLength.Length; i++)
                VariableIntArray3DLength[i] = (100L << 32) + (100L << 16) + 100L;
            for (int i = 0; i < VariableStrArray3DLength.Length; i++)
                VariableStrArray3DLength[i] = (100L << 32) + (100L << 16) + 100L;
        }

        private void loadVariableSizeData(string csvPath, bool disp)
		{
			if (!File.Exists(csvPath))
				return;
			EraStreamReader eReader = new EraStreamReader();
			if (!eReader.Open(csvPath))
			{
                output.PrintError(eReader.Filename + "のオープンに失敗しました");
				return;
			}
			ScriptPosition position = null;
			if (disp)
				output.PrintLine(eReader.Filename + "読み込み中・・・");
			try
			{
				StringStream st = null;
				while ((st = eReader.ReadEnabledLine()) != null)
				{
					position = new ScriptPosition(eReader.Filename, eReader.LineNo, st.RowString);
					changeVariableSizeData(st.Substring(), position);
				}
			}
			catch
			{
                System.Media.SystemSounds.Hand.Play();
                if (position != null)
					ParserMediator.Warn("予期しないエラーが発生しました", position, 3);
				else
                    output.PrintError("予期しないエラーが発生しました");
				return;
			}
			finally
			{
				eReader.Close();
			}
            decideActualArraySize(position);
		}

        List<VariableCode> changedCode = new List<VariableCode>();

		private void changeVariableSizeData(string line, ScriptPosition position)
		{
			string[] tokens = line.Split(',');
			if (tokens.Length < 2)
			{
				ParserMediator.Warn("\",\"が必要です", position, 1);
				return;
			}
			string idtoken = tokens[0].Trim();
			VariableIdentifier id = VariableIdentifier.GetVariableId(idtoken);
			if (id == null)
			{
				ParserMediator.Warn("一つ目の値を変数名として認識できません", position, 1);
				return;
			}
			if ((!id.IsArray1D) && (!id.IsArray2D) && (!id.IsArray3D))
			{
				ParserMediator.Warn("配列変数でない変数" + id.ToString() + "のサイズを変更できません", position, 1);
				return;
			}
			int length = 0;
			int length2 = 0;
            int length3 = 0;
			if (!int.TryParse(tokens[1], out length))
			{
				ParserMediator.Warn("二つ目の値を整数値として認識できません", position, 1);
				return;
			}
            //__CALC__は弾かないと変更できないエラーが表示できない
			if(id.IsArray1D && !id.IsCalc)
			{
				if (id.IsLocal && length < 1)
				{
					ParserMediator.Warn("ローカル変数のサイズを1未満には出来ません", position, 1);
					return;
				}
				else if (!id.IsLocal && length < 100)
				{
					ParserMediator.Warn("ローカル変数でない一次元配列のサイズを100未満には出来ません", position, 1);
					return;
				}
			}
			if (id.IsArray2D)
			{
				if (tokens.Length < 3)
				{
					ParserMediator.Warn("二次元配列のサイズ指定には2つの数値が必要です", position, 1);
					return;
				}
				if (!int.TryParse(tokens[2], out length2))
				{
					ParserMediator.Warn("三つ目の値を整数値として認識できません", position, 1);
					return;
				}
				if ((length < 1) || (length2 < 1))
				{
					ParserMediator.Warn("配列サイズを1未満には出来ません", position, 1);
					return;
				}
			}
            if (id.IsArray3D)
            {
                if (tokens.Length < 4)
                {
                    ParserMediator.Warn("三次元配列のサイズ指定には3つの数値が必要です", position, 1);
                    return;
                }
                if (!int.TryParse(tokens[2], out length2))
                {
                    ParserMediator.Warn("三つ目の値を整数値として認識できません", position, 1);
                    return;
                }
                if (!int.TryParse(tokens[3], out length3))
                {
                    ParserMediator.Warn("四つ目の値を整数値として認識できません", position, 1);
                    return;
                }
				if ((length < 1) || (length2 < 1) || (length3 < 1))
				{
                    ParserMediator.Warn("配列サイズを1未満には出来ません", position, 1);
                    return;
                }
                if (length * length2 * length3 > 1000000)
                {
                    ParserMediator.Warn("三次元配列の要素数は最大で100万個までです", position, 1);
                    return;
                }
            }
            switch (id.Code)
            {
                //1753a PALAMだけ仕様が違うのはかえって問題なので、変数と要素文字列配列数の同期は全部バックアウト
                //基本的には旧来の処理に戻しただけ
                case VariableCode.ITEMNAME:
                case VariableCode.ITEMPRICE:
                    VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.ITEMPRICE)] = length;
                    ConstantData.MaxItem = length; break;
                case VariableCode.ABLNAME:
                    ConstantData.MaxAbl = length; break;
                case VariableCode.TALENTNAME:
                    ConstantData.MaxTalent = length; break;
                case VariableCode.EXPNAME:
                    ConstantData.MaxExp = length; break;
                case VariableCode.MARKNAME:
                    ConstantData.MaxMark = length; break;
                case VariableCode.PALAMNAME:
                    ConstantData.MaxParam = length; break;
                case VariableCode.TRAINNAME:
                    ConstantData.MaxTrain = length; break;
                case VariableCode.BASENAME:
                    ConstantData.MaxBasedata = length; break;
                case VariableCode.SOURCENAME:
                    ConstantData.MaxSource = length; break;
                case VariableCode.EXNAME:
                    ConstantData.MaxEx = length; break;
                case VariableCode.EQUIPNAME:
                    ConstantData.MaxEquip = length; break;
                case VariableCode.TEQUIPNAME:
                    ConstantData.MaxTequip = length; break;
                case VariableCode.FLAGNAME:
                    ConstantData.MaxFlag = length; break;
                case VariableCode.TFLAGNAME:
                    ConstantData.MaxTFlag = length; break;
                case VariableCode.CFLAGNAME:
                    ConstantData.MaxCFlag = length; break;
                case VariableCode.STR:
                    VariableStrArrayLength[id.CodeInt] = length;
                    ConstantData.MaxStr = length; break;
                case VariableCode.TCVARNAME:
                    ConstantData.MaxTCVar = length; break;
                case VariableCode.CSTRNAME:
                    ConstantData.MaxCStr = length; break;
                default:
                    {
                        if ((id.IsCalc) || (id.Code == VariableCode.RANDDATA))
                        {
                            ParserMediator.Warn(id.ToString() + "のサイズは変更できません", position, 1);
                        }
                        else if (id.IsArray2D)
                        {
                            Int64 length64 = (((Int64)length) << 32) + ((Int64)length2);
                            if (id.IsInteger)
                                VariableIntArray2DLength[id.CodeInt] = length64;
                            else if (id.IsString)
                                VariableStrArray2DLength[id.CodeInt] = length64;
                        }
                        else if (id.IsArray3D)
                        {
                            Int64 length3d = ((Int64)length << 32) + ((Int64)length2 << 16) + (Int64)length3;
                            if (id.IsInteger)
                                VariableIntArray3DLength[id.CodeInt] = length3d;
                            else
                                VariableStrArray3DLength[id.CodeInt] = length3d;
                        }
                        else if (id.IsCharacterData)
                        {
                            if (id.IsInteger)
                                CharacterIntArrayLength[id.CodeInt] = length;
                            else if (id.IsString)
                                CharacterStrArrayLength[id.CodeInt] = length;
                        }
                        else
                        {
                            if (id.IsInteger)
                                VariableIntArrayLength[id.CodeInt] = length;
                            else if (id.IsString)
                                VariableStrArrayLength[id.CodeInt] = length;
                        }
                    }
                    break;
            }
            changedCode.Add(id.Code);
		}

        private void decideActualArraySize(ScriptPosition position)
        {
            //ABL
            if (changedCode.Contains(VariableCode.ABLNAME) && changedCode.Contains(VariableCode.ABL))
            {
                if (MaxAbl > CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.ABL)])
                    CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.ABL)] = MaxAbl;
                else if (MaxAbl < CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.ABL)])
                    MaxAbl = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.ABL)];
            }
            else if (changedCode.Contains(VariableCode.ABLNAME) && !changedCode.Contains(VariableCode.ABL))
                CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.ABL)] = MaxAbl;
            else if (!changedCode.Contains(VariableCode.ABLNAME) && changedCode.Contains(VariableCode.ABL))
                MaxAbl = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.ABL)];
            //TALENT
            if (changedCode.Contains(VariableCode.TALENTNAME) && changedCode.Contains(VariableCode.TALENT))
            {
                if (MaxTalent > CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TALENT)])
                    CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TALENT)] = MaxTalent;
                else if (MaxTalent < CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TALENT)])
                    MaxTalent = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TALENT)];
            }
            else if (changedCode.Contains(VariableCode.TALENTNAME) && !changedCode.Contains(VariableCode.TALENT))
                CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TALENT)] = MaxTalent;
            else if (!changedCode.Contains(VariableCode.TALENTNAME) && changedCode.Contains(VariableCode.TALENT))
                MaxTalent = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TALENT)];
            //EXP
            if (changedCode.Contains(VariableCode.EXPNAME) && changedCode.Contains(VariableCode.EXP))
            {
                if (MaxExp > CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EXP)])
                    CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EXP)] = MaxExp;
                else if (MaxExp < CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EXP)])
                    MaxExp = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EXP)];
            }
            else if (changedCode.Contains(VariableCode.EXPNAME) && !changedCode.Contains(VariableCode.EXP))
                CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EXP)] = MaxExp;
            else if (!changedCode.Contains(VariableCode.EXPNAME) && changedCode.Contains(VariableCode.EXP))
                MaxExp = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EXP)];
            //MARK
            if (changedCode.Contains(VariableCode.MARKNAME) && changedCode.Contains(VariableCode.MARK))
            {
                if (MaxMark > CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.MARK)])
                    CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.MARK)] = MaxMark;
                else if (MaxMark < CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.MARK)])
                    MaxMark = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.MARK)];
            }
            else if (changedCode.Contains(VariableCode.MARKNAME) && !changedCode.Contains(VariableCode.MARK))
                CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.MARK)] = MaxMark;
            else if (!changedCode.Contains(VariableCode.MARKNAME) && changedCode.Contains(VariableCode.MARK))
                MaxMark = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.MARK)];
            //PALAM(JUEL込み)
            //PALAMかJUELが変わっていれば、そのうち大きい方にPALAMNAMEをあわせる
            if (changedCode.Contains(VariableCode.PALAM) || changedCode.Contains(VariableCode.JUEL))
                MaxParam = Math.Max(CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.PALAM)], CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.JUEL)]);
            //PALAMとJUEL不変でPALAMNAMEが変わっている場合
            else if (changedCode.Contains(VariableCode.PALAMNAME))
            {
                //PALAMを想定のPALAMNAMEにあわせる
                if (!changedCode.Contains(VariableCode.PALAM))
                    CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.PALAM)] = MaxParam;
                //想定のPALAMNAMEがJUELより小さければ警告出してJUELにあわせる
                if (MaxParam < CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.JUEL)])
                {
                    ParserMediator.Warn("PALAMNAMEの要素数がJUELより少なくなっています", position, 1);
                    MaxParam = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.JUEL)];
                }
            }
            //BASE
            if (changedCode.Contains(VariableCode.BASENAME) && changedCode.Contains(VariableCode.BASE))
            {
                if (MaxBasedata > CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.BASE)])
                    CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.BASE)] = MaxBasedata;
                else if (MaxBasedata < CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.BASE)])
                    MaxBasedata = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.BASE)];
            }
            else if (changedCode.Contains(VariableCode.BASENAME) && !changedCode.Contains(VariableCode.BASE))
                CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.BASE)] = MaxBasedata;
            else if (!changedCode.Contains(VariableCode.BASENAME) && changedCode.Contains(VariableCode.BASE))
                MaxBasedata = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.BASE)];
            //SOURCE
            if (changedCode.Contains(VariableCode.SOURCENAME) && changedCode.Contains(VariableCode.SOURCE))
            {
                if (MaxSource > CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.SOURCE)])
                    CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.SOURCE)] = MaxSource;
                else if (MaxSource < CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.SOURCE)])
                    MaxSource = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.SOURCE)];
            }
            else if (changedCode.Contains(VariableCode.SOURCENAME) && !changedCode.Contains(VariableCode.SOURCE))
                CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.SOURCE)] = MaxSource;
            else if (!changedCode.Contains(VariableCode.SOURCENAME) && changedCode.Contains(VariableCode.SOURCE))
                MaxSource = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.SOURCE)];
            //EX
            if (changedCode.Contains(VariableCode.EXNAME) && changedCode.Contains(VariableCode.EX))
            {
                if (MaxEx > CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EX)])
                    CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EX)] = MaxEx;
                else if (MaxEx < CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EX)])
                    MaxEx = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EX)];
            }
            else if (changedCode.Contains(VariableCode.EXNAME) && !changedCode.Contains(VariableCode.EX))
                CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EX)] = MaxEx;
            else if (!changedCode.Contains(VariableCode.EXNAME) && changedCode.Contains(VariableCode.EX))
                MaxEx = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EX)];
            //EQUIP
            if (changedCode.Contains(VariableCode.EQUIPNAME) && changedCode.Contains(VariableCode.EQUIP))
            {
                if (MaxEquip > CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EQUIP)])
                    CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EQUIP)] = MaxEquip;
                else if (MaxEquip < CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EQUIP)])
                    MaxEquip = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EQUIP)];
            }
            else if (changedCode.Contains(VariableCode.EQUIPNAME) && !changedCode.Contains(VariableCode.EQUIP))
                CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EQUIP)] = MaxEquip;
            else if (!changedCode.Contains(VariableCode.EQUIPNAME) && changedCode.Contains(VariableCode.EQUIP))
                MaxEquip = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EQUIP)];
            //TEQUIP
            if (changedCode.Contains(VariableCode.TEQUIPNAME) && changedCode.Contains(VariableCode.TEQUIP))
            {
                if (MaxTequip > CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TEQUIP)])
                    CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TEQUIP)] = MaxTequip;
                else if (MaxTequip < CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TEQUIP)])
                    MaxTequip = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TEQUIP)];
            }
            else if (changedCode.Contains(VariableCode.TEQUIPNAME) && !changedCode.Contains(VariableCode.TEQUIP))
                CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TEQUIP)] = MaxTequip;
            else if (!changedCode.Contains(VariableCode.TEQUIPNAME) && changedCode.Contains(VariableCode.TEQUIP))
                MaxTequip = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TEQUIP)];
            //FLAG
            if (changedCode.Contains(VariableCode.FLAGNAME) && changedCode.Contains(VariableCode.FLAG))
            {
                if (MaxFlag > VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.FLAG)])
                    VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.FLAG)] = MaxFlag;
                else if (MaxFlag < VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.FLAG)])
                    MaxFlag = VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.FLAG)];
            }
            else if (changedCode.Contains(VariableCode.FLAGNAME) && !changedCode.Contains(VariableCode.FLAG))
                VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.FLAG)] = MaxFlag;
            else if (!changedCode.Contains(VariableCode.FLAGNAME) && changedCode.Contains(VariableCode.FLAG))
                MaxFlag = VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.FLAG)];
            //TFLAG
            if (changedCode.Contains(VariableCode.TFLAGNAME) && changedCode.Contains(VariableCode.TFLAG))
            {
                if (MaxTFlag > VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TFLAG)])
                    VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TFLAG)] = MaxTFlag;
                else if (MaxTFlag < VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TFLAG)])
                    MaxTFlag = VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TFLAG)];
            }
            else if (changedCode.Contains(VariableCode.TFLAGNAME) && !changedCode.Contains(VariableCode.TFLAG))
                VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TFLAG)] = MaxTFlag;
            else if (!changedCode.Contains(VariableCode.TFLAGNAME) && changedCode.Contains(VariableCode.TFLAG))
                MaxTFlag = VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TFLAG)];
            //CFLAG
            if (changedCode.Contains(VariableCode.CFLAGNAME) && changedCode.Contains(VariableCode.CFLAG))
            {
                if (MaxCFlag > CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.CFLAG)])
                    CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.CFLAG)] = MaxCFlag;
                else if (MaxCFlag < CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.CFLAG)])
                    MaxCFlag = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.CFLAG)];
            }
            else if (changedCode.Contains(VariableCode.CFLAGNAME) && !changedCode.Contains(VariableCode.CFLAG))
                CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.CFLAG)] = MaxCFlag;
            else if (!changedCode.Contains(VariableCode.CFLAGNAME) && changedCode.Contains(VariableCode.CFLAG))
                MaxCFlag = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.CFLAG)];
            //TCVAR
            if (changedCode.Contains(VariableCode.TCVARNAME) && changedCode.Contains(VariableCode.TCVAR))
            {
                if (MaxTCVar > CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TCVAR)])
                    CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TCVAR)] = MaxTCVar;
                else if (MaxTCVar < CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TCVAR)])
                    MaxTCVar = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TCVAR)];
            }
            else if (changedCode.Contains(VariableCode.TCVARNAME) && !changedCode.Contains(VariableCode.TCVAR))
                CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TCVAR)] = MaxTCVar;
            else if (!changedCode.Contains(VariableCode.TCVARNAME) && changedCode.Contains(VariableCode.TCVAR))
                MaxTCVar = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TCVAR)];
            //CSTR
            if (changedCode.Contains(VariableCode.CSTRNAME) && changedCode.Contains(VariableCode.CSTR))
            {
                if (MaxCStr > CharacterStrArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.CSTR)])
                    CharacterStrArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.CSTR)] = MaxCStr;
                else if (MaxCStr < CharacterStrArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.CSTR)])
                    MaxCStr = CharacterStrArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.CSTR)];
            }
            else if (changedCode.Contains(VariableCode.CSTRNAME) && !changedCode.Contains(VariableCode.CSTR))
                CharacterStrArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.CSTR)] = MaxCStr;
            else if (!changedCode.Contains(VariableCode.CSTRNAME) && changedCode.Contains(VariableCode.CSTR))
                MaxCStr = CharacterStrArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.CSTR)];
            //もう使わないのでデータ破棄
            changedCode.Clear();
        }

		private readonly GameBase gamebase;
		private string[][] names = new string[18][];
		private Dictionary<string, int>[] nameToIntDics = new Dictionary<string, int>[18];
		private Dictionary<string, int> relationDic = new Dictionary<string, int>();
		//追加変更する際はGetKeywordDictionary()も変更が必要
		public string[] AblName { get { return names[0]; } private set { names[0] = value; } }
		public string[] ExpName { get { return names[1]; } private set { names[1] = value; } }
		public string[] TalentName { get { return names[2]; } private set { names[2] = value; } }
		public string[] ParamName { get { return names[3]; } private set { names[3] = value; } }
		public string[] TrainName { get { return names[4]; } private set { names[4] = value; } }
		public string[] MarkName { get { return names[5]; } private set { names[5] = value; } }
		public string[] ItemName { get { return names[6]; } private set { names[6] = value; } }
		public string[] BaseName { get { return names[7]; } private set { names[7] = value; } }
		public string[] SourceName { get { return names[8]; } private set { names[8] = value; } }
		public string[] ExName { get { return names[9]; } private set { names[9] = value; } }
		public string[] Str { get { return names[10]; } private set { names[10] = value; } }
		public string[] EquipName { get { return names[11]; } private set { names[11] = value; } }
		public string[] TequipName { get { return names[12]; } private set { names[12] = value; } }
		public string[] FlagName { get { return names[13]; } private set { names[13] = value; } }
		public string[] TFlagName { get { return names[14]; } private set { names[14] = value; } }
		public string[] CFlagName { get { return names[15]; } private set { names[15] = value; } }
        public string[] TCVarName { get { return names[16]; } private set { names[16] = value; } }
        public string[] CStrName { get { return names[17]; } private set { names[17] = value; } }
        public Int64[] ItemPrice;

		private readonly List<CharacterTemplate> CharacterTmplList;

		private EmueraConsole output;
		public void LoadData(string csvDir, EmueraConsole console, bool disp)
		{
			output = console;
			loadVariableSizeData(csvDir + "VariableSize.CSV", disp);
			setArray();
            definedNames.Clear();
            
			loadDataTo(csvDir + "ABL.CSV", AblName, null, disp);
            definedNames.Add("ABL", new List<string>());
            foreach (string str in AblName)
                definedNames["ABL"].Add(str);

            loadDataTo(csvDir + "EXP.CSV", ExpName, null, disp);
            definedNames.Add("EXP", new List<string>());
            foreach (string str in ExpName)
                definedNames["EXP"].Add(str);

            loadDataTo(csvDir + "TALENT.CSV", TalentName, null, disp);
            definedNames.Add("TALENT", new List<string>());
            foreach (string str in TalentName)
                definedNames["TALENT"].Add(str);

            loadDataTo(csvDir + "PALAM.CSV", ParamName, null, disp);
            definedNames.Add("PALAM", new List<string>());
            foreach (string str in ParamName)
                definedNames["PALAM"].Add(str);

            loadDataTo(csvDir + "TRAIN.CSV", TrainName, null, disp);
            definedNames.Add("TRAIN", new List<string>());
            foreach (string str in TrainName)
                definedNames["TRAIN"].Add(str);

            loadDataTo(csvDir + "MARK.CSV", MarkName, null, disp);
            definedNames.Add("MARK", new List<string>());
            foreach (string str in MarkName)
                definedNames["MARK"].Add(str);

            loadDataTo(csvDir + "ITEM.CSV", ItemName, ItemPrice, disp);
            definedNames.Add("ITEM", new List<string>());
            foreach (string str in ItemName)
                definedNames["ITEM"].Add(str);

            loadDataTo(csvDir + "BASE.CSV", BaseName, null, disp);
            definedNames.Add("BASE", new List<string>());
            foreach (string str in BaseName)
                definedNames["BASE"].Add(str);

            loadDataTo(csvDir + "SOURCE.CSV", SourceName, null, disp);
            definedNames.Add("SOURCE", new List<string>());
            foreach (string str in SourceName)
                definedNames["SOURCE"].Add(str);

            loadDataTo(csvDir + "EX.CSV", ExName, null, disp);
            definedNames.Add("EX", new List<string>());
            foreach (string str in ExName)
                definedNames["EX"].Add(str);

            loadDataTo(csvDir + "EQUIP.CSV", EquipName, null, disp);
            definedNames.Add("EQUIP", new List<string>());
            foreach (string str in EquipName)
                definedNames["EQUIP"].Add(str);

            loadDataTo(csvDir + "TEQUIP.CSV", TequipName, null, disp);
            definedNames.Add("TEQUIP", new List<string>());
            foreach (string str in TequipName)
                definedNames["TEQUIP"].Add(str);

            loadDataTo(csvDir + "FLAG.CSV", FlagName, null, disp);
            definedNames.Add("FLAG", new List<string>());
            foreach (string str in FlagName)
                definedNames["FLAG"].Add(str);

            loadDataTo(csvDir + "TFLAG.CSV", TFlagName, null, disp);
            definedNames.Add("TFLAG", new List<string>());
            foreach (string str in TFlagName)
                definedNames["TFLAG"].Add(str);

            loadDataTo(csvDir + "CFLAG.CSV", CFlagName, null, disp);
            definedNames.Add("CFLAG", new List<string>());
            foreach (string str in CFlagName)
                definedNames["CFLAG"].Add(str);

            loadDataTo(csvDir + "STR.CSV", Str, null, disp);
            definedNames.Add("STR", new List<string>());
            foreach (string str in Str)
                definedNames["STR"].Add(str);

            loadDataTo(csvDir + "TCVAR.CSV", TCVarName, null, disp);
            definedNames.Add("TCVAR", new List<string>());
            foreach (string str in TCVarName)
                definedNames["TCVAR"].Add(str);

            loadDataTo(csvDir + "CSTR.CSV", CStrName, null, disp);
            definedNames.Add("CSTR", new List<string>());
            foreach (string str in CStrName)
                definedNames["CSTR"].Add(str);

			//逆引き辞書を作成
			for(int i = 0;i < names.Length; i++)
			{
				string[] nameArray = names[i];
				for (int j = 0; j < nameArray.Length; j++)
				{
					if (!string.IsNullOrEmpty(nameArray[j]) && !nameToIntDics[i].ContainsKey(nameArray[j]))
						nameToIntDics[i].Add(nameArray[j], j);
				}
			}
			//if (!Program.AnalysisMode)
			loadCharacterData(csvDir, disp);
			//definedNames.Clear();
			//foreach (string[] strs in names)
			//    foreach (string str in strs)
			//        definedNames.Add(str);
			definedCharaNames.Clear();
			foreach (CharacterTemplate chara in CharacterTmplList)
			{
				definedCharaNames.Add(chara.Name);
				definedCharaNames.Add(chara.Callname);
			}

			//逆引き辞書を作成2
			for (int i = 0; i < CharacterTmplList.Count; i++)
			{
				CharacterTemplate tmpl = CharacterTmplList[i];
				if (!string.IsNullOrEmpty(tmpl.Name) && !relationDic.ContainsKey(tmpl.Name))
					relationDic.Add(tmpl.Name, i);
				if (!string.IsNullOrEmpty(tmpl.Callname) && !relationDic.ContainsKey(tmpl.Callname))
					relationDic.Add(tmpl.Callname, i);
				if (!string.IsNullOrEmpty(tmpl.Nickname) && !relationDic.ContainsKey(tmpl.Nickname))
					relationDic.Add(tmpl.Nickname, i);
			}
		}

        private static readonly Dictionary<string, List<string>> definedNames = new Dictionary<string, List<string>>();
        private static readonly List<String> definedCharaNames = new List<string>();

		public static bool isDefined(VariableCode varCode, string str)
		{
			if (string.IsNullOrEmpty(str))
				return false;
            string id = null;
            switch (varCode)
            {
                case VariableCode.ITEM:
                case VariableCode.ITEMSALES:
                    id = "ITEM";
                    break;
                case VariableCode.LOSEBASE:
                case VariableCode.BASE:
                case VariableCode.MAXBASE:
                case VariableCode.DOWNBASE:
                    id = "BASE";
                    break;

                case VariableCode.ABL:
                    id = "ABL";
                    break;

                case VariableCode.TALENT:
                    id = "TALENT";
                    break;
                case VariableCode.EXP:
                    id = "EXP";
                    break;
                case VariableCode.MARK:
                    id = "MARK";
                    break;
                case VariableCode.SOURCE:
                    id = "SOURCE";
                    break;
                case VariableCode.EX:
                case VariableCode.NOWEX:
                    id = "EX";
                    break;
                case VariableCode.EQUIP:
                    id = "EQUIP";
                    break;
                case VariableCode.TEQUIP:
                    id = "TEQUIP";
                    break;
                case VariableCode.FLAG:
                    id = "FLAG";
                    break;
                case VariableCode.TFLAG:
                    id = "TFLAG";
                    break;
                case VariableCode.CFLAG:
                    id = "CFLAG";
                    break;
                case VariableCode.UP:
                case VariableCode.DOWN:
                case VariableCode.PALAM:
                case VariableCode.JUEL:
                case VariableCode.GOTJUEL:
                case VariableCode.CUP:
                case VariableCode.CDOWN:
                    id = "PALAM";
                    break;
                case VariableCode.TRAINNAME:
                    id = "TRAIN";
                    break;
                case VariableCode.STR:
                    id = "STR";
                    break;
                case VariableCode.TCVAR:
                    id = "TCVAR";
                    break;
                case VariableCode.CSTR:
                    id = "CSTR";
                    break;
            }
            if (id != null)
            {
                if (definedNames[id].Contains(str))
                {
                    return true;
                }
            }
            return definedCharaNames.Contains(str);
		}


		public int KeywordToInteger(VariableCode code, string key, int index)
		{
			if (string.IsNullOrEmpty(key))
				throw new CodeEE("キーワードを空には出来ません");
			int ret = -1;
			string errPos;
			Dictionary<string, int> dic = GetKeywordDictionary(out errPos, code, index);
			if (dic.TryGetValue(key, out ret))
				return ret;
			if (errPos == null)
				throw new CodeEE("配列変数" + code.ToString() + "の要素を文字列で指定することはできません");
			else
				throw new CodeEE(errPos + "の中に\"" + key + "\"の定義がありません");
		}
		
		public Dictionary<string, int> GetKeywordDictionary(out string errPos, VariableCode code, int index)
		{
			errPos = null;
			int allowIndex = -1;
			Dictionary<string, int> ret = null;
			switch (code)
			{
				case VariableCode.ABL:
					ret = nameToIntDics[0];//AblName;
					errPos = "abl.csv";
					allowIndex = 1;
					break;
				case VariableCode.EXP:
					ret = nameToIntDics[1];//ExpName;
					errPos = "exp.csv";
					allowIndex = 1;
					break;
				case VariableCode.TALENT:
					ret = nameToIntDics[2];//TalentName;
					errPos = "talent.csv";
					allowIndex = 1;
					break;
				case VariableCode.UP:
				case VariableCode.DOWN:
                    ret = nameToIntDics[3];//ParamName;
					errPos = "palam.csv";
					allowIndex = 0;
					break;
				case VariableCode.PALAM:
				case VariableCode.JUEL:
				case VariableCode.GOTJUEL:
                case VariableCode.CUP:
                case VariableCode.CDOWN:
                    ret = nameToIntDics[3];//ParamName;
					errPos = "palam.csv";
					allowIndex = 1;
					break;
					
                case VariableCode.TRAINNAME:
                    ret = nameToIntDics[4];//TrainName;
                    errPos = "train.csv";
					allowIndex = 0;
                    break;
				case VariableCode.MARK:
					ret = nameToIntDics[5];//MarkName;
					errPos = "mark.csv";
					allowIndex = 1;
					break;
				case VariableCode.ITEM:
				case VariableCode.ITEMSALES:
					ret = nameToIntDics[6];//ItemName;
					errPos = "Item.csv";
					allowIndex = 0;
					break;
				case VariableCode.LOSEBASE:
					ret = nameToIntDics[7];//BaseName;
					errPos = "base.csv";
					allowIndex = 0;
					break;
				case VariableCode.BASE:
				case VariableCode.MAXBASE:
                case VariableCode.DOWNBASE:
					ret = nameToIntDics[7];//BaseName;
					errPos = "base.csv";
					allowIndex = 1;
					break;
				case VariableCode.SOURCE:
					ret = nameToIntDics[8];//SourceName;
					errPos = "source.csv";
					allowIndex = 1;
					break;
				case VariableCode.EX:
				case VariableCode.NOWEX:
					ret = nameToIntDics[9];//ExName;
					errPos = "ex.csv";
					allowIndex = 1;
					break;
					
				//case VariableCode.STR:
					
				case VariableCode.EQUIP:
					ret = nameToIntDics[11];//EquipName;
					errPos = "equip.csv";
					allowIndex = 1;
					break;
				case VariableCode.TEQUIP:
					ret = nameToIntDics[12];//TequipName;
					errPos = "tequip.csv";
					allowIndex = 1;
					break;
				case VariableCode.FLAG:
					ret = nameToIntDics[13];//FlagName;
					errPos = "flag.csv";
					allowIndex = 0;
					break;
				case VariableCode.TFLAG:
					ret = nameToIntDics[14];//TFlagName;
					errPos = "tflag.csv";
					allowIndex = 0;
					break;
				case VariableCode.CFLAG:
					ret = nameToIntDics[15];//CFlagName;
					errPos = "cflag.csv";
					allowIndex = 1;
					break;
                case VariableCode.TCVAR:
                    ret = nameToIntDics[16];//TCVarName;
                    errPos = "tcvar.csv";
					allowIndex = 1;
                    break;
                case VariableCode.CSTR:
                    ret = nameToIntDics[17];//CStrName;
                    errPos = "cstr.csv";
					allowIndex = 1;
                    break;
                    
                    
                case VariableCode.RELATION:
					ret = relationDic;
					errPos = "chara*.csv";
					allowIndex = 1;
					break;

				//case VariableCode.STAIN:
			}
			if (ret == null)
				throw new CodeEE("配列変数" + code.ToString() + "の要素を文字列で指定することはできません");
			if ((index >= 0) && (index != allowIndex))
				throw new CodeEE("配列変数" + code.ToString() + "の" + (index+1).ToString() + "番目の要素を文字列で指定することはできません");
			return ret;
		}
		
		public CharacterTemplate GetCharacterTemplate(Int64 index, bool sp)
		{
			foreach (CharacterTemplate chara in CharacterTmplList)
			{
				if (chara.No != index)
					continue;
				if (sp == chara.IsSpchara)
					return chara;
			}
			return null;
		}

        public CharacterTemplate GetCharacterTemplateFromCsvNo(Int64 index)
        {
            foreach (CharacterTemplate chara in CharacterTmplList)
            {
                if (chara.csvNo != index)
                    continue;
                return chara;
            }
            return null;
        }

        public CharacterTemplate GetPseudoChara()
        {
            return new CharacterTemplate(0, this);
        }

		private void loadCharacterData(string csvDir, bool disp)
		{
			if (!Directory.Exists(csvDir))
				return;
			List<KeyValuePair<string, string>> csvPaths = Config.GetFiles(csvDir, "CHARA*.CSV");
			for (int i = 0; i < csvPaths.Count; i++)
                loadCharacterDataFile(csvPaths[i].Value, csvPaths[i].Key, disp);
            if (useCompatiName)
			{
				foreach (CharacterTemplate tmpl in CharacterTmplList)
					if (string.IsNullOrEmpty(tmpl.Callname))
						tmpl.Callname = tmpl.Name;
			}
			foreach (CharacterTemplate tmpl in CharacterTmplList)
				tmpl.SetSpFlag();
		}

		private void loadCharacterDataFile(string csvPath, string csvName, bool disp)
		{
			CharacterTemplate tmpl = null;
			EraStreamReader eReader = new EraStreamReader();
			if (!eReader.Open(csvPath, csvName))
			{
                output.PrintError(eReader.Filename + "のオープンに失敗しました");
				return;
			}
			ScriptPosition position = null;
            if (disp)
				output.PrintLine(eReader.Filename + "読み込み中・・・");
			try
			{
				Int64 index = -1;
				StringStream st = null;
				while ((st = eReader.ReadEnabledLine()) != null)
				{
					position = new ScriptPosition(eReader.Filename, eReader.LineNo, st.RowString);
					string[] tokens = st.Substring().Split(',');
					if (tokens.Length < 2)
					{
						ParserMediator.Warn("\",\"が必要です", position, 1);
						continue;
					}
					if (tokens[0].Length == 0)
					{
						ParserMediator.Warn("\",\"で始まっています", position, 1);
						continue;
					}
					if ((tokens[0].Equals("NO", Config.SCVariable))
						|| (tokens[0].Equals("番号", Config.SCVariable)))
					{
						if (tmpl != null)
						{
							ParserMediator.Warn("番号が二重に定義されました", position, 1);
							continue;
						}
						if (!Int64.TryParse(tokens[1].TrimEnd(), out index))
						{
							ParserMediator.Warn(tokens[1] + "を整数値に変換できません", position, 1);
							continue;
						}
						tmpl = new CharacterTemplate(index, this);
                        string no = eReader.Filename.ToUpper();
                        no = no.Substring(no.IndexOf("CHARA"), 5);
                        StringBuilder sb = new StringBuilder();
                        StringStream ss = new StringStream(no);
                        while (!ss.EOS && char.IsNumber(ss.Current))
                        {
                            sb.Append(ss.Current);
                            ss.ShiftNext();
                        }
                        if (sb.Length > 0)
                            tmpl.csvNo = Convert.ToInt64(sb.ToString());
                        else
                            tmpl.csvNo = index;
						CharacterTmplList.Add(tmpl);
						continue;
					}
					if (tmpl == null)
					{
						ParserMediator.Warn("番号が定義される前に他のデータが始まりました", position, 1);
						continue;
					}
					toCharacterTemplate(gamebase, position, tmpl, tokens);
				}
			}
			catch
			{
                System.Media.SystemSounds.Hand.Play();
                if (position != null)
					ParserMediator.Warn("予期しないエラーが発生しました", position, 3);
				else
                    output.PrintError("予期しないエラーが発生しました");
				return;
			}
			finally
			{
				eReader.Dispose();
			}
		}

		private bool tryToInt64(string str, out Int64 p)
		{
			p = -1;
			if (string.IsNullOrEmpty(str))
				return false;
			StringStream st = new StringStream(str);
			int sign = 1;
			if (st.Current == '+')
				st.ShiftNext();
			else if (st.Current == '-')
			{
				sign = -1;
				st.ShiftNext();
			}
			if (!char.IsDigit(st.Current))
				return false;
			try
			{
				p = LexicalAnalyzer.ReadInt64(st, false);
				p = p * sign;
			}
			catch
			{
				return false;
			}
			return true;
		}

		private void toCharacterTemplate(GameBase gamebase, ScriptPosition position, CharacterTemplate chara, string[] tokens)
		{
			if (chara == null)
				return;
			int length = -1;
			Int64 p1 = -1;
			Int64 p2 = -1;
			Dictionary<int, Int64> intArray = null;
			Dictionary<int, string> strArray = null;
			Dictionary<string, int> namearray = null;
			string errPos = null;
			string varname = tokens[0].ToUpper();
			switch (varname)
			{
				case "NAME":
				case "名前":
					chara.Name = tokens[1];
					return;
				case "CALLNAME":
				case "呼び名":
					chara.Callname = tokens[1];
					return;
				case "NICKNAME":
				case "あだ名":
					chara.Nickname = tokens[1];
					return;
				case "MASTERNAME":
				case "主人の呼び方":
					chara.Mastername = tokens[1];
					return;
				case "MARK":
				case "刻印":
					length = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.MARK)];
					intArray = chara.Mark;
					namearray = GetKeywordDictionary(out errPos, VariableCode.MARK, -1);
					break;
				case "EXP":
				case "経験":
					length = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EXP)];
					intArray = chara.Exp;
					namearray = GetKeywordDictionary(out errPos, VariableCode.EXP, -1);
					break;
				case "ABL":
				case "能力":
					length = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.ABL)];
					intArray = chara.Abl;
					namearray = GetKeywordDictionary(out errPos, VariableCode.ABL, -1);
					break;
				case "BASE":
				case "基礎":
					length = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.MAXBASE)];
					intArray = chara.Maxbase;
					namearray = GetKeywordDictionary(out errPos, VariableCode.MAXBASE, -1);
					break;
				case "TALENT":
				case "素質":
					length = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TALENT)];
					intArray = chara.Talent;
					namearray = GetKeywordDictionary(out errPos, VariableCode.TALENT, -1);
					break;
				case "RELATION":
				case "相性":
					length = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.RELATION)];
					intArray = chara.Relation;
					namearray = null;
					break;
				case "CFLAG":
				case "フラグ":
					length = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.CFLAG)];
					intArray = chara.CFlag;
					namearray = GetKeywordDictionary(out errPos, VariableCode.CFLAG, -1);
					break;
                case "EQUIP":
                case "装着物":
					length = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.EQUIP)];
                    intArray = chara.Equip;
					namearray = GetKeywordDictionary(out errPos, VariableCode.EQUIP, -1);
                    break;
                case "JUEL":
                case "珠":
					length = CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.JUEL)];
                    intArray = chara.Juel;
					namearray = GetKeywordDictionary(out errPos, VariableCode.JUEL, -1);
                    break;
				case "CSTR":
					length = CharacterStrArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.CSTR)];
					strArray = chara.CStr;
					namearray = GetKeywordDictionary(out errPos, VariableCode.CSTR, -1);
					break;
				default:
					ParserMediator.Warn("\"" + tokens[0] + "\"は解釈できない識別子です", position, 1);
					return;
			}
			if (length < 0)
			{
				ParserMediator.Warn("プログラムミス", position, 3);
				return;
			}
			bool p1isNumeric = tryToInt64(tokens[1].TrimEnd(), out p1);
			if(p1isNumeric && ((p1 < 0) || (p1 >= length)))
			{
				ParserMediator.Warn(p1.ToString() + "は配列の範囲外です", position, 1);
				return;
			}
			int index = (int)p1;
			if ((!p1isNumeric) && (namearray != null))
				if(!namearray.TryGetValue(tokens[1], out index))
					ParserMediator.Warn("\"" + tokens[1] + "\"は解釈できない識別子です", position, 1);
					
			if ((index < 0) || (index >= length))
			{
				if (p1isNumeric)
					ParserMediator.Warn(index.ToString() + "は配列の範囲外です", position, 1);
				else if (tokens[1].Length == 0)
					ParserMediator.Warn("二つ目の識別子がありません", position, 1);
				else
					ParserMediator.Warn("\"" + tokens[1] + "\"は解釈できない識別子です", position, 1);
				return;
			}
			if (strArray != null)
			{
				if (tokens.Length < 3)
					ParserMediator.Warn("三つ目の識別子がありません", position, 1);
				if (strArray.ContainsKey(index))
					ParserMediator.Warn(varname + "の"+ index.ToString() +"番目の要素は既に定義されています(上書きします)", position, 1);
				strArray[index] = tokens[2];
			}
			else
			{
				if ((tokens.Length < 3) || !tryToInt64(tokens[2], out p2))
					p2 = 1;
				if (intArray.ContainsKey(index))
					ParserMediator.Warn(varname + "の"+ index.ToString() +"番目の要素は既に定義されています(上書きします)", position, 1);
                intArray[index] = p2;
			}
		}


		private void loadDataTo(string csvPath, string[] target, Int64[] targetI, bool disp)
		{

			if (!File.Exists(csvPath))
				return;
			if (target == null)
				return;

			EraStreamReader eReader = new EraStreamReader();
			if (!eReader.Open(csvPath))
			{
				output.PrintError(eReader.Filename + "のオープンに失敗しました");
				return;
			}
			ScriptPosition position = null;

            if (disp || Program.AnalysisMode)
				output.PrintLine(eReader.Filename + "読み込み中・・・");
			try
			{
				StringStream st = null;
				while ((st = eReader.ReadEnabledLine()) != null)
				{
					position = new ScriptPosition(eReader.Filename, eReader.LineNo, st.RowString);
					string[] tokens = st.Substring().Split(',');
					if (tokens.Length < 2)
					{
						ParserMediator.Warn("\",\"が必要です", position, 1);
						continue;
					}
					int index = 0;
					if (!Int32.TryParse(tokens[0], out index))
					{
						ParserMediator.Warn("一つ目の値を整数値に変換できません", position, 1);
						continue;
					}
					if ((index < 0) || (target.Length <= index))
					{
						ParserMediator.Warn(index.ToString() + "は配列の範囲外です", position, 1);
						continue;
					}
					target[index] = tokens[1];
					if ((targetI != null) && (tokens.Length >= 3))
					{
						Int64 price;

						if (!Int64.TryParse(tokens[2].TrimEnd(), out price))
						{
							ParserMediator.Warn("金額が読み取れません", position, 1);
							continue;
						}

						targetI[index] = price;
					}
				}
			}
			catch
			{
                System.Media.SystemSounds.Hand.Play();
                if (position != null)
					ParserMediator.Warn("予期しないエラーが発生しました", position, 3);
				else
                    output.PrintError("予期しないエラーが発生しました");
				return;
			}
			finally
			{
				eReader.Close();
			}


		}
	}

	internal sealed class CharacterTemplate
	{
		int[] arraySize;
		int cstrSize;
		public CharacterTemplate(Int64 index, ConstantData constant)
		{
			arraySize = constant.CharacterIntArrayLength;
			cstrSize = constant.CharacterStrArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.CSTR)];
			No = index;
		}
        public int ArrayStrLength(CharacterStrData type)
		{ 
			switch (type)
            {
                case CharacterStrData.CSTR:
                    return cstrSize;
                default:
                    throw new CodeEE("存在しないキーを参照しました");
            }
		}

        public int ArrayLength(CharacterIntData type)
        {
            switch (type)
            {
                case CharacterIntData.BASE:
                	{
						int size = arraySize[(int)(VariableCode.__LOWERCASE__ & VariableCode.BASE)];
						int maxSize = arraySize[(int)(VariableCode.__LOWERCASE__ & VariableCode.MAXBASE)];
						return size > maxSize ? size : maxSize;
                    }
                case CharacterIntData.MARK:
                    return arraySize[(int)(VariableCode.__LOWERCASE__ & VariableCode.MARK)];
                case CharacterIntData.ABL:
                    return arraySize[(int)(VariableCode.__LOWERCASE__ & VariableCode.ABL)];
                case CharacterIntData.EXP:
                    return arraySize[(int)(VariableCode.__LOWERCASE__ & VariableCode.EXP)];
                case CharacterIntData.RELATION:
                    return arraySize[(int)(VariableCode.__LOWERCASE__ & VariableCode.RELATION)];
                case CharacterIntData.TALENT:
                    return arraySize[(int)(VariableCode.__LOWERCASE__ & VariableCode.TALENT)];
                case CharacterIntData.CFLAG:
                    return arraySize[(int)(VariableCode.__LOWERCASE__ & VariableCode.CFLAG)];
                case CharacterIntData.EQUIP:
                    return arraySize[(int)(VariableCode.__LOWERCASE__ & VariableCode.EQUIP)];
                case CharacterIntData.JUEL:
                    return arraySize[(int)(VariableCode.__LOWERCASE__ & VariableCode.JUEL)];
                default:
                    throw new CodeEE("存在しないキーを参照しました");
            }
        }

		public string Name;
		public string Callname;
		public string Nickname;
		public string Mastername;
		public readonly Int64 No;
		public readonly Dictionary<Int32, Int64> Maxbase = new Dictionary<Int32, Int64>();
		public readonly Dictionary<Int32, Int64> Mark = new Dictionary<Int32, Int64>();
		public readonly Dictionary<Int32, Int64> Exp = new Dictionary<Int32, Int64>();
		public readonly Dictionary<Int32, Int64> Abl = new Dictionary<Int32, Int64>();
		public readonly Dictionary<Int32, Int64> Talent = new Dictionary<Int32, Int64>();
		public readonly Dictionary<Int32, Int64> Relation = new Dictionary<Int32, Int64>();
		public readonly Dictionary<Int32, Int64> CFlag = new Dictionary<Int32, Int64>();
        public readonly Dictionary<Int32, Int64> Equip = new Dictionary<Int32, Int64>();
        public readonly Dictionary<Int32, Int64> Juel = new Dictionary<Int32, Int64>();
		public readonly Dictionary<Int32, string> CStr = new Dictionary<Int32, string>();
        public Int64 csvNo;
		public bool IsSpchara { get; private set; }

		internal void SetSpFlag()
		{
			if (CFlag.ContainsKey(0) && CFlag[0] != 0L)
				IsSpchara = true;
		}
	}
}
