using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.IO.Compression;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameData;
using MinorShift.Emuera.GameData.Variable;

namespace MinorShift.Emuera.GameProc
{
    internal sealed partial class Process
    {

        delegate void SystemProcess();
        Dictionary<SystemStateCode, SystemProcess> systemProcessDictionary = new Dictionary<SystemStateCode, SystemProcess>();
        private void initSystemProcess()
        {
            comAble = new int[ConstantData.MaxTrain];
            ablAble = new int[ConstantData.MaxAbl];
            systemProcessDictionary.Add(SystemStateCode.Initializing, new SystemProcess(this.endInitialize));
            systemProcessDictionary.Add(SystemStateCode.Openning, new SystemProcess(this.endOpenning));

            systemProcessDictionary.Add(SystemStateCode.Train_Begin, new SystemProcess(this.beginTrain));
            systemProcessDictionary.Add(SystemStateCode.Train_CallEventTrain, new SystemProcess(this.endCallEventTrain));
            systemProcessDictionary.Add(SystemStateCode.Train_CallShowStatus, new SystemProcess(this.endCallShowStatus));
            systemProcessDictionary.Add(SystemStateCode.Train_CallComAbleXX, new SystemProcess(this.endCallComAbleXX));
            systemProcessDictionary.Add(SystemStateCode.Train_CallShowUserCom, new SystemProcess(this.endCallShowUserCom));
            systemProcessDictionary.Add(SystemStateCode.Train_WaitInput, new SystemProcess(this.trainWaitInput));
            systemProcessDictionary.Add(SystemStateCode.Train_CallEventCom, new SystemProcess(this.endEventCom));
            systemProcessDictionary.Add(SystemStateCode.Train_CallComXX, new SystemProcess(this.endCallComXX));
            systemProcessDictionary.Add(SystemStateCode.Train_CallSourceCheck, new SystemProcess(this.endCallSourceCheck));
            systemProcessDictionary.Add(SystemStateCode.Train_CallEventComEnd, new SystemProcess(this.endCallEventComEnd));

            systemProcessDictionary.Add(SystemStateCode.AfterTrain_Begin, new SystemProcess(this.beginAfterTrain));

            systemProcessDictionary.Add(SystemStateCode.Ablup_Begin, new SystemProcess(this.beginAblup));
            systemProcessDictionary.Add(SystemStateCode.Ablup_CallShowJuel, new SystemProcess(this.endCallShowJuel));
            systemProcessDictionary.Add(SystemStateCode.Ablup_CallShowAblupSelect, new SystemProcess(this.endCallShowAblupSelect));
            systemProcessDictionary.Add(SystemStateCode.Ablup_WaitInput, new SystemProcess(this.ablupWaitInput));
            systemProcessDictionary.Add(SystemStateCode.Ablup_CallAblupXX, new SystemProcess(this.endCallAblupXX));

            systemProcessDictionary.Add(SystemStateCode.Turnend_Begin, new SystemProcess(this.beginTurnend));

            systemProcessDictionary.Add(SystemStateCode.Shop_Begin, new SystemProcess(this.beginShop));
            systemProcessDictionary.Add(SystemStateCode.Shop_CallEventShop, new SystemProcess(this.endCallEventShop));
            systemProcessDictionary.Add(SystemStateCode.Shop_CallShowShop, new SystemProcess(this.endCallShowShop));
            systemProcessDictionary.Add(SystemStateCode.Shop_WaitInput, new SystemProcess(this.shopWaitInput));
            systemProcessDictionary.Add(SystemStateCode.Shop_CallEventBuy, new SystemProcess(this.endCallEventBuy));

            systemProcessDictionary.Add(SystemStateCode.SaveGame_Begin, new SystemProcess(this.beginSaveGame));
            systemProcessDictionary.Add(SystemStateCode.SaveGame_WaitInput, new SystemProcess(this.saveGameWaitInput));
            systemProcessDictionary.Add(SystemStateCode.SaveGame_WaitInputOverwrite, new SystemProcess(this.saveGameWaitInputOverwrite));
            systemProcessDictionary.Add(SystemStateCode.SaveGame_CallSaveInfo, new SystemProcess(this.endCallSaveInfo));
            systemProcessDictionary.Add(SystemStateCode.LoadGame_Begin, new SystemProcess(this.beginLoadGame));
            systemProcessDictionary.Add(SystemStateCode.LoadGame_WaitInput, new SystemProcess(this.loadGameWaitInput));
            systemProcessDictionary.Add(SystemStateCode.LoadGameOpenning_Begin, new SystemProcess(this.beginLoadGameOpening));
            systemProcessDictionary.Add(SystemStateCode.LoadGameOpenning_WaitInput, new SystemProcess(this.loadGameWaitInput));

            //stateEndProcessDictionary.Add(ProgramState.AutoSave_Begin, new stateEndProcess(this.beginAutoSave));
            systemProcessDictionary.Add(SystemStateCode.AutoSave_CallSaveInfo, new SystemProcess(this.endAutoSaveCallSaveInfo));

            systemProcessDictionary.Add(SystemStateCode.Normal, new SystemProcess(this.endNormal));
            return;
        }



        Int64 systemResult = 0;
        int lastCalledComable = -1;
        int lastAddCom = -1;
        //(Train.csv̒lE`ĂȂ-1) == comAble[(\Ăl)];
        int[] comAble;//
        //(Abl.csv̒lE`ĂȂ-1) == ablAble[(\Ăl)];
        int[] ablAble;//


        private void runSystemProc()
        {
            if (!state.ScriptEnd)
                throw new ExeEE("sȌĂяo");

            if (systemProcessDictionary.ContainsKey(state.SystemState))
                systemProcessDictionary[state.SystemState]();
            else
                throw new ExeEE("`̏");

        }

        void setWait()
        {
            console.ReadSystemInteger();
        }


        private bool callFunction(string functionName, bool force, bool isEvent)
        {
            CalledFunction call = CalledFunction.CallFunction(this, functionName, null, isEvent);
            if ((call == null) || (call.NextLine == null))
                if (!force)
                    return false;
                else
                    throw new CodeEE("֐\"@" + functionName + "\"܂");
            if ((!isEvent) && (call.Count > 1))
                throw new ExeEE("Cxg֐łȂ֐\"@" + functionName + "\"̌₪");
            state.AddFunction(call);
            return true;
        }

        //CheckState()Ă΂֐QBScriptEndɒBƂ̏B




        void endInitialize()
        {
            console.DrawLine();
            console.NewLine();
            console.PrintCenter(vEvaluator.Gamebase.ScriptTitle);
            console.PrintCenter(string.Format("ver. {0:0.00}", vEvaluator.Gamebase.ScriptVersion / 1000.0));
            console.PrintCenter(vEvaluator.Gamebase.ScriptAutherName);
            console.PrintCenter("(" + vEvaluator.Gamebase.ScriptYear + ")");
            console.NewLine();
            console.PrintCenter(vEvaluator.Gamebase.ScriptDetail);
            console.DrawLine();
            console.NewLine();
            console.PrintLine("[0] ŏ͂߂");
            console.PrintLine("[1] [hĂ͂߂");
            setWait();
            state.SystemState = SystemStateCode.Openning;
            return;
        }

        void endOpenning()
        {
            if (systemResult == 0)
            {//[0] ŏ͂߂
                state.SystemState = SystemStateCode.Normal;
                callFunction("EVENTFIRST", true, true);
            }
            else if (systemResult == 1)
            {
                beginLoadGameOpening();
            }
            else//͂ȂȂIAIvB
                endInitialize();
        }

        void beginTrain()
        {
            vEvaluator.UpdateInBeginTrain();
            state.SystemState = SystemStateCode.Train_CallEventTrain;
            //EVENTTRAINĂяoTrain_CallEventTrainֈڍsB
            if (!callFunction("EVENTTRAIN", false, true))
            {
                //݂Ȃ΃XLbvTrain_CallEventTrainIƂɂB
                endCallEventTrain();
            }
        }

        void endCallEventTrain()
        {
            //SHOW_STATUSĂяoTrain_CallShowStatusֈڍsB
            callFunction("SHOW_STATUS", true, false);
            state.SystemState = SystemStateCode.Train_CallShowStatus;
        }

        void endCallShowStatus()
        {
            //SHOW_STATUSIComAbleXX̌ĂяoԂZbgTrain_CallComAbleXXֈڍsB
            state.SystemState = SystemStateCode.Train_CallComAbleXX;
            lastCalledComable = -1;
            lastAddCom = -1;
            printComCount = 0;
            for (int i = 0; i < comAble.Length; i++)
                comAble[i] = -1;
            endCallComAbleXX();
        }

        int printComCount = 0;
        void endCallComAbleXX()
        {
            //IǉBRESULT0̏ꍇ͑I̔ԍ̂ݑ₵Ēǉ͂ȂB
            if ((lastCalledComable >= 0) && (vEvaluator.Constant.TrainName[lastCalledComable] != null))
            {
                lastAddCom++;
                if (vEvaluator.RESULT != 0)
                {
                    console.PrintC(vEvaluator.GetTrainComString(lastCalledComable, lastAddCom), true);
                    comAble[lastAddCom] = lastCalledComable;
                    printComCount++;
                    if (printComCount % Config.PrintCPerLine == 0)
                        console.PrintFlash(false);
                }
            }
            //ComAbleXX̌ĂяoBtrain.csvɒ`ĂȂ̂̓XLbvAComAbleXXȂREUTRN 1ƓlɈB
            while (++lastCalledComable < ConstantData.MaxTrain)
            {
                if (vEvaluator.Constant.TrainName[lastCalledComable] == null)
                    continue;
                string comName = string.Format("COM_ABLE{0}", lastCalledComable);
                if (!callFunction(comName, false, false))
                {
                    lastAddCom++;
                    console.PrintC(vEvaluator.GetTrainComString(lastCalledComable, lastAddCom), true);
                    comAble[lastAddCom] = lastCalledComable;
                    printComCount++;
                    if (printComCount % Config.PrintCPerLine == 0)
                        console.PrintFlash(false);
                    continue;
                }
                return;
            }
            //SIASHOW_USERCOMĂяoB
            if (lastCalledComable >= ConstantData.MaxTrain)
            {
                console.PrintFlash(false);
                state.SystemState = SystemStateCode.Train_CallShowUserCom;
                callFunction("SHOW_USERCOM", true, false);
            }
        }

        void endCallShowUserCom()
        {
            //l͑҂ԂɂTrain_WaitInputֈڍsB
            setWait();

            vEvaluator.UpdateInTrainWaitInput();
            state.SystemState = SystemStateCode.Train_WaitInput;
        }

        void trainWaitInput()
        {
            int selectCom = -1;
            if ((systemResult >= 0) && (systemResult < comAble.Length))
                selectCom = comAble[systemResult];
            //TrainName`ĂĎgp\(COMABLE0Ԃ)ł
            if (selectCom >= 0)
            {
                string comName = string.Format("COM{0}", selectCom);
                state.SystemState = SystemStateCode.Train_CallEventCom;
                vEvaluator.SELECTCOM = selectCom;
                if (!callFunction("EVENTCOM", false, true))
                    endEventCom();
                return;
            }
            else
            {//ĂȂB
                vEvaluator.RESULT = systemResult;
                state.SystemState = SystemStateCode.Train_CallEventComEnd;
                callFunction("USERCOM", true, false);
                //COM̕KvȂƂ͑SUSERCOMłB
            }

        }

        void endEventCom()
        {
            int selectCom = (int)vEvaluator.SELECTCOM;
            string comName = string.Format("COM{0}", selectCom);
            state.SystemState = SystemStateCode.Train_CallComXX;
            callFunction(comName, true, false);
        }

        void endCallComXX()
        {
            //sɎs
            if (vEvaluator.RESULT == 0)
            {
                //ComIB
                endCallEventComEnd();
            }
            else
            {//ȂSOURCE_CHECKֈڍsB
                state.SystemState = SystemStateCode.Train_CallSourceCheck;
                callFunction("SOURCE_CHECK", true, false);
            }
        }

        void endCallSourceCheck()
        {
            //EVENTCOMENDĂяoTrain_CallEventComEndֈڍsB
            state.SystemState = SystemStateCode.Train_CallEventComEnd;
            if (!callFunction("EVENTCOMEND", false, true))
            {
                //ȂȂXLbvTrain_CallEventComEndIƂ݂ȂB
                endCallEventComEnd();
            }
        }

        void endCallEventComEnd()
        {
            //SHOW_STATUS蒼B
            //Train_CallEventTrainƓB
            endCallEventTrain();
        }

        void beginAfterTrain()
        {
            state.SystemState = SystemStateCode.Normal;
            //EVENTENDĂяoBexeԂcKvȂ̂NormalֈڍsB
            callFunction("EVENTEND", true, true);
        }

        void beginAblup()
        {
            state.SystemState = SystemStateCode.Ablup_CallShowJuel;
            //SHOW_JUELĂяoAblup_CallShowJuelֈڍsB
            callFunction("SHOW_JUEL", true, false);
        }

        void endCallShowJuel()
        {
            state.SystemState = SystemStateCode.Ablup_CallShowAblupSelect;
            //SHOW_ABLUP_SELECTĂяoAblup_CallAblupSelectֈڍsB
            callFunction("SHOW_ABLUP_SELECT", true, false);
        }

        void endCallShowAblupSelect()
        {
            //l͑҂ԂɂAblup_WaitInputֈڍsB
            setWait();
            state.SystemState = SystemStateCode.Ablup_WaitInput;
        }

        void ablupWaitInput()
        {
            //`ĂȂĂ100ȂABLUPĂ΂AUSERABLUP͌Ă΂ȂBȂ[99]ƂoȂB
            if ((systemResult >= 0) && (systemResult < 100))
            {
                state.SystemState = SystemStateCode.Ablup_CallAblupXX;
                string ablName = string.Format("ABLUP{0}", systemResult);
                if (!callFunction(ablName, false, false))
                {
                    //ȂΏI
                    endCallAblupXX();
                }
            }
            else
            {
                vEvaluator.RESULT = systemResult;
                state.SystemState = SystemStateCode.Ablup_CallAblupXX;
                callFunction("USERABLUP", true, false);
            }
        }

        void endCallAblupXX()
        {
            beginAblup();
        }

        void beginTurnend()
        {
            //EVENTTURNENDĂяoNormalֈڍs
            callFunction("EVENTTURNEND", true, true);
            state.SystemState = SystemStateCode.Normal;
        }

        void beginShop()
        {
            saveTarget = -1;
            if (Config.AutoSave && state.calledWhenNormal == true)
                beginAutoSave();
            else
                endAutoSaveCallSaveInfo();
        }

        void beginAutoSave()
        {
            saveTarget = AutoSaveIndex;
            state.SetPUTSAVE();
            state.SystemState = SystemStateCode.AutoSave_CallSaveInfo;
            if (!callFunction("SAVEINFO", false, false))
                endAutoSaveCallSaveInfo();//݂Ȃ΃XLbv
        }

        void endAutoSaveCallSaveInfo()
        {
            if (saveTarget == AutoSaveIndex)
                if (!saveTo(saveTarget, state.GetPUTSAVE()))
                    throw new ExeEE("I[gZ[uɗ\ȂG[܂");

            state.SystemState = SystemStateCode.Shop_CallEventShop;
            //EVENTSHOPĂяoShop_CallEventShopֈڍsB
            if (!callFunction("EVENTSHOP", false, true))
            {
                //݂Ȃ΃XLbvShop_CallEventShopIƂɂB
                endCallEventShop();
            }
        }

        void endCallEventShop()
        {

            state.SystemState = SystemStateCode.Shop_CallShowShop;
            //SHOW_SHOPĂяoShop_CallShowShopֈڍs
            callFunction("SHOW_SHOP", true, false);
        }

        void endCallShowShop()
        {
            //l͑҂ԂɂShop_WaitInputֈڍsB
            setWait();
            state.SystemState = SystemStateCode.Shop_WaitInput;
        }

        //PRINT_SHOPITEMƂ͓ƗĂB
        //BOUGHT100ȏ̃ACeLAITEMSALESTRUEƂĂI@USERSHOPsB
        void shopWaitInput()
        {
            if ((systemResult >= 0) && (systemResult < 100))
            {
                if (vEvaluator.ItemSales(systemResult))
                {
                    if (vEvaluator.BuyItem(systemResult))
                    {
                        state.SystemState = SystemStateCode.Shop_CallEventBuy;
                        //EVENTBUYĂяoShop_CallEventBuyֈڍs
                        if (!callFunction("EVENTBUY", false, true))
                            endCallEventBuy();
                        return;
                    }
                    else
                    {
                        console.Print("܂B");
                        console.NewLine();
                    }
                }
                else
                {
                    console.Print("Ă܂B");
                    console.NewLine();
                }
                //wɎsꍇAendCallEventShop()ɖ߂B
                endCallEventShop();
                return;
            }
            else
            {
                //RESULTXV
                vEvaluator.RESULT = systemResult;

                //USERSHOPĂяoShop_CallEventBuyֈڍs
                callFunction("USERSHOP", true, false);
                state.SystemState = SystemStateCode.Shop_CallEventBuy;
                return;
            }
        }

        void endCallEventBuy()
        {
            //ŏɖ߂
            endCallEventShop();
        }



        void beginSaveGame()
        {
            console.PrintLine("ԂɃZ[u܂H");
            state.SystemState = SystemStateCode.SaveGame_Begin;
            printSaveDataText();
        }

        void beginLoadGame()
        {
            console.PrintLine("Ԃ[h܂H");
            state.SystemState = SystemStateCode.LoadGame_Begin;
            printSaveDataText();
        }

        void beginLoadGameOpening()
        {
            console.PrintLine("Ԃ[h܂H");
            state.SystemState = SystemStateCode.LoadGameOpenning_Begin;
            printSaveDataText();
        }

        bool[] dataIsAvailable = new bool[21];
        const int AutoSaveIndex = 99;
        void printSaveDataText()
        {
            for (int i = 0; i < dataIsAvailable.Length; i++)
            {
                dataIsAvailable[i] = false;
                if (i == dataIsAvailable.Length - 1)
                {
                    //[ĥ݁AI[gZ[upf[^\
                    if (state.SystemState != SystemStateCode.SaveGame_Begin)
                        i = AutoSaveIndex;
                    else
                        break;
                }
                console.PrintFlash(false);
                console.Print(string.Format("[{0, 2}] ", i));
                if (!WriteTextFrom(i))
                    continue;
                if (i == AutoSaveIndex)
                    dataIsAvailable[dataIsAvailable.Length - 1] = true;
                else
                    dataIsAvailable[i] = true;
            }
            //`SI
            console.PrintLine("[100] ߂");
            setWait();
            if (state.SystemState == SystemStateCode.SaveGame_Begin)
                state.SystemState = SystemStateCode.SaveGame_WaitInput;
            else if (state.SystemState == SystemStateCode.LoadGame_Begin)
                state.SystemState = SystemStateCode.LoadGame_WaitInput;
            else if (state.SystemState == SystemStateCode.LoadGameOpenning_Begin)
                state.SystemState = SystemStateCode.LoadGameOpenning_WaitInput;
            else
                throw new ExeEE("ُȏ");
        }

        int saveTarget = -1;
        void saveGameWaitInput()
        {
            if (systemResult == 100)
            {
                //LZȂ璼ȌԂĂі߂
                loadPrevState();
                return;
            }
            bool available = false;
            if ((systemResult >= 0) && (systemResult < dataIsAvailable.Length - 1))
                available = dataIsAvailable[systemResult];
            else
            {//͂Ȃ
                setWait();
                return;
            }
            saveTarget = (int)systemResult;
            //f[^ȂI\SaveGame_WaitInputOverwriteֈڍsB
            if (available)
            {
                console.PrintLine("Ƀf[^݂܂B㏑܂H");
                console.PrintC("[0] ͂", false);
                console.PrintC("[1] ", false);
                setWait();
                state.SystemState = SystemStateCode.SaveGame_WaitInputOverwrite;
                return;
            }
            //f[^ȂȂu͂vI񂾂ƂɂĒڃWv
            systemResult = 0;
            saveGameWaitInputOverwrite();
        }

        void saveGameWaitInputOverwrite()
        {
            if (systemResult == 1)//
            {
                beginSaveGame();
                return;
            }
            else if (systemResult != 0)//u͂vłȂ
            {//͂Ȃ
                setWait();
                return;
            }
            state.SetPUTSAVE();
            state.SystemState = SystemStateCode.SaveGame_CallSaveInfo;
            if (!callFunction("SAVEINFO", false, false))
                endCallSaveInfo();//݂Ȃ΃XLbv
        }

        void endCallSaveInfo()
        {
            if (!saveTo(saveTarget, state.GetPUTSAVE()))
                throw new ExeEE("Z[uɗ\ȂG[܂");
            loadPrevState();
        }

        void loadGameWaitInput()
        {
            if (systemResult == 100)
            {//LZȂ
                //I[vjOȂI[vjO֖߂
                if (state.SystemState == SystemStateCode.LoadGameOpenning_WaitInput)
                {
                    endInitialize();
                    return;
                }
                //ȊO痈Ȃ璼ȌԂĂі߂
                loadPrevState();
                return;
            }
            bool available = false;
            if ((systemResult >= 0) && (systemResult < dataIsAvailable.Length - 1))
                available = dataIsAvailable[systemResult];
            else if (systemResult == AutoSaveIndex)
                available = dataIsAvailable[dataIsAvailable.Length - 1];
            else
            {//͂Ȃ
                setWait();
                return;
            }
            if (!available)
            {
                console.PrintLine("f[^܂");
                if (state.SystemState == SystemStateCode.LoadGameOpenning_WaitInput)
                {
                    beginLoadGameOpening();
                    return;
                }
                beginLoadGame();
                return;
            }

            if (!loadFrom((int)systemResult))
                throw new ExeEE("t@C̃[hɗ\ȂG[܂");
            deletePrevState();
            endCallEventShop();
        }


        void endNormal()
        {
            throw new CodeEE("\ȂXNvgI[ł");
        }

        private bool WriteTextFrom(int saveIndex)
        {
            string filepath = getSaveDataPath(saveIndex);
            if (!File.Exists(filepath))
            {
                console.Print("----");
                console.NewLine();
                return false;
            }
            StreamReader stream = null;
            EraDataReader reader = null;
            try
            {
                stream = new StreamReader(filepath, Config.Encode);
                reader = new EraDataReader(stream);
                string text = VariableEvaluator.TextLoadFromStream(vEvaluator.Gamebase, reader);
                console.Print(text);
                console.NewLine();
            }
            catch (FileEE fee)
            {
                console.Print(fee.Message);
                console.NewLine();
                return false;
            }
            catch (Exception)
            {
                console.Print("ǂݍݒɃG[܂");
                console.NewLine();
                return false;
            }
            finally
            {
                if (reader != null)
                    reader.Close();
                else if (stream != null)
                    stream.Close();
            }
            return true;
        }

        private bool loadFrom(int saveIndex)
        {
            return loadFrom(getSaveDataPath(saveIndex));
        }

        private bool loadFrom(string filepath)
        {
            if (!File.Exists(filepath))
                throw new ExeEE("݂ȂpXĂяo");
            StreamReader stream = null;
            EraDataReader reader = null;
            try
            {
                stream = new StreamReader(filepath, Config.Encode);
                reader = new EraDataReader(stream);
                vEvaluator.LoadFromStream(reader);
            }
            finally
            {
                if (reader != null)
                    reader.Close();
                else if (stream != null)
                    stream.Close();
            }
            return true;
        }


        private bool saveTo(int saveIndex, string saveText)
        {
            string filepath = getSaveDataPath(saveIndex);
            StreamWriter stream = null;
            EraDataWriter writer = null;
            try
            {
                stream = new StreamWriter(filepath, false, Config.Encode);
                writer = new EraDataWriter(stream);
                vEvaluator.SaveToStream(writer, saveText);
            }
            catch (Exception)
            {
                console.Print("ۑɃG[܂");
                console.NewLine();
                return false;
            }
            finally
            {
                if (writer != null)
                    writer.Close();
                else if (stream != null)
                    stream.Close();
            }
            return true;
        }


        private string getSaveDataPath(int index)
        {
            return string.Format("{0}save{1:00}.sav", Program.ExeDir, index);
        }
    }
}