using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Text.RegularExpressions;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameData;
using MinorShift.Emuera.GameView;
using MinorShift.Emuera.GameData.Expression;
using MinorShift.Emuera.GameData.Variable;
namespace MinorShift.Emuera.GameProc
{
    public class StrIgnoreCaseComparer : IComparer<string>
    {
        public int Compare(string x, string y)
        {
            return string.Compare(x, y, false);
        }
    }


    internal sealed partial class Process
    {
        private sealed class ErbLoader
        {
            public ErbLoader(EmueraConsole main, VariableEvaluator var)
            {
                output = main;
                varData = var;
            }
            readonly EmueraConsole output;
            readonly VariableEvaluator varData;
            Dictionary<string, int> ignoredWarningCount = new Dictionary<string, int>();
            List<string> ignoredFNFWarningFileList = new List<string>();
            int ignoredFNFWarningCount = 0;

            int enabledLineCount = 0;
            int lineCount = 0;
            LabelDictionary labelDic;
            /// <summary>
            /// ̃t@Cǂ
            /// </summary>
            /// <param name="filepath"></param>
            public LabelDictionary LoadErbFiles(string erbDir)
            {
                labelDic = new LabelDictionary();
                string[] erbFiles = Directory.GetFiles(erbDir, "*.ERB", SearchOption.TopDirectoryOnly);
                //NTFS̏ƃt@C͈Ⴄ炵
                //Array.Sort(erbFiles, new StrIgnoreCaseComparer());
                int first = Environment.TickCount;
                try
                {
                    foreach (string file in erbFiles)
                    {

#if DEBUG
                        output.PrintLine(Path.GetFileName(file) + "ǂݍݒEEE" + (Environment.TickCount - first).ToString() + ":");
#else
						output.PrintLine(Path.GetFileName(file) + "ǂݍݒEEE");
#endif
                        System.Windows.Forms.Application.DoEvents();
                        loadErb(file);
                    }
                    checkScript();
                }
                catch (CodeEE e)
                {
                    if (e.Position != null)
                    {
                        output.PrintLine(e.Position.Filename + "" + e.Position.LineNo.ToString() + "sڂŃG[܂");
                        output.PrintLine(e.Position.RowLine);
                    }
                    output.PrintLine(e.Message);
                    return null;
                }
                catch (Exception e)
                {
                    output.PrintLine("\ȂG[܂");
                    output.PrintLine(e.GetType().ToString() + ":" + e.Message);
                    return null;
                }
                return labelDic;
            }

            /// <summary>
            /// t@Cǂ
            /// </summary>
            /// <param name="filepath"></param>
            private void loadErb(string filepath)
            {
                string filename = Path.GetFileName(filepath);

                EraStreamReader eReader = new EraStreamReader();
                if (!eReader.Open(filepath))
                {
                    output.PrintLine(eReader.Filename + "̃I[vɎs܂");
                    return;
                }
                try
                {
                    string line = null;
                    LogicalLine lastLine = new NullLine();
                    FunctionLabelLine lastLabelLine = null;
                    StringStream st = null;
                    bool skip = false;
                    string rowLine = null;
                    while ((line = eReader.ReadLine()) != null)
                    {
                        lineCount++;
                        if (line.Length == 0)
                            continue;
                        rowLine = line;
                        st = new StringStream(line);
                        TokenReader.SkipWhiteSpace(st);
                        if (st.Current == ';')
                        {
                            if ((st.Next != '!') || (st.NextNext != ';'))
                                continue;
                            st.ShiftNext();
                            st.ShiftNext();
                            st.ShiftNext();
                            TokenReader.SkipWhiteSpace(st);
                            if (st.Current == ';')
                                continue;
                        }
                        if (st.EOS)
                            continue;
                        line = st.Substring();
                        if (Config.UseRenameFile)
                            line = applyRename(line);
                        st = new StringStream(line);
                        ScriptPosition position = new ScriptPosition(eReader.Filename, eReader.LineNo, rowLine);
                        if (st.Current == '[')
                        {
                            st.ShiftNext();
                            if (TokenReader.GetNextTokenType(st) != TokenType.Identifer)
                                output.PrintWarning("[]̎gsł", position, 1);
                            string token = TokenReader.ReadSingleIdentifer(st);
                            if ((token == null) || (st.Current != ']'))
                                output.PrintWarning("[]̎gsł", position, 1);
                            switch (token)
                            {
                                case "SKIPSTART":
                                    if (skip)
                                        output.PrintWarning("[SKIPSTART]dĎgpĂ܂", position, 1);
                                    skip = true;
                                    break;
                                case "SKIPEND":
                                    if (!skip)
                                        output.PrintWarning("[SKIPSTART]ƑΉȂ[SKIPEND]ł", position, 1);
                                    skip = false;
                                    break;
                                default:
                                    output.PrintWarning("FłȂvvZbTł", position, 1);
                                    break;
                            }
                            continue;
                        }
                        if (skip == true)
                            continue;
                        //܂ŃvvZbT

                        if (st.Current == '#')
                        {
                            if (!(lastLine is FunctionLabelLine))
                            {
                                output.PrintWarning("֐錾̒ȊO#sgĂ܂", position, 1);
                                continue;
                            }
                            FunctionLabelLine label = (FunctionLabelLine)lastLine;
                            st.ShiftNext();
                            string token = TokenReader.ReadSingleIdentifer(st);
                            if (token == null)
                            {
                                output.PrintWarning("߂łȂ#sł", position, 1);
                                continue;
                            }
                            if (Config.IgnoreCase)
                                token = token.ToUpper();
                            switch (token)
                            {
                                case "SINGLE": label.IsSingle = true; break;
                                case "LATER": label.Priority++; break;
                                case "PRI": label.Priority--; break;
                                default:
                                    output.PrintWarning("߂łȂ#sł", position, 1);
                                    break;
                            }
                            continue;
                        }
                        LogicalLine nextLine = LogicalLineParser.ParseLine(st, position, output);

                        if (nextLine == null)
                            continue;
                        if (nextLine is InvalidLine)
                        {
                            output.PrintWarning(nextLine.ErrMes, position, 2);
                        }
                        else if (nextLine is FunctionLabelLine)
                        {
                            FunctionLabelLine label = (FunctionLabelLine)nextLine;
                            labelDic.AddLabel(label);
                            lastLabelLine = label;
                            //if (labelDic.IsOverride(label))
                            //    output.PrintWarning("Cxg֐d`Ă܂", position, 0);
                        }
                        else if (nextLine is GotoLabelLine)
                        {
                            GotoLabelLine gotoLabel = (GotoLabelLine)nextLine;
                            gotoLabel.SetParentFunction(lastLabelLine);
                            if (!labelDic.AddLabelDollar((GotoLabelLine)nextLine))
                                output.PrintWarning("x$" + line + "͊ɂ̊֐ŎgpĂ܂", position, 2);
                        }
                        if (lastLabelLine == null)
                            output.PrintWarning("֐`Oɍs܂", position, 1);
                        else
                            lastLine = addLine(nextLine, lastLine);
                    }
                    addLine(new NullLine(), lastLine);
                }
                finally
                {
                    eReader.Close();
                }
                return;
            }


            private LogicalLine addLine(LogicalLine nextLine, LogicalLine lastLine)
            {
                if (nextLine == null)
                    return null;
                enabledLineCount++;
                nextLine.PrevLine = lastLine;
                lastLine.NextLine = nextLine;
                return nextLine;
            }

            Dictionary<string, string> renameDic = null;
            internal void LoadEraExRenameFile(string filepath)
            {
                EraStreamReader eReader = new EraStreamReader();
                if ((!File.Exists(filepath)) || (!eReader.Open(filepath)))
                {
                    return;
                }

                renameDic = new Dictionary<string, string>();
                string line = null;
                ScriptPosition pos = null;
                try
                {
                    while ((line = eReader.ReadLine()) != null)
                    {
                        if (line.Length == 0)
                            continue;
                        if (line.StartsWith(";"))
                            continue;
                        string[] tokens = line.Split(',');
                        if (tokens.Length < 2)
                            continue;
                        pos = new ScriptPosition(eReader.Filename, eReader.LineNo, line);
                        //EERB̕\LAϊɂȂB
                        string value = tokens[0].Trim();
                        string key = string.Format("[[{0}]]", tokens[1].Trim());
                        renameDic[key] = value;
                        pos = null;
                    }
                }
                catch (Exception e)
                {
                    if (pos != null)
                        throw new CodeEE(e.Message, pos);
                    else
                        throw new CodeEE(e.Message);

                }
                finally
                {
                    eReader.Close();
                }

            }

            private string applyRename(string rowLine)
            {
                if ((rowLine.IndexOf("[[") < 0) || (rowLine.IndexOf("]]") < 0))
                    return rowLine;
                if (renameDic == null)
                    return rowLine;
                string ret = rowLine;
                foreach (KeyValuePair<string, string> pair in renameDic)
                    ret = ret.Replace(pair.Key, pair.Value);
                return ret;
            }


            /// <summary>
            /// ǍIt@C`FbN
            /// </summary>
            private void checkScript()
            {
                int usedLabelCount = 0;
                int labelDepth = -1;
                List<FunctionLabelLine> labelList = labelDic.GetAllLabels();
                while (true)
                {
                    labelDepth++;
                    int countInDepth = 0;
                    foreach (FunctionLabelLine label in labelList)
                    {
                        if (label.Depth != labelDepth)
                            continue;
                        usedLabelCount++;
                        countInDepth++;
                        checkFunction(label);
                    }
                    if (countInDepth == 0)
                        break;
                }
                labelDepth = -1;
                List<string> ignoredFNCWarningFileList = new List<string>();
                int ignoredFNCWarningCount = 0;

				bool ignoreAll = false;
				switch (Config.FunctionNotCalledWarning)
				{
					case DisplayWarningFlag.IGNORE:
					case DisplayWarningFlag.LATER:
						ignoreAll = true;
						break;
				}
                foreach (FunctionLabelLine label in labelList)
                {
                    if (label.Depth != labelDepth)
                        continue;
                    bool ignore = false;
					if (Config.FunctionNotCalledWarning == DisplayWarningFlag.ONCE)
					{
						string filename = label.Position.Filename.ToUpper();

						if (!string.IsNullOrEmpty(filename))
						{
							if (ignoredFNCWarningFileList.Contains(filename))
							{
								ignore = true;
							}
							else
							{
								ignore = false;
								ignoredFNCWarningFileList.Add(filename);
							}
						}
						break;
					}
                    if (ignoreAll || ignore)
                        ignoredFNCWarningCount++;
                    else
                        printWarning("֐@" + label.LabelName + "͒`Ă܂xĂяo܂", label, 1, false);
                    if (!Config.IgnoreUncalledFunction)
                        checkFunction(label);
                    else
                    {
                        if (!(label.NextLine is NullLine) && !(label.NextLine is FunctionLabelLine))
                        {
                            if (!label.NextLine.IsError)
                            {
                                label.NextLine.IsError = true;
                                label.NextLine.ErrMes = "ĂяoȂ͂̊֐Ă΂ꂽ";
                            }
                        }
                    }
                }
				if ((ignoredFNCWarningCount > 0) && (Config.DisplayWarningLevel <= 1) && (Config.FunctionNotCalledWarning != DisplayWarningFlag.IGNORE))
                    output.PrintLine(string.Format("xLv1:`ꂽ֐xĂяoĂȂɊւx{0}܂", ignoredFNCWarningCount));
                if ((ignoredFNFWarningCount > 0) && (Config.DisplayWarningLevel <= 2) && (Config.FunctionNotCalledWarning != DisplayWarningFlag.IGNORE))
                    output.PrintLine(string.Format("xLv2:`ĂȂ֐ĂяoɊւx{0}܂", ignoredFNFWarningCount));
                foreach (KeyValuePair<string, int> pair in ignoredWarningCount)
                {
                    output.PrintLine(string.Format("xLv{0}ȏ:{1}:{2}̃G[𖳎܂", Config.DisplayWarningLevel, pair.Key, pair.Value));
                }
                if (Config.DisplayReport)
                    output.PrintLine(string.Format("Ss:{0}, Rgs:{1}, S֐v:{2}, ďo֐v:{3}", lineCount, enabledLineCount, labelDic.Count, usedLabelCount));

            }

            /// <summary>
            /// 
            /// </summary>
            /// <param name="str"></param>
            /// <param name="line"></param>
            /// <param name="level">xx.0:yȃ~X.1:łs.2:ssȂΖQ.3:vI</param>
            private void printWarning(string str, LogicalLine line, int level, bool isError)
            {
                if (isError)
                {
                    line.IsError = true;
                    line.ErrMes = str;
                }
                if (level < Config.DisplayWarningLevel)
                    return;
                if ((line.Position != null) && (line.Position.Filename != null))
                {
                    string filename = line.Position.Filename.ToUpper();
                    if (!string.IsNullOrEmpty(filename))
                    {
                        if (Config.IgnoreWarningFiles.Contains(filename))
                        {
                            if (ignoredWarningCount.ContainsKey(filename))
                                ignoredWarningCount[filename]++;
                            else
                                ignoredWarningCount.Add(filename, 1);
                            return;
                        }
                    }
                }
                output.PrintWarning(str, line.Position, level);
            }

            private void printFunctionNotFoundWarning(string str, LogicalLine line, int level, bool isError)
            {
                if (isError)
                {
                    line.IsError = true;
                    line.ErrMes = str;
                }
                if (level < Config.DisplayWarningLevel)
                    return;
                bool ignore = false;
                if (Config.FunctionNotFoundWarning == DisplayWarningFlag.IGNORE)
                    ignore = true;
                else if (Config.FunctionNotFoundWarning == DisplayWarningFlag.DISPLAY)
                    ignore = false;
                else if (Config.FunctionNotFoundWarning == DisplayWarningFlag.ONCE)
                {

                    string filename = line.Position.Filename.ToUpper();
                    if (!string.IsNullOrEmpty(filename))
                    {
                        if (ignoredFNFWarningFileList.Contains(filename))
                        {
                            ignore = true;
                        }
                        else
                        {
                            ignore = false;
                            ignoredFNFWarningFileList.Add(filename);
                        }
                    }
                }
                if (ignore)
                {
                    ignoredFNFWarningCount++;
                    return;
                }
                printWarning(str, line, level, isError);
            }

            private void checkFunction(FunctionLabelLine label)
            {
                System.Windows.Forms.Application.DoEvents();
                int depth = label.Depth;
                if (depth < 0)
                    depth = -2;
                LogicalLine nextLine = label;
                int ifNest = 0;
                int repeatNest = 0;
                string filename = null;
                if (label.Position.Filename != null)
                    filename = label.Position.Filename.ToUpper();
                bool ignoreWarning = false;
                if (!string.IsNullOrEmpty(filename))
                    ignoreWarning = Config.IgnoreWarningFiles.Contains(filename);
                while (true)
                {
                    nextLine = nextLine.NextLine;
                    if ((nextLine is NullLine) || (nextLine is FunctionLabelLine))
                        break;
                    //t[䖽߂̃Wvݒ
                    //łIF-ELSEIF-ENDIFAREPEAT-REND̑Ή`FbNȂ
                    //IF-REPEAT-ENDIF-RENDƂ̍ݓp^[̓`FbNĂȂ
                    if (nextLine is InstructionLine)
                    {
                        InstructionLine func = (InstructionLine)nextLine;
                        if (Config.ReduceArgumentOnLoad)
                        {
                            LogicalLineParser.SetArgumentTo(func, this.printWarning);
                        }
                        LogicalLine jumpto = null;
                        switch (func.Function)
                        {
                            case BuiltInFunctionCode.IF:

                                LogicalLine jumptoendif = findEndif(func);
                                if (jumptoendif is NullLine)
                                {
                                    printWarning("ΉENDIFȂ܂܃t@CI[ɓB܂", nextLine, 2, true);
                                    break;
                                }
                                else if (jumptoendif is FunctionLabelLine)
                                {
                                    printWarning("ΉENDIFȂ܂܊֐I[ɓB܂", nextLine, 2, true);
                                    break;
                                }
                                func.JumpToEndif = jumptoendif;
                                InstructionLine tempFunc = func;
                                jumpto = findIf(tempFunc);
                                tempFunc.JumpTo = jumpto;
                                while (jumptoendif != jumpto)//ׂĂELSEIFAELSEɃWvݒB
                                {
                                    tempFunc = (InstructionLine)jumpto;
                                    tempFunc.JumpToEndif = jumptoendif;
                                    jumpto = findIf(tempFunc);
                                    tempFunc.JumpTo = jumpto;
                                }
                                ifNest++;
                                break;
                            case BuiltInFunctionCode.ELSEIF:
                                if ((ifNest <= 0) || (func.JumpToEndif == null))
                                {
                                    printWarning("IF`ENDIF̊OELSEIFg܂", nextLine, 2, true);
                                    break;
                                }
                                break;
                            case BuiltInFunctionCode.ELSE:
                                if ((ifNest <= 0) || (func.JumpToEndif == null))
                                {
                                    printWarning("IF`ENDIF̊OELSEg܂", nextLine, 2, true);
                                    break;
                                }
                                jumpto = findIf(func);
                                InstructionLine jumptofunc = (InstructionLine)jumpto;
                                if (jumptofunc.Function != BuiltInFunctionCode.ENDIF)
                                {
                                    if (jumptofunc.Function == BuiltInFunctionCode.ELSE)
                                        printWarning("ELSEőELSEgĂ܂", nextLine, 1, false);
                                    else if (jumptofunc.Function == BuiltInFunctionCode.ELSEIF)
                                        printWarning("ELSEELSEIFgĂ܂", nextLine, 1, false);
                                    else
                                        printWarning("ΉENDIF܂ł", nextLine, 2, true);
                                }
                                else
                                    func.JumpTo = jumpto;
                                break;
                            case BuiltInFunctionCode.ENDIF:
                                if (ifNest <= 0)
                                {
                                    printWarning("ΉIF̖ENDIFł", nextLine, 2, true);
                                    break;
                                }
                                ifNest--;
                                break;
                            case BuiltInFunctionCode.REPEAT:
                                if (repeatNest >= 1)
                                {
                                    printWarning("REPEATqɂĂ܂", nextLine, 2, true);
                                    break;
                                }
                                jumpto = findFunction(func, BuiltInFunctionCode.REND, true);
                                if (jumpto is NullLine)
                                    printWarning("ΉRENDȂ܂܃t@CI[ɓB܂", nextLine, 2, true);
                                else if (jumpto is FunctionLabelLine)
                                    printWarning("ΉRENDȂ܂܊֐I[ɓB܂", nextLine, 2, true);
                                else if (jumpto is InstructionLine)
                                {
                                    func.JumpTo = jumpto;
                                    ((InstructionLine)jumpto).JumpTo = func;//RENDREPEAT̈ʒuݒ
                                    repeatNest++;
                                }
                                break;
                            case BuiltInFunctionCode.REND:
                                if ((repeatNest <= 0) || (func.JumpTo == null))
                                {
                                    printWarning("ΉREPEATRENDł", nextLine, 2, true);
                                    break;
                                }
                                repeatNest--;
                                break;
                            case BuiltInFunctionCode.CONTINUE:
                                if (repeatNest <= 0)
                                {
                                    printWarning("REPEAT`REND̊OCONTINUEg܂", nextLine, 2, true);
                                    break;
                                }
                                func.JumpTo = findFunction(func, BuiltInFunctionCode.REPEAT, false);
                                if (func.JumpTo is NullLine)
                                    printWarning("ΉREPEATȂ܂܃t@Cn[ɓB܂", nextLine, 2, true);
                                else if (func.JumpTo is FunctionLabelLine)
                                    printWarning("ΉREPEATȂ܂܊֐n[ɓB܂", nextLine, 2, true);
                                break;
                            case BuiltInFunctionCode.BREAK:
                                if (repeatNest <= 0)
                                {
                                    printWarning("REPEAT`REND̊OBREAKg܂", nextLine, 2, true);
                                    break;
                                }
                                func.JumpTo = findFunction(func, BuiltInFunctionCode.REND, true);
                                if (func.JumpTo is NullLine)
                                    printWarning("ΉRENDȂ܂܃t@CI[ɓB܂", nextLine, 2, true);
                                else if (func.JumpTo is FunctionLabelLine)
                                    printWarning("ΉRENDȂ܂܊֐I[ɓB܂", nextLine, 2, true);
                                break;
                            case BuiltInFunctionCode.SIF:

                                jumpto = func.NextLine;

                                if ((jumpto == null) || (jumpto.NextLine == null) ||
                                    (jumpto is FunctionLabelLine) || (jumpto is NullLine))
                                    printWarning("SIF̃Xe[gg܂", nextLine, 2, true);
                                else if (jumpto is InstructionLine)
                                {
                                    InstructionLine sifFunc = (InstructionLine)jumpto;
                                    switch (sifFunc.Function)
                                    {
                                        case BuiltInFunctionCode.SIF:
                                        case BuiltInFunctionCode.IF:
                                        case BuiltInFunctionCode.ELSEIF:
                                        case BuiltInFunctionCode.ELSE:
                                        case BuiltInFunctionCode.ENDIF:
                                        case BuiltInFunctionCode.REPEAT:
                                        case BuiltInFunctionCode.REND:
                                            printWarning("SIF̎̍s" + sifFunc.Function.ToString() + "ɂ邱Ƃ͂ł܂", nextLine, 2, true);
                                            break;
                                        default:
                                            func.JumpTo = func.NextLine.NextLine;
                                            break;
                                    }
                                }
                                else
                                    func.JumpTo = func.NextLine.NextLine;
                                break;
                            case BuiltInFunctionCode.GOTO://$xփWv
                                {
                                    string labelName = func.ArgumentStr.Trim();
                                    if (Config.IgnoreCase)
                                        labelName = labelName.ToUpper();
                                    jumpto = labelDic.GetLabelDollar(labelName, label);
                                    if (jumpto == null)
                                        printWarning("w肳ꂽx\"$" + labelName + "\"݂͌̊֐ɑ݂܂", nextLine, 2, true);
                                    else
                                        func.JumpTo = jumpto;
                                }
                                break;
                            case BuiltInFunctionCode.JUMP:
                                {
                                    string labelName = func.ArgumentStr.Trim();
                                    if (Config.IgnoreCase)
                                        labelName = labelName.ToUpper();
                                    FunctionLabelLine targetLabel = labelDic.GetLabel(labelName);
                                    if (targetLabel == null)
                                        printFunctionNotFoundWarning("w肳ꂽ֐\"@" + labelName + "\"݂͑܂", nextLine, 2, true);
                                    else
                                    {
                                        func.JumpTo = targetLabel;
                                        if (targetLabel.Depth < 0)
                                            targetLabel.Depth = depth + 1;
                                    }

                                }
                                break;

                            case BuiltInFunctionCode.CALL://֐ɈړBړLARETURNŋAB
                                {
                                    string labelName = func.ArgumentStr.Trim();
                                    if (Config.IgnoreCase)
                                        labelName = labelName.ToUpper();
                                    FunctionLabelLine targetLabel = labelDic.GetLabel(labelName);
                                    if (targetLabel == null)
                                        printFunctionNotFoundWarning("w肳ꂽ֐\"@" + labelName + "\"݂͑܂", nextLine, 2, true);
                                    else
                                    {
                                        func.JumpTo = targetLabel;
                                        if (targetLabel.Depth < 0)
                                            targetLabel.Depth = depth + 1;
                                    }
                                }
                                break;
                            case BuiltInFunctionCode.RESTART:
                                func.JumpTo = label;
                                break;

                        }
                    }
                }

            }
            ///elseif,else,endif̂AŏɌ̂ԂB̂݁BqɑΉB
            private LogicalLine findIf(LogicalLine current)
            {
                LogicalLine next = current;
                while (true)
                {
                    next = next.NextLine;
                    if (next == null)
                        throw new ExeEE("IFTɒvIG[");
                    if (next is NullLine)
                        return next;//t@Cn[͏I[ɓB
                    if (next is FunctionLabelLine)
                        return next;//֐̃XR[v̊O֏oĂ܂
                    if (!(next is InstructionLine))
                        continue;
                    switch (((InstructionLine)next).Function)
                    {
                        case BuiltInFunctionCode.ELSE:
                        case BuiltInFunctionCode.ELSEIF:
                        case BuiltInFunctionCode.ENDIF:
                            return next;
                        case BuiltInFunctionCode.IF://qIF
                            next = findEndif(next);
                            if (!(next is InstructionLine))
                                return next;
                            break;
                    }
                }
            }

            ///endifԂB̂݁BqɑΉ
            private LogicalLine findEndif(LogicalLine current)
            {
                LogicalLine next = current;
                while (true)
                {
                    next = next.NextLine;
                    if (next == null)
                        throw new ExeEE("");
                    if (next is NullLine)
                        return next;//t@Cn[͏I[ɓB
                    if (next is FunctionLabelLine)
                        return next;//֐̃XR[v̊O֏oĂ܂
                    if (!(next is InstructionLine))
                        continue;
                    switch (((InstructionLine)next).Function)
                    {
                        case BuiltInFunctionCode.ENDIF:
                            return next;
                        case BuiltInFunctionCode.IF://qIF
                            next = findEndif(next);
                            if (!(next is InstructionLine))
                                return next;
                            break;
                    }
                }
            }

            private LogicalLine findFunction(LogicalLine current, BuiltInFunctionCode findKey, bool downSearch)
            {
                LogicalLine next = current;
                while (true)
                {
                    if (downSearch)
                        next = next.NextLine;
                    else
                        next = next.PrevLine;
                    if (next == null)
                        throw new ExeEE("");
                    if (next is NullLine)
                        return next;//t@Cn[͏I[ɓB
                    if (next is FunctionLabelLine)
                        return next;//֐̃XR[v̊O֏oĂ܂
                    if (!(next is InstructionLine))
                        continue;
                    if (((InstructionLine)next).Function == findKey)
                        return next;
                }
            }
        }
    }
}
