using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Text.RegularExpressions;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameData;
using MinorShift.Emuera.GameView;
using MinorShift.Emuera.GameData.Expression;
using MinorShift.Emuera.GameData.Variable;
namespace MinorShift.Emuera.GameProc
{
	internal enum ArgumentType
	{
		NULL = 0,
		VOID = BuiltInFunctionCode.__ARG_VOID__,//void
		INT_EXPRESSION = BuiltInFunctionCode.__ARG_INT_EXPRESSION__,//^
		STR_EXPRESSION = BuiltInFunctionCode.__ARG_STR_EXPRESSION__,//񎮌^
		STR = BuiltInFunctionCode.__ARG_STR__,//P^
		FORM_STR = BuiltInFunctionCode.__ARG_FORM_STR__,//t^
		SP_PRINTV = BuiltInFunctionCode.__ARG_SP_PRINTV__,//^B'``,
		SP_TIMES = BuiltInFunctionCode.__ARG_SP_TIMES__,//lϐE^B
		SP_BAR = BuiltInFunctionCode.__ARG_SP_BAR__,//EE^
		SP_SET = BuiltInFunctionCode.__ARG_SP_SET__,//ϐlϐE^B
		SP_SETS = BuiltInFunctionCode.__ARG_SP_SETS__,//ϕϐEP^B
		__MASK__ = unchecked((int)0x7FF00000),
	}
	internal abstract class Argument
	{
		//ArgumentType type = (ArgumentType)((int)ArgumentType.__MASK__ & (int)func);
	}

	internal sealed class VoidArgument : Argument
	{
		public VoidArgument() { }
	}

	internal sealed class ExpressionArgument : Argument
	{
		public ExpressionArgument(IOperandTerm termSrc)
		{
			Term = termSrc;
		}
		readonly public IOperandTerm Term;
	}

	internal sealed class StrArgument : Argument
	{
		public StrArgument(string str)
		{
			Str = str;
		}
		readonly public string Str;
	}

	internal sealed class FormStrArgument : Argument
	{
		public FormStrArgument(StringForm strform)
		{
			StrForm = strform;
		}
		readonly public StringForm StrForm;
	}


	internal sealed class SpPrintVArgument : Argument
	{
		public SpPrintVArgument(List<IOperandTerm> list)
		{
			Terms = list;
		}
		readonly public List<IOperandTerm> Terms;
	}

	internal sealed class SpTimesArgument : Argument
	{
		public SpTimesArgument(VariableToken var, double d)
		{
			VariableDest = var;
			DoubleValue = d;
		}
		readonly public VariableToken VariableDest;
		readonly public double DoubleValue;
	}

	internal sealed class SpBarArgument : Argument
	{
		public SpBarArgument(IOperandTerm value, IOperandTerm max, IOperandTerm length)
		{
			Terms[0] = value;
			Terms[1] = max;
			Terms[2] = length;
		}
		readonly public IOperandTerm[] Terms = new IOperandTerm[3];
	}

	internal sealed class SpSetArgument : Argument
	{
		public SpSetArgument(VariableToken var, IOperandTerm termSrc)
		{
			VariableDest = var;
			Term = termSrc;
		}
		readonly public VariableToken VariableDest;
		readonly public IOperandTerm Term;
	}

	internal sealed class SpSetsArgument : Argument
	{
		public SpSetsArgument(VariableToken var, StringForm strform)
		{
			VariableDest = var;
			StrForm = strform;
		}
		readonly public VariableToken VariableDest;
		readonly public StringForm StrForm;
	}
}
