using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Windows.Forms;
using System.Drawing;
using MinorShift.Emuera.Sub;

namespace MinorShift.Emuera
{
    //internal enum HandlingOverflow
    //{
    //    CHECKED = 0,
    //    UNCHECKED = 1,
    //    EXCEPTION = 2,
    //}

    internal enum DisplayWarningFlag
    {
        IGNORE = 0,
        LATER = 1,
        ONCE = 2,
        DISPLAY = 3,
    }

    /// <summary>
    /// vOŜŎgplWindow쐬Oɐݒ肵ĈȌύXȂ
    /// </summary>
    internal static class Config
    {
        static Config()
        {
        }
        private static bool ignoreCase = true;
        private static bool useRenameFile = false;
        private static bool useMouse = true;
        private static bool useMenu = true;
        private static bool useDebugCommand = false;
        private static bool allowMultipleInstances = true;
        private static bool autoSave = true;
        private static bool sizableWindow = true;

        private static int windowX = 760;
        private static int windowY = 480;
        private static int maxLog = 5000;
        private static int printCPerLine = 3;
        private static int printCLength = 25;
        private static Color foreColor = Color.FromArgb(192, 192, 192);//LIGHTGRAY
        private static Color backColor = Color.FromArgb(0, 0, 0);//BLACK
        private static Color focusColor = Color.FromArgb(255, 255, 0);//YELLOW
        private static Color logColor = Color.FromArgb(192, 192, 192);//LIGHTGRAY//Color.FromArgb(128, 128, 128);//GRAY
        private static Font font = new Font("lr SVbN", 18.0f, GraphicsUnit.Pixel);
        private static int lineHeight = 19;
        private static int fps = 15;
        private static int skipFrame = 3;

        private static int displayWarningLevel = 1;
        private static bool displayReport = false;
        private static bool reduceArgumentOnLoad = false;
        private static bool reduceFormattedStringOnLoad = true;
        private static bool ignoreUncalledFunction = true;
        private static DisplayWarningFlag functionNotFoundWarning = DisplayWarningFlag.IGNORE;
        private static DisplayWarningFlag functionNotCalledWarning = DisplayWarningFlag.IGNORE;
        private static List<string> ignoreWarningFiles = new List<string>();


        private static bool changeMasterNameIfDebug = true;//{̃CJT}B݂Ȃɂ͂Ȃ傾
        public static bool ChangeMasterNameIfDebug { get { return Config.changeMasterNameIfDebug; } }

        public readonly static Encoding Encode = Encoding.GetEncoding("SHIFT-JIS");

        public static bool IgnoreCase { get { return Config.ignoreCase; } }
        public static bool UseRenameFile { get { return Config.useRenameFile; } }
        public static bool UseMouse { get { return Config.useMouse; } }
        public static bool UseMenu { get { return Config.useMenu; } }
        public static bool UseDebugCommand { get { return Config.useDebugCommand; } }
        public static bool AllowMultipleInstances { get { return Config.allowMultipleInstances; } }
        public static bool AutoSave { get { return Config.autoSave; } }
        public static bool SizableWindow { get { return Config.sizableWindow; } }
        public static int WindowX { get { return Config.windowX; } }
        public static int WindowY { get { return Config.windowY; } }
        public static int MaxLog { get { return Config.maxLog; } }
        public static int PrintCPerLine { get { return Config.printCPerLine; } }
        public static int PrintCLength { get { return Config.printCLength; } }
        public static Color ForeColor { get { return Config.foreColor; } }
        public static Color BackColor { get { return Config.backColor; } }
        public static Color FocusColor { get { return Config.focusColor; } }
        public static Color LogColor { get { return Config.logColor; } }
        public static Font Font { get { return Config.font; } }
        public static int LineHeight { get { return Config.lineHeight; } }
        public static int FPS { get { return Config.fps; } }
        public static int SkipFrame { get { return Config.skipFrame; } }

        public static int DisplayWarningLevel { get { return Config.displayWarningLevel; } }
        public static bool DisplayReport { get { return Config.displayReport; } }
        public static bool ReduceArgumentOnLoad { get { return Config.reduceArgumentOnLoad; } }
        public static bool ReduceFormattedStringOnLoad { get { return Config.reduceFormattedStringOnLoad; } }
        public static bool IgnoreUncalledFunction { get { return Config.ignoreUncalledFunction; } }
        public static DisplayWarningFlag FunctionNotFoundWarning { get { return Config.functionNotFoundWarning; } }
        public static DisplayWarningFlag FunctionNotCalledWarning { get { return Config.functionNotCalledWarning; } }
        public static List<string> IgnoreWarningFiles { get { return Config.ignoreWarningFiles; } }



        public static bool LoadConfig(string confPath)
        {
            if (!File.Exists(confPath))
            {
                if (!CreateConfig(confPath))
                {
                    MessageBox.Show("RtBOt@Cǂݍ߂܂ł", "s");
                    return false;
                }
            }
            string FontName = "lr SVbN";
            float FontSize = 18.0f;

            EraStreamReader eReader = new EraStreamReader();
            if (!eReader.Open(confPath))
                return false;
            try
            {
                string line = null;
                while ((line = eReader.ReadLine()) != null)
                {
                    if ((line.Length == 0) || (line[0] == ';'))
                        continue;
                    string[] tokens = line.Split(new char[] { ',', ':' });
                    if (tokens.Length < 2)
                        continue;
                    string param = tokens[1].Trim();
                    double d = 0.0;
                    switch (tokens[0])
                    {
                        case "IgnoreCase":
                        case "啶̈Ⴂ𖳎":
                            tryStringToBool(param, ref ignoreCase);
                            break;
                        case "UseRenameFile":
                        case "_Rename.csv𗘗p":
                            tryStringToBool(param, ref useRenameFile);
                            break;
                        case "UseMouse":
                        case "}EXgp":
                            tryStringToBool(param, ref useMouse);
                            break;
                        case "UseMenu":
                        case "j[gp":
                            tryStringToBool(param, ref useMenu);
                            break;
                        case "UseDebugCommand":
                        case "fobOR}hgp":
                            tryStringToBool(param, ref useDebugCommand);
                            break;
                        case "AllowMultipleInstances":
                        case "dN":
                            tryStringToBool(param, ref allowMultipleInstances);
                            break;
                        case "AutoSave":
                        case "I[gZ[usȂ":
                            tryStringToBool(param, ref autoSave);
                            break;
                        case "SizableWindow":
                        case "EBhE̍ςɂ":
                            tryStringToBool(param, ref sizableWindow);
                            break;
                        case "WindowX":
                        case "EBhE":
                            Int32.TryParse(param, out windowX);
                            if (windowX < 160)
                                windowX = 160;
                            break;
                        case "WindowY":
                        case "EBhE":
                            Int32.TryParse(param, out windowY);
                            if (windowY < 120)
                                windowY = 120;
                            break;
                        case "MaxLog":
                        case "O̍s":
                            Int32.TryParse(param, out maxLog);
                            if (maxLog < 20)
                                maxLog = 20;
                            break;
                        case "PrintCPerLine":
                        case "PRINTCׂ鐔":
                            Int32.TryParse(param, out printCPerLine);
                            if (printCPerLine < 1)
                                printCPerLine = 1;
                            break;
                        case "PrintCLength":
                        case "PRINTC̕":
                            Int32.TryParse(param, out printCLength);
                            if (printCLength < 5)
                                printCLength = 5;
                            break;
                        case "FontName":
                        case "tHg":
                            FontName = tokens[1];
                            break;
                        case "FontSize":
                        case "tHgTCY":
                            Double.TryParse(param, out d);
                            if (d < 4.0)
                                break;
                            FontSize = (float)d;
                            break;
                        case "LineHeight":
                        case "s̍":
                            Double.TryParse(param, out d);
                            if (d < 4.0)
                                break;
                            lineHeight = (int)d;
                            break;
                        case "BackColor":
                        case "wiF":
                            tryStringsToColor(tokens, ref backColor);
                            break;
                        case "ForeColor":
                        case "F":
                            tryStringsToColor(tokens, ref foreColor);
                            break;
                        case "FocusColor":
                        case "I𒆕F":
                            tryStringsToColor(tokens, ref focusColor);
                            break;
                        case "LogColor":
                        case "𕶎F":
                            tryStringsToColor(tokens, ref logColor);
                            break;
                        case "FPS":
                        case "t[b":
                            Int32.TryParse(param, out fps);
                            break;
                        case "SkipFrame":
                        case "őXLbvt[":
                            Int32.TryParse(param, out skipFrame);
                            break;
                        case "DisplayWarningLevel":
                        case "\Œxx":
                            Int32.TryParse(param, out displayWarningLevel);
                            break;
                        case "DisplayReport":
                        case "[hɃ|[g\":
                            tryStringToBool(param, ref displayReport);
                            break;
                        case "ReduceArgumentOnLoad":
                        case "[hɈ͂":
                            tryStringToBool(param, ref reduceArgumentOnLoad);
                            break;
                        case "ReduceFormattedStringOnLoad":
                        case "[hFORM͂":
                            tryStringToBool(param, ref reduceFormattedStringOnLoad);
                            break;
                        case "IgnoreUncalledFunction":
                        case "ĂяoȂ֐𖳎":
                            tryStringToBool(param, ref ignoreUncalledFunction);
                            break;

                        case "FunctionNotFoundWarning":
                        case "֐Ȃẍ":
                            param = param.ToUpper();
                            if (!Enum.IsDefined(typeof(DisplayWarningFlag), param))
                                break;
                            functionNotFoundWarning = (DisplayWarningFlag)Enum.Parse(typeof(DisplayWarningFlag), param);
                            break;
                        case "FunctionNotCalledWarning":
                        case "֐ĂяoȂẍ":
                            param = param.ToUpper();
                            if (!Enum.IsDefined(typeof(DisplayWarningFlag), param))
                                break;
                            functionNotCalledWarning = (DisplayWarningFlag)Enum.Parse(typeof(DisplayWarningFlag), param);
                            break;
                        case "IgnoreWarningFile":
                        case "w肵t@Čx𖳎":
                            param = param.ToUpper();
                            if ((param.Length != 0) && (!ignoreWarningFiles.Contains(param)))
                                ignoreWarningFiles.Add(param);
                            break;

                        case "ChangeMasterNameIfDebug":
                        case "fobOR}hgpMASTER̖OύX":
                            tryStringToBool(param, ref changeMasterNameIfDebug);
                            break;

                        case "":
                            break;
#if DEBUG
                        default:
                            throw new Exception("RtBOt@C");
#endif
                    }

                }
                if (lineHeight < FontSize)
                    lineHeight = (int)FontSize;
                if (font != null)
                    font.Dispose();
                font = new Font(FontName, FontSize, GraphicsUnit.Pixel);
            }
            catch
            {
                return false;
            }
            finally
            {
                eReader.Dispose();
            }
            return true;
        }

        public static string boolToString(bool p)
        {
            if (p)
                return "YES";
            return "NO";
        }

        public static bool tryStringToBool(string str, ref bool p)
        {
            if (str == null)
                return false;
            int i = 0;
            if (Int32.TryParse(str, out i))
            {
                p = (i != 0);
                return true;
            }
            if (str.Equals("NO", StringComparison.CurrentCultureIgnoreCase)
                || str.Equals("FALSE", StringComparison.CurrentCultureIgnoreCase))
            {
                p = false;
                return true;
            }
            if (str.Equals("YES", StringComparison.CurrentCultureIgnoreCase)
                || str.Equals("TRUE", StringComparison.CurrentCultureIgnoreCase))
            {
                p = true;
                return true;
            }
            return false;
        }

        public static string colorToString(Color c)
        {
            return string.Format("{0},{1},{2}", c.R, c.G, c.B);
        }
        public static bool tryStringsToColor(string[] tokens, ref Color c)
        {
            int r, g, b;
            if (tokens.Length < 4)
                return false;
            if (!Int32.TryParse(tokens[1], out r) || (r < 0) || (r > 255))
                return false;
            if (!Int32.TryParse(tokens[2], out g) || (g < 0) || (g > 255))
                return false;
            if (!Int32.TryParse(tokens[3], out b) || (b < 0) || (b > 255))
                return false;
            c = Color.FromArgb(r, g, b);
            return true;
        }


        public static bool CreateConfig(string confPath)
        {
            StreamWriter writer = null;
            try
            {
                writer = new StreamWriter(confPath, false, Encode);
                writer.WriteLine("啶̈Ⴂ𖳎:" + boolToString(ignoreCase));
                writer.WriteLine("_Rename.csv𗘗p:" + boolToString(useRenameFile));
                writer.WriteLine("}EXgp:" + boolToString(useMouse));
                writer.WriteLine("j[gp:" + boolToString(useMenu));
                writer.WriteLine("fobOR}hgp:" + boolToString(useDebugCommand));
                writer.WriteLine("dN:" + boolToString(allowMultipleInstances));
                writer.WriteLine("I[gZ[usȂ:" + boolToString(autoSave));
                writer.WriteLine("EBhE̍ςɂ:" + boolToString(sizableWindow));
                writer.WriteLine("EBhE:" + windowX.ToString());
                writer.WriteLine("EBhE:" + windowY.ToString());
                writer.WriteLine("O̍s:" + maxLog.ToString());
                writer.WriteLine("PRINTCׂ鐔:" + printCPerLine.ToString());
                writer.WriteLine("PRINTC̕:" + printCLength.ToString());
                writer.WriteLine("tHg:" + font.Name);
                writer.WriteLine("tHgTCY:" + font.Size.ToString());
                writer.WriteLine("s̍:" + lineHeight.ToString());
                writer.WriteLine("wiF:" + colorToString(backColor));
                writer.WriteLine("F:" + colorToString(foreColor));
                writer.WriteLine("I𒆕F:" + colorToString(focusColor));
                writer.WriteLine("𕶎F:" + colorToString(logColor));
                writer.WriteLine("t[b:" + fps.ToString());
                writer.WriteLine("őXLbvt[:" + skipFrame.ToString());
                writer.WriteLine("\Œxx:" + displayWarningLevel.ToString());
                writer.WriteLine("[hɃ|[g\:" + boolToString(displayReport));
                writer.WriteLine("[hɈ͂:" + boolToString(reduceArgumentOnLoad));
                writer.WriteLine("[hFORM͂:" + boolToString(reduceFormattedStringOnLoad));
                writer.WriteLine("ĂяoȂ֐𖳎:" + boolToString(ignoreUncalledFunction));
                writer.WriteLine("֐Ȃẍ:" + functionNotFoundWarning.ToString());
                writer.WriteLine("֐ĂяoȂẍ:" + functionNotCalledWarning.ToString());
                foreach (string filename in ignoreWarningFiles)
                    writer.WriteLine("w肵t@Čx𖳎:" + filename);
                if (IgnoreWarningFiles.Count == 0)
                {
                    writer.WriteLine("w肵t@Čx𖳎:EVENT_K.ERB");
                    writer.WriteLine("w肵t@Čx𖳎:EVENT_K_DUMMY.ERB");
                }
            }
            catch (Exception)
            {
                return false;
            }
            finally
            {
                if (writer != null)
                    writer.Close();
            }
            return true;
        }
    }
}
