package elazyrest.twitter.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import elazyrest.core.util.DateUtil;

public class TwitterDateUtil extends DateUtil{
	private static SimpleDateFormat twitterDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss Z yyyy", Locale.US);
	
	public static String format(Date date) {
		if (date == null) {
			date = new Date();
		}
		return twitterDateFormat.format(date);
	}

	public static Date parse(String date) throws ParseException {
		if (date == null) {
			return null;
		}
		return twitterDateFormat.parse(date);
	}
	

}
