package elazyrest.twitter.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.List;
import java.util.Properties;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

import elazyrest.i18n.MessageResourceBundle;
import elazyrest.i18n.ResourceBundleEx;
import elazyrest.core.annotation.RestMethod;
import elazyrest.core.annotation.RestParam;
import elazyrest.core.annotation.SimpleXml;
import elazyrest.core.exception.ResponseCodeException;
import elazyrest.core.provider.PropertiesLoader;
import elazyrest.ext.hibernate.HibernateUse;
import elazyrest.ext.hibernate.HibernateUtil;
import elazyrest.twitter.auth.BasicAuthUse;
import elazyrest.twitter.auth.BasicAuthUtil;
import elazyrest.twitter.auth.BasicAuthenticator;
import elazyrest.twitter.constant.Globals;
import elazyrest.twitter.db.FriendsTimelineTbl;
import elazyrest.twitter.db.FriendsTimelineTblId;
import elazyrest.twitter.util.TwitterDateUtil;
import elazyrest.twitter.xml.statuses.Status;
import elazyrest.twitter.xml.statuses.Statuses;
import elazyrest.twitter.xml.statuses.User;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;


/**
 * 
 * @author kaz
 *
 */
@SimpleXml
@BasicAuthUse
@HibernateUse
public class TwitterService {
	private static Log log = LogFactory.getLog(TwitterService.class);
	
	private static MessageResourceBundle messageResource
	= new MessageResourceBundle(ResourceBundleEx.getBundle("resources/validator_resource"));
	
	public final static String FRIEND_TIMELINE_ENDPOINT;
	static {
		// get properties
		Properties props = PropertiesLoader.get(Globals.APP_CONFIG);
		
		FRIEND_TIMELINE_ENDPOINT = props.getProperty("twitter_api.root") +"statuses/friends_timeline.xml?";	
	}
	
	@RestMethod("GET")
	@SuppressWarnings("unchecked")
	public Statuses friendTimeline(
			@RestParam(name="page") Integer page,
			@RestParam(name="num") Integer num
			)
	{
		
		// get new friends timeline
		updateFriendTimeline();
		
		Session session = HibernateUtil.currentSession();
		
		BasicAuthenticator authenticator = BasicAuthUtil.getAuthenticator();
		String twitterId = authenticator.getUsername();
		
		// order by createAt
		Criteria criteria = session.createCriteria(FriendsTimelineTbl.class)
								.add(Restrictions.eq("id.twitterId", twitterId))
								.addOrder(Order.desc("createAt"));
//		Criteria countCriteria = session.createCriteria(FriendsTimelineTbl.class)
//								.add(Restrictions.eq("id.twitterId", twitterId));
	
		//  100ȏ͋Ȃ
		if (num == null || num <= 0 || num > 100) {
			num = 20; //default
		}
		criteria.setMaxResults(num);
		
		// Jns
		if (page != null) {
			criteria.setFirstResult((page-1) * num);
		}
	
		criteria.setMaxResults(num);
	
		
		List<FriendsTimelineTbl> friendsTimeLineTblList = criteria.list();
	
		// DB to XML
		elazyrest.twitter.xml.statuses.ObjectFactory of = new elazyrest.twitter.xml.statuses.ObjectFactory();
		Statuses statuses = of.createStatuses();
		
		if (friendsTimeLineTblList.isEmpty()) {
			return statuses;
		}

		List<Status> statusList = statuses.getStatus();
	
		for(FriendsTimelineTbl friendsTimeLineTbl : friendsTimeLineTblList) {
			//status
			elazyrest.twitter.xml.statuses.Status status = of.createStatus();
			status.setCreatedAt(TwitterDateUtil.format(friendsTimeLineTbl.getCreateAt()));
			FriendsTimelineTblId friendsTimeLineTblId = friendsTimeLineTbl.getId();  
			status.setId(friendsTimeLineTblId.getId());
			status.setInReplyToStatusId(friendsTimeLineTbl.getInReplyToStatusId());
			status.setInReplyToUserId(friendsTimeLineTbl.getInReplyToUserId());
			status.setSource(friendsTimeLineTbl.getSource());
			status.setText(friendsTimeLineTbl.getText());
			status.setTruncated(friendsTimeLineTbl.getTruncated());
			status.setFavorited(friendsTimeLineTbl.getFavorited());
			
			//user
			User user = of.createUser();
			user.setDescription(friendsTimeLineTbl.getUserDescription());
			user.setFollowersCount(friendsTimeLineTbl.getUserFollowersCount());
			user.setId(friendsTimeLineTbl.getUserId());
			user.setLocation(friendsTimeLineTbl.getUserLocation());
			user.setName(friendsTimeLineTbl.getUserName());
			user.setProfileImageUrl(friendsTimeLineTbl.getUserProfileImageUrl());
			user.setProtected(friendsTimeLineTbl.getUserProtected());
			user.setScreenName(friendsTimeLineTbl.getUserScreenName());
			user.setUrl(friendsTimeLineTbl.getUserUrl());
	
			status.setUser(user);
			statusList.add(status);
		}
		return statuses;
	}
	
	public void updateFriendTimeline() {
		Session session = HibernateUtil.currentSession();
	
		BasicAuthenticator authenticator = BasicAuthUtil.getAuthenticator();
		
		String twitterId = authenticator.getUsername();
		
		java.util.Date lastCreateAt = (java.util.Date)session.createCriteria(FriendsTimelineTbl.class)
								.add(Restrictions.eq("id.twitterId", twitterId))
								.addOrder(Order.desc("createAt"))
								.setProjection(Projections.property("createAt"))
								.setMaxResults(1)
								.uniqueResult();
	
		String friend_timeline_url = FRIEND_TIMELINE_ENDPOINT;
		if (lastCreateAt != null) {
			try {
				friend_timeline_url += "since=" +URLEncoder.encode(TwitterDateUtil.format(lastCreateAt), "UTF-8");
			}
			catch (UnsupportedEncodingException e) {
				log.error(e);
			}

		}
		
		Statuses statuses = null;
		
		try {
			// get friends_timeline
	        URL url = new URL(friend_timeline_url);
	        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
	        urlConnection.setRequestProperty("Authorization", authenticator.getCredential());
			urlConnection.setRequestMethod("GET");
			
	        urlConnection.connect();

	        int responseCode = urlConnection.getResponseCode();
	        // no new data
	        if (responseCode == 304) {
	        	return;
	        }
	        else if (responseCode != 200) {
				urlConnection.disconnect();
				throw new ResponseCodeException(responseCode);
			}
	        InputStream is = urlConnection.getInputStream();
	
			JAXBContext context = JAXBContext.newInstance(Statuses.class.getPackage().getName());
			Unmarshaller unmarshaller = context.createUnmarshaller();
			 
			JAXBElement<Statuses> jaxbElement = (JAXBElement<Statuses>)unmarshaller.unmarshal(is);
			statuses = jaxbElement.getValue();
			
	    	// release
			is.close();
			urlConnection.disconnect();
		}
		catch (MalformedURLException e) {
			throw new RuntimeException(e);
		}
		catch (IOException e) {
			throw new RuntimeException(e);
		}
		catch (JAXBException e) {
			throw new RuntimeException(e);
		}

		Transaction transaction = HibernateUtil.beginTransaction();

		// friend_timeline to db
		List<Status> statusList = statuses.getStatus();
		//java.util.Date now = new java.util.Date();
		
		for (Status status : statusList) {
			FriendsTimelineTblId friendTimeLineTblId = new FriendsTimelineTblId(twitterId, status.getId()); 
			FriendsTimelineTbl friendTimeLineTbl = new FriendsTimelineTbl();
			friendTimeLineTbl.setId(friendTimeLineTblId);
			try {
				friendTimeLineTbl.setCreateAt(TwitterDateUtil.parse(status.getCreatedAt()));
			}
			catch (ParseException e) {
				e.printStackTrace();
			}
			friendTimeLineTbl.setInReplyToStatusId(status.getInReplyToStatusId());
			friendTimeLineTbl.setInReplyToUserId(status.getInReplyToUserId());
			friendTimeLineTbl.setSource(status.getSource());
			friendTimeLineTbl.setText(status.getText());
			friendTimeLineTbl.setTruncated(status.getTruncated());
			friendTimeLineTbl.setFavorited(status.getFavorited());
			friendTimeLineTbl.setUserDescription(status.getUser().getDescription());
			friendTimeLineTbl.setUserFollowersCount(status.getUser().getFollowersCount());
			friendTimeLineTbl.setUserId(status.getUser().getId());
			friendTimeLineTbl.setUserLocation(status.getUser().getLocation());
			friendTimeLineTbl.setUserName(status.getUser().getName());
			friendTimeLineTbl.setUserProfileImageUrl(status.getUser().getProfileImageUrl());
			friendTimeLineTbl.setUserProtected(status.getUser().getProtected());
			friendTimeLineTbl.setUserScreenName(status.getUser().getScreenName());
			friendTimeLineTbl.setUserUrl(status.getUser().getUrl());

			session.save(friendTimeLineTbl);
		}
		transaction.commit();
	}
}
