/**
 * 
 */
package elazyrest.twitter.auth;

import java.io.IOException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BasicAuthUtil {

	private static Log log = LogFactory.getLog(BasicAuthUtil.class);

//    private static BasicAuthUtil _instance = new BasicAuthUtil();
    private BasicAuthUtil() {}
//    public static BasicAuthUtil getInstance() {return _instance;} 

    private static final ThreadLocal<BasicAuthenticator> authenticator = new ThreadLocal<BasicAuthenticator>();

    public static BasicAuthenticator getAuthenticator() {
    	return (BasicAuthenticator) authenticator.get();
    }
    
    public static void clear() {
    	authenticator.set(null);
    }
    
    public static boolean setCredential(String credential) throws IOException{
        if (credential == null || credential.length() == 0) {
        	return false;
        }

        if (!credential.toUpperCase().startsWith("BASIC ")) {
        	return false;
        }

        // "BASIC "
        String userpass = credential.substring(6);

        sun.misc.BASE64Decoder dec = new sun.misc.BASE64Decoder();
        String userpassDecoded = new String(dec.decodeBuffer(userpass));
        String[] userinfo = userpassDecoded.split(":");
        if (userinfo.length != 2) {
        	return false;
        }
        else {
        	BasicAuthenticator basicAuthenticator = new BasicAuthenticator(userinfo[0], userinfo[1]);
        	authenticator.set(basicAuthenticator);
        	return true;
        }

      }
}