/**
 * 
 */
package elazyrest.twitter.auth;

import java.io.IOException;
import java.lang.annotation.Annotation;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import elazyrest.core.aspect.AspectBase;
import elazyrest.core.aspect.AspectChain;
import elazyrest.core.exception.AuthenticationErrorException;
import elazyrest.core.exception.ResponseCodeException;

/**
 * @author kaz
 *
 */
public class BasicAuthAspect extends AspectBase {
	
	private static Log log = LogFactory.getLog(BasicAuthAspect.class);
	
	@Override
	protected void afterService(HttpServletRequest req, HttpServletResponse res, AspectChain chain, Annotation methodAnnotation) throws IOException{
		BasicAuthUtil.clear();
	}

	@Override
	protected void beforeService(HttpServletRequest req, HttpServletResponse res, AspectChain chain, Annotation methodAnnotation) throws IOException{

		String credential = req.getHeader("Authorization");
		//BasicAuthUtil.setCredential(credential);
		
		if (!BasicAuthUtil.setCredential(credential)) {
			res.setHeader("WWW-Authenticate", "BASIC realm=\"twitter proxy\"");
			//res.sendError(HttpServletResponse.SC_UNAUTHORIZED);
			throw new ResponseCodeException(HttpServletResponse.SC_UNAUTHORIZED);
		 }
	}

	@Override
	protected void onException(HttpServletRequest req, HttpServletResponse res, AspectChain chain, Annotation methodAnnotation, Exception e) throws IOException{
		BasicAuthUtil.clear();
		if (e instanceof ResponseCodeException) {
			ResponseCodeException re = (ResponseCodeException)e;
			if (re.getResponseCode() == HttpServletResponse.SC_UNAUTHORIZED) {
				res.setHeader("WWW-Authenticate", "BASIC realm=\"twitter proxy\"");
				//res.sendError(HttpServletResponse.SC_UNAUTHORIZED);
			}
		}
	}
}
