/*
 * Decompiled with CFR 0.152.
 */
package elazyrest.core.servlet;

import elazyrest.core.annotation.Aspect;
import elazyrest.core.annotation.RestMethod;
import elazyrest.core.annotation.RestParam;
import elazyrest.core.annotation.SimpleXml;
import elazyrest.core.aspect.AspectBase;
import elazyrest.core.aspect.AspectChain;
import elazyrest.core.exception.AuthenticationErrorException;
import elazyrest.core.exception.AuthorizationRequiredException;
import elazyrest.core.exception.DataEmptyException;
import elazyrest.core.exception.DuplicationException;
import elazyrest.core.exception.ForbiddenException;
import elazyrest.core.exception.InternalServerErrorException;
import elazyrest.core.exception.InvalidParameterException;
import elazyrest.core.exception.NotSupportedMethodException;
import elazyrest.core.exception.NotSupportedOperationException;
import elazyrest.core.exception.ResponseCodeException;
import elazyrest.core.provider.InstanceProvider;
import elazyrest.core.provider.SingletonProvider;
import elazyrest.core.provider.ThreadLocalProvider;
import elazyrest.core.util.AppContext;
import elazyrest.core.util.JaxbUtil;
import elazyrest.core.util.ResponseGen;
import elazyrest.core.validator.RestParamErrors;
import elazyrest.core.validator.RestParamValidator;
import elazyrest.core.validator.RestParamValidatorException;
import generator.DocGen;
import generator.ResourceGen;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.net.InetAddress;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RestServlet
extends HttpServlet {
    private static Log log = LogFactory.getLog(RestServlet.class);
    private String requestEncoding = "UTF-8";
    private String responseEncoding = "UTF-8";
    private String rootPackage = null;
    protected InstanceProvider instanceProvider = new InstanceProvider();
    protected SingletonProvider singletonProvider = new SingletonProvider();
    private static final long serialVersionUID = 6807245574600933798L;

    public void init(ServletConfig sc) throws ServletException {
        if (sc.getInitParameter("requestEncoding") != null) {
            this.requestEncoding = sc.getInitParameter("requestEncoding");
        }
        if (sc.getInitParameter("responseEncoding") != null) {
            this.responseEncoding = sc.getInitParameter("responseEncoding");
        }
        this.rootPackage = sc.getInitParameter("package");
        String docGenStr = sc.getInitParameter("docgen");
        if (docGenStr == null || docGenStr.equals("true")) {
            try {
                String docRoot = sc.getServletContext().getRealPath("");
                String contextPath = docRoot.substring(docRoot.lastIndexOf(System.getProperty("file.separator")) + 1);
                InetAddress inet = InetAddress.getLocalHost();
                String endPoint = "http://" + inet.getHostAddress() + ":8080/" + contextPath + "/" + sc.getServletName();
                DocGen docGen = new DocGen(this.rootPackage, String.valueOf(docRoot) + "/services", endPoint);
                docGen.generate();
                ResourceGen resourceGen = new ResourceGen();
                resourceGen.generate(this.rootPackage, String.valueOf(docRoot) + "/../src/main/resources/");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.init(sc);
    }

    public void destroy() {
        this.instanceProvider.clear();
        SingletonProvider.clear();
        ThreadLocalProvider.clear();
        this.rootPackage = null;
        super.destroy();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Object resultData;
        String method;
        RestParamErrors errors;
        String responseType;
        boolean isBinary;
        AppContext appContext;
        String requestMethod;
        block62: {
            req.setCharacterEncoding(this.requestEncoding);
            res.setCharacterEncoding(this.responseEncoding);
            requestMethod = req.getMethod();
            appContext = new AppContext();
            appContext.setRequest(req);
            appContext.setResponse(res);
            AppContext.setCurrentContext(appContext);
            isBinary = false;
            responseType = null;
            errors = new RestParamErrors();
            responseType = appContext.getParameter("response_type");
            method = appContext.getParameter("method");
            if (method != null && method.length() > 0) break block62;
            res.sendRedirect("services/index.html");
            return;
        }
        try {
            try {
                int lastIndex = method.lastIndexOf(".");
                String className = this.rootPackage != null && this.rootPackage.length() > 0 ? String.valueOf(this.rootPackage) + "." + method.substring(0, lastIndex) : method.substring(0, lastIndex);
                String methodName = method.substring(lastIndex + 1);
                Class<?> cl = Class.forName(className);
                if (!cl.isAnnotationPresent(SimpleXml.class)) {
                    throw new NotSupportedMethodException(String.valueOf(cl.getName()) + "is not SimpleXml Class.");
                }
                Method[] ms = cl.getMethods();
                AccessibleObject targetMethod = null;
                Method[] methodArray = ms;
                int n = 0;
                int n2 = methodArray.length;
                while (n < n2) {
                    Method m = methodArray[n];
                    if (m.getName().equals(methodName)) {
                        targetMethod = m;
                        break;
                    }
                    ++n;
                }
                if (targetMethod == null || !targetMethod.isAnnotationPresent(RestMethod.class)) {
                    throw new NotSupportedMethodException(String.valueOf(methodName) + " is not RestMethod.");
                }
                String contentType = ((Method)targetMethod).getAnnotation(RestMethod.class).contentType();
                res.setContentType(contentType);
                String charset = ((Method)targetMethod).getAnnotation(RestMethod.class).responseEncoding();
                if (charset.length() > 0) {
                    res.setCharacterEncoding(charset);
                }
                String[] allowMethods = ((Method)targetMethod).getAnnotation(RestMethod.class).value();
                boolean isAccessible = false;
                String[] stringArray = allowMethods;
                int n3 = 0;
                int n4 = stringArray.length;
                while (n3 < n4) {
                    String allowMethod = stringArray[n3];
                    if (allowMethod.equals(requestMethod)) {
                        isAccessible = true;
                        break;
                    }
                    ++n3;
                }
                if (!isAccessible) {
                    throw new NotSupportedOperationException();
                }
                Class<?>[] paramTypes = ((Method)targetMethod).getParameterTypes();
                Object[] params = new Object[paramTypes.length];
                Annotation[][] paramAnnotation = ((Method)targetMethod).getParameterAnnotations();
                int i = 0;
                while (i < paramAnnotation.length) {
                    int j = 0;
                    while (j < paramAnnotation[i].length) {
                        if (paramAnnotation[i][j].annotationType() == RestParam.class) {
                            RestParam restParam = (RestParam)paramAnnotation[i][j];
                            String key = restParam.name();
                            String[] sufixs = restParam.suffix();
                            String[] val = null;
                            if (sufixs != null && sufixs.length > 0 && sufixs[0] != null && sufixs[0].length() > 0) {
                                val = new String[sufixs.length];
                                int si = 0;
                                while (si < sufixs.length) {
                                    val[si] = appContext.getParameter(String.valueOf(key) + sufixs[si]);
                                    ++si;
                                }
                            } else {
                                val = appContext.getParameters(key);
                                if ((val == null || val.length == 1 && (val[0] == null || val[0].length() == 0)) && restParam.def().length() > 0) {
                                    val = new String[]{restParam.def()};
                                }
                            }
                            if (appContext.isMultipart() && restParam.binary()) {
                                params[i] = appContext.getBytes(key);
                            } else if (val == null) {
                                params[i] = null;
                            } else if (val.length == 1) {
                                params[i] = val[0] != null && val[0].length() > 0 ? ConvertUtils.convert((String)val[0], paramTypes[i]) : null;
                            } else if (val.length > 1) {
                                params[i] = ConvertUtils.convert((String[])val, paramTypes[i]);
                            }
                            RestParamValidator.validate(method, params[i], restParam, errors);
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (!errors.isEmpty()) {
                    throw new RestParamValidatorException(errors);
                }
                boolean validateOnly = Boolean.parseBoolean(appContext.getParameter("validate"));
                if (validateOnly) {
                    resultData = ResponseGen.generateXML(0, null);
                } else {
                    Annotation[] methodAs;
                    Annotation[] as;
                    Object restService = SingletonProvider.get(cl);
                    AspectChain chain = new AspectChain();
                    chain.setMainMethod((Method)targetMethod, restService, params);
                    Annotation[] annotationArray = as = cl.getAnnotations();
                    int val = 0;
                    int n5 = annotationArray.length;
                    while (val < n5) {
                        Annotation a = annotationArray[val];
                        Class<? extends Annotation> aType = a.annotationType();
                        if (aType != null && aType.isAnnotationPresent(Aspect.class)) {
                            Aspect aspectType = aType.getAnnotation(Aspect.class);
                            Class<? extends AspectBase> aspectCl = aspectType.value();
                            AspectBase aspect = (AspectBase)this.instanceProvider.get(aspectCl);
                            chain.addAdvice(aspect, a);
                        }
                        ++val;
                    }
                    Annotation[] annotationArray2 = methodAs = targetMethod.getAnnotations();
                    n5 = 0;
                    int n6 = annotationArray2.length;
                    while (n5 < n6) {
                        Annotation methodA = annotationArray2[n5];
                        Class<? extends Annotation> aType = methodA.annotationType();
                        if (aType != null && aType.isAnnotationPresent(Aspect.class)) {
                            Aspect aspectType = aType.getAnnotation(Aspect.class);
                            Class<? extends AspectBase> aspectCl = aspectType.value();
                            AspectBase aspect = (AspectBase)this.instanceProvider.get(aspectCl);
                            chain.addAdvice(aspect, methodA);
                        }
                        ++n5;
                    }
                    resultData = chain.invoke();
                    if (resultData == null) {
                        resultData = "";
                    }
                    if (!(appContext.isBinary() || resultData.getClass().isAnnotationPresent(XmlType.class) || res.getContentType() == null || res.getContentType().equals("text/html"))) {
                        resultData = ResponseGen.generateXML(0, null, resultData.toString());
                    }
                }
            }
            catch (NotSupportedMethodException e) {
                resultData = ResponseGen.generateXML(8, e.getMessage(), null, errors);
            }
            catch (NotSupportedOperationException e) {
                resultData = ResponseGen.generateXML(9, e.getMessage(), null, errors);
            }
            catch (ResponseCodeException e) {
                log.warn((Object)e.toString());
                res.sendError(e.getResponseCode());
                return;
            }
            catch (RestParamValidatorException e) {
                resultData = ResponseGen.generateXML(1, e.getMessage(), null, errors);
            }
            catch (InvalidParameterException e) {
                resultData = ResponseGen.generateXML(1, "\u30d1\u30e9\u30e1\u30fc\u30bf\u30a8\u30e9\u30fc");
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
            catch (InternalServerErrorException e) {
                resultData = ResponseGen.generateXML(2, "\u30b5\u30fc\u30d0\u5185\u90e8\u30a8\u30e9\u30fc");
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (DataEmptyException e) {
                resultData = ResponseGen.generateXML(3, e.getMessage());
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
            catch (AuthorizationRequiredException e) {
                resultData = ResponseGen.generateXML(4, e.getMessage());
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
            catch (AuthenticationErrorException e) {
                resultData = ResponseGen.generateXML(5, e.getMessage());
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
            catch (DuplicationException e) {
                resultData = ResponseGen.generateXML(6, e.getMessage());
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
            catch (ForbiddenException e) {
                resultData = ResponseGen.generateXML(7, e.getMessage());
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                resultData = ResponseGen.generateXML(1, "\u30d1\u30e9\u30e1\u30fc\u30bf\u30a8\u30e9\u30fc");
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                resultData = ResponseGen.generateXML(1, "\u30d1\u30e9\u30e1\u30fc\u30bf\u30a8\u30e9\u30fc");
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (RuntimeException e) {
                resultData = ResponseGen.generateXML(2, "\u30b5\u30fc\u30d0\u5185\u90e8\u30a8\u30e9\u30fc");
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                resultData = ResponseGen.generateXML(2, "\u30b5\u30fc\u30d0\u5185\u90e8\u30a8\u30e9\u30fc");
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            isBinary = appContext.isBinary();
            AppContext.setCurrentContext(null);
        }
        if (isBinary) {
            ServletOutputStream os = res.getOutputStream();
            if (resultData != null) {
                byte[] bytes = (byte[])resultData;
                os.write(bytes, 0, bytes.length);
                os.close();
                return;
            } else {
                res.sendError(404);
            }
            return;
        } else if (resultData.getClass().isAnnotationPresent(XmlType.class)) {
            String resStr = "";
            if (responseType == null || responseType.equals("xml")) {
                resStr = JaxbUtil.object2Xml(resultData, appContext.getResponseEncoding());
            } else if (responseType.equals("vars")) {
                res.setContentType("text/plain");
                resStr = JaxbUtil.object2Html(resultData, "resources/xml2vars.xsl", appContext.getResponseEncoding());
            } else {
                resStr = JaxbUtil.object2Xml(resultData, appContext.getResponseEncoding());
            }
            PrintWriter pw = res.getWriter();
            pw.print(resStr);
            pw.flush();
            pw.close();
            return;
        } else {
            PrintWriter pw = res.getWriter();
            pw.print(resultData.toString());
            pw.flush();
            pw.close();
        }
    }
}

