/*
 * Decompiled with CFR 0.152.
 */
package elazyrest.core.aspect;

import elazyrest.core.aspect.AspectChain;
import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AspectBase {
    protected abstract void beforeService(HttpServletRequest var1, HttpServletResponse var2, AspectChain var3, Annotation var4) throws IOException;

    protected abstract void afterService(HttpServletRequest var1, HttpServletResponse var2, AspectChain var3, Annotation var4) throws IOException;

    protected abstract void onException(HttpServletRequest var1, HttpServletResponse var2, AspectChain var3, Annotation var4, Exception var5) throws IOException;

    public void doAdvice(HttpServletRequest req, HttpServletResponse res, AspectChain chain, Annotation methodAnnotation) throws IOException {
        try {
            this.beforeService(req, res, chain, methodAnnotation);
            chain.doAdvice();
            this.afterService(req, res, chain, methodAnnotation);
        }
        catch (RuntimeException e) {
            this.onException(req, res, chain, methodAnnotation, e);
            throw e;
        }
        catch (IOException e) {
            this.onException(req, res, chain, methodAnnotation, e);
            throw e;
        }
        catch (Exception e) {
            this.onException(req, res, chain, methodAnnotation, e);
            throw new RuntimeException(e);
        }
    }
}

