package org.j69.eewiki.wiki.tag;

import org.apache.oro.text.perl.Perl5Util;

import org.j69.eewiki.wiki.transformer.DataTag;

/**
 * Color Data Tag
 * @author <a href="mailto:masanori@mobster.jp">Masanori Hashimoto</a>
 * @version $Revision: 1.3 $ $Date: 2003/06/30 17:07:44 $
 */
public class SizeDataTag implements DataTag {

    private static final String REGULAR_EXPRESSION =
        "s!#Size\\(([^:]*):([^)]*)\\)!<font size=\\\"$1\\\">$2</font>!g";

    /**
     * @see jp.mobster.webapp.wiki.transform.DataTag#get()
     */
    public String get(String pageData) {
        Perl5Util perl = new Perl5Util();
        return perl.substitute(REGULAR_EXPRESSION, pageData);
    }

}
