/*
 * Created on 2003/06/15
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package org.j69.eewiki.wiki;

import java.io.File;
import java.io.IOException;
import java.util.Vector;

import org.apache.oro.text.perl.Perl5Util;
import org.j69.eewiki.util.CacheConfig;
import org.j69.eewiki.util.WebUtil;

/**
 * @author sally
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class WikiAttachment {

	// コンフィグ
	private final static CacheConfig config_ = CacheConfig.getInstance( );

	//Uploadディレクトリ
	private final static String UploadPath = config_.getConfig("define.wiki.basedir") + config_.getConfig("define.dir.upload");
	private final static String UploadURL = config_.getConfig("define.dir.upload");

	/**
	 * ページに紐づく添付ファイルリストの取得
	 * @return
	 */
	public static Vector getAttList(String pageData) throws IOException {
		Vector images = new Vector();
		Perl5Util util = new Perl5Util();
		
		if (pageData.equals(null) || pageData.equals(""))
			return null;
		
		String[] datas = pageData.split("\n");
		
		String data;
		String options;
		for (int i = 0; i < datas.length; i++) {
			data = datas[i];
			//#Imageの検索
			if (util.match("m!^#Image.+!", data)) {
				//オプションの取得
				if (util.match("m!.+\\(.+\\)!", data)) {
					options = util.substitute("s!.+\\((.+)\\)!$1!g", data);
				}
				else {
					options = "";
				}
				//ファイルサイズの取得
				if (!options.equals(null) && !options.equals("")) {
					//拡張子
					String suffix = options.substring(options.lastIndexOf(".") + 1);
					//Uploadディレクトリ名をコンフィグより取得し、物理ファイル名に変換
					String upfile = WebUtil.getEncodeFileName(options) + "." + suffix;
					String UploadFile = UploadPath + "/" + upfile;
					File file = new File(UploadFile);
					String fSize = Integer.toString((int)file.length()/1024 + 1);
					options = "<a href=\""+ UploadURL + "/" + upfile + "\">" + options + "</a>[" + fSize + "KB]";
				}
				images.add(options);
			}
		}				
		return images;
	}

	/**
	 * 添付ファイル一覧の取得
	 * @return
	 */
	public static Vector getAllList() {

		//添付ファイルディレクトリを指定してWikiListの作成
		WikiList wikilist = new WikiList(UploadPath);
		Vector datas = wikilist.getAttFiles("title");
		return datas;
	}
}
