/*
 * Created on 2003/06/25
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package org.j69.eewiki.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.CharacterCodingException;
import java.util.Vector;

import org.apache.oro.text.perl.Perl5Util;
import org.j69.eewiki.util.WebUtil;
import org.j69.eewiki.wiki.WikiConstants;

/**
 * @author sally
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class PluginShowText extends WikiPlugin {

	/* (non-Javadoc)
	 * @see org.j69.eewiki.plugin.WikiPluginImp#execute(java.lang.String, java.lang.String[], javax.servlet.http.HttpServletRequest)
	 */
	public String execute(
		String pageData,
		String[] optinos) {

		//オプション指定がなければ何もしない
		if (optinos == null || optinos[0].equals("")) 
			return null;
	
		//拡張子の取得とチェック
		String suffix = optinos[0].substring(optinos[0].lastIndexOf(".") + 1);
		if (!suffix.equals("txt"))
			return null;
	
		//Uploadディレクトリ名をコンフィグより取得し、物理ファイル名に変換
		String outputFilePath = config_.getConfig("define.wiki.basedir") + config_.getConfig("define.dir.upload");
		String fileName;
		try {
			fileName = WebUtil.getEncodeFileName(optinos[0]) + ".txt";
		} catch (CharacterCodingException e) {
			return e.getMessage();
		}
		outputFilePath = outputFilePath + "/" + fileName;
	
		//指定ファイルがなければ何もしない
		File filename = new File(outputFilePath);
		if (!filename.exists()) 
			return null;

		//ファイルの読込み		
		try {
			StringBuffer buf = new StringBuffer();
			String[] datas = slurp(outputFilePath);
			for (int i = 0; i < datas.length; i++) {
				buf.append(datas[i] + "\n");
			}
			return "<pre>\n" + buf.toString() + "</pre>\n";
		} catch (IOException e1) {
			return e1.getMessage();
		}
	}

	/** 
	 *  ファイルを読んでString[]に格納する
	 * HTML記述でタグとみなされる文字を置き換える 
	*/
	private String[] slurp(String file) throws IOException {
		BufferedReader br = null;
		Vector buffer = new Vector();
		br = new BufferedReader(new InputStreamReader(
				   new FileInputStream(new File(file)), WikiConstants.DEFAULT_FILE_ENCODING));

		Perl5Util perl = new Perl5Util();

		for (;;) {
			String line = br.readLine();

			if (line == null) break;

			//HTML記述でタグとみなされる文字を置き換える
			line = WebUtil.escapeChar(line);

			buffer.addElement(line);
		}
		String[] data = new String[buffer.size()];
		buffer.copyInto(data);
		return data;
	}

}
