/*
 * Created on 2003/05/02
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2002 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Struts", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 */

package org.j69.eewiki.init;

import java.io.File;

import javax.servlet.ServletException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;

import org.j69.eewiki.util.CacheConfig;
import org.j69.eewiki.util.CacheTagConfig;
import org.j69.eewiki.wiki.WikiConstants;

/**
 * eeWiki初期化処理クラス
 * 設定ファイルから設定を読みCachePropertiesに格納する
 * ※StrutsPluginから呼ばれるため、Struts-config.xmlへ定義が必要
 *
 * @author J.r0ck
 *
 */
public final class WikiInitialisation implements PlugIn {

    /**
     * The application configuration for our owning module.
     */
    private ModuleConfig config = null;

    /**
     * The {@link ActionServlet} owning this application.
     */
    private ActionServlet servlet = null;

    /**
     * Logging output for this plug in instance.
     */
    private Log log = LogFactory.getLog(this.getClass());

    /**
     * 設定キャッシュ
     */
    private CacheConfig cacheconfig = null;
    private CacheTagConfig cacheTagConfig = null;

    /**
     * アプリケーションベースパス
     */
    private String basedir = null;

    /**
     * システムのエンコーディング
     */
    private static final String DEFAULT_SYSTEM_ENCODING = "UTF-8";

    /* (non-Javadoc)
     * @see org.apache.struts.action.PlugIn#destroy()
     */
    public void destroy() {
        log.info("Finalizing WikiInitialisation plug in");

        //コンテキストから設定情報を削除
        servlet.getServletContext().removeAttribute(WikiConstants.WIKI_ELKEY_CONFIG);
        servlet.getServletContext().removeAttribute(WikiConstants.WIKI_ELKEY_BASE);
        config = null;
        cacheconfig = null;
        servlet = null;
    }

    /* (non-Javadoc)
     * @see org.apache.struts.action.PlugIn#init(org.apache.struts.action.ActionServlet, org.apache.struts.config.ModuleConfig)
     */
    public void init(ActionServlet servlet, ModuleConfig config) throws ServletException {

        // Remember our associated configuration and servlet
        this.config = config;
        this.servlet = servlet;

        // web.xmlから設定ファイルパス情報を読み込む
        String wikiConfigFile = servlet.getServletConfig().getInitParameter(WikiConstants.WIKI_CONFIG_FILE);
        if (wikiConfigFile == null)
        throw new ServletException("No '" + WikiConstants.WIKI_CONFIG_FILE + "' Init Parameter supplied in web.xml");

        log.info("Initializing eeWiki plug in from '" + wikiConfigFile + "'");

        try {
            // 設定ファイルのフルパスをサーブレットコンテキストから取得
            basedir = servlet.getServletContext().getRealPath("/");

            // 設定ファイルのフルパスを生成
            if(!basedir.substring(basedir.length() - 1).equals(File.separator)) {
                basedir += File.separator;
            }
            String configPath = basedir + wikiConfigFile;

            // 設定ファイルをキャッシュに読み込む
            cacheconfig = CacheConfig.createInstance(new File(configPath));
			
            // 設定項目の追加
            // 1.基盤ディレクトリ
            cacheconfig.setConfig("define.wiki.basedir", basedir);

            // TODO設定項目のチェック
            chkProperties();

            // Tagプラグインの初期化設定
            String tagConfigPath = basedir + cacheconfig.getConfig("define.tag.plugin");
            cacheTagConfig = CacheTagConfig.createInstance(new File(tagConfigPath));

        }
        catch (Exception e) {
            log.error("Initializing eeWiki", e);
            throw new ServletException("Cannot load WikiInitialisation from '" + wikiConfigFile + "'", e);
        }

        // 設定情報をコンテキストに格納
        servlet.getServletContext().setAttribute(WikiConstants.WIKI_ELKEY_CONFIG, cacheconfig);
        servlet.getServletContext().setAttribute(WikiConstants.WIKI_ELKEY_BASE, basedir);
    }

    /**
     * Method chkProperties
     * パラメータのチェック
     * TODO
     */
    private void chkProperties() {

        //TODO　今後ここでパラメータのチェックをすること
        log.info("Initializing eeWiki properties Check OK !! ");

    }

}
