/*
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2002 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Struts", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 */

package org.j69.eewiki.action;

import java.util.Vector;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.j69.eewiki.util.CacheConfig;
import org.j69.eewiki.util.WebUtil;
import org.j69.eewiki.wiki.Wiki;
import org.j69.eewiki.wiki.WikiList;

/**
 * QueryAction.java created by EasyStruts - XsltGen.
 * http://easystruts.sf.net
 * created on 05-31-2003
 *
 * XDoclet definition:
 * @struts:action path="/Query" name="Form" input="/form/.jsp" validate="true"
 * @struts:action-forward name="/List.do" path="/List.do"
 */
public class QueryAction extends Action {

    //------------------------------------------------------------ Local Forwards
    static final private String FORWARD_View = "View";

    // コンフィグ
    private final static CacheConfig config_ = CacheConfig.getInstance( );

    /**
     * Method execute
     * @param ActionMapping mapping
     * @param ActionForm form
     * @param HttpServletRequest request
     * @param HttpServletResponse response
     * @return ActionForward
     * @throws Exception
     */
    public ActionForward execute(
        ActionMapping mapping,
        ActionForm form,
        HttpServletRequest request,
        HttpServletResponse response)
        throws Exception {

		//メッセージリソース
		MessageResources msg = getResources(request);

        String pid ="";
        String queryword = "";

        //遷移元によって検索文字列の取得方法を変更
        if (form == null) {
            //ナビゲータから
            queryword = request.getParameter("queryword");
        }
        else {
            //単語入力ホームから
            QueryForm queryform = (QueryForm) form;
            queryword = queryform.getQueryword();
        }

        //表示するコンテンツのタイプを設定
        request.setAttribute("contentType", "lists");

        //コンテンツ格納(Listページを設定)
		String linkName = WebUtil.getEncodeFileName(config_.getConfig("define.pagename.list"));
        Wiki wiki = new Wiki(linkName, request, msg);
        request.setAttribute("content" , wiki);

        //WikiListの作成
        WikiList wikilist = new WikiList(wiki.getBasePath());
        Vector datas = wikilist.getWikiFiles(queryword, "title", true);
        request.setAttribute("lists", datas);

        //検索結果なしの場合その旨を表示する
        if (datas.isEmpty()) {
            request.setAttribute("error_id" , msg.getMessage(request.getLocale(), "error.nofound", ""));
        }

        //Viewpageに遷移元を伝える
        request.setAttribute("from_id", "Querypage");

        return mapping.findForward(FORWARD_View);

    }

}
