/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.dbcp.AbandonedTrace;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.DelegatingResultSet;

public class DelegatingPreparedStatement
extends AbandonedTrace
implements PreparedStatement {
    protected PreparedStatement _stmt = null;
    protected DelegatingConnection _conn = null;
    protected boolean _closed = false;

    public DelegatingPreparedStatement(DelegatingConnection c, PreparedStatement s) {
        super(c);
        this._stmt = s;
        this._conn = c;
    }

    public PreparedStatement getDelegate() {
        return this._stmt;
    }

    public PreparedStatement getInnermostDelegate() {
        PreparedStatement s = this._stmt;
        while (s != null && s instanceof DelegatingPreparedStatement) {
            if (this != (s = ((DelegatingPreparedStatement)s).getDelegate())) continue;
            return null;
        }
        return s;
    }

    public void setDelegate(PreparedStatement s) {
        this._stmt = s;
    }

    public void close() throws SQLException {
        this._stmt.close();
        this.passivate();
    }

    public Connection getConnection() throws SQLException {
        this.checkOpen();
        return this._conn;
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkOpen();
        return DelegatingResultSet.wrapResultSet(this, this._stmt.executeQuery(sql));
    }

    public ResultSet getResultSet() throws SQLException {
        this.checkOpen();
        return DelegatingResultSet.wrapResultSet(this, this._stmt.getResultSet());
    }

    public ResultSet executeQuery() throws SQLException {
        this.checkOpen();
        return DelegatingResultSet.wrapResultSet(this, this._stmt.executeQuery());
    }

    public int executeUpdate(String sql) throws SQLException {
        this.checkOpen();
        return this._stmt.executeUpdate(sql);
    }

    public int getMaxFieldSize() throws SQLException {
        this.checkOpen();
        return this._stmt.getMaxFieldSize();
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.checkOpen();
        this._stmt.setMaxFieldSize(max);
    }

    public int getMaxRows() throws SQLException {
        this.checkOpen();
        return this._stmt.getMaxRows();
    }

    public void setMaxRows(int max) throws SQLException {
        this.checkOpen();
        this._stmt.setMaxRows(max);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkOpen();
        this._stmt.setEscapeProcessing(enable);
    }

    public int getQueryTimeout() throws SQLException {
        this.checkOpen();
        return this._stmt.getQueryTimeout();
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkOpen();
        this._stmt.setQueryTimeout(seconds);
    }

    public void cancel() throws SQLException {
        this.checkOpen();
        this._stmt.cancel();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return this._stmt.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.checkOpen();
        this._stmt.clearWarnings();
    }

    public void setCursorName(String name) throws SQLException {
        this.checkOpen();
        this._stmt.setCursorName(name);
    }

    public boolean execute(String sql) throws SQLException {
        this.checkOpen();
        return this._stmt.execute(sql);
    }

    public int getUpdateCount() throws SQLException {
        this.checkOpen();
        return this._stmt.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        this.checkOpen();
        return this._stmt.getMoreResults();
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.checkOpen();
        this._stmt.setFetchDirection(direction);
    }

    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return this._stmt.getFetchDirection();
    }

    public void setFetchSize(int rows) throws SQLException {
        this.checkOpen();
        this._stmt.setFetchSize(rows);
    }

    public int getFetchSize() throws SQLException {
        this.checkOpen();
        return this._stmt.getFetchSize();
    }

    public int getResultSetConcurrency() throws SQLException {
        this.checkOpen();
        return this._stmt.getResultSetConcurrency();
    }

    public int getResultSetType() throws SQLException {
        this.checkOpen();
        return this._stmt.getResultSetType();
    }

    public void addBatch(String sql) throws SQLException {
        this.checkOpen();
        this._stmt.addBatch(sql);
    }

    public void clearBatch() throws SQLException {
        this.checkOpen();
        this._stmt.clearBatch();
    }

    public int[] executeBatch() throws SQLException {
        this.checkOpen();
        return this._stmt.executeBatch();
    }

    public int executeUpdate() throws SQLException {
        this.checkOpen();
        return this._stmt.executeUpdate();
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkOpen();
        this._stmt.setNull(parameterIndex, sqlType);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkOpen();
        this._stmt.setBoolean(parameterIndex, x);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkOpen();
        this._stmt.setByte(parameterIndex, x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkOpen();
        this._stmt.setShort(parameterIndex, x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkOpen();
        this._stmt.setInt(parameterIndex, x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkOpen();
        this._stmt.setLong(parameterIndex, x);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkOpen();
        this._stmt.setFloat(parameterIndex, x);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkOpen();
        this._stmt.setDouble(parameterIndex, x);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkOpen();
        this._stmt.setBigDecimal(parameterIndex, x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkOpen();
        this._stmt.setString(parameterIndex, x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkOpen();
        this._stmt.setBytes(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.checkOpen();
        this._stmt.setDate(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.checkOpen();
        this._stmt.setTime(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.checkOpen();
        this._stmt.setTimestamp(parameterIndex, x);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkOpen();
        this._stmt.setAsciiStream(parameterIndex, x, length);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkOpen();
        this._stmt.setUnicodeStream(parameterIndex, x, length);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkOpen();
        this._stmt.setBinaryStream(parameterIndex, x, length);
    }

    public void clearParameters() throws SQLException {
        this.checkOpen();
        this._stmt.clearParameters();
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.checkOpen();
        this._stmt.setObject(parameterIndex, x, targetSqlType, scale);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.checkOpen();
        this._stmt.setObject(parameterIndex, x, targetSqlType);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkOpen();
        this._stmt.setObject(parameterIndex, x);
    }

    public boolean execute() throws SQLException {
        this.checkOpen();
        return this._stmt.execute();
    }

    public void addBatch() throws SQLException {
        this.checkOpen();
        this._stmt.addBatch();
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.checkOpen();
        this._stmt.setCharacterStream(parameterIndex, reader, length);
    }

    public void setRef(int i, Ref x) throws SQLException {
        this.checkOpen();
        this._stmt.setRef(i, x);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this.checkOpen();
        this._stmt.setBlob(i, x);
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.checkOpen();
        this._stmt.setClob(i, x);
    }

    public void setArray(int i, Array x) throws SQLException {
        this.checkOpen();
        this._stmt.setArray(i, x);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkOpen();
        return this._stmt.getMetaData();
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.checkOpen();
        this._stmt.setDate(parameterIndex, x, cal);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.checkOpen();
        this._stmt.setTime(parameterIndex, x, cal);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.checkOpen();
        this._stmt.setTimestamp(parameterIndex, x, cal);
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.checkOpen();
        this._stmt.setNull(paramIndex, sqlType, typeName);
    }

    protected void checkOpen() throws SQLException {
        if (this._closed) {
            throw new SQLException("Connection is closed.");
        }
    }

    protected void activate() {
        this._closed = false;
        if (this._stmt instanceof DelegatingPreparedStatement) {
            ((DelegatingPreparedStatement)this._stmt).activate();
        }
    }

    protected void passivate() throws SQLException {
        List resultSets;
        this._closed = true;
        if (this._conn != null) {
            this._conn.removeTrace(this);
            this._conn = null;
        }
        if ((resultSets = this.getTrace()) != null) {
            ResultSet[] set = new ResultSet[resultSets.size()];
            resultSets.toArray(set);
            int i = 0;
            while (i < set.length) {
                set[i].close();
                ++i;
            }
            this.clearTrace();
        }
        if (this._stmt instanceof DelegatingPreparedStatement) {
            ((DelegatingPreparedStatement)this._stmt).passivate();
        }
    }

    protected boolean isClosed() {
        return this._closed;
    }

    public boolean getMoreResults(int current) throws SQLException {
        this.checkOpen();
        return this._stmt.getMoreResults(current);
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkOpen();
        return this._stmt.getGeneratedKeys();
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        return this._stmt.executeUpdate(sql, autoGeneratedKeys);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        return this._stmt.executeUpdate(sql, columnIndexes);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        return this._stmt.executeUpdate(sql, columnNames);
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        return this._stmt.execute(sql, autoGeneratedKeys);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        return this._stmt.execute(sql, columnIndexes);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        return this._stmt.execute(sql, columnNames);
    }

    public int getResultSetHoldability() throws SQLException {
        this.checkOpen();
        return this._stmt.getResultSetHoldability();
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.checkOpen();
        this._stmt.setURL(parameterIndex, x);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkOpen();
        return this._stmt.getParameterMetaData();
    }
}

