/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view.context;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.view.context.ToolboxContext;
import org.apache.velocity.tools.view.context.ViewContext;

public class ChainedContext
extends VelocityContext
implements ViewContext {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private HttpSession session;
    private ServletContext application;
    private ToolboxContext toolboxContext = null;
    public static final String REQUEST = "request";
    public static final String RESPONSE = "response";
    public static final String SESSION = "session";
    public static final String APPLICATION = "application";

    public ChainedContext(Context context, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServletContext servletContext) {
        super(null, context);
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.session = httpServletRequest.getSession(false);
        this.application = servletContext;
    }

    public void setToolbox(ToolboxContext toolboxContext) {
        this.toolboxContext = toolboxContext;
        this.session = this.request.getSession(false);
    }

    public Object internalGet(String string) {
        Object object = null;
        if (this.toolboxContext != null && (object = this.toolboxContext.get(string)) != null) {
            return object;
        }
        if (string.equals(REQUEST)) {
            return this.request;
        }
        if (string.equals(RESPONSE)) {
            return this.response;
        }
        if (string.equals(SESSION)) {
            return this.session;
        }
        if (string.equals(APPLICATION)) {
            return this.application;
        }
        object = super.internalGet(string);
        if (object != null) {
            return object;
        }
        object = this.request.getAttribute(string);
        if (object == null) {
            if (this.session != null) {
                object = this.session.getAttribute(string);
            }
            if (object == null) {
                object = this.application.getAttribute(string);
            }
        }
        return object;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public ServletContext getServletContext() {
        return this.application;
    }

    public Context getVelocityContext() {
        return this;
    }
}

