/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.struts;

import java.util.Iterator;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionFormBean;
import org.apache.struts.action.ActionFormBeans;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionForwards;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMappings;
import org.apache.struts.upload.MultipartRequestWrapper;
import org.apache.struts.util.MessageResources;

class StrutsUtils {
    StrutsUtils() {
    }

    static DataSource getDataSource(ServletContext servletContext) {
        if (servletContext == null) {
            return null;
        }
        return (DataSource)servletContext.getAttribute("org.apache.struts.action.DATA_SOURCE");
    }

    static ActionFormBeans getActionFormBeans(ServletContext servletContext) {
        if (servletContext == null) {
            return null;
        }
        return (ActionFormBeans)servletContext.getAttribute("org.apache.struts.action.FORM_BEANS");
    }

    static ActionFormBean getFormBean(String string, ServletContext servletContext) {
        ActionFormBeans actionFormBeans = StrutsUtils.getActionFormBeans(servletContext);
        if (actionFormBeans == null) {
            return null;
        }
        return actionFormBeans.findFormBean(string);
    }

    static ActionForwards getActionForwards(ServletContext servletContext) {
        if (servletContext == null) {
            return null;
        }
        return (ActionForwards)servletContext.getAttribute("org.apache.struts.action.FORWARDS");
    }

    static ActionForward getActionForward(String string, ServletContext servletContext) {
        ActionForwards actionForwards = StrutsUtils.getActionForwards(servletContext);
        if (actionForwards == null) {
            return null;
        }
        return actionForwards.findForward(string);
    }

    static ActionMappings getActionMappings(ServletContext servletContext) {
        if (servletContext == null) {
            return null;
        }
        return (ActionMappings)servletContext.getAttribute("org.apache.struts.action.MAPPINGS");
    }

    static ActionMapping getActionMapping(String string, ServletContext servletContext) {
        ActionMappings actionMappings = StrutsUtils.getActionMappings(servletContext);
        if (actionMappings == null) {
            return null;
        }
        return actionMappings.findMapping(string);
    }

    static MessageResources getMessageResources(ServletContext servletContext) {
        if (servletContext == null) {
            return null;
        }
        return (MessageResources)servletContext.getAttribute("org.apache.struts.action.MESSAGE");
    }

    static String getServletMapping(ServletContext servletContext) {
        if (servletContext == null) {
            return null;
        }
        return (String)servletContext.getAttribute("org.apache.struts.action.SERVLET_MAPPING");
    }

    static Locale getLocale(HttpServletRequest httpServletRequest, HttpSession httpSession) {
        Locale locale = null;
        if (httpSession != null) {
            locale = (Locale)httpSession.getAttribute("org.apache.struts.action.LOCALE");
        }
        if (locale == null && httpServletRequest != null) {
            locale = httpServletRequest.getLocale();
        }
        return locale;
    }

    static String getToken(HttpSession httpSession) {
        if (httpSession == null) {
            return null;
        }
        return (String)httpSession.getAttribute("org.apache.struts.action.TOKEN");
    }

    static ActionErrors getActionErrors(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            return null;
        }
        return (ActionErrors)httpServletRequest.getAttribute("org.apache.struts.action.ERROR");
    }

    static Throwable getException(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            return null;
        }
        return (Throwable)httpServletRequest.getAttribute("org.apache.struts.action.EXCEPTION");
    }

    static MultipartRequestWrapper getMultipartRequestWrapper(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            return null;
        }
        return (MultipartRequestWrapper)httpServletRequest.getAttribute("org.apache.struts.action.mapping.multipartclass");
    }

    static ActionMapping getMapping(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            return null;
        }
        return (ActionMapping)httpServletRequest.getAttribute("org.apache.struts.action.mapping.instance");
    }

    static ActionForm getActionForm(HttpServletRequest httpServletRequest, HttpSession httpSession) {
        ActionMapping actionMapping = (ActionMapping)httpServletRequest.getAttribute("org.apache.struts.action.mapping.instance");
        if (actionMapping == null) {
            return null;
        }
        String string = actionMapping.getAttribute();
        if (string == null) {
            return null;
        }
        if ("request".equals(actionMapping.getScope())) {
            return (ActionForm)httpServletRequest.getAttribute(string);
        }
        if (httpSession != null) {
            return (ActionForm)httpSession.getAttribute(string);
        }
        return null;
    }

    static String getCancelName() {
        return "org.apache.struts.taglib.html.CANCEL";
    }

    static String getGlobalErrorName() {
        return "org.apache.struts.action.GLOBAL_ERROR";
    }

    static String getTokenName() {
        return "org.apache.struts.taglib.html.TOKEN";
    }

    static String getActionMappingName(String string) {
        String string2 = string;
        int n = string.indexOf("?");
        if (n >= 0) {
            string2 = string2.substring(0, n);
        }
        int n2 = string2.lastIndexOf("/");
        int n3 = string2.lastIndexOf(".");
        if (n3 >= 0 && n3 > n2) {
            string2 = string2.substring(0, n3);
        }
        if (string2.startsWith("/")) {
            return string2;
        }
        return "/" + string2;
    }

    static String getActionMappingURL(ServletContext servletContext, HttpServletRequest httpServletRequest, String string) {
        StringBuffer stringBuffer = new StringBuffer(httpServletRequest.getContextPath());
        String string2 = StrutsUtils.getServletMapping(servletContext);
        if (string2 != null) {
            String string3 = null;
            int n = string.indexOf("?");
            if (n >= 0) {
                string3 = string.substring(n);
            }
            String string4 = StrutsUtils.getActionMappingName(string);
            if (string2.startsWith("*.")) {
                stringBuffer.append(string4);
                stringBuffer.append(string2.substring(1));
            } else if (string2.endsWith("/*")) {
                stringBuffer.append(string2.substring(0, string2.length() - 2));
                stringBuffer.append(string4);
            }
            if (string3 != null) {
                stringBuffer.append(string3);
            }
        } else {
            if (!string.startsWith("/")) {
                stringBuffer.append("/");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    static String errorMarkup(String string, HttpServletRequest httpServletRequest, HttpSession httpSession, ServletContext servletContext) {
        ActionErrors actionErrors = StrutsUtils.getActionErrors(httpServletRequest);
        if (actionErrors == null) {
            return "";
        }
        Iterator iterator = null;
        iterator = string == null ? actionErrors.get() : actionErrors.get(string);
        if (!iterator.hasNext()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        String string3 = null;
        Locale locale = StrutsUtils.getLocale(httpServletRequest, httpSession);
        MessageResources messageResources = StrutsUtils.getMessageResources(servletContext);
        if (messageResources != null) {
            string2 = messageResources.getMessage(locale, "errors.header");
            string3 = messageResources.getMessage(locale, "errors.footer");
        }
        if (string2 == null) {
            string2 = "errors.header";
        }
        if (string3 == null) {
            string3 = "errors.footer";
        }
        stringBuffer.append(string2);
        stringBuffer.append("\r\n");
        while (iterator.hasNext()) {
            String string4 = null;
            ActionError actionError = (ActionError)iterator.next();
            if (messageResources != null) {
                string4 = messageResources.getMessage(locale, actionError.getKey(), actionError.getValues());
            }
            if (string4 != null) {
                stringBuffer.append(string4);
                stringBuffer.append("\r\n");
                continue;
            }
            stringBuffer.append(actionError.getKey());
            stringBuffer.append("\r\n");
        }
        stringBuffer.append(string3);
        stringBuffer.append("\r\n");
        return stringBuffer.toString();
    }
}

