/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.impl;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.apache.commons.pool.BaseObjectPool;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

public class StackObjectPool
extends BaseObjectPool
implements ObjectPool {
    protected static final int DEFAULT_MAX_SLEEPING = 8;
    protected static final int DEFAULT_INIT_SLEEPING_CAPACITY = 4;
    protected Stack _pool = null;
    protected PoolableObjectFactory _factory = null;
    protected int _maxSleeping = 8;
    protected int _numActive = 0;

    public StackObjectPool() {
        this(null, 8, 4);
    }

    public StackObjectPool(int max) {
        this(null, max, 4);
    }

    public StackObjectPool(int max, int init) {
        this(null, max, init);
    }

    public StackObjectPool(PoolableObjectFactory factory) {
        this(factory, 8, 4);
    }

    public StackObjectPool(PoolableObjectFactory factory, int max) {
        this(factory, max, 4);
    }

    public StackObjectPool(PoolableObjectFactory factory, int max, int init) {
        this._factory = factory;
        this._maxSleeping = max < 0 ? 8 : max;
        int initcapacity = init < 1 ? 4 : init;
        this._pool = new Stack();
        this._pool.ensureCapacity(initcapacity > this._maxSleeping ? this._maxSleeping : initcapacity);
    }

    public synchronized Object borrowObject() throws Exception {
        Object obj = null;
        try {
            obj = this._pool.pop();
        }
        catch (Exception e) {
            if (null == this._factory) {
                throw new NoSuchElementException();
            }
            obj = this._factory.makeObject();
        }
        if (null != this._factory && null != obj) {
            this._factory.activateObject(obj);
        }
        ++this._numActive;
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(Object obj) throws Exception {
        block13: {
            boolean success = true;
            if (null != this._factory) {
                if (!this._factory.validateObject(obj)) {
                    success = false;
                } else {
                    try {
                        this._factory.passivateObject(obj);
                    }
                    catch (Exception e) {
                        success = false;
                    }
                }
            }
            boolean shouldDestroy = !success;
            StackObjectPool stackObjectPool = this;
            synchronized (stackObjectPool) {
                --this._numActive;
                if (this._pool.size() >= this._maxSleeping) {
                    shouldDestroy = true;
                } else if (success) {
                    this._pool.push(obj);
                }
                this.notifyAll();
            }
            if (!shouldDestroy) break block13;
            try {
                this._factory.destroyObject(obj);
            }
            catch (Exception e) {}
        }
    }

    public synchronized void invalidateObject(Object obj) throws Exception {
        --this._numActive;
        if (null != this._factory) {
            this._factory.destroyObject(obj);
        }
        this.notifyAll();
    }

    public int getNumIdle() {
        return this._pool.size();
    }

    public int getNumActive() {
        return this._numActive;
    }

    public synchronized void clear() {
        if (null != this._factory) {
            Enumeration enumeration = this._pool.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    this._factory.destroyObject(enumeration.nextElement());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        this._pool.clear();
    }

    public synchronized void close() throws Exception {
        this.clear();
        this._pool = null;
        this._factory = null;
    }

    public synchronized void setFactory(PoolableObjectFactory factory) throws IllegalStateException {
        if (0 < this.getNumActive()) {
            throw new IllegalStateException("Objects are already active");
        }
        this.clear();
        this._factory = factory;
    }
}

