/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.datatype;

import com.sun.msv.datatype.DatabindableDatatype;
import com.sun.msv.datatype.xsd.XSDatatype;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.tree.AbstractAttribute;
import org.relaxng.datatype.ValidationContext;

public class DatatypeAttribute
extends AbstractAttribute
implements ValidationContext {
    private Element parent;
    private QName qname;
    private XSDatatype datatype;
    private Object data;
    private String text;

    public DatatypeAttribute(QName qname, XSDatatype datatype) {
        this.qname = qname;
        this.datatype = datatype;
    }

    public DatatypeAttribute(QName qname, XSDatatype datatype, String text) {
        this.qname = qname;
        this.datatype = datatype;
        this.text = text;
        this.data = this.validate(text);
    }

    public Object getData() {
        return this.data;
    }

    public Element getParent() {
        return this.parent;
    }

    public QName getQName() {
        return this.qname;
    }

    public String getValue() {
        if (this.text == null) {
            this.text = this.data == null ? "" : this.data.toString();
        }
        return this.text;
    }

    public XSDatatype getXSDatatype() {
        return this.datatype;
    }

    public boolean isNotation(String notationName) {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isUnparsedEntity(String entityName) {
        return true;
    }

    public String resolveNamespacePrefix(String prefix) {
        Namespace namespace;
        if (prefix.equals(this.getNamespacePrefix())) {
            return this.getNamespaceURI();
        }
        Element parent = this.getParent();
        if (parent != null && (namespace = parent.getNamespaceForPrefix(prefix)) != null) {
            return namespace.getURI();
        }
        return null;
    }

    public void setData(Object data) {
        this.data = data;
        this.text = null;
    }

    public void setParent(Element parent) {
        this.parent = parent;
    }

    public void setValue(String text) {
        this.text = text;
        this.data = this.validate(text);
    }

    public boolean supportsParent() {
        return true;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + this.hashCode() + " [Attribute: name " + this.getQualifiedName() + " value \"" + this.getValue() + "\" data: " + this.getData() + "]";
    }

    protected Object validate(String text) {
        if (this.datatype instanceof DatabindableDatatype) {
            XSDatatype bindable = this.datatype;
            return bindable.createJavaObject(text, (ValidationContext)this);
        }
        return this.datatype.createValue(text, (ValidationContext)this);
    }
}

