/*
 * Decompiled with CFR 0.152.
 */
package dvi.browser;

import dvi.DviException;
import dvi.DviRect;
import dvi.DviResolution;
import dvi.api.DviContextSupport;
import dvi.api.DviDocument;
import dvi.browser.AbstractDviBrowserPageLayout;
import dvi.browser.DviBrowserPage;
import dvi.gui.swing.DviLayoutManager;
import java.awt.Dimension;
import java.awt.Point;
import java.util.logging.Logger;

public class DviBoxBrowserPageLayout
extends AbstractDviBrowserPageLayout {
    private static final Logger LOGGER = Logger.getLogger(DviBoxBrowserPageLayout.class.getName());
    private boolean fitToWidth;
    private boolean fitToHeight;
    private double minimumDpi = 16.0;

    public DviBoxBrowserPageLayout(DviContextSupport dcs, String name, boolean fitToWidth, boolean fitToHeight) {
        super(dcs, name);
        this.setFitToHeight(fitToHeight);
        this.setFitToWidth(fitToWidth);
    }

    public void layoutDviBrowserPage(DviBrowserPage browserPage, DviDocument doc) throws DviException {
        boolean success;
        Dimension viewportSize = browserPage.getViewportSize();
        DviResolution or = browserPage.getViewSpec().getResolution();
        DviLayoutManager layout = browserPage.getTDviDocument().getDviLayout();
        Point pos = browserPage.getScrollPane().getViewport().getViewPosition();
        int sf = 1;
        DviResolution nr = null;
        do {
            nr = new DviResolution(or.dpi(), sf);
            DviRect pageBbox = browserPage.getTDviDocument().getDviLayout().getPageBoundingBox(doc, nr);
            DviRect bbox = layout.getBoundingBox(doc, nr);
            success = true;
            if (this.fitToWidth && bbox.width() >= viewportSize.width) {
                success = false;
            }
            if (!this.fitToHeight || pageBbox.height() < viewportSize.height) continue;
            success = false;
        } while (!success && ++sf < 1024 && nr.actualDpi() > this.minimumDpi);
        int ny = (int)((double)pos.y * (double)or.shrinkFactor() / (double)nr.shrinkFactor());
        ny = Math.max(0, ny);
        LOGGER.fine("setting the resolution to " + nr);
        browserPage.getViewSpec().setResolution(nr);
        browserPage.getScrollPane().getViewport().setViewPosition(new Point(0, ny));
    }

    public void setFitToWidth(boolean fitToWidth) {
        this.fitToWidth = fitToWidth;
    }

    public boolean getFitToWidth() {
        return this.fitToWidth;
    }

    public void setFitToHeight(boolean fitToHeight) {
        this.fitToHeight = fitToHeight;
    }

    public boolean getFitToHeight() {
        return this.fitToHeight;
    }

    public void setMinimumDpi(double minimumDpi) {
        this.minimumDpi = minimumDpi;
    }

    public double getMinimumDpi() {
        return this.minimumDpi;
    }
}

