/*
 * Decompiled with CFR 0.152.
 */
package dvi;

import dvi.DviRect;
import dvi.DviSize;

public class DviRectSplitter {
    private final DviRect rect;
    private final DviSize unit;
    private final int cols;
    private final int rows;

    public DviRectSplitter(DviRect rect, DviSize unit) {
        this.rect = rect;
        this.unit = unit;
        if (unit.width == 0) {
            throw new IllegalArgumentException("width must be > 0: " + unit.width);
        }
        if (unit.height == 0) {
            throw new IllegalArgumentException("height must be > 0: " + unit.height);
        }
        this.cols = (rect.width() + unit.width - 1) / unit.width;
        this.rows = (rect.height() + unit.height - 1) / unit.height;
    }

    public int getNumColumns() {
        return this.cols;
    }

    public int getNumRows() {
        return this.rows;
    }

    public DviRect getRect() {
        return this.rect;
    }

    public DviSize getUnitSize() {
        return this.unit;
    }

    public DviRect getRectAt(int row, int col) {
        if (row < 0 || this.rows <= row) {
            throw new IllegalArgumentException("Row index out of range: " + row);
        }
        if (col < 0 || this.cols <= col) {
            throw new IllegalArgumentException("Column index out of range: " + col);
        }
        int x = this.rect.x() + col * this.unit.width();
        int y = this.rect.y() + row * this.unit.height();
        DviRect r = new DviRect(x, y, this.unit);
        return r.intersect(this.rect);
    }

    public DviRect[][] getRects() {
        DviRect[][] rects = new DviRect[this.rows][this.cols];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                rects[i][j] = this.getRectAt(i, j);
            }
        }
        return rects;
    }
}

