/*
 * Decompiled with CFR 0.152.
 */
package dvi;

import dvi.DviPoint;
import dvi.DviSize;
import java.io.Serializable;

public final class DviRect
implements Serializable {
    private static final long serialVersionUID = 1112844763203879499L;
    public static final DviRect EMPTY = new DviRect();
    private final int x;
    private final int y;
    private final int width;
    private final int height;

    public DviRect() {
        this.x = 0;
        this.y = 0;
        this.width = 0;
        this.height = 0;
    }

    public DviRect(int x, int y, int width, int height) {
        if (width < 0) {
            this.x = x + width;
            this.width = -width;
        } else {
            this.x = x;
            this.width = width;
        }
        if (height < 0) {
            this.y = y + height;
            this.height = -height;
        } else {
            this.y = y;
            this.height = height;
        }
    }

    public DviRect(DviPoint p, int width, int height) {
        this(p.x, p.y, width, height);
    }

    public DviRect(DviPoint p, DviSize s) {
        this(p.x, p.y, s.width(), s.height());
    }

    public DviRect(int x, int y, DviSize s) {
        this(x, y, s.width(), s.height());
    }

    public DviRect(DviRect r) {
        this(r.x(), r.y(), r.width(), r.height());
    }

    public boolean isEmpty() {
        return this.width == 0 || this.height == 0;
    }

    public boolean contains(int x, int y) {
        return this.x <= x && x < this.x + this.width && this.y <= y && y < this.y + this.height;
    }

    public boolean contains(DviPoint p) {
        return this.x <= p.x && p.x < this.x + this.width && this.y <= p.y && p.y < this.y + this.height;
    }

    public DviSize size() {
        return new DviSize(this.width, this.height);
    }

    public DviRect shrink(int f) {
        if (f <= 0) {
            throw new IllegalArgumentException("shrink factor can't be <= 0.");
        }
        DviRect r = DviRect.getDviRect(DviRect.flooredDivision(this.x, f), DviRect.flooredDivision(this.y, f), DviRect.flooredDivision(this.right(), f), DviRect.flooredDivision(this.bottom(), f));
        return r;
    }

    public DviRect magnify(int f) {
        return new DviRect(this.x * f, this.y * f, this.width * f, this.height * f);
    }

    public static DviRect getDviRect(int sx, int sy, int ex, int ey) {
        return new DviRect(sx, sy, ex - sx + 1, ey - sy + 1);
    }

    public DviRect translate(DviPoint p) {
        return new DviRect(this.x + p.x, this.y + p.y, this.width, this.height);
    }

    public DviRect translate(int dx, int dy) {
        return new DviRect(this.x + dx, this.y + dy, this.width, this.height);
    }

    public DviRect crop(int top, int left, int bottom, int right) {
        return new DviRect(this.x + left, this.y + top, this.width - left - right, this.height - top - bottom);
    }

    public DviRect union(DviRect r) {
        if (r == null) {
            r = EMPTY;
        }
        if (this.isEmpty()) {
            return r;
        }
        if (r.isEmpty()) {
            return this;
        }
        int sx = Math.min(this.x, r.x);
        int sy = Math.min(this.y, r.y);
        int ex = Math.max(this.right(), r.right());
        int ey = Math.max(this.bottom(), r.bottom());
        return DviRect.getDviRect(sx, sy, ex, ey);
    }

    public static DviRect union(DviRect[] rs) {
        DviRect ret = EMPTY;
        if (rs != null) {
            for (DviRect r : rs) {
                ret = ret.union(r);
            }
        }
        return ret;
    }

    public DviRect intersect(DviRect r) {
        int sx = Math.max(this.x, r.x);
        int sy = Math.max(this.y, r.y);
        int ex = Math.min(this.right(), r.right());
        int ey = Math.min(this.bottom(), r.bottom());
        return sx <= ex && sy <= ey ? DviRect.getDviRect(sx, sy, ex, ey) : new DviRect();
    }

    public boolean intersects(DviRect r) {
        int sx = Math.max(this.x, r.x);
        int sy = Math.max(this.y, r.y);
        int ex = Math.min(this.right(), r.right());
        int ey = Math.min(this.bottom(), r.bottom());
        return sx < ex && sy < ey;
    }

    public DviRect addPadding(int by) {
        if (this.isEmpty()) {
            return this;
        }
        return DviRect.getDviRect(this.x - by, this.y - by, this.right() + by, this.bottom() + by);
    }

    private static int flooredDivision(int a, int b) {
        return a < 0 ? (a - b + 1) / b : a / b;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public int left() {
        return this.x;
    }

    public int top() {
        return this.y;
    }

    public int right() {
        return this.x + this.width - 1;
    }

    public int bottom() {
        return this.y + this.height - 1;
    }

    public DviPoint topLeft() {
        return new DviPoint(this.x, this.y);
    }

    public DviPoint topRight() {
        return new DviPoint(this.x + this.width - 1, this.y);
    }

    public DviPoint bottomLeft() {
        return new DviPoint(this.x, this.y + this.height - 1);
    }

    public DviPoint bottomRight() {
        return new DviPoint(this.x + this.width - 1, this.y + this.height - 1);
    }

    public DviRect resize(int width, int height) {
        return new DviRect(this.x, this.y, width, height);
    }

    public int hashCode() {
        return this.x + 33 * (this.y + 33 * (this.width + 33 * this.height));
    }

    public boolean equals(Object obj) {
        if (obj instanceof DviRect) {
            DviRect a = (DviRect)obj;
            return this.isEmpty() ? a.isEmpty() : this.x == a.x && this.y == a.y && this.width == a.width && this.height == a.height;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + "]";
    }
}

